#!/local/bin/perl
# $Id: policy2filters.pl,v 1.3 95/03/16 19:27:22 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

#package policy2filters;

sub policy2filters_for_all {
    local (*policy, *filter) = (@_);

    foreach $_ (keys %policy) {
	if (/^as-in%/) {
	    ($keyword, $as, $peeras) = split(/%/);
	    do policy2import_filters(*policy, *filter, 
				     $as, $peeras, "default", "default");
	    next;
	}
	if (/^as-out%/) {
	    ($keyword, $as, $peeras) = split(/%/);
	    do policy2export_filters(*policy, *filter, 
				     $as, $peeras, "default", "default");
	    next;
	}
	if (/^interas-in%/) { 
	    ($keyword, $as, $peeras, $br, $peerbr) = split(/%/);
	    do policy2import_filters(*policy,*filter, $as,$peeras, $br,$peerbr);
	    next;
	}
	if (/^interas-out%/) { 
	    ($keyword, $as, $peeras, $br, $peerbr) = split(/%/);
	    do policy2export_filters(*policy,*filter, $as,$peeras, $br,$peerbr);
	    next;
	}
    }
}

sub policy2export_filters {
    local (*policy, *filters, $as, $peeras, $br, $peerbr) = (@_);
    local (@result);

    if (!$policy{"as-out%$as%$peeras"}) {
	print STDERR "Warning: no as-out line for $as peer $peeras.\n";
	$policy{"as-out%$as%$peeras"} = "NOT ANY+";
	$policy{"c-as-out%$as%$peeras"} = "NOT ANY";
	$policy{"l-as-out%$as%$peeras"} = "NOT ANY";
    }

    @result = ();
    foreach $interasout (split(/\+/, 
			   $policy{"interas-out%$as%$peeras%$br%$peerbr"})) {
	local ($cost, $interasoutrpe) = split(/\s+/, $interasout, 2);

	push(@result, 
           "$cost ($policy{\"c-as-out%$as%$peeras\"}) AND ($interasoutrpe)");
    }
    ##### these are the left over routes that are accepted at all interfaces
    if ($policy{"l-as-out%$as%$peeras"} 
        && $policy{"l-as-out%$as%$peeras"} ne "NOT ANY") {
	push(@result, 
           "? ($policy{\"l-as-out%$as%$peeras\"})");
    }

   ##### sort the filters
   if (@result) {
       $filters{"export%$as%$peeras%$br%$peerbr"} = 
	   join('+', sort by_pref @result);
   } else {
       $filters{"export%$as%$peeras%$br%$peerbr"} = "? NOT ANY";
   }

}

sub policy2import_filters {
    local (*policy, *filters, $as, $peeras, $br, $peerbr) = (@_);
    local (@result);

    do make_preference_map(*policy, *preference_map, $as);

##### Make import filters
    if (!$policy{"as-in%$as%$peeras"}) {
	print STDERR "Warning: no as-in line for $as peer $peeras.\n";
	$policy{"as-in%$as%$peeras"} = "0 NOT ANY+";
	$policy{"c-as-in%$as%$peeras"} = "NOT ANY";
	$policy{"l-as-in%$as%$peeras"} = "NOT ANY";
    }

    @result = ();
    foreach $asin (split(/\+/, $policy{"as-in%$as%$peeras"})) {
	local ($asinpref, $asinrpe) = split(/\s+/, $asin, 2);

	foreach $interasin (split(/\+/, 
		  $policy{"interas-in%$as%$peeras%$br%$peerbr"})) {
	    local ($interasinpref, $interasinrpe) = split(/\s+/, $interasin, 2);

	    push(@result, 
		&compute_preference(*preference_map, $as, $peeras, $asinpref, $interasinpref)
		    . " ($asinrpe) AND ($interasinrpe)");
	}

        ##### these are the left over routes that are accepted at all interfaces
	if ($policy{"l-as-in%$as%$peeras"} 
	    && $policy{"l-as-in%$as%$peeras"} ne "NOT ANY") {
	    push(@result, 
		&compute_preference(*preference_map, $as, $peeras, $asinpref, 0)
		    . " ($asinrpe) AND ($policy{\"l-as-in%$as%$peeras\"})");
	}
   }

   ##### sort the filters
   if (@result) {
       $filters{"import%$as%$peeras%$br%$peerbr"} = 
	   join('+', sort by_pref @result);
   } else {
       $filters{"import%$as%$peeras%$br%$peerbr"} = "0 NOT ANY";
   }

}

sub compute_preference {
    local (*map, $as, $peer_as, $asin_pref, $interasin_pref) = (@_);
    local ($pref);

    $pref = $preference_offset + $map{"as-in%$as%$asin_pref"};

    if ($interasin_pref eq "MED") {
	$pref .= ":MED";
    } else {
	$pref += $map{"interas-in%$as%$peer_as%$interasin_pref"};
    }

    return $pref;
}


sub make_preference_map {
    local (*policy, *map, $as) = (@_);
    local ($max_preference, $i, $lastpref, $pref, $peer_as, $key);

    return if ($preference_map_done{$as});

    $preference_map_done{$as} = 1;

# rank interas-in preferences in (as, peer-as) groups
# smallest becomes 0, next one becomes 1, etc
    $max_preference = 1;
    foreach $peer_as (grep(s/(p-interas-in%$as%)//, keys %policy)) {
	$i = -1;
	$lastpref=-2;
	foreach $pref (sort(split(/\+/, $policy{"p-interas-in%$as%$peer_as"}))){
	    next if ($pref !~ /^[0-9]+$/);
	    $i++ if ($pref != $lastpref);
	    $max_preference = $i if ($i > $max_preference);
	    $map{"interas-in%$as%$peer_as%$pref"} = $i;
	    $lastpref=$pref;
	}
    }

# rank as-in preferences in as groups
    $max_preference++;
    $i = -1;
    $lastpref=-2;
    foreach $pref (sort(split(/\+/, $policy{"p-as-in%$as"}))) {
	next if ($pref !~ /^[0-9]+$/);
	$i++ if ($pref != $lastpref);
	$map{"as-in%$as%$pref"} = $i * $max_preference;
	$lastpref=$pref;
    }

    print STDERR "=====\n", join("\n", %map), "\n" if $opt_d;

}

sub by_pref {
# todo: does this work with MED?

    local ($apref, $bpref, $rest);

    if (!(($apref, $rest) = split(/[ :]/, $a, 2))) {
	print STDERR "Can not find pref in $a\n";
	exit 1;
    }
    if (!(($bpref, $rest) = split(/[ :]/, $b, 2))) {
	print STDERR "Can not find pref in $b\n";
	exit 1;
    }

    if ($apref eq "?" || $apref eq "IGP") {
      return 1;
    }
    if ($bpref eq "?" || $bpref eq "IGP") {
      return -1;
    }
    
    $apref <=> $bpref;
}

1;
