#!/usr/local/bin/perl
# $Id: listfilters.pl,v 1.1 95/04/11 14:51:03 cengiz Exp $
# 
#  Copyright (c) 1994 by the University of Southern California
#  and/or the International Business Machines Corporation.
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation in source and binary forms for lawful
#  non-commercial purposes and without fee is hereby granted, provided
#  that the above copyright notice appear in all copies and that both
#  the copyright notice and this permission notice appear in supporting
#  documentation, and that any documentation, advertising materials,
#  and other materials related to such distribution and use acknowledge
#  that the software was developed by the University of Southern
#  California, Information Sciences Institute and/or the International
#  Business Machines Corporation.  The name of the USC or IBM may not
#  be used to endorse or promote products derived from this software
#  without specific prior written permission.
#
#  NEITHER THE UNIVERSITY OF SOUTHERN CALIFORNIA NOR INTERNATIONAL
#  BUSINESS MACHINES CORPORATION MAKES ANY REPRESENTATIONS ABOUT
#  THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE.  THIS SOFTWARE IS
#  PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES,
#  INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
#  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE, AND 
#  NON-INFRINGEMENT.
#
#  IN NO EVENT SHALL USC, IBM, OR ANY OTHER CONTRIBUTOR BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN CONTRACT,
#  TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN CONNECTION WITH,
#  THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
#  Questions concerning this software should be directed to 
#  info-ra@isi.edu.
#
#  Author(s): Cengiz Alaettinoglu <cengiz@isi.edu>

push(@INC, "lib");

require "qradbserver.pl";
require "data2policy.pl";
require "policy2filters.pl";
require "pevalclient.pl";

$as=$ARGV[0];

$whoishost      = "radb2.ra.net";
$port           = 5042;
$database       = "ISITEST";
$opt_d = 1;
$opt_peval = 0;
$preference_offset = 110;
$peval = "../peval/peval";
$peval_options = " -h $whoishost -p $port -s $database -sync -expand_all";

&OpenConnection($whoishost,$port);
&AskServer("s$database", *data);
&AskServer("man,$as", *data);

&data2policy("$as",*data,*policy);
print STDERR join("\n", %policy), "\n" if ($opt_d);

&policy2filters_for_all(*policy, *filter);

if ($opt_peval) {
    &StartPeval($peval, $peval_options);
    $| = 1;
}

foreach $key (sort keys %filter) {
    ($keyword, $as, $peeras, $br, $peerbr) = split(/%/, $key);
    foreach $policy (split(/\+/, $filter{$key})) {
	($pref, $rpe) = split(/ /, $policy, 2);
	print "$keyword: $as $peeras $br $peerbr $pref ";
	if ($opt_peval) {
	    do AskPeval("$rpe");
	} else {
	    print "$rpe\n";
	}
    }
}


&CloseConnection($whoishost,$port);
&EndPeval() if ($opt_peval);
exit;
