#define YES 1
#define NO 0
#define ON 1
#define OFF 0
#define MAXN 500  /* maximum number of nodes to allow for as neighbors */
#define TRN_THRES .03 /* amount turn to trigger new search list */
#define INIT_HDNG 0
#define SEARCH_SIZE 30   /* how wide a sweep to search */
#define PIXPERDEGREE 20  /*pixels per degree  */
#define DEGREEPERSCRN 45  /* 45 degrees per screen  */
#define PIXSIX 120 /* pixels per six degree increment  */
#define PIX3DEGREES 60 /* pixels per 3 degrees */
#define MAXUPDATECLOCK 5    /* slowest frequency to updatepos  */
#define YDSPERUNIT 17.5  /* 17.5 yds per world cartesian unit */

/* The next two are declared in LINKNODES to make the original data set.  
*  They're used in make_neighbor_list   */
#define PIESIZE 6
#define PIECUTS 360/PIESIZE
#define MAX_NODES 1500

/*
*  Define node_types masks:   1= pset, 2= chart sym, 4= real, 8= effector
*/
#define PSET 1
#define CHTSYM 2
#define REAL 4
#define EFF 8
#define ANYTYPE 15
/*
*  Define chart_touch_context_flags:
*/
#define ZOOM 	0
#define PUTB 	1
#define SHOW 	2
#define SHOW1 	3
#define SHOW2 	4
#define LOP 	5
#define LOP1	6


#define WATER_MODE 1
#define CHART_MODE 2
#define AERIAL_MODE 3

#define WATER 1
#define CHART 2
#define AERIAL 3

/*  these are used by lopmode in LOP functions */
#define POSN1 1
#define POSN2 2
        
#define HEAD 1
#define TAIL 2
#define NEWLINE 3
#define ERASE 4
#define STOP 5
#define CANCEL 6
#define SELECT 7

/*****************************************************************
*  BOAT STRUCT ACCESSORS
*/
#define BOAT_TIME(arg)   		arg->time
#define BOAT_TIME_EF(arg)		arg->time_ef
#define BOAT_TIMREQIDT(arg)  		arg->timreqidt
#define BOAT_X(arg)          		arg->x
#define BOAT_Y(arg)          		arg->y
#define BOAT_SPEED(arg)			arg->speed         
#define BOAT_UPDATE_CLOCK(arg)        	arg->update_clock  
#define BOAT_SPEED_MULTIPLIER(arg)      arg->speed_multiplier 
#define BOAT_HEADING(arg)       	arg->heading
#define BOAT_PROWX(arg)	       		arg->prowx
#define BOAT_PROWY(arg)	       		arg->prowy
#define BOAT_CURRENT_NODE(arg)      	arg->current_node
#define BOAT_PICSET(arg)       		arg->picset
#define BOAT_VIEW(arg)       		arg->view
#define BOAT_OLD_VIEW(arg)      	arg->old_view
#define BOAT_FORWARD_VIEW(arg)       	arg->forward_view
#define BOAT_GUNL_VIEW(arg)      	arg->gunl_view
#define BOAT_DRAFT(arg)       		arg->draft
#define BOAT_SPEEDLIMITFWD(arg)       	arg->speedlimitfwd
#define BOAT_SPEEDLIMITREV(arg)       	arg->speedlimitrev
#define BOAT_N_LIST(arg,ele)       	arg->n_list[ele]

/************************************************************************
*  LIST STRUCTURE ACCESSORS
*/
#define ELE_DAT(arg) 		arg->content
#define ELE_NEXT(arg) 		arg->next
#define ELE_PREV(arg) 		arg->prev


/************************************************************************
*  LOP STRUCTURE ACCESSORS
*/
#define LOP_NEXT(arg) 		arg->next
#define LOP_PREV(arg) 		arg->prev
#define LOP_X1(arg) 		arg->wx1
#define LOP_Y1(arg) 		arg->wy1
#define LOP_X2(arg) 		arg->wx2
#define LOP_Y2(arg) 		arg->wy2
#define LOP_LENGTH(arg) 	arg->length
#define LOP_ROSE1(arg) 		arg->rose1
#define LOP_ROSE2(arg) 		arg->rose2
   
/************************************************************************
*  POS STRUCTURE ACCESSORS  (for converting touch to world)
*/
#define POS_TYPE(arg) 		arg->type
#define POS_WX(arg) 		arg->wx
#define POS_WY(arg) 		arg->wy
#define POS_SX(arg) 		arg->sx
#define POS_SY(arg) 		arg->sy


/************************************************************************
*  BOX STRUCTURE ACCESSORS
*/
#define BOX_SEEN(arg)		arg->seen
#define BOX_X(arg)		arg->x
#define BOX_Y(arg)		arg->y
#define BOX_WDTH(arg)		arg->wdth
#define BOX_HGHT(arg)		arg->hght

typedef struct box{
  			int 	seen;
			float   x;
			float   y;
			float   wdth;
			float   hght;
	    } Box;

/************************************************************************
*  BOAT STRUCT 
* 
*/
typedef struct boat_struct {
    unsigned int time[2];
    long	time_ef;
    long	timreqidt;
    float 	x;
    float	y;
    int 	speed;           /*  speed is a combination of update_clock*/
    int		update_clock;    /*  sets how often pos'n updated      */
    int 	speed_multiplier;  /*  and multiplier used on trig vals.*/
    int 	heading;
    float       prowx;
    float	prowy;
    int		current_node;
    int 	picset;
    int 	view;
    int		old_view;
    int 	forward_view;
    int		gunl_view;
    int 	draft;                                   
    int 	speedlimitfwd;                 
    int 	speedlimitrev;
    /* following is ptr to an array of ints -- the neighbor list  */
    int		*n_list[SEARCH_SIZE+3];
    } Boat_struct;
                   
    
Boat_struct *african_queen;   /* the main one is called boat */
Boat_struct *show_boat;       /* and one for the show routine  */
Boat_struct *boat;            /* current boat variable*/



/************************************************************************
*   NODE STRUCTURE
*
*   There will be a structure for nodes with an identifier, x, y, and z
*    coords, and other data including a type code (picture set, real
*    object, e.g. house, rock, etc.), and possibly text description.  
*    Chart symbols -- some code real objects, others are labels, some 
*    show depth contours or bottom condition.
*    Symbols may refer to a point, a line, or an area -- these are problems
*    for another day.  
*/
                   
/*  Declare the structure of the nodes.  
*/

typedef struct node {
		int	node_x;
		int	node_y;
		int	node_z;     /* depth over water, elevation over land*/
		int	node_type;
		int 	picture_ptr;  /* what picture set (-1 if none)  */
		int     chart_ptr;    /* what chart object (-1 if none) */
		int	current_ptr;  /* what current effect   "      */
		int	object_ptr;   /* what object data              */
		int     geom;
		int     prox;  /* proximity, for historesis  */
		int     n_list[PIECUTS];  /* neighbor_list  */
	     } Node;


/*  Declare an array of pointers to an array of node structures called WORLD.
*/

static struct node *world[MAX_NODES];




/***********************************************************************
*   PSET STRUCTURE  
*/

typedef struct pictureset {
		   int  first;
		   int  compass_error;  /* compass correction factor  */  
                   } Pictureset;

static struct pictureset *picture_sets[MAX_NODES];


/************************************************************************
*  LIST STRUCTURES
*/

typedef struct ele {	struct ele	*next;
		struct ele 	*prev;
		int		content; 
		} Ele;

struct ele list;                                                   


/**********************************************************************
*   LOP STRUCTURE
*/

typedef struct lop {  	struct lop *next;
		struct lop *prev;
		float	wx1;
		float	wy1;
		float	wx2;
		float	wy2;
		int	length;
		int	rose1;
       		int	rose2;
		} Lop;


   static Lop lps, *lops = &lps;   /* make one at a global level */
   static struct lop *current_lop = &lps;  /* and a moveable one */


/**********************************************************************
*   POS STRUCTURE
*/

struct pos {  	int  	type;
		float	wx;
		float	wy;
		float	sx;
		float	sy;
		}; 

struct pos psn;
struct pos *posn = &psn;	
struct pos wpsn;
struct pos *wld_posn = &wpsn;

/*******************************************************************
*  COMPASS STRUCT
*/
struct compass_struct {   float x;
			  float y;
	     		  int on;
			  int reading; 
			  int variation;  } compass = {0, 0, 0, 0, 16};


/*************************************************************************
*    DISPLAY STRUCTURES
*/

struct disp { float x;
	      float y;
	      int labx;
	      int laby;
	      char *label;
	      int valx;
	      int valy;};

struct disp spdmeter = {0,0,1,2,"Speed: ",1,9};
struct disp dbg = {0,0,1,2,"DBG: ",1,15};
struct disp chtcontrol = {0,0,1,2,
"ZOOM UP           PUT BOAT            SHOW            LOP            CANCEL  ",
       			  0,0};
struct disp aercontrol = {0,0,1,2,
"ZOOM UP           PUT BOAT            SHOW            LOP            CANCEL  ",
       			  0,0};
struct disp showmenu = {0,0,1,2,
"ON WATER       ON WATER FROM...       AERIAL        CHART            CANCEL  ",
                        0,0};
struct disp lopmenu = {0,0,1,2,
"SELECT    OTHER END    DELETE     NEW LINE     EXIT      REDRAW      ERASE  ",
                        0,0};
             
/*************************************************************************
*  PDI STRUCT
*
*/
struct pdi_struct {int dummy[20];
		   int did[2];
	    	   int status[2];
	    	   int butmsk;
	    	   int tmo;
	    	   int button;
	    	   int xpos;
	    	   int ypos;
		   int oldx;
		   int oldy;
	 	   int bounds[4];
	    	   int buffer[20];
		   char typeahead[100];};

struct pdi_struct pdi;

/***********************************************************************
*
*  This makes a global structure for the search parameters holding the
*   turn threshold that triggers a new n_list, a direction bias, a minimum
*   search range, and an expansion factor that increases the search bias
*   and minimum.
*/

struct search_params {
 	float turn_threshold;
	int   heading;
	int   neighbors_desired; }  srch ={TRN_THRES, 
					   INIT_HDNG, 
					   SEARCH_SIZE};

/************************************************************************
*   CHART STRUCTURES AND DEFINITIONS
*/

/* matrix dimensions in chart structure  */
#define CHTX 0
#define CHTY 1                  
#define CHTWIDTH 2
#define CHTHEIGHT 3
#define CHTDX 4
#define CHTDY 5         
#define CHTFRAME1 6

struct pos3d {int level, 
		  x, 
		  y; };

struct cht_struct {
	int 	numlevel;     /* how many levels in pyramid */
	int	matrix[5][7];  /* 5 levels: x, y, width(wld units), dx, dy, */
	int	first_frame;
	struct pos3d posn;
	struct pos3d init;
	int 	wld_orig_x;   /* same all levels -- top left corner */
	int	wld_orig_y;
	int	index;
	int 	frame;          
	int	framex;
	int 	framey; };
/***********************************************************************
*  AERIAL PHOTO STRUCTURES
*/
/* matrix dimensions in aerial structure  */
#define AERX 0
#define AERY 1                        
#define AERWIDTH 2
#define AERHEIGHT 3
#define AERDX 4
#define AERDY 5
#define AERFRAME1 6


struct aer_struct {
	int	numlevel;
	int	matrix[2][7];  /* 2 levels: x, y, width(wld units), dx, dy, */
        int     rowxes[2][30];    /* stores indiv. row widths  */
	int	first_frame;
	struct pos3d posn;
	struct pos3d init;
   	int 	wld_orig_x;   /* same all levels -- top left corner */
	int	wld_orig_y;
	int	index;
      	int 	frame;  
	int	framex;                           
	int 	framey; };
		
/************************************************************************
*************************************************************************
*  GLOBAL VARIABLE DECLARATIONS
*/

int debug = OFF;
int simulator_mode = CHART_MODE;
int chart_touch_context_flag = ZOOM;
int aerial_touch_context_flag = ZOOM;
int current_frame;
int return_status;

/* this is used in calc_xypos  */
float time_scalar = .5;

/*  global variable to hold the number of nodes in the world
*/
int total_node_count;




/*char *text[80];*/
char generalbuffer[80];
char *buff = generalbuffer;
