#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#include "widgets.h"


 int
getmap(fp, m, e)
  FILE 		*fp;
  Map 		*m;
  Element	*e;

{
  Lkup_union    lkp, *lkup = &lkp;
  static char 	*funcname = "getmap";
  int 		n;
  char 		*rindex(), *colon;
  char 		*line;
  char		tname[Nchars],tval[Nchars];
  extern char *lookup_map_type();


  if((line = get_data_line(fp)) == NULL)
    	{
	  	printf("%s: missing data at line %d\n",funcname, linecount);
		exit(1);
	 }


  sscanf(line,"%s %[^\n]\n",tname,tval);
 	 if( (colon = rindex(tname,':')) !=0 )
	 {
    		*colon = '\0';
  	  }

  if((n = lookup(tname)) != NULL)
  {
      	if(n != TYPE)
      	{
	  	printf("%s: first parameter of a map must be `type:'\n"
			,funcname);
	  	return(-1);
       	 }
      	strcpy(lkup->name,tval);
      	if((m->simple.type = (int)lookup_map_type(Key,lkup)) == FAILURE)
	{
       		printf("%s: Bad map type '%s'in line %d\n"
				,funcname,tval,linecount);
      	 }
	  	switch(m->simple.type)
		{
		  case STILL_MAP:
		  case VIDEO_MAP:
			n = getsimple(fp, m);
			return(n);
		  case COMPLEX_MAP:
			n = getcomplex(fp, m);
			break;
	  	  case BUTTON_MAP:
			if((m->simple.w = 
				(Window) calloc(1, sizeof(Button))) == NULL)
			{
				printf("%s: can't allocate Button\n"
					,funcname);
			 }
			n = getbutton(fp, m, e);
	    		return(n);

	  	  case TKSCROLL_MAP:
			if((m->simple.w = 
				(Window) calloc(1, sizeof(TKscrollbar)))==NULL)
			{
				printf("%s: can't allocate TKscrollbar\n"
					,funcname);
			 }
			n = getTKscroll(fp, m, e);
	    		return(n);

	    	  case TKDIALOG_MAP:
			if((m->simple.w = 
				(Window) calloc(1, sizeof(TKdialog)))==NULL)
			{
				printf("%s: can't allocate TKdialog\n"
					,funcname);
			 }
	    		n = getTKdialog(fp, m, e);
	    		return(n);
	    	  case TKTEXT_MAP:
	    		n = getTKtext(fp, m, e);
	    		return(n);

		  case LINE_MAP:
		  case LABEL_MAP:
		  case ARC_MAP:
		  case BOX_MAP:
			n = getgraphic(fp, m); 
		  	break;
	  	  default:
	    		printf("%s: can't use `%s', line %d\n"
				,funcname,tval,linecount);
	  	 }
   }  
   else printf("%s: can't use `%s', line %d\n",funcname,tname,linecount);
}

