/*
 * Operators used in the expr/test command.
 */

#include "../shell.h"
#include "operators.h"

char *const unary_op[] = {
      "!",
      "-r",
      "-w",
      "-x",
      "-f",
      "-d",
      "-c",
      "-b",
      "-p",
      "-u",
      "-g",
      "-k",
      "-s",
      "-t",
      "-z",
      "-n",
      NULL
};

char *const binary_op[] = {
      "-o",
      "|",
      "-a",
      "&",
      "=",
      "!=",
      "-eq",
      "-ne",
      "-gt",
      "-lt",
      "-le",
      "-ge",
      "+",
      "-",
      "*",
      "/",
      "%",
      ":",
      NULL
};

const char op_priority[] = {
      3,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      12,
      1,
      1,
      2,
      2,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      4,
      5,
      5,
      6,
      6,
      6,
      7,
};

const char op_argflag[] = {
      0,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_FILE,
      OP_INT,
      OP_STRING,
      OP_STRING,
      0,
      0,
      0,
      0,
      OP_STRING,
      OP_STRING,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_INT,
      OP_STRING,
};
