# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

#ifdef FLUKE
# ifndef LINT
    static char RCSid[] = "@(#)FLUKE  $Header: /afs/athena.mit.edu/contrib/watchmaker/src/ease/src/RCS/lexan.l,v 1.4 91/05/16 16:31:54 jik Exp $";
# endif LINT
#endif FLUKE

/*
 *	lexan.l -- Lexical Analyzer for EASE.
 *
 *		   Contains code for lex(1) which generates a lexical
 *		   analyzer (lex.yy.c) for Ease, a high-level specification 
 *		   format for sendmail configuration files.
 *
 *	author -- James S. Schoner, Purdue University Computing Center,
 *				    West Lafayette, Indiana  47907
 *
 *	date   -- July 1, 1985
 *
 *	Copyright (c) 1985 by Purdue Research Foundation
 *
 *	All rights reserved.
 *
 * $Log:	lexan.l,v $
 * Revision 1.4  91/05/16  16:31:54  jik
 * merge in patch 3.2
 * 
 * Revision 1.1.1.2  91/05/16  16:24:10  jik
 * Patch 3.2.
 * 
 * Revision 1.1.1.1  91/02/27  23:05:00  jik
 * Patch 3.1 from the net.
 * 
 * Revision 1.1  91/02/24  20:24:11  jik
 * Initial revision
 * 
 * Revision 3.2  1991/05/16  10:45:25  barnett
 * Better support for System V machines
 * Support for machines with read only text segments
 *
 * Revision 3.1  1991/02/25  22:09:52  barnett
 * Fixed some portability problems
 *
 * Revision 3.0  1991/02/22  18:50:27  barnett
 * Added support for HP/UX and IDA sendmail.
 *
 * Revision 2.3  1991/02/12  20:49:34  barnett
 * Added several new tokens.
 * Merged Jeff's changes with my own.
 *
 * Revision 2.2  1990/05/07  11:12:53  jeff
 * Add support for the "Cflag" variable which controls whether or not
 * input lines are passed through as comments in the output stream.
 *
 * Version 2.1  90/01/30  15:26:23  jeff
 * If -C flag is specified, emit input as comments in the output stream.
 * 
 * Revision 2.0  88/06/15  15:11:30  root
 * Baseline release for net posting. ADR.
 * 
 */

#include "fixstrings.h"
#include "symtab.h"
#include "lexdefs.h"

#define  LEXnewline '\n'
#define	 LEXeof	    '\0'
#define  MaxFN	    200			/* maximum file name length */

extern int	  EchoInputAsComments;
extern struct he *LookupSymbol ();
extern void	  ErrorReport ();
extern void	  yymark();
extern void	  PrintError();
extern char *	  malloc ();

int  Lcount;				/* line counter		    */
char FNbuf[MaxFN];			/* file name buffer	    */
short RMatch  = FALSE;			/* ruleset match flag  	    */

#ifdef YYDEBUG
extern int yychar;
#else
int   yychar;
#endif

#undef input
# define input() (((yytchar=yychar=yysptr>yysbuf?U(*--yysptr):Getc(yyin,yyout))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)

int
Getc (yyin, yyout)
	FILE *yyin, *yyout;
{
	static char linbuf[BUFSIZ], *pc = linbuf;
	char c;

	/* initialize buffer: first call only */
	if (*pc == '\0' && pc == linbuf) {
		if (fgets(linbuf, BUFSIZ, yyin)==NULL)
			return EOF;
		/* echo input as comment */
		if (EchoInputAsComments) {
		    fprintf(yyout, "%s%s", (linbuf[0] == '#' ? "" : "# "), linbuf);
		}
	}
	c = *pc++;
	if (c == '\n') {
		pc = linbuf;
		if (fgets(linbuf, BUFSIZ, yyin) == NULL)
			*pc = (char) EOF;
		else
			/* echo input as comment (except cpp comments) */
			if (EchoInputAsComments) {
			    fprintf(yyout, "%s%s",
				(linbuf[0] == '#' ? "" : "# "), linbuf);
			}
	}
 	return (c == (char) EOF) ? EOF : c;
}

/*
 * Table of keywords. NOTE: This is in sorted order, and
 * must stay that way if anything else is added to it.
 */
static struct resword {
	char	*r_text;
	int	r_tokval;
} reswords[] = {
	{ "Argv",		MARGV },
	{ "Eol",		MEOL },
	{ "Flags",		MFLAGS },
	{ "Maxsize",		MMAXSIZE },
	{ "Path",		MPATH },
	{ "Recipient",		MRECIPIENT },
	{ "Sender",		MSENDER },
 	{ "alias",		ALIAS },
 	{ "asm",		ASM },
	{ "bind",		BIND },
	{ "canon",		CANON },
	{ "class",		CLASS },
	{ "concat",		CONCAT },
	{ "d_background",	DOPTB },
	{ "d_interactive",	DOPTI },
	{ "d_queue",		DOPTQ },
	{ "dbm",		DBM },	   /* IDA */
	{ "default",		DEFAULT }, /* IDA */
	{ "define",		DEFINE },
 	{ "eval",		EVAL },
	{ "f_addrw",		CCFLAG },
	{ "f_arpa",		AAFLAG },
 	{ "f_bsmtp",		BBFLAG },	/* IDA */
	{ "f_date",		DDFLAG },
	{ "f_dot",		XXFLAG },
	{ "f_escape",		EEFLAG },
	{ "f_expensive",	EFLAG },
	{ "f_ffrom",		FFLAG },
	{ "f_from",		FFFLAG },
	{ "f_full",		XFLAG },
	{ "f_llimit",		LLFLAG },
	{ "f_locm",		LFLAG },
	{ "f_mail11",		HHFLAG },  /* Ultrix */
	{ "f_mesg",		MMFLAG },
	{ "f_mult",		MFLAG },
	{ "f_noreset",		SSFLAG },
	{ "f_noufrom",		NFLAG },
 	{ "f_relativize",	VVFLAG },	/* IDA */
	{ "f_retsmtp",		PFLAG },
	{ "f_return",		PPFLAG },
	{ "f_rfrom",		RFLAG },
	{ "f_rport",		RRFLAG },
	{ "f_smtp",		IIFLAG },
	{ "f_strip",		SFLAG },
	{ "f_ufrom",		UUFLAG },
	{ "f_upperh",		HFLAG },
	{ "f_upperu",		UFLAG },
	{ "field",		FIELD },
	{ "for",		FOR },
	{ "h_exit",		EOPTE },
	{ "h_mail",		EOPTM },
	{ "h_mailz",		EOPTZ },
	{ "h_print",		EOPTP },
	{ "h_write",		EOPTW },
	{ "header",		HEADER },
	{ "host",		HOST },
	{ "hostnum",		HOSTNUM },
	{ "if",			IF },
	{ "ifset",		IFSET },
	{ "in",			IN },
	{ "macro",		MACRO },
	{ "mailer",		MAILER },
	{ "map",		MAP },
	{ "match",		MATCH },
	{ "next",		NEXT },
	{ "o_alias",		AAOPT },
 	{ "o_aliasfile",	YYOPT },	/* SunOS */
	{ "o_bsub",		BBOPT },
	{ "o_checkpoint",	CCOPT },
	{ "o_delivery",		DOPT },
	{ "o_dmuid",		UOPT },
	{ "o_dnet",		NNOPT },
 	{ "o_envelope",		SLOPT },	/* IDA */
	{ "o_ewait",		AOPT },
	{ "o_flog",		SSOPT },
	{ "o_fsmtp",		HHOPT },
	{ "o_gid",		GOPT },
	{ "o_handling",		EOPT },
	{ "o_hformat",		OOPT },
	{ "o_loadnc",		XXOPT },
	{ "o_loadq",		XOPT },
	{ "o_maxempty",		BOPT },	/* SunOS */
 	{ "o_maxhops",		HOPT }, /* SunOS */
  	{ "o_nameserver",	IIOPT }, /* HP/UX */
  	{ "o_newproc",		YYOPT },
 	{ "o_nfs",		RROPT },	/* SunOS 4.0 */
	{ "o_pmaster",		PPOPT },
	{ "o_prifactor",	ZOPT },
	{ "o_qdir",		QQOPT },
	{ "o_qfactor",		QOPT },
	{ "o_qtimeout",		TTOPT },
	{ "o_qwait",		COPT },
	{ "o_rebuild",		DDOPT },
	{ "o_recipfactor",	YOPT },
	{ "o_rsend",		MOPT },
	{ "o_safe",		SOPT },
	{ "o_skipd",		IOPT },
	{ "o_slog",		LLOPT },
	{ "o_timezone",		TOPT },
	{ "o_tmode",		FFOPT },
	{ "o_tread",		ROPT },
	{ "o_usave",		FOPT },
	{ "o_validate",		NOPT },
	{ "o_verbose",		VOPT },
	{ "o_waitfactor",	ZZOPT },
	{ "o_wizpass",		WWOPT },
	{ "options",		OPTIONS },
	{ "precedence",		PRECEDENCE },
 	{ "program",		PROGRAM },	/* HP/UX */
 	{ "quote",		QUOTE },
	{ "readclass",		READCLASS },
	{ "resolve",		RESOLVE },
 	{ "resolved",		RESOLVED },
	{ "retry",		RETRY },
	{ "return",		RETURN },
	{ "ruleset",		RULESET },
	{ "trusted",		TRUSTED },
	{ "user",		USER },
	{ "while",		IF },
 	{ "ypalias",		YPALIAS },	/* Ultrix */
 	{ "ypmap",		YPMAP },	/* SunOS */
 	{ "yppasswd",		YPPASSWD },	/* Ultrix */
};
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
int INch;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
		;
break;
case 2:
			Lcount++;
break;
case 3:
{
/*			        sscanf (yytext, "%*c%d%s", &Lcount, FNbuf); */
	                        yymark();
			        }
break;
case 4:
	{
				register int l, h, m, r, c;

				l = 0;
				h = (sizeof (reswords) / sizeof(reswords[0])) - 1;
				while (l <= h) {
					m = (h + l) / 2;
					c = yytext[0] - reswords[m].r_text[0];
					r = c ? c : strcmp (yytext, reswords[m].r_text);
					if (r < 0)
						h = m - 1;
					else if (r > 0)
						l = m + 1;
					else
						return reswords[m].r_tokval;
				}

				/* not a keyword */

				/* store identifiers in symbol table */
				yylval.phe = LookupSymbol (yytext);
				return (IDENT);
				}
break;
case 5:
{
				if ((INch = input()) == LEXnewline) {
					ErrorReport ("End of line in string.\n");
					unput (INch);
				}
				fixquotes ();
				yylval.psb = (char *) malloc (strlen (yytext) + 1);
				strcpy (yylval.psb, yytext + 1);
				return (SCONST);
				}
break;
case 6:
		{
				sscanf (yytext, "%o", &yylval.ival);  /* octal constant */
				return (ICONST);
				}
break;
case 7:
		{
				yylval.ival = atoi (yytext);
				return (ICONST);
				}
break;
case 8:
			return (ASGN);
break;
case 9:
			return (COMMA);
break;
case 10:
			return (LBRACE);
break;
case 11:
			return (RBRACE);
break;
case 12:
			return (LPAREN);
break;
case 13:
			return (RPAREN);
break;
case 14:
			return (SEMI);
break;
case 15:
			return (DOLLAR);
break;
case 16:
			return (COLON);
break;
case 17:
			return (STAR);
break;
case 18:
			{
				/* eat C comments */
				INch = input ();
				while ((INch != '*') || 
				      ((INch = input ()) != '/')) {
					if (INch == LEXnewline)
						Lcount++;
					else
						if (INch == LEXeof) {
							ErrorReport ("End of file in comment.\n");
							break;
						}
					if (INch != '*')
						INch = input ();
				}
				}
break;
case 19:
			return (SLASH);
break;
case 20:
			{
				if (RMatch) {	/* in rulesets, return literal character */
					yylval.ival = (yytext[0] == '\\') ? yytext[1] : yytext[0];
					return (SEPCHAR);
				} else {
					PrintError ("Illegal delimiter character: (octal code) \\%03o", *yytext);
				}
				}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

/*
 * fixquotes --- inside a "quoted string", turn `\"' into just `"'
 *
 * this is most useful inside the Argv strings for mailers,
 * particularly when debugging.
 */

fixquotes ()
{
	register char *cp1, *cp2;

	cp1 = cp2 = yytext;
	while (*cp2) {
		/*
		 * if we really wanted to get fancy,
		 * at this point we'd handle C escapes,
		 * but I don't think it's necessary.
		 */
		if (*cp2 == '\\' && cp2[1] == '"')
			cp2++;
		*cp1++ = *cp2++;
	}
	*cp1++ = *cp2++;	/* final '\0' */
}
int yyvstop[] ={
0,

20,
0,

1,
20,
0,

2,
0,

5,
20,
0,

15,
20,
0,

12,
20,
0,

13,
20,
0,

17,
20,
0,

9,
20,
0,

20,
0,

19,
20,
0,

6,
20,
0,

7,
20,
0,

16,
20,
0,

14,
20,
0,

8,
20,
0,

4,
20,
0,

20,
0,

10,
20,
0,

11,
20,
0,

20,
0,

1,
0,

5,
0,

5,
0,

7,
0,

18,
0,

6,
0,

4,
0,

3,
0,
0};
# define YYTYPE char
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
25,0,	1,4,	0,0,	4,24,	
26,25,	0,0,	4,24,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	32,33,	0,0,	1,6,	
25,0,	1,7,	4,24,	0,0,	
26,25,	1,8,	1,9,	1,10,	
6,25,	1,11,	1,12,	13,28,	
1,13,	1,14,	1,15,	15,27,	
6,25,	6,0,	27,27,	6,25,	
32,33,	1,15,	32,34,	1,16,	
1,17,	0,0,	1,18,	2,23,	
2,7,	0,0,	1,19,	0,0,	
2,8,	2,9,	2,10,	33,33,	
2,11,	0,0,	0,0,	2,13,	
0,0,	6,0,	14,29,	14,29,	
14,29,	14,29,	14,29,	14,29,	
14,29,	14,29,	2,16,	2,17,	
6,25,	2,18,	0,0,	6,25,	
6,25,	1,20,	33,33,	0,0,	
33,34,	0,0,	0,0,	6,25,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
6,25,	12,27,	12,27,	12,27,	
12,27,	12,27,	12,27,	12,27,	
12,27,	12,27,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
1,21,	0,0,	1,22,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,30,	6,26,	
0,0,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	0,0,	
0,0,	0,0,	0,0,	2,21,	
0,0,	2,22,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
0,0,	0,0,	0,0,	0,0,	
19,30,	0,0,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
19,30,	19,30,	19,30,	19,30,	
20,3,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
20,3,	20,0,	0,0,	20,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	23,31,	0,0,	
0,0,	0,0,	0,0,	0,0,	
35,36,	20,3,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
35,35,	35,37,	34,34,	35,36,	
20,3,	0,0,	0,0,	20,3,	
20,3,	23,31,	34,34,	34,0,	
0,0,	34,34,	0,0,	20,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
20,3,	23,32,	23,32,	23,32,	
23,32,	23,32,	23,32,	23,32,	
23,32,	23,32,	23,32,	34,35,	
35,36,	0,0,	0,0,	35,36,	
35,36,	0,0,	0,0,	0,0,	
36,36,	0,0,	34,34,	35,36,	
0,0,	34,34,	34,34,	20,3,	
36,36,	36,37,	0,0,	36,36,	
35,36,	34,34,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	34,34,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	35,36,	
0,0,	0,0,	0,0,	0,0,	
36,36,	0,0,	0,0,	36,36,	
36,36,	34,34,	0,0,	0,0,	
0,0,	0,0,	0,0,	36,36,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,36,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	36,36,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-28,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+6,	0,		yyvstop+3,
yycrank+0,	0,		yyvstop+6,
yycrank+-43,	0,		yyvstop+8,
yycrank+0,	0,		yyvstop+11,
yycrank+0,	0,		yyvstop+14,
yycrank+0,	0,		yyvstop+17,
yycrank+0,	0,		yyvstop+20,
yycrank+0,	0,		yyvstop+23,
yycrank+60,	0,		yyvstop+26,
yycrank+5,	0,		yyvstop+28,
yycrank+30,	0,		yyvstop+31,
yycrank+3,	yysvec+12,	yyvstop+34,
yycrank+0,	0,		yyvstop+37,
yycrank+0,	0,		yyvstop+40,
yycrank+0,	0,		yyvstop+43,
yycrank+89,	0,		yyvstop+46,
yycrank+-211,	0,		yyvstop+49,
yycrank+0,	0,		yyvstop+51,
yycrank+0,	0,		yyvstop+54,
yycrank+229,	0,		yyvstop+57,
yycrank+0,	yysvec+4,	yyvstop+59,
yycrank+-2,	yysvec+6,	yyvstop+61,
yycrank+-6,	yysvec+6,	yyvstop+63,
yycrank+6,	yysvec+12,	yyvstop+65,
yycrank+0,	0,		yyvstop+67,
yycrank+0,	yysvec+14,	yyvstop+69,
yycrank+0,	yysvec+19,	yyvstop+71,
yycrank+0,	yysvec+23,	0,	
yycrank+24,	yysvec+23,	0,	
yycrank+62,	0,		0,	
yycrank+-253,	0,		0,	
yycrank+-243,	yysvec+34,	0,	
yycrank+-295,	yysvec+34,	0,	
yycrank+0,	0,		yyvstop+73,
0,	0,	0};
struct yywork *yytop = yycrank+387;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,014 ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,'"' ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,'-' ,01  ,01  ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'8' ,'8' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,0134,01  ,01  ,'A' ,
01  ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,'A' ,
'A' ,'A' ,'A' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
