
# line 2 "parser.y"
#ifdef FLUKE
# ifndef LINT
    static char RCSid[] = "@(#)FLUKE  $Header: /afs/athena.mit.edu/contrib/watchmaker/src/ease/src/RCS/parser.y,v 1.7 91/10/15 14:36:42 jik Exp $";
# endif LINT
#endif FLUKE

/*
 *	parser.y -- EASE parser.
 *
 *		    Contains code for yacc(1) which produces a parser (y.tab.c)
 *		    for Ease, a specification format for sendmail configuration
 *		    files.
 *
 *	author   -- James S. Schoner, Purdue University Computing Center,
 *		    		      West Lafayette, Indiana  47907
 *
 *	date     -- July 2, 1985
 *
 *	Copyright (c) 1985 by Purdue Research Foundation
 *
 *	All rights reserved.
 *
 * $Log:	parser.y,v $
 * Revision 1.7  91/10/15  14:36:42  jik
 * Merge in 1.1.1.4..
 * 
 * Revision 1.6  91/09/11  19:10:56  jik
 * Merge in 1.1.1.3.
 * 
 * Revision 1.5  91/05/16  16:50:17  jik
 * Strdup, not strdup
 * 
 * Revision 1.4  91/05/16  16:31:59  jik
 * merge in patch 3.2
 * 
 * Revision 1.1.1.2  91/05/16  16:24:55  jik
 * Patch 3.2.
 * 
 * Revision 1.1.1.1  91/02/27  23:06:13  jik
 * Patch 3.1 from the net.
 * 
 * Revision 1.1  91/02/24  21:10:18  jik
 * Initial revision
 * 
 * Revision 3.4  1991/10/15  17:02:04  barnett
 * Detect if (one_or_more) next ($2) error
 *
 * Revision 3.3  1991/09/09  16:33:23  barnett
 * Minor bug fix release
 *
 * Revision 3.2  1991/05/16  10:45:25  barnett
 * Better support for System V machines
 * Support for machines with read only text segments
 *
 * Revision 3.1  1991/02/25  22:09:52  barnett
 * Fixed some portability problems
 *
 * Revision 3.0  1991/02/22  18:50:27  barnett
 * Added support for HP/UX and IDA sendmail.
 *
 * Revision 2.1  1990/01/30  15:48:35  jeff
 * Added SunOS/Ultrix/IDA extensions  Jan 24, 1989 Bruce Barnett
 *
 * Version 2.0  90/01/30  15:44:34  jeff
 * Baseline release for netwide posting.
 * 
 */

#include "fixstrings.h"
#include <stdio.h>
#include "symtab.h"
#include <ctype.h>
extern void	   BindID ();
extern void	   EmitDef ();
extern char	  *ListAppend ();
extern char 	  *MakeCond ();
extern char	  *MakeRStr ();
extern char       *ConvOpt ();
extern char	  *ConvFlg ();
extern char	  *MacScan ();
extern char	  *ConvMat ();
extern void	   StartRuleset ();
extern char	  *MakePosTok ();
extern char	  *GetField ();
extern char	  *Bracket ();
extern char	  *DbmParen ();
extern char	  *MakeRSCall ();
extern char	  *CheckMailer ();
extern char	  *CheckRS ();
extern char	  *MakeField ();
extern char	   MakeMac ();
extern void	   AssignType ();
extern void	   RemoveSymbol ();
extern void	   yyerror ();
extern void	   FatalError ();
extern short RMatch;		/* ruleset match flag 		      */
extern short number_of_fields;	/* number of fields on the line	      */
#ifdef DATA_RW
char *Cbuf = " ";		/* character buffer   		      */
char *Mbuf = "$ ";		/* macro buffer	      		      */
#else
char *Cbuf = NULL;
char *Mbuf = NULL;
extern char *Strdup(); 
#endif
char *Tsb;			/* pointer to temporary string buffer */
char *Tsb1;			/* pointer to another temporary string buffer */
char *Flaglist;			/* pointer to header flag list	      */

#define DIM(x)	(sizeof x/sizeof x[0])
extern int yychar;
extern int	yydebug;

#ifndef	DATA_RW
void InitParser()
{
	if(!(Cbuf = Strdup(" ")) || !(Mbuf = Strdup("$ ")))
		FatalError("Out of memory in InitParser()", (char *)NULL);
}
#endif

static void	
Free( ptr )
char *ptr;
  {
      if (ptr == (char *)0) {
/*	  fprintf(stderr,"Freeing a null pointer\n"); */
      } else {
	  if (free(ptr) < 0 ) {
	      fprintf(stderr,"Free() returned an error\n");
	  }
      }
      fflush(stderr);
  };
static char *
yydisplay(ch)
     register int ch;
{
    static char buf[15];
    static char * token[] = {
#include "y.tok.h"
	0 };

    switch (ch) {
      case 0:
	return "[end of file]";
/* YYERRCODE is 256. See below */
/*      case YYERRCODE:
	return "[error]"; */
      case '\b':
	return "'\\b'";
      case '\f':
	return "'\\f'";
      case '\n':
	return "'\\n'";
      case '\r':
	return "'\\r'";
      case '\t':
	return "'\\t'";
    }
    /* I should use YYERRCODE - but it hasn't been defined yet */
    /* when /usr/lib/yaccpar is added to this file, it will be defined */
    if (ch == 256 ) return ("[error]"); 
    if (ch > 256 && ch < 256 + DIM(token))
      return token[ch - 257];
    if (isascii(ch) && isprint(ch))
      sprintf(buf, "'%c'",ch);
    else if (ch < 256)
      sprintf(buf, "Char %o4.3o", ch);
    else 
      sprintf(buf, "token %d", ch);
    return buf;
}
static yyyylex() 
{
	if (yychar < 0) {
	    /* don't make this match =yylex - because sed changes
	       =yylex to =yyyylex in the Makefile. 
	       the pieces it changes is in /usr/lib/yaccparr and I don't
	       want to modify THAT!  - bgb */

		if ((yychar = yylex ()) < 0)	/* call yylex, not yyyylex */
			yychar = 0;
#ifdef YYDEBUG
	if (yydebug)
		printf("[yydebug] reading %s\n",
			yydisplay(yychar));
		fflush(stdout);
#endif
		return yychar;
	}
}
 	


# line 198 "parser.y"
typedef union  {			/* value stack element type    */
	int	  ival;		/* integer token 	       */
	char	  *psb;		/* string token		       */
	struct he *phe;		/* pointer to hash entry       */
	enum opts optval;	/* sendmail options	       */
	enum flgs flgval;	/* mailer flags		       */
	enum mats mpval;	/* mailer attribute parameters */
} YYSTYPE;
# define IDENT 257
# define SCONST 258
# define ICONST 259
# define SEPCHAR 260
# define BIND 261
# define CANON 262
# define CLASS 263
# define CONCAT 264
# define FOR 265
# define HEADER 266
# define HOST 267
# define HOSTNUM 268
# define IF 269
# define IFSET 270
# define IN 271
# define MACRO 272
# define MAILER 273
# define MAP 274
# define MARGV 275
# define MATCH 276
# define MEOL 277
# define MFLAGS 278
# define MMAXSIZE 279
# define MPATH 280
# define MRECIPIENT 281
# define MSENDER 282
# define NEXT 283
# define OPTIONS 284
# define PRECEDENCE 285
# define READCLASS 286
# define RESOLVE 287
# define RETRY 288
# define RETURN 289
# define RULESET 290
# define TRUSTED 291
# define USER 292
# define YPALIAS 293
# define YPMAP 294
# define YPPASSWD 295
# define EVAL 296
# define RESOLVED 297
# define QUOTE 298
# define ASM 299
# define PROGRAM 300
# define DEFAULT 301
# define ALIAS 302
# define DBM 303
# define ASGN 304
# define COLON 305
# define COMMA 306
# define DEFINE 307
# define DOLLAR 308
# define FIELD 309
# define LBRACE 310
# define LPAREN 311
# define RBRACE 312
# define RPAREN 313
# define SEMI 314
# define STAR 315
# define SLASH 316
# define AAOPT 317
# define AOPT 318
# define BBOPT 319
# define CCOPT 320
# define COPT 321
# define DDOPT 322
# define DOPT 323
# define DOPTB 324
# define DOPTI 325
# define DOPTQ 326
# define EOPT 327
# define EOPTE 328
# define EOPTM 329
# define EOPTP 330
# define EOPTW 331
# define EOPTZ 332
# define FFOPT 333
# define FOPT 334
# define GOPT 335
# define HHOPT 336
# define IOPT 337
# define LLOPT 338
# define MOPT 339
# define NNOPT 340
# define NOPT 341
# define OOPT 342
# define PPOPT 343
# define QOPT 344
# define QQOPT 345
# define ROPT 346
# define SOPT 347
# define SSOPT 348
# define TOPT 349
# define TTOPT 350
# define UOPT 351
# define VOPT 352
# define WWOPT 353
# define XOPT 354
# define XXOPT 355
# define YOPT 356
# define YYOPT 357
# define ZOPT 358
# define ZZOPT 359
# define RROPT 360
# define BOPT 361
# define SLOPT 362
# define HOPT 363
# define IIOPT 364
# define AAFLAG 365
# define CCFLAG 366
# define DDFLAG 367
# define EEFLAG 368
# define EFLAG 369
# define FFFLAG 370
# define FFLAG 371
# define HFLAG 372
# define IIFLAG 373
# define LFLAG 374
# define LLFLAG 375
# define MFLAG 376
# define MMFLAG 377
# define NFLAG 378
# define PFLAG 379
# define PPFLAG 380
# define RFLAG 381
# define RRFLAG 382
# define SFLAG 383
# define SSFLAG 384
# define UFLAG 385
# define UUFLAG 386
# define XFLAG 387
# define XXFLAG 388
# define HHFLAG 389
# define VVFLAG 390
# define BBFLAG 391
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern short yyerrflag;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
YYSTYPE yylval, yyval;
# define YYERRCODE 256
short yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 409,
	313, 209,
	-2, 191,
	};
# define YYNPROD 302
# define YYLAST 1053
short yyact[]={

 395, 422, 424, 519, 518, 407, 388, 448, 390, 377,
 408, 325, 144, 447, 130, 131, 129, 132, 133, 334,
 391, 160, 168, 154, 169, 163, 153, 146, 159, 167,
 150, 165, 152, 155, 149, 166, 157, 147, 170, 151,
 148, 158, 162, 156, 164, 171, 172, 161, 389, 117,
 290, 336, 399, 400, 289, 116, 126, 125, 127, 294,
   4, 239,   6, 196, 314,  10, 315, 421, 410, 142,
 471,   5,  11, 372, 358, 369, 365, 351, 321, 357,
 359, 303, 470,   7,   8, 397, 302, 403, 300,  12,
   9, 398, 278, 394, 401, 343, 337, 335, 196, 402,
 196, 340, 275, 341, 532, 339, 338, 342,  13, 267,
 266, 280, 257, 216, 248, 113, 247, 246, 279, 308,
 242, 160, 168, 154, 169, 163, 153, 146, 159, 167,
 150, 165, 152, 155, 149, 166, 157, 147, 170, 151,
 148, 158, 162, 156, 164, 171, 172, 161,  42, 233,
 284, 222, 216, 212, 206, 320, 243, 210, 283, 215,
 200, 201, 117, 282, 208, 556,  43,  44,  45,  47,
  48,  49,  40, 207, 204, 194,  41, 173, 137,  92,
  89,  87,  50,  51,  52,  54,  55,  57,  58,  59,
  60,  62,  61,  64,  63,  65,  68,  67,  70,  69,
  71,  72,  73,  74,  75,  76,  77,  78,  79,  66,
  46,  80,  53,  56, 389, 117, 199, 336, 549, 400,
  84, 116,  81,  36,  34, 543, 542, 239, 326, 117,
 540, 336, 539, 533, 516, 116, 509, 508, 507, 501,
 358, 333, 481, 461, 259, 357, 359, 430, 404, 385,
 264, 397, 384, 403, 383, 368, 352, 398, 348, 394,
 401, 343, 337, 335, 330, 402, 331, 340, 332, 341,
 513, 339, 338, 342, 344, 343, 337, 335, 323, 329,
 265, 340, 316, 341, 324, 339, 338, 342, 285, 281,
 271, 295, 219, 263, 241, 217, 221, 209, 389, 117,
 240, 336, 220, 400, 192, 116, 205, 554, 102, 530,
 211, 239, 537, 536, 269, 504, 492, 479, 478, 477,
 327, 466, 121, 465, 358, 464, 463, 141, 460, 357,
 359, 459, 328, 458, 420, 397, 417, 403, 416, 349,
 295, 398, 415, 394, 401, 343, 337, 335, 414, 402,
 413, 340, 120, 341, 512, 339, 338, 342, 268, 520,
 521, 412, 525, 103, 529, 520, 521, 411, 525, 406,
 327, 327, 327, 373, 374, 375, 119, 354, 140, 350,
 371, 139, 328, 328, 328, 522, 433, 117, 370, 336,
 364, 522, 363, 116, 362, 361, 305, 107, 403, 440,
 292, 291, 287, 523, 403, 274, 203, 429, 197, 523,
 402, 195, 190, 443, 534, 551, 402, 453, 105, 456,
 100, 442, 437,  96, 438, 446, 439, 260, 434, 435,
 428, 108,  83, 343, 337, 491, 553, 436, 183, 340,
 526, 341, 403, 339, 338, 342, 510, 196, 453, 505,
 196,  85, 467, 500, 402, 476, 473, 185, 472, 186,
 180, 187, 184, 182, 181, 405, 189, 191, 192, 403,
 486, 386, 327, 327, 327, 487, 488, 489, 453, 453,
 499, 402, 493, 494, 328, 328, 328, 434, 435, 319,
 503, 496, 498,  86, 177, 272, 318, 453, 218, 453,
 286, 524, 511, 273, 476, 527, 476, 270, 226, 225,
 224, 223, 101,  99,  98,  97, 531,  95,  94, 524,
  93,  37, 535, 426, 111, 106, 239, 389, 117, 538,
 336, 541, 400, 484, 116, 524, 252, 524, 524, 544,
 239, 546, 548, 423, 143, 524, 425, 524, 535, 524,
 535, 347, 535, 358, 346, 235, 555, 293, 357, 359,
 193, 231, 381,  38, 397, 418, 403, 419, 426, 135,
 398, 356, 394, 401, 343, 337, 335, 396, 402, 382,
 340, 230, 341, 506, 339, 338, 342, 389, 117, 254,
 336, 238, 400, 117, 116, 255, 276, 117, 358, 322,
 239, 239, 355, 357, 359, 239, 117, 296, 117, 117,
 196, 313, 116, 358, 116, 116, 117, 134, 357, 359,
 114, 245, 122, 117, 397, 175, 403, 117, 490, 115,
 398, 485, 394, 401, 343, 337, 335, 480, 402, 462,
 340, 457, 341, 474, 339, 338, 342, 389, 117, 445,
 336, 444, 400, 376, 116, 367, 366, 360, 310, 309,
 239, 299, 262, 261, 234, 232, 214,  91,  90,  88,
  82,  35,  33, 358, 409, 378, 468, 312, 357, 359,
 250, 228,  32,  29, 397,  27, 403,  25,  22,  20,
 398,  18, 394, 401, 343, 337, 335,  16, 402,   2,
 340, 227, 341, 469, 339, 338, 342, 389, 117, 188,
 336, 109, 400,   3, 116, 178,  14, 145, 249, 213,
 239,  31,  30,  28,  26,  24,  23, 123, 110,  21,
  19,  17,  15, 358, 431, 552, 528, 174, 357, 359,
 432, 179,  39, 345, 397, 253, 403, 112, 138, 202,
 398, 483, 394, 401, 343, 337, 335, 482, 402, 517,
 340, 393, 341, 387, 339, 338, 342, 502, 117, 379,
 336, 392, 400, 427, 116, 237, 229, 380, 353, 311,
 239, 326, 117, 176, 336, 104, 128, 124, 116, 198,
 118, 317,   1, 358, 333,   0, 256,   0, 357, 359,
   0,   0,   0,   0, 397, 288, 403,   0,   0, 304,
 398,   0, 394, 401, 343, 337, 335, 330, 402, 331,
 340, 332, 341, 306, 339, 338, 342, 236, 343, 337,
 335, 136, 329, 244, 340,   0, 341,   0, 339, 338,
 342, 433, 117, 307, 336,   0,   0,   0, 116,   0,
 297,   0,   0,   0, 440,   0,   0,   0, 449, 450,
   0, 454,   0,   0, 256, 237,   0, 449, 450, 455,
 454, 277,   0,   0,   0,   0,   0, 437, 455, 438,
   0, 439, 520, 521, 451, 525,   0,   0, 343, 337,
 441,   0, 436, 451, 340,   0, 341, 403, 339, 338,
 342,   0, 452, 298, 449, 450, 403, 454, 522, 402,
 301, 452,   0,   0, 515, 455,   0, 236, 402,   0,
   0, 403,   0, 514, 449, 450, 523, 454, 449, 450,
 451, 454,   0, 402, 251, 455,   0, 258, 550, 455,
   0,   0,   0, 403, 520, 521,   0, 525, 452,   0,
 451,   0,   0,   0, 451, 402,   0,   0,   0,   0,
 497,   0,   0, 403,   0,   0,   0, 403, 452,   0,
 522,   0, 452, 520, 521, 402, 525,   0,   0, 402,
 495,   0,   0, 403, 475,   0,   0,   0, 523, 520,
 521,   0, 525, 449, 450, 402, 454,   0,   0, 522,
 547,   0,   0,   0, 455,   0,   0,   0,   0,   0,
   0,   0, 403,   0,   0, 522,   0, 523,   0, 451,
   0,   0,   0,   0, 402,   0, 183,   0, 403, 545,
   0,   0, 403, 523,   0,   0,   0, 452,   0,   0,
 402,   0,   0,   0, 402, 185,   0, 186, 180, 187,
 184, 182, 181 };
short yypact[]={

 443,-201,-201,-1000, 441, 435, 433, 432,-1000, 431,
 429, 427,-1000, 426,-1000, 415, -90, 414, -91, 264,
-1000,-151, -92, 413, 122, -94, 186,-133, 412,-134,
 411, 410,-135, 216,-1000, 214,-1000, 213, 112, 211,
 210, 209, 109,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000, 208,  51,-1000, 107,  86,-1000, 121,-1000,
-1000,-1000,-1000, 234, 350,  66, 364, 358,-268,-314,
 359, 310,-1000,-136,  71,-244,-137, 369, 182, 156,
 162, 301,-139,-1000, 100, 352,  97,-1000,-1000, -96,
  95,-140,  -7,-160,-141,-1000,-1000,-1000,-150,-1000,
-1000,-1000,-1000,-1000, -16,-157,  -2,-1000,-161,-1000,
  86,-1000,-1000,-154, -18,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000, 192, -21, -10,-163,-1000, 207,
 206, 205, 204,-1000,-1000,-1000,-1000,-1000,-1000, 425,
-1000, 305, 408,-165,-1000, 407,-1000, 335, -12,-194,
-156,-1000, 352, 365,-1000,-197,-1000,-1000,-1000,-198,
-1000,-200,-1000, 424,-1000,-1000,-344,-1000, 331,-1000,
-202, 770,-1000, 348, 117, 406, 405, -19,-204,-205,
  47,-1000,-1000,-1000, 201, -23, 189, 197,-1000,  94,
-212, 339,-1000,-222,-195, -24,-1000,-1000,-1000,-149,
-1000,-1000, -25, 194,-1000,  91,-1000,-1000,-1000,-1000,
-344,-262,-266,-1000,  90,  89,-1000,-1000, 298,-1000,
 351,-1000, 256, 358, 404,-1000,-1000, 352,-1000,-226,
 358,-228,-233,  86,  85,-1000, 331, 335,-193, 402,
 401, 421, 353,-249, -31, 190,-1000,-1000, 352, 183,
-1000,-158,-1000,-1000,-236, 341,-1000, -35,-1000,-1000,
-1000, -29,-1000, -39, 280, -55,-1000,-1000, 348, 351,
-237,-1000, -57,-1000, 315,-1000,-1000,-1000,-1000, 400,
  84,  83,  81,  79,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-238,-1000, 399, 398,-1000,-1000,
 -58,-1000,-239,-1000,  77,  69,-241,-1000,-1000,-1000,
-1000, 524, 524, 524, 396,-1000,-1000,-1000,-1000,-1000,
 419, 306,-1000, -59, -61, -64, 165, 450,-1000, -65,
 159,-1000,  58,-1000,-1000,-1000, 418,-246,-1000,  56,
-1000,-1000,-1000,-1000,  50,-1000,-1000,  39,  37,  31,
  27,  25, 308,  23,-247, 276, 173, -66, 584,-1000,
-1000, 419, 146, 394, 392, 419, 736, 111,-1000,-1000,
 384,-1000,-1000,  22,-1000,  20,  17, -70,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000, 382,  15,  14,  12,
  10, 420, 390,-231, 152, 150, 330, 671,-1000,-1000,
-1000,   8,   7,-1000,-1000,   6, 380, -71, 265, 374,
 419,-1000,-1000, 524, 524, 524, 371, 129,-1000,-1000,
-1000,   5, 419, 419,-1000,-1000,-1000, 667, 647, 146,
 147,-1000, -74, 510,   4, 143, 270, -75, -76, -77,
 140,-1000, 419,  41, -43,-1000, 610,-1000, 601, -79,
 732, 134,-1000,-1000, 146,  53,-1000,-1000,-1000,-1000,
 418,-209,-1000,-1000,-1000,-1000,-1000, -80, 108,-1000,
-1000,-1000,   2,   1,-1000,-1000, 231, -81, -83, 276,
-1000, -87, -88,-1000, 732,-1000, 716, 687,-1000,-1000,
-1000, -95,-1000,-1000, 732,-1000, 625,-1000, 102, 130,
-1000,-1000,-1000,  -4, 276,-148,-1000 };
short yypgo[]={

   0, 792,  20, 629, 577, 555,  59, 791, 790, 789,
 787, 786, 728, 785, 525, 544,   1, 783, 779,  11,
  52, 778, 777, 715,   9,   6, 776,   0, 773, 771,
 769, 761,   4,   3, 759,   2, 757, 751, 748, 747,
 745, 536,  13,   7,   8, 743, 742, 717, 741,   5,
 740, 736, 735,  19,  10, 734, 713, 732, 731, 730,
 729, 726, 725, 724, 723, 722, 721, 719, 718, 711,
 709, 701 };
short yyr1[]={

   0,   1,   1,   1,  56,  56,  56,  56,  56,  56,
  56,  56,  56,  56,  57,  57,  57,  58,  58,  58,
  39,  39,   2,   2,   3,   3,   5,   5,   5,   5,
   4,   6,   6,   7,   7,  59,  59,  59,  59,   8,
   8,   8,   8,   8,   8,   8,   9,   9,   9,   9,
  60,  60,  60,  60,  60,  60,  46,  46,  46,  46,
  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,
  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,
  46,  46,  46,  46,  46,  46,  46,  46,  46,  46,
  46,  46,  46,  46,  10,  10,  10,  11,  11,  11,
  11,  11,  61,  61,  62,  62,  62,  62,  63,  63,
  67,  63,  63,  63,  13,  13,  13,  15,  15,  47,
  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  47,  47,  47,  47,
  47,  47,  47,  47,  47,  47,  38,  38,  38,  68,
  68,  68,  68,  14,  14,  41,  41,  40,  40,  40,
  64,  64,  64,  64,  17,  17,  23,  23,  23,  23,
  23,  23,  23,  48,  48,  48,  48,  65,  69,  65,
  70,  70,  71,  71,  71,  71,  18,  18,  18,  54,
  54,  54,  19,  19,  19,  19,  19,  19,  19,  19,
  55,  55,  55,  55,  55,  55,  55,  55,  49,  49,
  50,  21,  21,  21,  20,  20,  20,  24,  24,  24,
  24,  25,  25,  25,  25,  25,  25,  25,  25,  25,
  25,  25,  29,  42,  42,  43,  43,  43,  43,  43,
  43,  43,  43,  43,  31,  34,  34,  32,  32,  33,
  33,  33,  33,  33,  33,  33,  33,  27,  27,  27,
  44,  44,  53,  53,  53,  53,  53,  53,  53,  53,
  53,  53,  30,  30,  30,  22,  16,  16,  16,  51,
  51,  52,  36,  36,  37,  37,  37,  35,  28,  28,
  66,  66,  66,  12,  12,  26,  26,  26,  26,  26,
  45,  45 };
short yyr2[]={

   0,   0,   2,   2,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   0,   6,   2,   0,   5,   2,
   1,   6,   1,   4,   1,   2,   3,   3,   1,   1,
   6,   2,   1,   0,   2,   0,   4,   6,   1,   4,
   3,   4,   5,   7,   5,   2,   1,   1,   3,   3,
   0,   5,   5,   5,   6,   2,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   0,   5,   0,   6,   4,   2,   0,   5,
   0,   8,   4,   2,   2,   3,   3,   1,   3,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   1,   1,   1,   1,   0,   2,   1,   0,
   4,   6,   1,   5,   3,   1,   3,   1,   4,   1,
   0,   6,   5,   2,   1,   3,   3,   5,   3,   5,
   3,   5,   1,   1,   1,   1,   1,   0,   0,   4,
   3,   1,   0,   6,   6,   2,   0,   2,   1,   0,
   2,   1,   1,   1,   1,   2,   4,   4,   4,   6,
   1,   1,   1,   2,   4,   4,   4,   6,   2,   1,
   2,   5,   5,   2,   1,   1,   1,   0,   2,   5,
   1,   1,   1,   1,   1,   4,   8,   1,   1,   6,
   6,   4,   4,   1,   2,   1,   1,   3,   4,   3,
   4,   1,   1,   4,   7,   3,   1,   1,   2,   1,
   1,   3,   4,   3,   4,   1,   1,   2,   2,   4,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   3,   1,   1,   4,   6,   1,   6,   4,
   1,   4,   1,   4,   0,   2,   2,   4,   1,   1,
   0,   6,   2,   0,   3,   5,   6,   2,   5,   1,
   0,   2 };
short yychk[]={

-1000,  -1, 256, -56, 261, 272, 263, 284, 285, 291,
 266, 273, 290, 309, -56, -57, 256, -58, 256, -59,
 256, -60, 256, -61, -62, 256, -63, 256, -64, 256,
 -65, -66, 256, 257, 314, 257, 314, 257, 299, -46,
 323, 327, 299, 317, 318, 319, 361, 320, 321, 322,
 333, 334, 335, 363, 336, 337, 364, 338, 339, 340,
 341, 343, 342, 345, 344, 346, 360, 348, 347, 350,
 349, 351, 352, 353, 354, 355, 356, 357, 358, 359,
 362, 314, 257, 310, 314, 265, 307, 314, 257, 314,
 257, 257, 314, 304, 304, 304, 311, 304, 304, 304,
 311, 304, 257, 312, -13, 311, -14, 311, 310, -69,
 -12, 290, -39,  -2, 270,  -3, 264, 258,  -8, 310,
 286, 256, 258,  -3, -10, 325, 324, 326, -11, 330,
 328, 329, 331, 332, 258, 259, -12, 314, -38, 310,
 307, 256, 313, -15, 256, -47, 371, 381, 384, 378,
 374, 383, 376, 370, 367, 377, 387, 380, 385, 372,
 365, 391, 386, 369, 388, 375, 379, 373, 366, 368,
 382, 389, 390, 314,  -3, 256, -17, 312, -23, -48,
 278, 282, 281, 256, 280, 275, 277, 279, -70, 310,
 256, 305, 306, 259, 314, 311, 258, 311,  -9, 312,
 256, 257,  -3, 311, 314, 313, 314, 314, 314, 313,
 314, 312, 314, -67, -14, 313, 306, 313, 306, 313,
 312, 306, 314, 304, 304, 304, 304, -71, 256, -26,
 276, 256, 257, 314, 257,  -5,  -3,  -4, 256, 270,
 312, 306, 314, 312,  -3, 256, 314, 314, 314, -68,
 256, -47, -41, -40, 258, 264,  -4, 314, -23,  -2,
 310, 257, 257, 312, 269, 299, 314, 314, 311, 267,
 306, 313, 306, 306, 311, 314, 257,  -3, 314, 313,
 306, 313, 312, 307, 299, 313, 306, 311, -15, 316,
 316, 311, 311, 259,  -6,  -2, 256,  -4,  -3, 257,
 314,  -3, 314, 314, -14, 311, -41,  -5, 312, 257,
 257, -18, 256, 258, 313, 315, 313,  -7, 306, 306,
 313, 314, 258, 313, 313, -19, 257, -44,  -2, 308,
 293, 295, 297, 270, -53, 306, 260, 305, 315, 314,
 310, 312, 316, 304, 313, -45, 274, 271, 313,  -2,
  -6, 314, 313, -21, -20, 287, 256, 288, 283, 289,
 257, 311, 311, 311, 311, 314, 257, 257, 313, 314,
 311, 311, 314, -19, -19, -19, 257, -24, 256, -30,
 -22, 256, 273, 313, 313, 313, 306, 313, -25, 257,
 -44,  -2, -29, -31, 302, -27,  -4, 294, 300, -20,
 262, 303, 308, 296, 313, 306, 311, -49, -54, 256,
 314, 311, 311, 311, 311, 311, 311, 311, 257, 259,
 311, 314, -16, 267, -35, 270, 292, -28, 257, -27,
 313, -55, -50, 257, -53,  -2, 308, 293, 295, 297,
 270, 306, -24, -27, 257, 257, -24, -42, -43, 257,
 258, 283, 301, -27, 260, 268, 308, 257, 311, 311,
 311, 313, 257, 311, 311, 311, 311, -54, 256, 313,
 313, 301, 306, 306, 313, 313, -43, 311, 311, 311,
 257, 313, -36, -37, 268, 257, -24, -19, -19, -19,
 257, 306, 311, -24, -24, 313, -42, 313, -42, -27,
 306, 313, 257, -25, 311, 306, 313, 313, 313, 313,
 306, -24, 313, 313, 313, 313, 313, -34, -32, -33,
 257, 258, 283, 301, -27, 260, 306, -27, -51, 311,
 256, -49, 313, 313, 306, -33, 311, 311, -35, 313,
 313, -16, 313, 313, -32, 313, -32, 313, -32, 313,
 313, 313, -52, 306, 311, -16, 313 };
short yydef[]={

   1,  -2,   0,   2,  14,  17,  35,  50, 102, 104,
 108, 160, 177, 290,   3,   4,   0,   5,   0,   6,
  38,   7,   0,   8,   9,   0,  10,   0,  11,   0,
  12,  13,   0,   0,  16,   0,  19,   0,   0,   0,
   0,   0,   0,  56,  57,  58,  59,  60,  61,  62,
  63,  64,  65,  66,  67,  68,  69,  70,  71,  72,
  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,
  83,  84,  85,  86,  87,  88,  89,  90,  91,  92,
  93,  55,   0,   0, 107,   0,   0, 113,   0, 163,
 178, 293, 292,   0,   0,   0,   0,   0,   0,   0,
   0,   0, 293,   0, 146,   0,   0,   0,   0,   0,
   0,   0,   0,  20,   0,  22,   0,  24,  36,   0,
   0,   0,   0,   0,   0,  94,  95,  96,   0,  97,
  98,  99, 100, 101,   0,   0,   0, 106,   0, 110,
   0, 148, 114,   0,   0, 117, 119, 120, 121, 122,
 123, 124, 125, 126, 127, 128, 129, 130, 131, 132,
 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
 143, 144, 145, 112,   0,   0,   0,   0, 164,   0,
   0,   0,   0, 172, 173, 174, 175, 176, 179, 182,
 181,   0,   0,   0,  18,   0,  25,   0,   0,   0,
   0,  46,  47,   0,  45,   0,  51,  52,  53,   0,
 103,   0, 109, 149, 147, 115,   0, 116,   0, 154,
   0,   0, 162,   0,   0,   0,   0,   0,   0,   0,
   0, 299, 294,  15,   0,   0,   0,  28,  29,   0,
   0,   0,  40,   0,   0,   0,  37,  54, 105,   0,
 152, 118,   0, 155, 157,   0, 159, 161, 165, 166,
   0, 168, 170, 180,   0,   0, 185, 291,   0, 297,
   0,  23,   0,   0,   0,  39,  48,  49,  41,   0,
   0,   0,   0,   0,   0, 153,   0,   0,   0,   0,
   0, 186,   0,   0,   0,  33,  32,  26,  27,   0,
  42,   0,  44, 111,   0,   0, 156,   0, 167, 169,
 171,   0, 188,   0, 300,   0,  21,  31,   0,   0,
   0, 150,   0, 158,   0, 187, 192, 193, 194,   0,
   0,   0,   0,   0, 260, 261, 262, 263, 264, 265,
 266, 267, 270, 271,   0, 295,   0,   0, 298,  34,
   0,  43,   0, 183,   0,   0,   0, 214, 215, 216,
 195,   0,   0,   0,   0, 184, 296, 301,  30, 151,
 217,   0, 213,   0,   0,   0,   0,   0, 220,   0,
 273, 274,   0, 196, 197, 198, 189,   0, 218,   0,
 221, 222, 223, 224,   0, 227, 228,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,  -2,
 211, 217,   0,   0,   0, 217,   0,   0, 257, 258,
   0, 212, 272,   0, 277,   0,   0,   0, 288, 289,
 199, 190, 208, 200, 201, 202,   0,   0,   0,   0,
   0, 189,   0,   0,   0,   0,   0,   0, 233, 235,
 236,   0,   0, 241, 242,   0,   0,   0, 284,   0,
 217, 275, 203,   0,   0,   0,   0, 210, 191, 219,
 225,   0, 217, 217, 231, 232, 234,   0,   0,   0,
   0, 259,   0, 282,   0,   0,   0,   0,   0,   0,
   0, 268, 217,   0,   0, 237,   0, 239,   0,   0,
   0,   0, 285, 286,   0,   0, 287, 204, 205, 206,
 189,   0, 229, 230, 238, 240, 243,   0, 246, 247,
 249, 250,   0,   0, 255, 256,   0,   0,   0,   0,
 280,   0,   0, 244,   0, 248,   0,   0, 276, 283,
 278,   0, 207, 226, 245, 251,   0, 253,   0,   0,
 252, 254, 279,   0,   0,   0, 281 };
#ifndef lint
static char yaccpar_sccsid[] = "@(#)yaccpar	4.1	(Berkeley)	2/11/83";
#endif

#
# define YYFLAG -1000
# define YYERROR goto yyerrlab
# define YYACCEPT return(0)
# define YYABORT return(1)

/*	parser for yacc output	*/

#ifdef YYDEBUG
int yydebug = 0; /* 1 for debugging */
#endif
YYSTYPE yyv[YYMAXDEPTH]; /* where the values are stored */
int yychar = -1; /* current input token number */
int yynerrs = 0;  /* number of errors */
short yyerrflag = 0;  /* error recovery flag */

yyparse() {

	short yys[YYMAXDEPTH];
	short yyj, yym;
	register YYSTYPE *yypvt;
	register short yystate, *yyps, yyn;
	register YYSTYPE *yypv;
	register short *yyxi;

	yystate = 0;
	yychar = -1;
	yynerrs = 0;
	yyerrflag = 0;
	yyps= &yys[-1];
	yypv= &yyv[-1];

 yystack:    /* put a state and value onto the stack */

#ifdef YYDEBUG
	if( yydebug  ) printf( "state %d, char 0%o\n", yystate, yychar );
#endif
		if( ++yyps> &yys[YYMAXDEPTH] ) { yyerror( "yacc stack overflow" ); return(1); }
		*yyps = yystate;
		++yypv;
		*yypv = yyval;

 yynewstate:

	yyn = yypact[yystate];

	if( yyn<= YYFLAG ) goto yydefault; /* simple state */

	if( yychar<0 ) if( (yychar=yylex())<0 ) yychar=0;
	if( (yyn += yychar)<0 || yyn >= YYLAST ) goto yydefault;

	if( yychk[ yyn=yyact[ yyn ] ] == yychar ){ /* valid shift */
		yychar = -1;
		yyval = yylval;
		yystate = yyn;
		if( yyerrflag > 0 ) --yyerrflag;
		goto yystack;
		}

 yydefault:
	/* default state action */

	if( (yyn=yydef[yystate]) == -2 ) {
		if( yychar<0 ) if( (yychar=yylex())<0 ) yychar = 0;
		/* look through exception table */

		for( yyxi=yyexca; (*yyxi!= (-1)) || (yyxi[1]!=yystate) ; yyxi += 2 ) ; /* VOID */

		while( *(yyxi+=2) >= 0 ){
			if( *yyxi == yychar ) break;
			}
		if( (yyn = yyxi[1]) < 0 ) return(0);   /* accept */
		}

	if( yyn == 0 ){ /* error */
		/* error ... attempt to resume parsing */

		switch( yyerrflag ){

		case 0:   /* brand new error */

			yyerror( "syntax error" );
		yyerrlab:
			++yynerrs;

		case 1:
		case 2: /* incompletely recovered error ... try again */

			yyerrflag = 3;

			/* find a state where "error" is a legal shift action */

			while ( yyps >= yys ) {
			   yyn = yypact[*yyps] + YYERRCODE;
			   if( yyn>= 0 && yyn < YYLAST && yychk[yyact[yyn]] == YYERRCODE ){
			      yystate = yyact[yyn];  /* simulate a shift of "error" */
			      goto yystack;
			      }
			   yyn = yypact[*yyps];

			   /* the current yyps has no shift onn "error", pop stack */

#ifdef YYDEBUG
			   if( yydebug ) printf( "error recovery pops state %d, uncovers %d\n", *yyps, yyps[-1] );
#endif
			   --yyps;
			   --yypv;
			   }

			/* there is no state on the stack with an error shift ... abort */

	yyabort:
			return(1);


		case 3:  /* no shift yet; clobber input char */

#ifdef YYDEBUG
			if( yydebug ) printf( "error recovery discards char %d\n", yychar );
#endif

			if( yychar == 0 ) goto yyabort; /* don't discard EOF, quit */
			yychar = -1;
			goto yynewstate;   /* try again in the same state */

			}

		}

	/* reduction by production yyn */

#ifdef YYDEBUG
		if( yydebug ) printf("reduce %d\n",yyn);
#endif
		yyps -= yyr2[yyn];
		yypvt = yypv;
		yypv -= yyr2[yyn];
		yyval = yypv[1];
		yym=yyn;
			/* consult goto table to find next state */
		yyn = yyr1[yyn];
		yyj = yypgo[yyn] + *yyps + 1;
		if( yyj>=YYLAST || yychk[ yystate = yyact[yyj] ] != -yyn ) yystate = yyact[yypgo[yyn]];
		switch(yym){
			
case 15:
# line 273 "parser.y"
{
				BindID (yypvt[-4].phe, yypvt[-1].ival, (unsigned) ID_RULESET);
			} break;
case 16:
# line 276 "parser.y"
{
				yyerrok;
			} break;
case 18:
# line 282 "parser.y"
{
				EmitDef (def_macro, yypvt[-3].phe, yypvt[-1].psb, (char *) NULL);
			} break;
case 19:
# line 285 "parser.y"
{
				yyerrok;
			} break;
case 20:
# line 295 "parser.y"
{
                        yyval.psb = yypvt[-0].psb;
			} break;
case 21:
# line 298 "parser.y"
{
				yyval.psb = MakeCond (yypvt[-3].phe, MacScan(yypvt[-1].psb));
			} break;
case 22:
# line 302 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 23:
# line 305 "parser.y"
{
				yyval.psb = yypvt[-1].psb;
			} break;
case 24:
# line 310 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 25:
# line 313 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb);
			} break;
case 26:
# line 320 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-2].psb);
				Free (yypvt[-0].psb);
			} break;
case 27:
# line 325 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-2].psb);
				Free (yypvt[-0].psb);
			} break;
case 28:
# line 330 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 29:
# line 333 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 30:
# line 338 "parser.y"
{
				yyval.psb = MakeCond (yypvt[-3].phe, MacScan(yypvt[-1].psb));
			} break;
case 31:
# line 343 "parser.y"
{
				if (yypvt[-0].psb != NULL) {
					yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, "$|");
					Free (yypvt[-1].psb);
					Free (yypvt[-0].psb);
				} else
					yyval.psb = yypvt[-1].psb;
			} break;
case 32:
# line 351 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 33:
# line 356 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 34:
# line 359 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 36:
# line 365 "parser.y"
{
				EmitDef (def_class, yypvt[-2].phe, yypvt[-0].psb, (char *) NULL);
			} break;
case 37:
# line 368 "parser.y"
{
				printf("%s\n",yypvt[-2].psb);
                        } break;
case 39:
# line 374 "parser.y"
{
				yyval.psb = yypvt[-2].psb;
			} break;
case 40:
# line 377 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 41:
# line 380 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 42:
# line 383 "parser.y"
{
				yyval.psb = MakeRStr (yypvt[-2].psb, (char *) NULL);
			} break;
case 43:
# line 386 "parser.y"
{
				yyval.psb = MakeRStr (yypvt[-4].psb, yypvt[-2].psb);
			} break;
case 44:
# line 389 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 45:
# line 392 "parser.y"
{
				yyval.psb = NULL;
				yyerrok;
			} break;
case 46:
# line 398 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-0].phe->psb, (char *) NULL, (char *) NULL);
				RemoveSymbol (yypvt[-0].phe);
			} break;
case 47:
# line 402 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 48:
# line 405 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].phe->psb, " ");
				Free (yypvt[-2].psb);
				RemoveSymbol (yypvt[-0].phe);
			} break;
case 49:
# line 410 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, " ");
				Free (yypvt[-2].psb);
				Free (yypvt[-0].psb);
			} break;
case 51:
# line 418 "parser.y"
{
				EmitDef (def_option, (struct he *) NULL, ConvOpt (yypvt[-3].optval), yypvt[-1].psb);
			} break;
case 52:
# line 421 "parser.y"
{
				EmitDef (def_option, (struct he *) NULL, ConvOpt (opt_d), yypvt[-1].psb);
			} break;
case 53:
# line 424 "parser.y"
{
				EmitDef (def_option, (struct he *) NULL, ConvOpt (opt_e), yypvt[-1].psb);
			} break;
case 54:
# line 427 "parser.y"
{
				printf("%s\n",yypvt[-2].psb);
                        } break;
case 55:
# line 430 "parser.y"
{
				yyerrok;
			} break;
case 56:
# line 435 "parser.y"
{
				yyval.optval = opt_A;
			} break;
case 57:
# line 438 "parser.y"
{
				yyval.optval = opt_a;
			} break;
case 58:
# line 441 "parser.y"
{
				yyval.optval = opt_B;
			} break;
case 59:
# line 444 "parser.y"
{
				yyval.optval = opt_b;
			} break;
case 60:
# line 447 "parser.y"
{
				yyval.optval = opt_C;
			} break;
case 61:
# line 450 "parser.y"
{
				yyval.optval = opt_c;
			} break;
case 62:
# line 453 "parser.y"
{
				yyval.optval = opt_D;
			} break;
case 63:
# line 456 "parser.y"
{
				yyval.optval = opt_F;
			} break;
case 64:
# line 459 "parser.y"
{
				yyval.optval = opt_f;
			} break;
case 65:
# line 462 "parser.y"
{
				yyval.optval = opt_g;
			} break;
case 66:
# line 465 "parser.y"
{
				yyval.optval = opt_h;
			} break;
case 67:
# line 468 "parser.y"
{
				yyval.optval = opt_H;
			} break;
case 68:
# line 471 "parser.y"
{
				yyval.optval = opt_i;
			} break;
case 69:
# line 474 "parser.y"
{
				yyval.optval = opt_I;
			} break;
case 70:
# line 477 "parser.y"
{
				yyval.optval = opt_L;
			} break;
case 71:
# line 480 "parser.y"
{
				yyval.optval = opt_m;
			} break;
case 72:
# line 483 "parser.y"
{
				yyval.optval = opt_N;
			} break;
case 73:
# line 486 "parser.y"
{
				yyval.optval = opt_n;
			} break;
case 74:
# line 489 "parser.y"
{
				yyval.optval = opt_P;
			} break;
case 75:
# line 492 "parser.y"
{
				yyval.optval = opt_o;
			} break;
case 76:
# line 495 "parser.y"
{
				yyval.optval = opt_Q;
			} break;
case 77:
# line 498 "parser.y"
{
				yyval.optval = opt_q;
			} break;
case 78:
# line 501 "parser.y"
{
				yyval.optval = opt_r;
			} break;
case 79:
# line 504 "parser.y"
{
				yyval.optval = opt_R;
			} break;
case 80:
# line 507 "parser.y"
{
				yyval.optval = opt_S;
			} break;
case 81:
# line 510 "parser.y"
{
				yyval.optval = opt_s;
			} break;
case 82:
# line 513 "parser.y"
{
				yyval.optval = opt_T;
			} break;
case 83:
# line 516 "parser.y"
{
				yyval.optval = opt_t;
			} break;
case 84:
# line 519 "parser.y"
{
				yyval.optval = opt_u;
			} break;
case 85:
# line 522 "parser.y"
{
				yyval.optval = opt_v;
			} break;
case 86:
# line 525 "parser.y"
{
				yyval.optval = opt_W;
			} break;
case 87:
# line 528 "parser.y"
{
				yyval.optval = opt_x;
			} break;
case 88:
# line 531 "parser.y"
{
				yyval.optval = opt_X;
			} break;
case 89:
# line 534 "parser.y"
{
				yyval.optval = opt_y;
			} break;
case 90:
# line 537 "parser.y"
{
				yyval.optval = opt_Y;
			} break;
case 91:
# line 540 "parser.y"
{
				yyval.optval = opt_z;
			} break;
case 92:
# line 543 "parser.y"
{
				yyval.optval = opt_Z;
			} break;
case 93:
# line 546 "parser.y"
{
				yyval.optval = opt_SL;	/* SLASH .e.g. O/ in IDA */
			} break;
case 94:
# line 551 "parser.y"
{
				yyval.psb = ConvOpt (d_opt_i);
			} break;
case 95:
# line 554 "parser.y"
{
				yyval.psb = ConvOpt (d_opt_b);
			} break;
case 96:
# line 557 "parser.y"
{
				yyval.psb = ConvOpt (d_opt_q);
			} break;
case 97:
# line 562 "parser.y"
{
				yyval.psb = ConvOpt (e_opt_p);
			} break;
case 98:
# line 565 "parser.y"
{
				yyval.psb = ConvOpt (e_opt_e);
			} break;
case 99:
# line 568 "parser.y"
{
				yyval.psb = ConvOpt (e_opt_m);
			} break;
case 100:
# line 571 "parser.y"
{
				yyval.psb = ConvOpt (e_opt_w);
			} break;
case 101:
# line 574 "parser.y"
{
				yyval.psb = ConvOpt (e_opt_z);
			} break;
case 103:
# line 580 "parser.y"
{
				BindID (yypvt[-3].phe, yypvt[-1].ival, (unsigned) ID_PREC);
				EmitDef (def_prec, yypvt[-3].phe, (char *) NULL, (char *) NULL);
			} break;
case 105:
# line 587 "parser.y"
{
				EmitDef (def_trusted, (struct he *) NULL, 
					 ListAppend (yypvt[-3].phe->psb, yypvt[-2].psb, " "), (char *) NULL);
				Free (yypvt[-2].psb); /* Gets a Null pointer */
				RemoveSymbol (yypvt[-3].phe);
			} break;
case 107:
# line 594 "parser.y"
{
				yyerrok;
			} break;
case 109:
# line 600 "parser.y"
{
				EmitDef (def_header, (struct he *) NULL, yypvt[-2].psb, yypvt[-1].psb);
			} break;
case 110:
# line 603 "parser.y"
{ Flaglist = yypvt[-1].psb; } break;
case 112:
# line 605 "parser.y"
{
				EmitDef (def_header, (struct he *) NULL, (char *) NULL, yypvt[-1].psb);
			} break;
case 113:
# line 608 "parser.y"
{
				yyerrok;
			} break;
case 114:
# line 613 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 115:
# line 616 "parser.y"
{
				yyval.psb = yypvt[-1].psb;
			} break;
case 116:
# line 619 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 117:
# line 624 "parser.y"
{
				yyval.psb = ListAppend (ConvFlg (yypvt[-0].flgval), (char *) NULL, (char *) NULL);
			} break;
case 118:
# line 627 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, ConvFlg(yypvt[-0].flgval), (char *) NULL);
				Free (yypvt[-2].psb);
			} break;
case 119:
# line 633 "parser.y"
{
				yyval.flgval = flg_f;
			} break;
case 120:
# line 636 "parser.y"
{
				yyval.flgval = flg_r;
			} break;
case 121:
# line 639 "parser.y"
{
				yyval.flgval = flg_S;
			} break;
case 122:
# line 642 "parser.y"
{
				yyval.flgval = flg_n;
			} break;
case 123:
# line 645 "parser.y"
{
				yyval.flgval = flg_l;
			} break;
case 124:
# line 648 "parser.y"
{
				yyval.flgval = flg_s;
			} break;
case 125:
# line 651 "parser.y"
{
				yyval.flgval = flg_m;
			} break;
case 126:
# line 654 "parser.y"
{
				yyval.flgval = flg_F;
			} break;
case 127:
# line 657 "parser.y"
{
				yyval.flgval = flg_D;
			} break;
case 128:
# line 660 "parser.y"
{
				yyval.flgval = flg_M;
			} break;
case 129:
# line 663 "parser.y"
{
				yyval.flgval = flg_x;
			} break;
case 130:
# line 666 "parser.y"
{
				yyval.flgval = flg_P;
			} break;
case 131:
# line 669 "parser.y"
{
				yyval.flgval = flg_u;
			} break;
case 132:
# line 672 "parser.y"
{
				yyval.flgval = flg_h;
			} break;
case 133:
# line 675 "parser.y"
{
				yyval.flgval = flg_A;
			} break;
case 134:
# line 678 "parser.y"
{
				yyval.flgval = flg_B;
			} break;
case 135:
# line 681 "parser.y"
{
				yyval.flgval = flg_U;
			} break;
case 136:
# line 684 "parser.y"
{
				yyval.flgval = flg_e;
			} break;
case 137:
# line 687 "parser.y"
{
				yyval.flgval = flg_X;
			} break;
case 138:
# line 690 "parser.y"
{
				yyval.flgval = flg_L;
			} break;
case 139:
# line 693 "parser.y"
{
				yyval.flgval = flg_p;
			} break;
case 140:
# line 696 "parser.y"
{
				yyval.flgval = flg_I;
			} break;
case 141:
# line 699 "parser.y"
{
				yyval.flgval = flg_C;
			} break;
case 142:
# line 702 "parser.y"
{
				yyval.flgval = flg_E;
			} break;
case 143:
# line 705 "parser.y"
{
				yyval.flgval = flg_R;
			} break;
case 144:
# line 708 "parser.y"
{
				yyval.flgval = flg_H;
			} break;
case 145:
# line 711 "parser.y"
{
				yyval.flgval = flg_V;
			} break;
case 146:
# line 716 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 147:
# line 719 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 148:
# line 722 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 150:
# line 728 "parser.y"
{
				EmitDef (def_header, (struct he *) NULL, Flaglist, yypvt[-1].psb);
			} break;
case 151:
# line 731 "parser.y"
{
				printf("%s\n",yypvt[-2].psb);
                        } break;
case 153:
# line 737 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-3].psb, MacScan (yypvt[-1].psb), " ");
				Free (yypvt[-3].psb);
				Free (yypvt[-1].psb);
			} break;
case 154:
# line 742 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 155:
# line 747 "parser.y"
{
  				yyval.psb = yypvt[-0].psb;
			} break;
case 156:
# line 750 "parser.y"
{
  				yyval.psb = ListAppend( yypvt[-2].psb, yypvt[-0].psb, (char *) NULL);
  				Free(yypvt[-2].psb);
			} break;
case 157:
# line 754 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 158:
# line 757 "parser.y"
{
				yyval.psb = yypvt[-1].psb;
			} break;
case 159:
# line 760 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 161:
# line 766 "parser.y"
{
				EmitDef (def_mailer, yypvt[-4].phe, yypvt[-2].psb, (char *) NULL);
			} break;
case 162:
# line 769 "parser.y"
{
				EmitDef (def_mailer, yypvt[-3].phe, (char *) NULL, (char *) NULL);
			} break;
case 163:
# line 772 "parser.y"
{
				yyerrok;
			} break;
case 164:
# line 777 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 165:
# line 780 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, ", ");
				Free (yypvt[-2].psb);
				Free (yypvt[-0].psb);
			} break;
case 166:
# line 787 "parser.y"
{
				yyval.psb = ListAppend (ConvMat (yypvt[-2].mpval), MacScan (yypvt[-0].psb), "=");
				Free (yypvt[-0].psb);
			} break;
case 167:
# line 791 "parser.y"
{
				yyval.psb = ListAppend (ConvMat (mat_flags), yypvt[-1].psb, "=");
			} break;
case 168:
# line 794 "parser.y"
{
				yyval.psb = ListAppend (ConvMat (mat_sender), CheckRS (yypvt[-0].phe), "=");
			} break;
case 169:
# line 797 "parser.y"
{
				yyval.psb = ListAppend(
				 Tsb = ListAppend (ConvMat(mat_sender), CheckRS (yypvt[-2].phe), "="),
				 Tsb1 = ListAppend ("/", CheckRS (yypvt[-0].phe), (char *) NULL),
						 (char *) NULL);
				Free (Tsb);
				Free (Tsb1);
			} break;
case 170:
# line 805 "parser.y"
{
				yyval.psb = ListAppend (ConvMat (mat_recipient), CheckRS (yypvt[-0].phe), "=");
			} break;
case 171:
# line 808 "parser.y"
{
				yyval.psb = ListAppend(
				 Tsb = ListAppend (ConvMat(mat_recipient), CheckRS (yypvt[-2].phe), "="),
				 Tsb1 = ListAppend ("/", CheckRS (yypvt[-0].phe), (char *) NULL),
						 (char *) NULL);
				Free (Tsb);
				Free (Tsb1);
			} break;
case 172:
# line 816 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 173:
# line 821 "parser.y"
{
				yyval.mpval = mat_path;
			} break;
case 174:
# line 824 "parser.y"
{
				yyval.mpval = mat_argv;
			} break;
case 175:
# line 827 "parser.y"
{
				yyval.mpval = mat_eol;
			} break;
case 176:
# line 830 "parser.y"
{
				yyval.mpval = mat_maxsize;
			} break;
case 178:
# line 836 "parser.y"
{ StartRuleset (yypvt[-0].phe); } break;
case 180:
# line 839 "parser.y"
{
				RMatch = FALSE;
			} break;
case 181:
# line 842 "parser.y"
{
				RMatch = FALSE;
			} break;
case 182:
# line 847 "parser.y"
{
				RMatch = TRUE;
			} break;
case 183:
# line 850 "parser.y"
{
  				number_of_fields	=0;
				EmitDef (def_ruleset, (struct he *) NULL, 
					 ListAppend (yypvt[-2].psb, yypvt[-0].psb, "\t"), (char *) NULL);
			Free (yypvt[-2].psb);
			Free (yypvt[-0].psb);
			} break;
case 184:
# line 857 "parser.y"
{
				  printf("%s\n",yypvt[-2].psb);
                        } break;
case 185:
# line 860 "parser.y"
{
				yyerrok;
			} break;
case 186:
# line 865 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 187:
# line 868 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb); /* NULL */
			} break;
case 188:
# line 872 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 189:
# line 878 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 190:
# line 881 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb); /* NULL */
			} break;
case 191:
# line 885 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 192:
# line 890 "parser.y"
{
				yyval.psb = GetField (yypvt[-0].phe);
			} break;
case 193:
# line 893 "parser.y"
{
				*Cbuf = yypvt[-0].ival;
				yyval.psb = ListAppend (Cbuf, (char *) NULL, (char *) NULL);
			} break;
case 194:
# line 897 "parser.y"
{
				yyval.psb = MacScan (yypvt[-0].psb);
			} break;
case 195:
# line 900 "parser.y"
{
				Mbuf[1] = MakeMac (yypvt[-0].phe, (unsigned) ID_MACRO);
				yyval.psb = ListAppend (Mbuf, (char *) NULL, (char *) NULL);
			} break;
case 196:
# line 904 "parser.y"
{
		         yyval.psb = ListAppend("${",yypvt[-1].psb,(char *) NULL);
/*			 Free ($3); */
		} break;
case 197:
# line 908 "parser.y"
{
		         yyval.psb = ListAppend("$\"",yypvt[-1].psb,(char *) NULL);
		} break;
case 198:
# line 911 "parser.y"
{
		         yyval.psb = ListAppend("$#",yypvt[-1].psb,(char *) NULL);
		} break;
case 199:
# line 914 "parser.y"
{
				yyval.psb = MakeCond (yypvt[-3].phe, MacScan(yypvt[-1].psb));
			} break;
case 200:
# line 920 "parser.y"
{
				yyval.psb = GetField (yypvt[-0].phe);
			} break;
case 201:
# line 923 "parser.y"
{
				*Cbuf = yypvt[-0].ival;
				yyval.psb = ListAppend (Cbuf, (char *) NULL, (char *) NULL);
			} break;
case 202:
# line 927 "parser.y"
{
				yyval.psb = MacScan (yypvt[-0].psb);
			} break;
case 203:
# line 930 "parser.y"
{
				Mbuf[1] = MakeMac (yypvt[-0].phe, ID_MACRO);
				yyval.psb = ListAppend (Mbuf, (char *) NULL, (char *) NULL);
			} break;
case 204:
# line 934 "parser.y"
{
		         yyval.psb = ListAppend("${",yypvt[-1].psb,(char *) NULL);
/*			 Free ($3); */
		} break;
case 205:
# line 938 "parser.y"
{
		         yyval.psb = ListAppend("$\"",yypvt[-1].psb,(char *) NULL);
		} break;
case 206:
# line 941 "parser.y"
{
		         yyval.psb = ListAppend("$#",yypvt[-1].psb,(char *) NULL);
		} break;
case 207:
# line 944 "parser.y"
{
				yyval.psb = MakeCond (yypvt[-3].phe, MacScan(yypvt[-1].psb));
			} break;
case 208:
# line 949 "parser.y"
{
				if (yypvt[-0].psb != NULL) {
					yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, "$|");
					Free (yypvt[-1].psb);
					Free (yypvt[-0].psb);
				} else
					yyval.psb = yypvt[-1].psb;
			} break;
case 209:
# line 957 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 210:
# line 963 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 211:
# line 968 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-4].psb, yypvt[-2].psb, (char *) NULL);
				Free (yypvt[-2].psb);
			} break;
case 212:
# line 972 "parser.y"
{
				yyval.psb = yypvt[-2].psb;
			} break;
case 213:
# line 975 "parser.y"
{
				yyval.psb = NULL;
				yyerrok;
			} break;
case 214:
# line 981 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 215:
# line 984 "parser.y"
{
				yyval.psb = "$:";
			} break;
case 216:
# line 987 "parser.y"
{
				yyval.psb = "$@";
			} break;
case 217:
# line 992 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 218:
# line 995 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb);	/* NULL */
			} break;
case 219:
# line 999 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-4].psb, (Tsb = MakeRSCall (yypvt[-3].phe, yypvt[-1].psb)), (char *) NULL);
				Free (yypvt[-4].psb);	/* NULL */
				Free (yypvt[-1].psb);
				Free (Tsb);
			} break;
case 220:
# line 1005 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 221:
# line 1010 "parser.y"
{
				*Cbuf = yypvt[-0].ival;
				yyval.psb = ListAppend (Cbuf, (char *) NULL, (char *) NULL);
			} break;
case 222:
# line 1014 "parser.y"
{
				yyval.psb = MacScan (yypvt[-0].psb);
			} break;
case 223:
# line 1017 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 224:
# line 1020 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 225:
# line 1023 "parser.y"
{
				yyval.psb = ListAppend("$(@", yypvt[-1].psb, "$:$)");
			} break;
case 226:
# line 1026 "parser.y"
{
				yyval.psb = ListAppend(Tsb = 
						ListAppend ( "$(@", 
							    yypvt[-5].psb, 
							    (char *)NULL),
						Tsb1 = ListAppend("$:", yypvt[-2].psb, "$)" ),
						(char *) NULL);
				Free (Tsb);
				Free (Tsb1);
				Free (yypvt[-5].psb);
				Free (yypvt[-2].psb);
			} break;
case 227:
# line 1038 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 228:
# line 1041 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 229:
# line 1044 "parser.y"
{
				*Cbuf = MakeMac (yypvt[-3].phe, (unsigned) ID_MACRO);
				yyval.psb = ListAppend(Tsb = ListAppend ("${", (char *)Cbuf, (char *)NULL),
						Tsb1 = ListAppend (yypvt[-1].psb, "$}", (char *) NULL),
						 (char *) NULL);
				Free (Tsb);
				Free (Tsb1);
				Free (yypvt[-1].psb);
			} break;
case 230:
# line 1054 "parser.y"
{
				*Cbuf = MakeMac (yypvt[-3].phe, (unsigned) ID_MACRO);
				yyval.psb = ListAppend(Tsb = ListAppend ("$<", (char *)Cbuf, (char *)NULL),
						Tsb1 = ListAppend (yypvt[-1].psb, "", (char *) NULL),
						 (char *) NULL);
				Free (Tsb);
				Free (Tsb1);
				Free (yypvt[-1].psb);
			} break;
case 231:
# line 1064 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-3].psb, yypvt[-1].psb, (char *) NULL);
				Free (yypvt[-1].psb);
			} break;
case 232:
# line 1071 "parser.y"
{
				yyval.psb = Bracket (yypvt[-1].psb, TRUE);
				Free (yypvt[-1].psb);
			} break;
case 233:
# line 1077 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 234:
# line 1080 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb);
/*				Free ($2); */
			} break;
case 235:
# line 1087 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-0].phe->psb, (char *) NULL, (char *) NULL);
				RemoveSymbol (yypvt[-0].phe);
			} break;
case 236:
# line 1091 "parser.y"
{
				yyval.psb = ListAppend (MacScan (yypvt[-0].psb), (char *) NULL, (char *) NULL);
				Free (yypvt[-0].psb);
			} break;
case 237:
# line 1095 "parser.y"
{	/* I Used next earlier, but now use default - because it is clearer syntax */
				yyval.psb = "$:";
			} break;
case 238:
# line 1098 "parser.y"
{
				yyval.psb = ListAppend("$:", yypvt[-1].psb, (char *)NULL);
			} break;
case 239:
# line 1101 "parser.y"
{
				yyval.psb = "$:";
			} break;
case 240:
# line 1104 "parser.y"
{
				yyval.psb = ListAppend("$:", yypvt[-1].psb, (char *)NULL);
			} break;
case 241:
# line 1107 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 242:
# line 1110 "parser.y"
{
				*Cbuf = yypvt[-0].ival;
				yyval.psb = ListAppend (Cbuf, (char *) NULL, (char *) NULL);
			} break;
case 243:
# line 1114 "parser.y"
{
				yyval.psb = Bracket (yypvt[-1].psb, FALSE);
				Free (yypvt[-1].psb);
			} break;
case 244:
# line 1120 "parser.y"
{
				yyval.psb = DbmParen (yypvt[-3].phe->psb, yypvt[-1].psb);
				RemoveSymbol(yypvt[-3].phe);
				Free (yypvt[-1].psb);
			} break;
case 245:
# line 1126 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, Tsb = ListAppend ("$@", yypvt[-0].psb, (char *) NULL),
						 (char *) NULL);
				Free (Tsb);
			} break;
case 246:
# line 1131 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 247:
# line 1136 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 248:
# line 1139 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb);
/*				Free ($2); */
			} break;
case 249:
# line 1146 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-0].phe->psb, (char *) NULL, (char *) NULL);
				RemoveSymbol (yypvt[-0].phe);
			} break;
case 250:
# line 1150 "parser.y"
{
				yyval.psb = ListAppend (MacScan (yypvt[-0].psb), (char *) NULL, (char *) NULL);
				Free (yypvt[-0].psb);
			} break;
case 251:
# line 1154 "parser.y"
{	/* I Used next earlier, but now use default - because it is clearer syntax */
				yyval.psb = "$:";
			} break;
case 252:
# line 1157 "parser.y"
{
				yyval.psb = ListAppend("$:", yypvt[-1].psb, (char *)NULL);
			} break;
case 253:
# line 1160 "parser.y"
{
				yyval.psb = "$:";
			} break;
case 254:
# line 1163 "parser.y"
{
				yyval.psb = ListAppend("$:", yypvt[-1].psb, (char *)NULL);
			} break;
case 255:
# line 1166 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 256:
# line 1169 "parser.y"
{
				*Cbuf = yypvt[-0].ival;
				yyval.psb = ListAppend (Cbuf, (char *) NULL, (char *) NULL);
			} break;
case 257:
# line 1175 "parser.y"
{
				Mbuf[1] = MakeMac (yypvt[-0].phe, (unsigned) ID_MACRO);
				yyval.psb = ListAppend (Mbuf, (char *) NULL, (char *) NULL);
			} break;
case 258:
# line 1179 "parser.y"
{
				yyval.psb = ListAppend (MakePosTok (yypvt[-0].ival), (char *) NULL, (char *) NULL);
			} break;
case 259:
# line 1182 "parser.y"
{
				*Cbuf = MakeMac (yypvt[-1].phe, (unsigned) ID_MACRO);
				yyval.psb = ListAppend("$&", (char *)Cbuf, (char *)NULL);
			} break;
case 260:
# line 1193 "parser.y"
{
  				yyval.ival = yypvt[-0].ival;
		} break;
case 261:
# line 1196 "parser.y"
{
				yyval.ival = ',';
			} break;
case 262:
# line 1202 "parser.y"
{
				yyval.ival = yypvt[-0].ival;
			} break;
case 263:
# line 1205 "parser.y"
{
				yyval.ival = ':';
			} break;
case 264:
# line 1208 "parser.y"
{
				yyval.ival = '*';
			} break;
case 265:
# line 1211 "parser.y"
{
				yyval.ival = ';';
			} break;
case 266:
# line 1214 "parser.y"
{
				yyval.ival = '{';
			} break;
case 267:
# line 1217 "parser.y"
{
				yyval.ival = '}';
			} break;
case 268:
# line 1220 "parser.y"
{
				yyval.ival = ',';
			} break;
case 269:
# line 1223 "parser.y"
{
				yyval.ival = ',';
			} break;
case 270:
# line 1226 "parser.y"
{
				yyval.ival = '/';
			} break;
case 271:
# line 1229 "parser.y"
{
				yyval.ival = '=';
			} break;
case 272:
# line 1234 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-2].psb);
				Free (yypvt[-0].psb);
			} break;
case 273:
# line 1239 "parser.y"
{
			yyval.psb = yypvt[-0].psb;
			} break;
case 274:
# line 1242 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 275:
# line 1247 "parser.y"
{
				yyval.psb = ListAppend ("$#", yypvt[-1].psb, (char *) NULL);
			} break;
case 276:
# line 1252 "parser.y"
{
				yyval.psb = ListAppend (Tsb = ListAppend ("$@", yypvt[-3].psb, (char *) NULL),
						 yypvt[-0].psb, (char *) NULL);
				Free (Tsb);


				Free (yypvt[-0].psb);
			} break;
case 277:
# line 1260 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 278:
# line 1263 "parser.y"
{
				yyval.psb = MakeCond (yypvt[-3].phe, MacScan(yypvt[-1].psb));
			} break;
case 279:
# line 1268 "parser.y"
{
				if (yypvt[-0].psb != NULL) {
					yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].psb, "$|");
					Free (yypvt[-2].psb);
					Free (yypvt[-0].psb);
				} else
					yyval.psb = yypvt[-2].psb;
			} break;
case 280:
# line 1276 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 281:
# line 1282 "parser.y"
{
				yyval.psb = yypvt[-1].psb;
			} break;
case 282:
# line 1287 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 283:
# line 1290 "parser.y"
{
				yyval.psb = Bracket (yypvt[-1].psb, FALSE);
				Free (yypvt[-1].psb);
			} break;
case 284:
# line 1296 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 285:
# line 1299 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].phe->psb, (char *) NULL);
				RemoveSymbol (yypvt[-0].phe);
				Free (yypvt[-1].psb);
			} break;
case 286:
# line 1304 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-1].psb, yypvt[-0].psb, (char *) NULL);
				Free (yypvt[-1].psb);	/* NULL */
			} break;
case 287:
# line 1310 "parser.y"
{
				yyval.psb = ListAppend ("$:", yypvt[-1].psb, (char *) NULL);
				Free (yypvt[-1].psb);
			} break;
case 288:
# line 1316 "parser.y"
{
				yyval.psb = CheckMailer (yypvt[-0].phe);
			} break;
case 289:
# line 1319 "parser.y"
{
				yyval.psb = yypvt[-0].psb;
			} break;
case 291:
# line 1325 "parser.y"
{
				AssignType (ListAppend (yypvt[-4].phe->psb, yypvt[-3].psb, " "), yypvt[-1].psb);
				Free (yypvt[-3].psb);	/* NULL */
			} break;
case 292:
# line 1329 "parser.y"
{
				yyerrok;
			} break;
case 293:
# line 1334 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 294:
# line 1337 "parser.y"
{
				yyval.psb = ListAppend (yypvt[-2].psb, yypvt[-0].phe->psb, " ");
				Free (yypvt[-2].psb);
			} break;
case 295:
# line 1343 "parser.y"
{
				yyval.psb = ListAppend (MakeField (yypvt[-2].ival, yypvt[-0].phe, FALSE, FALSE), 
				    		 (char *) NULL, (char *) NULL);
			} break;
case 296:
# line 1347 "parser.y"
{
				yyval.psb = ListAppend (MakeField (yypvt[-3].ival, yypvt[-0].phe, FALSE, TRUE), 
				    		 (char *) NULL, (char *) NULL);
			} break;
case 297:
# line 1351 "parser.y"
{
				yyval.psb = ListAppend ("$%y", 
				    		 (char *) NULL, (char *) NULL);
			} break;
case 298:
# line 1355 "parser.y"
{
				yyval.psb = ListAppend (MakeField (yypvt[-2].ival, (struct he *) NULL, TRUE, FALSE), 
						 (char *) NULL, (char *) NULL);
			} break;
case 299:
# line 1359 "parser.y"
{
				yyval.psb = NULL;
			} break;
case 300:
# line 1364 "parser.y"
{
				yyval.phe = NULL;
			} break;
case 301:
# line 1367 "parser.y"
{
				yyval.phe = yypvt[-0].phe;
			} break; 
		}
		goto yystack;  /* stack new state and value */

	}
