(*
    InOut module for the DEC MIPS Modula-2 compiler.
    Philip A. Nelson   (phil@cs.wwu.edu)
    April 1991

    This is public domain software.
*)

IMPLEMENTATION MODULE InOut;

FROM io IMPORT input, output;

VAR  InFile, OutFile : TextIO.File;

  PROCEDURE OpenIn (FileName : ARRAY OF CHAR);
    VAR newfile : TextIO.File;
    BEGIN
      TextIO.OpenIn (newfile, FileName);
      IF TextIO.Done THEN
        IF InFile <> input THEN
     	  TextIO.Close (InFile);
        END;
        InFile := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenIn;

  PROCEDURE OpenOut (FileName : ARRAY OF CHAR);
    VAR newfile : TextIO.File;
    BEGIN
      newfile := NIL;
      TextIO.OpenOut (newfile, FileName);
      IF TextIO.Done THEN
        IF OutFile <> output THEN
     	  TextIO.Close (OutFile);
        END;
        OutFile := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenOut;

  PROCEDURE OpenInput (defext: ARRAY OF CHAR);
    VAR newfile : TextIO.File;
    BEGIN
      TextIO.OpenInput (newfile, defext);
      IF TextIO.Done THEN
        IF InFile <> input THEN
     	  TextIO.Close (InFile);
        END;
        InFile := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenInput;

  PROCEDURE OpenOutput (defext: ARRAY OF CHAR);
    VAR newfile : TextIO.File;
    BEGIN
      TextIO.OpenOutput (newfile, defext);
      IF TextIO.Done THEN
        IF OutFile <> output THEN
     	  TextIO.Close (OutFile);
        END;
        OutFile := newfile;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END OpenOutput;

  PROCEDURE CloseInput;
    BEGIN
      IF InFile <> input THEN
        TextIO.Close(InFile);
        InFile := input;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END CloseInput;

  PROCEDURE CloseOutput;
    BEGIN
      IF OutFile <> output THEN
        TextIO.Close(OutFile);
        OutFile := output;
        Done := TRUE;
      ELSE
        Done := FALSE;
      END;
    END CloseOutput;

  PROCEDURE Read (VAR ch : CHAR);
    BEGIN
      TextIO.Read (InFile, ch);
      Done := TextIO.Done;
    END Read;

  PROCEDURE ReadLn ;
    BEGIN
      TextIO.ReadLn (InFile);
      Done := TextIO.Done;
    END ReadLn;

  PROCEDURE ReadString (VAR str : ARRAY OF CHAR);
    BEGIN
      TextIO.ReadString (InFile, str);
      Done := TextIO.Done;
    END ReadString; 

  PROCEDURE ReadInt (VAR int : INTEGER);
    BEGIN
      TextIO.ReadInt (InFile, int);
      Done := TextIO.Done;
    END ReadInt;

  PROCEDURE ReadCard (VAR card : CARDINAL);
    BEGIN
      TextIO.ReadCard (InFile, card);
      Done := TextIO.Done;
    END ReadCard;

  PROCEDURE ReadReal (VAR r: REAL);
    BEGIN
      TextIO.ReadReal (InFile, r);
      Done := TextIO.Done;
    END ReadReal;

  PROCEDURE Write (ch : CHAR);
    BEGIN
      TextIO.Write (OutFile, ch);
    END Write;

  PROCEDURE WriteLn;
    BEGIN
      TextIO.WriteLn (OutFile);
    END WriteLn;

  PROCEDURE WriteString (str : ARRAY OF CHAR);
    BEGIN
      TextIO.WriteString (OutFile, str);
    END WriteString;

  PROCEDURE WriteInt (int : INTEGER; n : CARDINAL);
    BEGIN
      TextIO.WriteInt (OutFile, int, n);
    END WriteInt;

  PROCEDURE WriteCard (card, n : CARDINAL);
    BEGIN
      TextIO.WriteCard (OutFile, card, n);
    END WriteCard;

  PROCEDURE WriteOct (card, n : CARDINAL);
    BEGIN
      TextIO.WriteOct (OutFile, card, n);
    END WriteOct;

  PROCEDURE WriteHex (card, n : CARDINAL);
    BEGIN
      TextIO.WriteHex (OutFile, card, n);
    END WriteHex;

  PROCEDURE WriteReal (r: REAL; n: CARDINAL);
    BEGIN
      TextIO.WriteReal (OutFile, r, n);
    END WriteReal;

BEGIN
  InFile := input;
  OutFile := output;
END InOut.
