implementation module SymbolDump;

(****************************************************************************
 *									    *
 *  Copyright (c) 1984 by						    *
 *  DIGITAL EQUIPMENT CORPORATION, Maynard, Massachusetts.		    *
 *  All rights reserved.						    *
 * 									    *
 *  This software is furnished under a license and may be used and copied   *
 *  only in  accordance with  the  terms  of  such  license  and with the   *
 *  inclusion of the above copyright notice. This software or  any  other   *
 *  copies thereof may not be provided or otherwise made available to any   *
 *  other person.  No title to and ownership of  the  software is  hereby   *
 *  transferred.							    *
 * 									    *
 *  The information in this software is  subject to change without notice   *
 *  and  should  not  be  construed as  a commitment by DIGITAL EQUIPMENT   *
 *  CORPORATION.							    *
 * 									    *
 *  DIGITAL assumes no responsibility for the use  or  reliability of its   *
 *  software on equipment which is not supplied by DIGITAL.		    *
 * 									    *
 *  $Header: SymbolDumpUC.mod,v 1.6 90/05/23 00:29:37 lattanzi Locked $
 ****************************************************************************)

from Machine import
    BYTESIZE,WORDSIZE,BYTESPERWORD,BOOLEANSIZE,MAXINT;

from Strings import
    String, CopyString, WriteString;

from Globals import
    compileModuleName, genDebugInfoFlag,
    DEBUG,TraceStab;

from Symbols import
    TypeNumber, Scope, PTRMODULA, GSNORMAL, Symbol, LookUpSymbol,
    FieldNode, FieldList, VariantNode, PortNode,
    ModuleNode, ProcNode, EnumNode, ParamNode, SymbolKind,
    MemoryType, DataType, ArrayKind,
    integerTypeNode, charTypeNode, booleanTypeNode, longrealTypeNode,
    packedCharTypeNode, packedBooleanTypeNode, 
    globalModule, globalProc, globalPortList, FIELDTAG, GSEXTERNAL,
    ConstSetList, ConstSetNode, GlobalSymKind, SIZEUNSPECIFIED, 
    ALIGNMENTUNSPECIFIED,BIPNOTBIP;

$if modula2 then
from Symbols import ArrayKindSet, realTypeNode, cardinalTypeNode, wordTypeNode,
    byteTypeNode, addressTypeNode, cardIntTypeNode, fileTypeNode, 
    processTypeNode, packedByteTypeNode,GlobalVarNode;
$else
from Symbols import PTRPASCAL;
$end

from Errors import
    ErrorName,Error;

from TypeInfo import
    SizeOf, AlignmentOf, LowerBoundOf, UpperBoundOf, BaseType;

from PCodeOps import
    PCSYM;

from UCode import
    C, GenReal, GenSet, EndLine, I, GenString;

from GenUC import
    MAINPROGNAME,theCharArray, GenConst;

from stsupport import indexNil,issNull, NULLDN;

from stinfc import
    st_extadd,st_auxbtadd,st_extstradd,st_idn_index_fext,
    st_stradd, st_symadd,st_symadd,st_currentifd,st_setfd,st_blockbegin,
    st_blockend,st_auxadd,st_auxrndxadd,st_auxrndxadd_idn,
    st_procbegin,st_pdadd_idn,st_procend,st_changeauxrndx,
    st_auxbtsize,st_pdn_idn,st_pext_iext,st_psym_ifd_isym,
    st_paux_iaux;

from stsupport import
    pDNR, pAUXU, pEXTR,ST_EXTIFD;

from symconst import
    btNil,btMax,stProc,stGlobal,scData,btAdr,btUChar,
    btInt,btUInt,btFloat,btDouble,btRange,btEnum,btSet,btIndirect,
    btStruct,scUndefined,scBss,scInfo,stLocal,stStatic,
    stMember,scVariant,btTypedef,scNil,btChar,stTypedef,tqArray,tqPtr,
    scVar,scAbs,stParam,stConstant,stStaticProc,tqProc,tqNil;

from MipSym import
    StartFile,symFileNumber,auxnums;

from io import
    SWriteF,WriteS,output,WriteF;

from PCodeOps import
    PCodeOp;

from GenUC import
    theCharArray;

from strings import
    Append,Assign;

from MemLib import
    ALLOCATE;

from Decls import
    adviseFlag;

const
    STABNMOD2         =  80;	(* same as N_MOD2 in /usr/include/stab.h *)

    STABSOURCEFILE    = 100;
    STABSYMBOL        = 128;
    STABREGISTER      =  64;
    STABGLOBAL        =  32;
    STABPARAM         = 160;
    STABLINE	      =  68;
    STABPROC	      =  36;
    STABTOKENSPERLINE =  10;

(* Builtin type numbers...dbx knows about all these. *)
$if modula2 then
    INTEGERNUMBER   =  1;
    CHARNUMBER      =  2;
    BOOLEANNUMBER   =  3;
    CARDINALNUMBER  =  4;
    REALNUMBER      =  5;
    LONGREALNUMBER  =  6;
    WORDNUMBER      =  7;
    BYTENUMBER      =  8;
    ADDRESSNUMBER   =  9;
    FILENUMBER      = 10;
    PROCESSNUMBER   = 11;
    CARDINTNUMBER   = 12;
$else (* pascal *)
    BOOLEANNUMBER   =  1;
    CHARNUMBER      =  2;
    INTEGERNUMBER   =  3;
    LONGREALNUMBER  =  4;
$end
    MAXBUILTINTYPES = 20;
type
    ForwardNode = pointer to ForwardRec;
    ForwardRec = record
        aux : integer;
     	ifd : integer;
     	tn : TypeNode;
        next : ForwardNode;
    end;
var
    currSym,currScopeName : String;
    forwardList,freeList : ForwardNode;
    generateTypeNumber : TypeNumber;
    stabFileName    : String;
    stabLineNumber  : integer;
    stabTokenCount  : integer;
    inTypeDef       : boolean;
    dt : DataType;
    bt_idn : array[btNil..btMax] of integer;
    bool_idn : integer;
    index : [btNil..btMax];

procedure @inline GenOp(const op : PCodeOp);
begin
     assert(op = PCSYM,'non PCSYM op in SymbolDumpUC.mod');
end GenOp;

(* Return an index into the string-table for string with optional suffix *)
procedure issname(const prefix : array of char; const i : integer) : integer;
var
     name,intname : array[1..20] of char;
begin
     Assign(name,prefix);
     if i > 0 then
         SWriteF(intname,'%d',i);
         Append(name,intname);
     end;
     return st_stradd(name);
end issname;

(* Find first type with Size info *)
procedure SizeType(tn : TypeNode) : TypeNode;
begin
     if tn # nil then
         while (tn^.kind = DTRENAME) and 
     	       (tn^.renameType # nil) and
     	       (tn^.size = SIZEUNSPECIFIED) do
             tn := tn^.renameType;
         end;
     end;
     return tn;
end SizeType;

(* Allocater for forward type declarations *)
procedure NewForwardNode (var f : ForwardNode);
begin
    if freeList # nil then
        f := freeList;
        freeList := freeList^.next;
    else
        new(f);
    end;
end NewForwardNode;

procedure DisposeForwardNode(f : ForwardNode);
begin
    f^.next := freeList;
    freeList := f;
end DisposeForwardNode;

(* Fix up forward definitions *)
procedure BackStab;
var
    f : ForwardNode;
    ifdsave : integer;
begin
    while forwardList # nil do
        f := forwardList;
        if f^.tn^.sym_idn # NULLDN then
     	    ifdsave := st_currentifd();
            st_setfd(f^.ifd);
            st_changeauxrndx(f^.aux,f^.ifd,TypeToAux(f^.tn));
     	    st_setfd(ifdsave);
        else
            CopyString(f^.tn^.name,theCharArray);
     	    Error(theCharArray);
            SWriteF(theCharArray,'Still void forward type: %n',f^.tn^.kind);
     	    Error(theCharArray);
        end;
        forwardList := forwardList^.next;
     	DisposeForwardNode(f);
    end;
end BackStab;

procedure NamedType(tn : TypeNode) : TypeNode;
begin
    if tn # nil then
	while   (tn^.opaqueName = nil) and (tn^.theModule = nil) and
		(tn^.kind = DTRENAME) and
		(tn^.alignment = ALIGNMENTUNSPECIFIED) and 
                (tn^.size = SIZEUNSPECIFIED) and
		(tn^.renameType # nil) do
	    tn := tn^.renameType;
	end;
    end;
    return tn;
end NamedType;

procedure InitStab(const mainFileName : String);
begin
    stabTokenCount := 0;

$if modula2 then
    integerTypeNode^.number	  := INTEGERNUMBER;
    charTypeNode^.number	  := CHARNUMBER;
    packedCharTypeNode^.number    := CHARNUMBER;
    booleanTypeNode^.number	  := BOOLEANNUMBER;
    packedBooleanTypeNode^.number := BOOLEANNUMBER;
    cardinalTypeNode^.number	  := CARDINALNUMBER;
    realTypeNode^.number	  := REALNUMBER;
    longrealTypeNode^.number	  := LONGREALNUMBER;
    wordTypeNode^.number	  := WORDNUMBER;
    byteTypeNode^.number	  := BYTENUMBER;
    packedByteTypeNode^.number    := BYTENUMBER;
    addressTypeNode^.number	  := ADDRESSNUMBER;
    fileTypeNode^.number	  := FILENUMBER;
    processTypeNode^.number	  := PROCESSNUMBER;
    cardIntTypeNode^.number	  := CARDINTNUMBER;
$else
    booleanTypeNode^.number	  := BOOLEANNUMBER;
    packedBooleanTypeNode^.number := BOOLEANNUMBER;
    charTypeNode^.number	  := CHARNUMBER;
    packedCharTypeNode^.number    := CHARNUMBER;
    integerTypeNode^.number	  := INTEGERNUMBER;
    longrealTypeNode^.number	  := LONGREALNUMBER;
$end

    generateTypeNumber := MAXBUILTINTYPES;
    inTypeDef := false;
end InitStab;

procedure IndirectTypeToAux(tn : TypeNode) : integer;
var
    iaux,ignore : integer;
    at : TypeNode;
begin
    assert(tn # nil,'Nil type in IndirectTypetoAux');
    at := SizeType(tn);
    assert(at^.sym_idn # NULLDN,'null Type index');
    iaux := st_auxbtadd(btTypedef);
    ignore := st_auxrndxadd_idn(at^.sym_idn);
    return iaux;
end IndirectTypeToAux;

procedure addtq(iaux : integer; tq : integer);
var
    paux : pAUXU;
begin
    paux := st_paux_iaux(iaux);
    if paux^.ti.tq0 = tqNil then
        paux^.ti.tq0 := tq;    
    elsif paux^.ti.tq1 = tqNil then
        paux^.ti.tq1 := tq;    
    elsif paux^.ti.tq2 = tqNil then
        paux^.ti.tq2 := tq;    
    elsif paux^.ti.tq3 = tqNil then
        paux^.ti.tq3 := tq;    
    elsif paux^.ti.tq4 = tqNil then
        paux^.ti.tq4 := tq;    
    elsif paux^.ti.tq5 = tqNil then
        paux^.ti.tq5 := tq;    
    else
     	Writes(output,'(Warning) Type qualifier overflow for symbol ');
        WriteString(output,currSym);
        Writes(output,'\n');
    end;
end addtq;

(* return index into aux table for type tn. Modify indicates that caller will
   munge auxialiaries so a copy may be required *)
procedure Aux_Type(const tn : TypeNode; modify : boolean;
     	       	   size : integer) : integer;
var
    baseiaux,iaux,ignore,idn : integer;
    at : TypeNode;
    bt : integer;
    fptr : ForwardNode;
    kind : DataType;

    procedure st_auxbtsizeadd(const bt, size : integer) : integer;
    var iaux,ignore : integer;
    begin
        iaux := st_auxbtadd(bt);
        if size # 0 then
            ignore := st_auxbtsize(iaux,size);
        end;
    return iaux;
    end st_auxbtsizeadd;

    (* Calculate aux index from relative file descriptor and index *)
    procedure iaux_rfd_index(const rfd, index : integer) : integer;
    var
        paux : pAUXU;
        iaux : integer;
        pext : pEXTR;
    begin
        iaux := indexNil;
        if not genDebugInfoFlag then
            return iaux;
        end;
        if rfd = ST_EXTIFD then
            pext := st_pext_iext(index);
            if pext^.ifd = st_currentifd() then
     	        iaux := st_psym_ifd_isym(pext^.ifd,pext^.asym.index)^.index;
            end;
        elsif rfd = st_currentifd() then
            iaux := st_psym_ifd_isym(rfd,index)^.index;
        end;
        if iaux # indexNil then
            paux := st_paux_iaux(iaux);
            if (paux^.ti.bt = btTypedef) and (* Traverse typedef? *)
               (paux^.ti.tq0 = tqNil) and	 (* no type quals *)
               (paux^.ti.fBitfield = 0) then (* no bit size *)
                paux := st_paux_iaux(iaux+1);
                if paux^.isym # -1 then (* and not waiting for back patch *)
                    iaux := iaux_rfd_index(paux^.rndx.rfd,paux^.rndx.index);
     	        end;
            end;
        end;
        return iaux;
    end iaux_rfd_index;

    procedure iaux_idn(const idn : integer) : integer;
    var pdn : pDNR;
    begin
        pdn := st_pdn_idn(idn);
        return iaux_rfd_index(pdn^.rfd,pdn^.index);
    end iaux_idn;

begin
    if (tn = nil) or not genDebugInfoFlag then return indexNil; end;
    iaux := indexNil;
    at := SizeType(tn);
    idn := at^.sym_idn;
    bt := mapDTtoBT[at^.kind];
    kind := at^.kind;
    if size # 0 then 
        modify := true;
    end;
    if (idn # NULLDN) and not modify and (bt # btEnum) and (bt # btStruct) and
       (kind # DTARRAY) then
        iaux := iaux_idn(idn);
     	if iaux # indexNil then
            return iaux;
        end;
    end;
    case bt of
    | btNil: (* needs work *)
	case kind of
        | DTRENAME, DTPOINTER, DTPROC:		 (* worry about forward def *)
            if kind = DTRENAME then
     	        if size = 0 then
     	            size := at^.size;
                end;
 	       	at := at^.renameType;
            elsif kind = DTPOINTER then
    	        at := at^.toType;
            elsif kind = DTPROC then
                at := at^.funcType;
 	    end;
      	    at := SizeType(at);
     	    if at = nil then
	        iaux := st_auxbtsizeadd(btInt,size); (* dbx2.1 dislikes btNil *)
     	    elsif at^.sym_idn # NULLDN then
     	        iaux := Aux_Type(at,true,size);
            else
                iaux := st_auxbtsizeadd(btIndirect,size);
            end;
     	    if kind = DTPOINTER then
     	        addtq(iaux,tqPtr);
     	    elsif kind = DTPROC then
	        addtq(iaux,tqProc);
     	        addtq(iaux,tqPtr);	 (* pointer to function *)
            end;
            if (at # nil) and (at^.sym_idn = NULLDN) then
         	(*   Need to make Forward list *)
         	NewForwardNode(fptr);
     	        fptr^.aux := st_auxrndxadd(-1,-1);
     	       	fptr^.ifd := st_currentifd();
         	fptr^.tn := at;
     	       	fptr^.next := forwardList;
     	       	forwardList := fptr;
            end;

        | DTDYNARRAY:
            iaux := Aux_Type(at^.dynArrayType,true,size);
     	    addtq(iaux,tqPtr);

        | DTARRAY:
            if at^.elementType = nil then
		 (* array of enum offset/names *)
     	        iaux := st_auxbtsizeadd(btNil,size);
     	        addtq(iaux,tqPtr);
     	    elsif (at^.arrayKind = ARRAYNORMAL) or
               (at^.arrayKind = ARRAYNOCOUNT) then
                if at^.indexType # nil then
     	       	    baseiaux := Aux_Type(at^.indexType,false,size);
                else
     	       	    baseiaux := Aux_Type(integerTypeNode,false,size);
                end;
     	       	iaux := Aux_Type(at^.elementType,true,0);
     	        addtq(iaux,tqArray);
     	        ignore := st_auxrndxadd(st_currentifd(),baseiaux);
     	        if at^.indexType # nil then
     	            ignore := st_auxadd(trunc(LowerBoundOf(at^.indexType)));
     	            ignore := st_auxadd(trunc(UpperBoundOf(at^.indexType)));
                else
     	       	    ignore := st_auxadd(0);
     	       	    ignore := st_auxadd(-1);
                end;
     	        ignore := st_auxadd(tn^.elementSize);
            else
     	       	(*  open or subarray *)
    	        assert(at^.sym_idn # NULLDN,'problem with open/subarray');
	        iaux := st_auxbtsizeadd(btStruct,size);
	        ignore := st_auxrndxadd_idn(at^.sym_idn);
     	    end;
        | DTANY: iaux := st_auxbtadd(btNil); (* ignore *)
     	else
     	    SWriteF(theCharArray,'Unexpected type in Aux_Type(%n)',
     	       	 at^.kind);
     	    Error(theCharArray);
     	end;

    | btInt, btUInt, btFloat, btDouble, btUChar, btChar, btAdr:
     	if modify then
            iaux := st_auxbtsizeadd(bt,size);
        else
     	    iaux := auxnums[bt];	 (* these are in every file! *)
        end;

    | btRange:
        baseiaux := Aux_Type(at^.baseType,false,0);
        if size = 0 then 
            size := SizeOf(at);
        end;
        if size = WORDSIZE then size := 0; end; (* default size *)
     	iaux := st_auxbtsizeadd(btRange,size);
     	ignore := st_auxrndxadd(st_currentifd(),baseiaux);
     	ignore := st_auxadd(trunc(tn^.subMinOrd));
     	ignore := st_auxadd(trunc(tn^.subMaxOrd));

    | btEnum, btStruct: 
        assert(at^.sym_idn # NULLDN,'problem with Enum/Struct');
        if bt = btEnum then
            if size = 0 then size := SizeOf(at); end;
     	    if size = WORDSIZE then size := 0; end; (* default size *)
        end;
        iaux := st_auxbtsizeadd(bt,size);
        ignore := st_auxrndxadd_idn(at^.sym_idn);

    | btSet:
        baseiaux := Aux_Type(at^.setRange,false,0);
        if size = 0 then
            size := SizeOf(at);
        end;
     	if size = WORDSIZE then size := 0; end; (* default size *)
     	iaux := st_auxbtsizeadd(bt,size);
     	ignore := st_auxrndxadd(st_currentifd(),baseiaux);
    end;
    if iaux = indexNil then
     	CopyString(at^.name,theCharArray);
     	Error(theCharArray);
        SWriteF(theCharArray,'Aux_Type(%n)=%d',kind,idn);
        Error(theCharArray);
    end;
    return iaux;
end Aux_Type;

procedure TypeToAux(tn : TypeNode) : integer;
begin
    return Aux_Type(tn,false,0);
end TypeToAux;

procedure StabCheckFieldList(fl : FieldList);
var
    fn : FieldNode;
    vn : VariantNode;
begin
    fn := fl^.first;
    while fn # nil do
	StabCheckType(fn^.fieldType);
	if fn^.kind = FIELDTAG then
	    vn := fn^.variantList^.first;
	    while vn # nil do
		StabCheckFieldList(vn^.fieldList);
		vn := vn^.next;
	    end;
	end;
	fn := fn^.next;
    end;
end StabCheckFieldList;

procedure SymName(name : String) : integer;
begin
    if name # nil then
        currSym := name;
    end;
    CopyString(name,theCharArray);
    if theCharArray[Low(theCharArray)] = 0C then
(* This breaks current implementation of btTypeDef 
        return issNull;*)
   	return st_stradd("#");
    else
        return st_stradd(theCharArray);
    end;
end SymName;

procedure GlobalSymName(name : String) : integer;
begin
    currSym := name;
    CopyString(name,theCharArray);
    assert(theCharArray[Low(theCharArray)] # 0C);
    return st_extstradd(theCharArray);
end GlobalSymName;

procedure StabCheckType(tn : TypeNode);
begin
    if tn # nil then
	if tn^.sym_idn = NULLDN then
	    StabNamedType(tn^.name,tn);
	elsif tn^.kind = DTRENAME then
	    StabCheckType(tn^.renameType);
	end;
    end;
end StabCheckType;

procedure StabFieldList(fl : FieldList;const delta : integer);
var
    fn : FieldNode;
    vn : VariantNode;
    field_isym,iaux,ignore,nRanges,baseiaux,upper,lower,offset, (* size, *)
     	  st,iss : integer;
    tag : ConstSetList;
    range : ConstSetNode;
begin
    fn := fl^.first;
    while fn # nil do
        offset := fn^.offset (* - delta *);
(*     	size := SizeOf(fn^.fieldType);*)
     	if (fn^.name # nil) or (offset # -1) then
     	    iss := SymName(fn^.name);
(*            if (offset mod BYTESIZE # 0) or 
     	       (size mod BYTESIZE # 0) then
     	        CopyString(fn^.name,theCharArray,);
     	        Error('problems with field %s',theCharArray);
     	        writef(terminal,'offset = %d, size = %d\n',offset,size);
            end;
     	    offset := offset div BYTESIZE; *)
     	    st := stMember;
        else
            iss := issNull;
     	    offset := 0;
     	    st := stTypedef;
        end;
        baseiaux := TypeToAux(fn^.fieldType);
     	field_isym := st_symadd(iss,offset,st,scInfo,baseiaux);
	if fn^.kind = FIELDTAG then
     	    ignore := st_blockbegin(0,field_isym,scVariant);
	    vn := fn^.variantList^.first;
	    while vn # nil do
                if vn^.fieldList^.first # nil then (* bag empty field lists *)
     	            tag := vn^.tag;
     	            range := tag^.first;
     	            nRanges := 0;
     	            repeat 
                        inc(nRanges);
     	       	        range := range^.next;
     	            until range = nil;
     	       	    (* iaux has tag info *)
     	            iaux := st_auxadd(nRanges);
     	            range := tag^.first;
     	            repeat
     	       	        ignore := st_auxrndxadd(st_currentifd(),baseiaux);
                        case range^.lower^.kind of
     	                | DTCARDINAL, DTINTEGER:
     	       	            lower := trunc(range^.lower^.cardVal);
     	       	            upper := trunc(range^.upper^.cardVal);
                        | DTENUMERATION:
     	       	            lower := range^.lower^.enumVal^.enumOrd;
     	       	            upper := range^.upper^.enumVal^.enumOrd;
                        | DTBOOLEAN:
     	       	            lower := ord(range^.lower^.boolVal);
     	       	            upper := ord(range^.upper^.boolVal);
     	                end;
		        ignore := st_auxadd(lower);
     	                ignore := st_auxadd(upper);
     	       	        range := range^.next;
                    until range = nil;
     	            ignore := st_blockbegin(0,iaux,scInfo);
		    StabFieldList(vn^.fieldList,
     	       	        	  delta+offset+SizeOf(fn^.fieldType));
     	            ignore := st_blockend(iaux);
                end;
		vn := vn^.next;
	    end;
     	    ignore := st_blockend(field_isym);
	end;
	fn := fn^.next;
    end;
end StabFieldList;

procedure StabCheckProcType(tn : TypeNode);
var
    pn : ParamNode;
begin
    StabCheckType(tn^.funcType);
    if tn^.paramList # nil then
	pn := tn^.paramList^.first;
	while pn # nil do
	    StabCheckType(pn^.paramType);
	    pn := pn^.next;
	end;
    end;
end StabCheckProcType;

var mapDTtoBT : array DataType of [btNil .. btMax];

(* try to make sure dependent types are output before this one is *)
procedure StabNamedType(name : String; tn : TypeNode);
var
    enum : EnumNode;
    i,n,ignore,iaux,baseiaux,iss,ifd : integer;
    atn : TypeNode;
begin
    if not genDebugInfoFlag then
        return;
    end;
    tn := NamedType(tn);
    if tn^.sym_idn = NULLDN then
        ifd := st_currentifd();
        if tn^.theModule # nil then
            st_setfd(tn^.theModule^.sym_file);
        end;
        if name = nil then
            if (tn^.name # nil) then
     	        name := tn^.name;
            else
                name := tn^.opaqueName;
            end;
        end;
        iss := SymName(name);
        if DEBUG and TraceStab then
            WriteS(output,'StabNamedType(');
     	    WriteString(output,name);
            WriteF(output,',%n)\n',tn^.kind);
        end;
	case tn^.kind of
        | DTANY:			 (* ignore *)
        | DTBOOLEAN:
            assert(bool_idn = NULLDN,'Another def of boolean');
            tn^.sym_idn := st_blockbegin(iss,2,scInfo);
            ignore := st_symadd(st_stradd('false'),0,stMember,scInfo,indexNil);
            ignore := st_symadd(st_stradd('true'),1,stMember,scInfo,indexNil);
            ignore := st_blockend(2);
            bool_idn := tn^.sym_idn;

	| DTINTEGER, DTCHAR, DTREAL, DTLONGREAL,
	  DTCARDINAL, DTWORD, DTBYTE :
     	    if bt_idn[mapDTtoBT[tn^.kind]] = NULLDN then
	        bt_idn[mapDTtoBT[tn^.kind]] := 
     	          st_idn_index_fext(st_symadd(iss,0,stTypedef,
     	       	    scNil,auxnums[mapDTtoBT[tn^.kind]]),0);
     	    end;
	    tn^.sym_idn := bt_idn[mapDTtoBT[tn^.kind]];

	| DTOPAQUE:
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	   	     stTypedef,scNil,TypeToAux(tn)),0);
	    (* nothing to do ??? *)
        | DTENUMERATION :
     	    tn^.sym_idn := st_blockbegin(iss,tn^.enumMax - tn^.enumMin + 1,
     	       	    	      	   	 scInfo);
	    enum := tn^.enumList^.first;
	    while enum # nil do
     	        ignore := st_symadd(SymName(enum^.name),enum^.enumOrd,stMember,
     	       	       	            scInfo, indexNil);
     	        enum := enum^.next;
            end;
     	    ignore := st_blockend(tn^.enumMax - tn^.enumMin + 1);

	| DTRENAME :
            if (tn^.renameType = nil) and (name # nil) then
                CopyString(name,theCharArray);
		Append(theCharArray,' has inadequate symbol type information');
                Error(theCharArray);
	    end;
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	   stTypedef,scNil,TypeToAux(tn)),0);
	    StabCheckType(tn^.renameType); (* this may Stab us *)

	| DTPOINTER :
	    if (tn^.toType = nil) or ((tn^.toType^.kind = DTRENAME) and
				      (tn^.toType^.renameType = nil) and
				      (tn^.toType^.name = nil)) then
                CopyString(name,theCharArray);
		Append(theCharArray,' has inadequate symbol type information');
                Error(theCharArray);
            end;
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	   	     stTypedef,scNil,TypeToAux(tn)),0);
	    StabCheckType(tn^.toType);	 (* prevent infinite recursion *)

	| DTPROC :
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	     stTypedef,scNil,TypeToAux(tn)),0);
	    StabCheckProcType(tn);

	| DTSET :
	    StabCheckType(tn^.setRange);
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	             stTypedef,scNil,TypeToAux(tn)),0);
	| DTSUBRANGE :
	    StabCheckType(tn^.baseType);
     	    tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	   	stTypedef,scNil,TypeToAux(tn)),0);
	| DTRECORD :
	    StabCheckFieldList(tn^.fieldList);
	    tn^.sym_idn := st_blockbegin(iss,
     	       	    	      	   	 (SizeOf(tn)+BYTESIZE-1) div BYTESIZE,
     	                                 scInfo);
            StabFieldList(tn^.fieldList,0);
     	    ignore := st_blockend((SizeOf(tn)+BYTESIZE-1) div BYTESIZE);

	| DTDYNARRAY :
	    StabCheckType(tn^.dynArrayType);
     	    StabCheckType(cardinalTypeNode);
     	    tn^.sym_idn := st_blockbegin(iss,SizeOf(tn) div BYTESIZE,scInfo);
     	    atn := tn^.dynArrayType;
            n := 0;
     	    while (atn^.kind = DTARRAY) and
		(atn^.arrayKind in ArrayKindSet{ARRAYOPEN,ARRAYNOCOUNT}) do
	        inc(n);
	        atn := atn^.elementType;
            end;
     	    iaux := Aux_Type(atn,true,0);
     	    addtq(iaux,tqPtr);
     	    ignore := st_symadd(issname('_dynarray',0),0,stMember,scInfo,iaux);
     	    for i := 1 to n do
     	        ignore := st_symadd(issname('_num_',i),i*WORDSIZE,stMember,
     	       	    	      	    scInfo,TypeToAux(cardinalTypeNode));
            end;
     	    ignore := st_blockend(SizeOf(tn) div BYTESIZE);

	| DTARRAY :
	    if tn^.indexType # nil then
		StabCheckType(tn^.indexType);
	    end;
	    (* ||| Need elementSize modifications *)
	    StabCheckType(tn^.elementType);
     	    if (tn^.arrayKind = ARRAYNORMAL) or
     	       (tn^.arrayKind = ARRAYNOCOUNT) then
     	        tn^.sym_idn := st_idn_index_fext(st_symadd(iss,0,
     	       	    	      	   stTypedef,scNil,TypeToAux(tn)),0);
            else
     	        StabCheckType(cardinalTypeNode);
     	        tn^.sym_idn := st_blockbegin(iss,SizeOf(tn) div BYTESIZE,
     	       	    	      scInfo);
     	        baseiaux := TypeToAux(cardinalTypeNode);
     	       	iaux := Aux_Type(tn^.elementType,true,0);
     	        addtq(iaux,tqArray);
     	        addtq(iaux,tqPtr);
     	        ignore := st_auxrndxadd(st_currentifd(),baseiaux);
     	        ignore := st_auxadd(0);
     	        ignore := st_auxadd(-1);
     	        ignore := st_auxadd(tn^.elementSize);
     	        case tn^.arrayKind of
     	        | ARRAYOPEN:
     	       	    ignore := st_symadd(issname('_openarray',0),0,stMember,
     	       	    	      	   	scInfo,iaux);
     	       	    for i := 1 to tn^.descripCount do
     	       	        ignore := st_symadd(issname('_num_',i),i*WORDSIZE,
     	       	    	      	   	    stMember,scInfo,
     	       	    	      	   	    TypeToAux(cardinalTypeNode));
                    end;
                | ARRAYSUBARRAY:
     	       	    ignore := st_symadd(issname('_subarray',0),0,stMember,
     	       	    	      	   	scInfo,iaux);
     	       	    for i := 1 to tn^.descripCount do
     	       	        ignore := st_symadd(issname('_num_',i),
     	       	    	      	   	    (2*i-1)*WORDSIZE,stMember,scInfo,
     	       	    	      	   	    TypeToAux(cardinalTypeNode));
     	       	        ignore := st_symadd(issname('_stride_',i),
     	       	    	      	   	    (2*i)*WORDSIZE,stMember,scInfo,
     	       	    	      	   	    TypeToAux(cardinalTypeNode));
                    end;
     	        end;
     	        ignore := st_blockend(SizeOf(tn) div BYTESIZE);
            end;
$if pascal then
	| DTFILE :
	    StabCheckType(tn^.fileType);
$end
	end (* case *);
     	st_setfd(ifd);
    end;
end StabNamedType;

procedure StabQualifiers(theModule : ModuleNode; 
			 proc      : ProcNode; 
			 last      : boolean);
begin
    if (theModule = nil) or
	((theModule = globalModule) and ((proc = globalProc) or (proc = nil)))
    then
	(* do nothing *)
    elsif proc = nil then
	(* global thing, just module qualifiers *)
	StabQualifiers(theModule^.enclosing,proc,false);
	GenString(theModule^.name);
	if not last then
(*	    C(':');*)
	end;
    elsif theModule^.enclosingProc = proc then
	(* next level is a module *)
	StabQualifiers(theModule^.enclosing,proc,false);
	GenString(theModule^.name);
	if not last then
(*	    C(':');*)
	end;
    elsif proc^.enclosingModule = theModule then
	(* next level is a proc *)
	StabQualifiers(theModule,proc^.enclosing,false);
	GenString(proc^.name);
	if not last then
(*	    C(':');*)
	end;
    else
	ErrorName(theModule^.name,'Module/proc list for $ confused');
	ErrorName(proc^.name,'Module/proc list for $ confused');
    end;
end StabQualifiers;

procedure StabCheckProcRef(proc : ProcNode);
var
    local : boolean;
    tn : TypeNode;
    iaux,ignore,index,iss,ifd : integer;
begin
    if (proc = nil) or (proc^.sym_idn # NULLDN) or
       (proc^.builtin # BIPNOTBIP) then   (* ignore builtins *)
        return;
    end;
    StabCheckProcType(proc^.procType);
    ifd := st_currentifd();
    st_setfd(proc^.enclosingModule^.sym_file);
    local := (proc # globalProc) and ((proc^.extern = GSPRIVATE)
		    or proc^.internalProc);
    tn := proc^.procType^.funcType;
    if (proc = globalProc) and (proc^.globalName = nil) then
	iss := st_extstradd(MAINPROGNAME);
    else
     	if local then
     	    iss := GlobalSymName(proc^.name);
        else
     	    iss := GlobalSymName(proc^.globalName);
        end;
    end;
    iaux := st_auxadd(-1);		 (* for isymMax *)
    if (tn # nil) and genDebugInfoFlag then
        ignore := Aux_Type(tn,true,0);	 (* need real copy *)
    else
        ignore := st_auxbtadd(btNil);
    end;
(* scText will break procbegin *)
    if local then
        index := st_extadd(iss,0,stStaticProc,scNil,iaux);
    else
        index := st_extadd(iss,0,stProc,scNil,iaux);
    end;				 
    (* st_procbegin will change stStaticProc's idn to point to local *)
    proc^.sym_idn := st_idn_index_fext(index,1);
    st_setfd(ifd);
    StabCheckProcRef(proc^.enclosing);
end StabCheckProcRef;

procedure StabProc(proc : ProcNode);
var
    pn : ParamNode;
    iaux,sc,ignore,ifd : integer;
begin
    if (proc^.enclosing # nil) and (proc^.enclosing # globalProc) then
        StabProc(proc^.enclosing);
    end;
    if proc^.stabbed then 
        return;
    else
        proc^.stabbed := true;
    end;
    if proc^.sym_idn = NULLDN then
        StabCheckProcRef(proc);
    end;
    ifd := st_currentifd();
    st_setfd(proc^.enclosingModule^.sym_file);
    if proc^.procType^.paramList # nil then
	pn := proc^.procType^.paramList^.first;
	while pn # nil do
     	    StabCheckType(pn^.paramType);
     	    pn := pn^.next;
     	end;
    end;
    ignore := st_procbegin(proc^.sym_idn);
    if genDebugInfoFlag then
        if proc^.procType^.paramList # nil then
	    pn := proc^.procType^.paramList^.first;
	    while pn # nil do
	        if pn^.reference then
		    sc := scVar;
		else
		    sc := scAbs;
		end;
     	       	iaux := TypeToAux(pn^.paramType);
     	        ignore := st_symadd(SymName(pn^.name),
     	       	  pn^.paramVar^.address.offset div BYTESIZE,stParam,sc,iaux);
		pn := pn^.next;
	    end;
	end;
        if proc # globalProc then
	    StabScope(proc^.scope,proc^.name)
        elsif proc^.name = nil then		 (* add main's params *)
            ignore := st_symadd(st_stradd('argc'),0,stParam,scAbs,
     	       	    	    TypeToAux(integerTypeNode));
     	    iaux := st_auxbtadd(mapDTtoBT[DTCHAR]);
     	    addtq(iaux,tqPtr);
     	    addtq(iaux,tqPtr);
            ignore := st_symadd(st_stradd('argv'),BYTESPERWORD,stParam,scAbs,
     	       	    	      	   	  iaux);
            ignore := st_symadd(st_stradd('environ'),2*BYTESPERWORD,stParam,
     	       	    	        scAbs,iaux);
        end;
    end;
    st_setfd(ifd);
end StabProc;

procedure StabProcEntry(proc: ProcNode);
var ifd,ignore : integer;
begin
    ifd := st_currentifd();
    st_setfd(proc^.enclosingModule^.sym_file);
    ignore := st_pdadd_idn(proc^.sym_idn);
    st_setfd(ifd);
end StabProcEntry;

procedure StabProcExit(proc : ProcNode) : integer;
var ifd,idn : integer;
begin
    ifd := st_currentifd();
    if proc # globalProc then
        st_setfd(proc^.enclosingModule^.sym_file);
    end;
    idn := st_procend(proc^.sym_idn);
    st_setfd(ifd);
    return idn;
end StabProcExit;

procedure StabModuleDef(const mn : ModuleNode);
var savefd : integer;
begin
    if (mn^.enclosing = nil) or 
       ((mn^.enclosing = globalModule) and 
        ((mn^.enclosingProc = globalProc) or (mn^.enclosingProc = nil))) then
        CopyString(mn^.name,theCharArray);
        Append(theCharArray,'.def');
        savefd := st_currentifd();
        mn^.sym_idn := StartFile(theCharArray);
        mn^.sym_file := st_currentifd();
        st_setfd(savefd);
    else
     	mn^.sym_idn := symFileNumber;
        mn^.sym_file := st_currentifd();
    end;
end StabModuleDef;

procedure StabModule(theModule : ModuleNode);
var sym : Symbol;
    ifd : integer;
begin
    if theModule^.sym_idn = NULLDN then
        StabModuleDef(theModule);
    end;
    ifd := st_currentifd();
    st_setfd(theModule^.sym_file);
    sym := theModule^.scope^.symbols^.first;
    while sym # nil do
        case sym^.kind of
        | SYMVAR:
     	    if sym^.symVar^.address.kind = MEMGLOBAL then 
                if sym^.symVar^.address.gvn^.sym_idn = NULLDN then
                    sym^.symVar^.address.gvn^.sym_idn := 
     	       	        MipGlobal(sym^.symVar^.address.gvn);
     	        end;
            end;
        | SYMTYPE:
     	    StabNamedType(sym^.name,sym^.symType);
        | SYMCONST:
            if sym^.symConst^.sym_idn = NULLDN then
     	        StabConstDef(sym^.name,sym^.symConst);
            end;
        | SYMPROC:
            StabCheckProcRef(sym^.symProc);
        | SYMENUM,SYMMODULE,SYMANY:		 (* ignore *)
        else
            writef(output,"Don't know what to do with ");
     	    WriteString(output,sym^.name);
            writef(output," of type %n from ",sym^.kind);
            WriteString(output,theModule^.name);
            Writes(output,'\n');
        end;
        sym := sym^.next;
    end;
    BackStab;
    st_setfd(ifd);
end StabModule;

procedure StabConst(cn : ConstNode);
begin
    SWriteF(theCharArray,'%n const',cn^.kind);
    Error(theCharArray);
    case cn^.kind of
    | DTREAL, DTLONGREAL :
    | DTINTEGER, DTCARDINAL :
    | DTBOOLEAN :
    | DTCHAR :
    | DTSTRING :
    | DTENUMERATION :
    | DTSET :
    | DTPOINTER :
    end;
end StabConst;

procedure StabConstDef(name : String; cn : ConstNode);
var
    tn : TypeNode;
    iaux,ignore : integer;
begin
    if not genDebugInfoFlag then
        return;
    end;
    if cn^.kind = DTBOOLEAN then
        tn := booleanTypeNode;
    elsif cn^.kind = DTENUMERATION then
	tn := cn^.enumVal^.enumType;
    elsif cn^.kind = DTSET then
	tn := cn^.setVal^.setType;
    else
        tn := nil;
    end;
    if tn # nil then
	StabCheckType(tn);
        iaux := TypeToAux(tn);
    elsif cn^.kind = DTBOOLEAN then
     	assert(bool_idn # NULLDN,'bad bool idn in StabConstDef');
     	iaux := st_auxbtadd(btEnum);
     	ignore := st_auxbtsize(iaux,BOOLEANSIZE);
        ignore := st_auxrndxadd_idn(bool_idn);
    else
        iaux := auxnums[mapDTtoBT[cn^.kind]];
    end;
    cn^.sym_idn := st_idn_index_fext(
      st_symadd(SymName(name),0,stConstant,scData,iaux),0);
    GenConst(cn);
end StabConstDef;

procedure StabScope(scope : Scope; name : String);
var
    sym, esym   : Symbol;
    tn		: TypeNode;
    ignore      : integer;
    used	: boolean;
    enum	: EnumNode;
begin
    if genDebugInfoFlag then
	sym := scope^.symbols^.first;
	while sym # nil do
	    if sym^.kind = SYMVAR then
		tn := NamedType(sym^.symVar^.varType);
		StabCheckType(tn);
		case sym^.symVar^.address.kind of
		| MEMGLOBAL: halt(1);
		| MEMNORMAL:
     	            ignore := MipSymbol(sym,name);
		| MEMFAST: halt(1);
                | MEMPARAM:
     	            if adviseFlag and (not sym^.used) and (sym^.name # nil) and 
     	       	       (sym^.name^.block^.s[sym^.name^.index] # '_') then
                        Writes(output, 'Parameter ');
     	       	        WriteString(output, sym^.name);
     	       	        Writes(output, ' not used in procedure ');
     	       	        WriteString(output, name);
     	       	        Writes(output, '\n');
     	       	    end;
		end;
	    elsif sym^.kind = SYMTYPE then
		if adviseFlag and (not sym^.used) and (sym^.name # nil) then
		    used := false;
		    tn := BaseType(sym^.symType);
		    if tn^.kind = DTENUMERATION then
			enum := tn^.enumList^.first;
			(* Look for a used enumeration constant *)
			while enum # nil do
			    esym := LookUpSymbol(enum^.enumSym^.name, scope);
			    if (esym # nil) and esym^.used then
				used := true;
				exit while;
			    end;
			    enum := enum^.next;
			end;
		    end;
		    if not used then
			WriteS(output, 'Type ');
			WriteString(output, sym^.name);
			Writes(output, ' not used in ');
			WriteString(output, name);
			Writes(output, '\n');
		    end;
		end;
		StabNamedType(sym^.name,sym^.symType);
	    elsif sym^.kind = SYMCONST then
		if adviseFlag and (not sym^.used) and (sym^.name # nil) then
		    WriteS(output, 'Constant ');
		    WriteString(output, sym^.name);
		    Writes(output, ' not used in ');
		    WriteString(output, name);
		    Writes(output, '\n');
		end;
		StabConstDef(sym^.name,sym^.symConst);
	    end;
	    sym := sym^.next;
	end;
    end;
end StabScope;

procedure StabGlobalPort;

procedure NewTypeNumber (): TypeNumber;
begin
    generateTypeNumber := generateTypeNumber + 1;
    return generateTypeNumber;
end NewTypeNumber;

procedure @inline StabEndLine;
begin
    EndLine;
    stabTokenCount := 0;
end StabEndLine;

procedure @inline StabComma;
begin
    C(',');
end StabComma;

procedure @inline StabSemicolon;
begin
    C(';');
end StabSemicolon;

procedure StartTypeDef;
begin
    GenOp(PCSYM); C('t'); StabComma; C('"');
end StartTypeDef;

procedure EndTypeDef;
begin
    C('"'); StabComma; I(STABSYMBOL); StabComma; I(0);
	StabComma; I(0); StabComma; I(0); StabEndLine;
end EndTypeDef;

procedure StabCommaX;
begin
    C(',');
    stabTokenCount := stabTokenCount + 1;
    if inTypeDef and (stabTokenCount > STABTOKENSPERLINE) then
	C('?');
	EndTypeDef;
	StartTypeDef;
    end;
end StabCommaX;

procedure StabSemicolonX;
begin
    StabSemicolon;
    stabTokenCount := stabTokenCount + 1;
    if inTypeDef and (stabTokenCount > STABTOKENSPERLINE) then
	C('?');
	EndTypeDef;
	StartTypeDef;
    end;
end StabSemicolonX;

procedure StabCheckFieldList(fl : FieldList);
var
    fn : FieldNode;
    vn : VariantNode;
begin
    fn := fl^.first;
    while fn # nil do
	StabCheckType(fn^.fieldType);
	if fn^.kind = FIELDTAG then
	    vn := fn^.variantList^.first;
	    while vn # nil do
		StabCheckFieldList(vn^.fieldList);
		vn := vn^.next;
	    end;
	end;
	fn := fn^.next;
    end;
end StabCheckFieldList;

procedure StabFieldList(fl : FieldList);
var
    fn : FieldNode;
    vn : VariantNode;
begin
    fn := fl^.first;
    while fn # nil do
	if fn^.name # nil then
	    GenString(fn^.name);
	    C(':');
	    StabTypeNumber(fn^.fieldType);
	    StabComma;
	    I(fn^.offset);
	    StabComma;
	    I(SizeOf(fn^.fieldType));
	    StabSemicolonX;
	end;
	if fn^.kind = FIELDTAG then
	    vn := fn^.variantList^.first;
	    while vn # nil do
		StabFieldList(vn^.fieldList);
		vn := vn^.next;
	    end;
	end;
	fn := fn^.next;
    end;
end StabFieldList;

procedure StabProcType(tn : TypeNode);
var
    param : ParamNode;
    ptn : TypeNode;
begin
    if tn^.funcType # nil then
	StabTypeNumber(tn^.funcType); StabComma;
    end;
    I(tn^.numParams); StabSemicolon;
    if tn^.paramList # nil then
	param := tn^.paramList^.first;
	while param # nil do
	    if param^.name # nil then
		GenString(param^.name); C(':');
	    end;
	    ptn := param^.paramType;
	    StabTypeNumber(ptn);
	    StabComma;
	    I(ord(param^.kind)); StabSemicolon;
	    param := param^.next;
	end;
    end;
    StabSemicolon;
end StabProcType;

procedure StabTypeDef(tn : TypeNode);
var
    enum : EnumNode;
    atn : TypeNode;
    i : integer;
begin
    tn := NamedType(tn);
    if tn^.opaqueName # nil then
	C('o');
	GenString(tn^.opaqueName);
	if tn^.kind # DTOPAQUE then
	    StabComma;
	end;
    elsif tn^.theModule # nil then
	(* indirect type name *)
	C('i');
	GenString(tn^.theModule^.name);
	C(':');
	GenString(tn^.name);
	StabComma;
    end;
    case tn^.kind of
    | DTINTEGER     : I(INTEGERNUMBER);
    | DTCHAR	    : I(CHARNUMBER);
    | DTBOOLEAN     : I(BOOLEANNUMBER);
    | DTLONGREAL    : I(LONGREALNUMBER);
    | DTRENAME      : (* watch for size and alignment *)
	if tn^.renameType # nil then
	    if (tn^.size # SIZEUNSPECIFIED) and 
               (tn^.size # tn^.renameType^.size)
	    then
		C('@'); C('s'); I(tn^.size);
		StabSemicolon;
	    end;
	    if (tn^.alignment # ALIGNMENTUNSPECIFIED) and
		(tn^.alignment # tn^.renameType^.alignment)
	    then
		C('@'); C('a'); I(tn^.alignment);
		StabSemicolon;
	    end;
	end;
	StabTypeNumber(tn^.renameType);

$if modula2 then
    | DTCARDINAL    : I(CARDINALNUMBER);
    | DTREAL	    : I(REALNUMBER);
    | DTWORD	    : I(WORDNUMBER);
    | DTBYTE	    : I(BYTENUMBER);
    | DTOPAQUE      : (* handled above *)
    | DTDYNARRAY    :
	atn := tn^.dynArrayType;
	i := 0;
	while (atn^.kind = DTARRAY) and
		(atn^.arrayKind in ArrayKindSet{ARRAYOPEN,ARRAYNOCOUNT}) do
	    i := i + 1;
	    atn := atn^.elementType;
	end;
	if tn^.dynArrayKind # PTRMODULA then
	    C('@'); C('p'); I(ord(tn^.dynArrayKind));
	    StabSemicolon;
	end;
	(* ||| Needs elementSize modifications, else dbx will lie about contents
	   if you index into the array *)
	C('D'); I(i); StabComma; StabTypeNumber(atn);
	    StabSemicolon;

$else (* pascal *)
    | DTFILE :
	C('@'); C('p'); I(ord(PTRPASCAL));
	    StabSemicolon;
	C('*');
	StabTypeNumber(tn^.fileType);
$end

    | DTPOINTER :
	if tn^.ptrKind # PTRMODULA then
	    C('@'); C('p'); I(ord(tn^.ptrKind)); StabSemicolon;
	end;
	C('*');
	StabTypeNumber(tn^.toType);
    
    | DTPROC :
	if tn^.funcType = nil then
	    C('p');
	else
	    C('f');
	end;
	StabProcType(tn);
    
    | DTSET :
	C('S');
	StabTypeNumber(tn^.setRange);
    
    | DTSUBRANGE :
	C('r');
	StabTypeNumber(tn^.baseType);
	StabSemicolon;
	I(trunc(tn^.subMinOrd));
	StabSemicolon;
	I(trunc(tn^.subMaxOrd));
    
    | DTRECORD :
	C('s');
	I(SizeOf(tn) div BYTESIZE);
	StabComma;
	I(AlignmentOf(tn));
	StabComma;
	StabFieldList(tn^.fieldList);
	StabSemicolon;
    
    | DTARRAY :
	if tn^.arrayKind = ARRAYNORMAL then
	    C('a');
	    StabTypeNumber(tn^.indexType);
	    StabSemicolon;
	    StabTypeNumber(tn^.elementType);
	    (* ||| Need elementSize modifications *)
	else
	    atn := tn;
	    i := 0;
	    while (atn^.kind = DTARRAY) and (atn^.arrayKind # ARRAYNORMAL) do
		atn := atn^.elementType;
		i := i + 1;
	    end;
	    if tn^.arrayKind = ARRAYSUBARRAY then
		C('E');
	    else
		C('O');
	    end;
	    I(i); StabComma; StabTypeNumber(atn); StabSemicolon;
	    (* ||| Need elementSize modifications *)
	end;

    | DTENUMERATION :
	C('e');
	enum := tn^.enumList^.first;
	while enum # nil do
	    GenString(enum^.name);
	    C(':');
	    I(enum^.enumOrd);
	    StabCommaX;
	    enum := enum^.next;
	end;
	StabSemicolon;

    end (* case *);
    if tn^.theModule # nil then
	StabSemicolon;
    elsif tn^.opaqueName # nil then
	StabSemicolon;
    end;
end StabTypeDef;


procedure StabCheckProcType(tn : TypeNode);
var
    pn : ParamNode;
begin
    StabCheckType(tn^.funcType);
    if tn^.paramList # nil then
	pn := tn^.paramList^.first;
	while pn # nil do
	    StabCheckType(pn^.paramType);
	    pn := pn^.next;
	end;
    end;
end StabCheckProcType;

(* try to make sure dependent types are output before this one is *)
procedure StabNamedType(name : String; tn : TypeNode);
var
begin
    tn := NamedType(tn);
    if name = nil then
	name := tn^.name;
    end;
    if tn^.number = 0 then
        tn^.number := NewTypeNumber();
	case tn^.kind of
	| DTINTEGER, DTCHAR, DTBOOLEAN, DTREAL, DTLONGREAL,
	  DTCARDINAL, DTSTRING, DTANY, DTWORD, DTBYTE :
	    (* these are already defined *)
	| DTOPAQUE, DTENUMERATION :
	    (* nothing to do *)
	| DTRENAME :
	    StabCheckType(tn^.renameType);	
	| DTPOINTER :
	    StabCheckType(tn^.toType);
	| DTPROC :
	    StabCheckProcType(tn);
	| DTSET :
	    StabCheckType(tn^.setRange);
	| DTSUBRANGE :
	    StabCheckType(tn^.baseType);
	| DTRECORD :
	    StabCheckFieldList(tn^.fieldList);
	| DTDYNARRAY :
	    StabCheckType(tn^.dynArrayType);
	| DTARRAY :
	    if tn^.indexType # nil then
		StabCheckType(tn^.indexType);
	    end;
	    (* ||| Need elementSize modifications *)
	    StabCheckType(tn^.elementType);
$if pascal then
	| DTFILE :
	    StabCheckType(tn^.fileType);
$end
	end (* case *);
	StartTypeDef;
	    GenString(name); C(':'); C('t');
	    I(tn^.number);
	    C('=');
	    inTypeDef := true;
	    StabTypeDef(tn);
	    inTypeDef := false;
	EndTypeDef;
    end;
end StabNamedType;

procedure StabTypeNumber(tn : TypeNode);
begin
    tn := NamedType(tn);
    if tn = nil then
	I(0);
    elsif tn^.number # 0 then
	I(tn^.number);
    else
	tn^.number := NewTypeNumber();
	I(tn^.number);
	C('=');
	StabTypeDef(tn);
    end;
end StabTypeNumber;

procedure StabCheckType(tn : TypeNode);
begin
    if tn = nil then
	(* do nothing *)
    elsif tn^.number = 0 then
	StabNamedType(tn^.name,tn);
    elsif tn^.kind = DTRENAME then
	StabCheckType(tn^.renameType);
    end;
end StabCheckType;
procedure StabQualifiers(theModule : ModuleNode; 
			 proc      : ProcNode; 
			 last      : boolean);
begin
    if (theModule = nil) or
	((theModule = globalModule) and ((proc = globalProc) or (proc = nil)))
    then
	(* do nothing *)
    elsif proc = nil then
	(* global thing, just module qualifiers *)
	StabQualifiers(theModule^.enclosing,proc,false);
	GenString(theModule^.name);
	if not last then
	    C(':');
	end;
    elsif theModule^.enclosingProc = proc then
	(* next level is a module *)
	StabQualifiers(theModule^.enclosing,proc,false);
	GenString(theModule^.name);
	if not last then
	    C(':');
	end;
    elsif proc^.enclosingModule = theModule then
	(* next level is a proc *)
	StabQualifiers(theModule,proc^.enclosing,false);
	GenString(proc^.name);
	if not last then
	    C(':');
	end;
    else
	ErrorName(theModule^.name,'Module/proc list for $ confused');
	ErrorName(proc^.name,'Module/proc list for $ confused');
    end;
end StabQualifiers;

procedure StabConst(cn : ConstNode);
begin
    C('c'); C('=');
    case cn^.kind of
    | DTREAL, DTLONGREAL :
	C('r');
	GenReal(cn^.realVal);

    | DTINTEGER, DTCARDINAL :
	C('i');
        if cn^.cardVal > MAXINT then
	    I(trunc(cn^.cardVal-MAXINT-1.0)+trunc(MAXINT)+1);
        else
	    I(trunc(cn^.cardVal));
        end;

    | DTBOOLEAN :
	C('b');
	I(ord(cn^.boolVal));

    | DTCHAR :
	C('c');
	I(ord(cn^.charVal));

    | DTSTRING :
	C('s');
	C('''');
        GenString(cn^.strVal);
	C('''');

    | DTENUMERATION :
	C('e');
	StabTypeNumber(cn^.enumVal^.enumType); StabComma;
	I(cn^.enumVal^.enumOrd);

    | DTSET :
	C('S');
	StabTypeNumber(cn^.setVal^.setType); StabComma;
	GenSet(cn^.setVal);

    | DTPOINTER :
	C('i');     (* Can only be nil right now *)
	I(0);
    end;
    StabSemicolon;
end StabConst;

procedure StabConstDef(name : String; cn : ConstNode);
var
    tn : TypeNode;
begin
    if cn^.kind = DTENUMERATION then
	tn := cn^.enumVal^.enumType;
	StabCheckType(tn);
    elsif cn^.kind = DTSET then
	tn := cn^.setVal^.setType;
	StabCheckType(tn);
    end;
    StartTypeDef;
    GenString(name); C(':');
    StabConst(cn);
    EndTypeDef;
end StabConstDef;

var
    pn : PortNode;
    tn : TypeNode;
    cn : ConstNode;
    proc : ProcNode;
begin
    GenOp(PCSYM); C('X'); StabComma; C('"');
	GenString(compileModuleName); C(':'); C('X'); I(0); I(0); I(0);
	C('m'); C('"'); StabComma; I(STABNMOD2); StabComma; I(0); StabComma;
	I(0); StabComma; I(0);
    StabEndLine;
    pn := globalPortList^.first;
    while pn # nil do
	if pn^.sym^.kind = SYMVAR then
	    tn := pn^.sym^.symVar^.varType;
	    StabCheckType(tn);
	    GenOp(PCSYM); C('X'); StabComma; C('"');
		GenString(pn^.theModule^.name); C('.');
		GenString(pn^.sym^.name); C(':'); C('X');
		I(ord(pn^.isQualified));
		I(ord(pn^.isExport));
		I(ord(pn^.extern));
		C('v'); StabTypeNumber(tn); C('"'); StabComma;
		I(STABNMOD2); StabComma; I(0); StabComma;
		I(0); StabComma; I(0);
	    StabEndLine;
	elsif pn^.sym^.kind = SYMPROC then
	    proc := pn^.sym^.symProc;
	    tn := proc^.procType;
	    StabCheckProcType(tn);
	    GenOp(PCSYM); C('X'); StabComma; C('"');
		GenString(pn^.theModule^.name); C('.');
		GenString(pn^.sym^.name); C(':'); C('X');
		I(ord(pn^.isQualified));
		I(ord(pn^.isExport));
		I(ord(pn^.extern));
		if tn^.funcType = nil then
		    C('p');
		else
		    C('f');
		end;
		if proc^.inlineProc then
		    I(proc^.time); StabComma;
		else
		    I(0); StabComma;
		end;
		StabProcType(tn); C('"'); StabComma;
		I(STABNMOD2); StabComma; I(0); StabComma;
		I(0); StabComma; I(0);
	    StabEndLine;
	elsif pn^.sym^.kind = SYMTYPE then
	    tn := pn^.sym^.symType;
	    StabCheckType(tn);
	    GenOp(PCSYM); C('X'); StabComma; C('"');
		GenString(pn^.theModule^.name); C('.');
		GenString(pn^.sym^.name); C(':'); C('X');
		I(ord(pn^.isQualified));
		I(ord(pn^.isExport));
		I(ord(pn^.extern));
		C('t'); StabTypeNumber(tn); C('"'); StabComma;
		I(STABNMOD2); StabComma; I(0); StabComma;
		I(0); StabComma; I(0);
	    StabEndLine;
	elsif pn^.sym^.kind = SYMCONST then
	    cn := pn^.sym^.symConst;
	    if cn^.kind = DTENUMERATION then
		tn := cn^.enumVal^.enumType;
		StabCheckType(tn);
	    elsif cn^.kind = DTSET then
		tn := cn^.setVal^.setType;
		StabCheckType(tn);
	    end;
	    GenOp(PCSYM); C('X'); StabComma; C('"');
		GenString(pn^.theModule^.name); C('.');
		GenString(pn^.sym^.name); C(':'); C('X');
		I(ord(pn^.isQualified));
		I(ord(pn^.isExport));
		I(ord(pn^.extern));
		StabConst(cn);
		C('"'); StabComma;
		I(STABNMOD2); StabComma; I(0); StabComma;
		I(0); StabComma; I(0);
	    StabEndLine;
	end;
	pn := pn^.next;
    end;
    GenOp(PCSYM); C('X'); StabComma; C('"');
	GenString(compileModuleName); C(':'); C('X');
	I(0); I(0); I(0);
	C('z'); C('"'); StabComma;
	I(STABNMOD2); StabComma; I(0); StabComma;
	I(0); StabComma; I(0);
    StabEndLine;
end StabGlobalPort;

procedure StabLine(fileName:String; lineNumber : integer);
begin
    if genDebugInfoFlag then
	if fileName # stabFileName then
	    (* stab file name *)
	    stabLineNumber := -1;
	end;
	if lineNumber # stabLineNumber then
(*	    GenOp(PCSYM); C('l'); StabComma; I(STABLINE); StabComma; I(0);
	    StabComma;
	    I(lineNumber);
	    StabEndLine;*)
	    stabLineNumber := lineNumber;
	end;
    end;
end StabLine;

procedure MipGlobal(const gvn : GlobalVarNode) : integer;
var
    sc,iaux,indx,iss : integer;
    local : boolean;
    tn : TypeNode;
begin
    indx := NULLDN;
    tn := NamedType(gvn^.varType);
    local := gvn^.value # nil;
    if local then
	iss := SymName(gvn^.globalName);
        sc := scData;
    else 
	iss := GlobalSymName(gvn^.globalName);
	if gvn^.defineMemory and (gvn^.extern # GSEXTERNAL) then
     	    sc := scBss;
        else 
     	    sc := scUndefined; 
        end;
    end;
    StabNamedType(tn^.name,tn);
    iaux := TypeToAux(tn);
    if local then
        indx := st_idn_index_fext(st_symadd(iss,0,stStatic,sc,iaux),0);
    elsif gvn^.used or gvn^.defineMemory then
        indx := st_idn_index_fext(st_extadd(iss,0,stGlobal,sc,iaux),1);
    end;
    return indx;
end MipGlobal;

procedure MipSymbol(const sym : Symbol; const scopeName : String) : integer;
var
    iaux,indx : integer;
    tn : TypeNode;
begin
    indx := NULLDN;
    case sym^.kind of
    | SYMVAR: 
        with sym^.symVar^ do
            tn := NamedType(varType);
    	    StabNamedType(tn^.name,tn);
     	    case address.kind of
     	    | MEMNORMAL:			 (* procedure local *)
     	        iaux := TypeToAux(tn);
     	        indx := st_symadd(SymName(sym^.name),
     	       	    	      -(address.offset+address.size) div BYTESIZE,
     	       	    	      stLocal,scAbs,iaux);
     	        if adviseFlag and (not sym^.used) then
                    Writes(output,'Local variable ');
     	       	    WriteString(output,sym^.name);
     	       	    Writes(output,' not used in procedure ');
     	       	    WriteString(output,scopeName);
     	       	    Writes(output,'\n');
                end;
            end;
        end;
    else
        SWriteF(theCharArray,'MipSymbol:%n',sym^.kind);
        Error(theCharArray);
    end;
    return indx;
end MipSymbol;

begin
     assert(true,'@(#)$Header: SymbolDumpUC.mod,v 1.6 90/05/23 00:29:37 lattanzi Locked $');
     for index := Low(bt_idn) to High(bt_idn) do
     	  bt_idn[index] := NULLDN;
     end;
     for dt := First(DataType) to Last(DataType) do
     	  mapDTtoBT[dt] := btNil;
     end;
     mapDTtoBT[DTCARDINAL] := btUInt;
     mapDTtoBT[DTINTEGER]  := btInt;
     mapDTtoBT[DTREAL]     := btFloat;
     mapDTtoBT[DTLONGREAL] := btDouble;
     mapDTtoBT[DTCHAR]     := btChar;	 (* default dbx will break with 
     	       	    	      	   	    btUChar*)
     mapDTtoBT[DTSUBRANGE] := btRange;
     mapDTtoBT[DTWORD]     := btUInt;
     mapDTtoBT[DTBYTE]     := btChar;	 (* see above *)
     mapDTtoBT[DTSET]      := btSet;
     mapDTtoBT[DTBOOLEAN]  := btEnum;
     mapDTtoBT[DTENUMERATION] := btEnum;
     mapDTtoBT[DTRECORD]   := btStruct;
     mapDTtoBT[DTOPAQUE]   := btAdr;
     mapDTtoBT[DTDYNARRAY] := btStruct;
     forwardList := nil;
     bool_idn := NULLDN;
     freeList := nil;
end SymbolDump.
