








                         A Terse Description of P-code


                               Michael L. Powell






          _1.  _T_h_e _B_a_s_i_c _I_d_e_a

          P-code appears to be machine instructions for a  stack  com-
          puter.   It  is  not  executed  as  such,  however,  but  is
          translated into machine instructions for your favorite  com-
          puter.   Thus,  you  will find in P-code some information to
          aid that translation, which would not be  necessary  if  the
          instructions were simply to be executed.  The "P-code trans-
          lator", as it is called, is expected to do a certain  amount
          of  peephole  optimization,  especially  constant folding in
          address  calculation.   Thus,  although  some  higher  level
          optimization  may be done, the P-code generated by the front
          end will not be optimal.

          There are four classes of P-code  instructions:  those  that
          move values between the stack and memory, those that operate
          on values on the stack, those that control the flow of  exe-
          cution,  and  pseudo-instructions for storage allocation and
          other functions.  The  stack  will  be  empty  at  procedure
          entry,  at  labels, and between statements.  Several mechan-
          isms exist for storing values that  must  span  these  boun-
          daries.

          This dialect of P-code is only loosely affiliated with other
          dialects that exist.  No compatibility is claimed.

          This document will discuss, in order, the general format  of
          P-code  instructions and P-code programs, the use and layout
          of memory, and the  function  of  individual  operations  by
          class.

          _2.  _P-_c_o_d_e _p_r_o_g_r_a_m_s

          The first statement of a P-code program  is  a  _b_g_n  opcode.
          After the bgn comes the _c_o_m instructions that declare global
          static storage.  Then there are  one  or  more  P-code  pro-
          cedures.  The last statement is an _e_n_d opcode.  In addition,
          _s_y_m instructions, which provide symbol table information for
          the   debugger  and  the  intermodule  checker,  may  appear
          throughout the program.  Note: If DBX debugging  information
          is  generated (-g option), the bgn will be preceded by a _s_y_m


                                  July 4, 1992






                                     - 2 -


          and a _l_a_b.

          A P-code procedure starts with an _e_n_t opcode and  ends  with
          an  _e_x_i opcode.  There must also be a _d_e_f opcode between the
          _e_n_t and the _e_x_i.  All executable statements must  be  inside
          some P-code procedure.

          P-code instructions have a fixed format, which allows faster
          parsing.   There is one P-code instruction per line.  A line
          starting with a # is a comment.  In the following, a _g_a_p  is
          a  sequence  of  one  or more tab or space characters.  If a
          line does not start with a gap, the  characters  up  to  the
          first  gap is a label.  Labels, which can occur only on _b_g_n,
          _l_a_b, and _e_n_t opcodes, can  contains  letters,  digits  or  _
          characters.   Following the first gap is the three character
          P-code opcode.  If there are operands  on  the  instruction,
          there is another gap after the P-code opcode followed by the
          list of operands separated by commas.  There  should  be  no
          gaps between the operands.

                  # P-code instruction with label
                  l10001   ent     P,0,2,102,1,5,100,-1
                  #        blank lines are not allowed
                  # P-code instruction without label
                           lod     i,32,0,t,0,102


          P-code labels and operands may be quite  long  (the  current
          VAX  translator  allows up to 5,000 characters per operand).
          Labels must  be  long  enough  to  handle  qualified  names;
          operands  must  be long enough to handle set and string con-
          stants and symbol table information.  There is a small  max-
          imum  number of operands (currently 8).  A particular opcode
          usually, but not always, has the same number of operands.

          Operands may be characters, words, numbers,  etc.   Operands
          may   contain  any  printable  character  except  comma  and
          linefeed.  String operands are  quoted  with  double  quotes
          (");  within a string, a backslash (\) must precede a double
          quote or backslash.  Non-printing  characters  (outside  the
          range  of  space  (40  octal)  to  tilde (176 octal)) may be
          represented by a backslash followed by three  octal  digits,
          e.g., linefeed is "\012".

          If you have the DECWRL Modula-2 compiler, you can generate a
          set of P-code for a program by compiling with the -P option.

          _3.  _P-_c_o_d_e _m_e_m_o_r_y

          There are several kinds of memory visible at  the  level  of
          P-code  instructions.   These  include the stack, stack save
          registers, global variables,  and  local  (procedure)  vari-
          ables.   The  P-code  translator  may  use additional memory
          locations to implement various facilities, for example,  the


                                  July 4, 1992






                                     - 3 -


          display.   However,  since they are implementation dependent
          and not visible to the P-code program, they will not be dis-
          cussed here.

          _3._1.  _T_h_e _S_t_a_c_k

          The stack is used for evaluating expressions.  For  example,
          the P-code instructions to compute the statement

                  a := b + c

          would be something like

                  load b
                  load c
                  add
                  store a


          Procedure arguments are also loaded  onto  the  stack.   The
          stack is in theory infinite but in practice 20 elements have
          been sufficient.  Values to be operated on are always loaded
          onto  the stack first.  A P-code operation pops its operands
          off the stack and pushes its result  onto  it.   The  result
          should then be stored in memory, removing it from the stack.

          Stack values are usually mapped into registers by the P-code
          translator.   Since  the P-code translator runs in one pass,
          there are some P-code programs  that  are  impractical.   In
          general,  values  should not be left on the stack (or in the
          stack save registers) across branches and labels.  In  fact,
          for  most  languages, the stack will be empty between state-
          ments.

          There are no real limits to how  large  an  element  may  be
          loaded onto the stack.  The semantics of most languages res-
          trict the size of most  values  to  a  word  or  two.   Some
          languages  permit  larger  values,  for example, set expres-
          sions, and these must be handled as well.

          _3._2.  _S_t_a_c_k _s_a_v_e _r_e_g_i_s_t_e_r_s

          There are about a dozen "registers" in the  P-code  machine.
          These  registers  are used to save values that are used more
          than once in an expression or  to  provide  storage  with  a
          non-stack  discipline  during  expression  evaluation.   For
          example, to evaluate a  conditional  expression,  one  might
          save a value in the same stack save register in the then and
          else parts, and use the register as the result.

          The stack registers are designed to be just like  the  stack
          elements,  and are not simply a word of storage.  Values are
          moved or copied between the stack  and  the  save  registers
          using  the  _s_a_v  and _u_s_e P-code instructions.  The registers


                                  July 4, 1992






                                     - 4 -


          are identified by small integers.

          _3._3.  _G_l_o_b_a_l _a_n_d _l_o_c_a_l _v_a_r_i_a_b_l_e_s

          Global variables are statically allocated and accessible  in
          separately  compiled  modules.   Storage is defined with the
          _c_o_m P-code instruction, which specifies  the  name  and  the
          size of the storage and establishes a local index to be used
          for references to the variable.

          Local variables are allocated on  entry  to  the  procedure,
          usually  on  a  runtime  stack.  Local variables do not have
          individual identities, but are grouped by memory class  into
          an  activation  record, and referenced by offset relative to
          the start of the particular memory  class.   The  amount  of
          storage of each class is specified on the _d_e_f instruction.

          Local variables  may  be  accessed  by  the  procedure  that
          defines  them  or by nested procedures that are called while
          the procedure is active.  A display or static links must  be
          maintained to allow uplevel accesses.

          There are three instructions that refer to global variables:

          ldo   T,S,M,O,N   Load variable onto stack
          sro   T,S,M,O,N   Store top of stack into variable
          lao   S,M,O,N     Load address of variable onto stack


          There are four instructions that refer to local variables:

          lod   T,S,D,M,O,N   Load variable onto stack
          str   T,S,D,M,O,N   Store top of stack into variable
          stn   T,S,D,M,O,N   Copy top of stack into variable
          lda   S,D,M,O,N     Load address of variable onto stack


          The last three operands of each memory reference instruction
          is  an  address triple.  The first operand (M) of the triple
          is a letter indicating the memory class; the second (O),  an
          integer bit offset into that class of memory; the third (N),
          a block number.  For global variables, the memory  class  is
          always  _c, the offset is from the beginning of the variable,
          and the block number is the number on  the  _c_o_m  instruction
          defining  the  variable.   For  local  variables, the memory
          class may be _p, _m, _b, or _t, the offset is from the beginning
          of  that memory class, and the block number is the number on
          the _e_n_t instruction of the procedure  containing  the  vari-
          able.

          Memory classes allow the P-code  translator  to  distinguish





                                  July 4, 1992






                                     - 5 -


          variables according to important characteristics.

          Class   Usage
            c     Global/static variables
            p     Parameter list memory
            m     General local memory
            t     Faster local memory
            b     Faster local memory for addresses


          Memory class b is like t and is  useful  for  machines  with
          address  registers.  Offsets in p memory are relative to the
          start of the parameter list.  Usually, t memory is placed so
          that  it  has shorter offsets from the frame pointer than m.
          The front end will allocate loop indices and  other  single-
          word  variables  to  t  memory  in  the  hope that it can be
          accessed faster than m memory.  It is also possible for some
          of t memory to be allocated to registers.

          The display level (D) in the local variable instructions  is
          the  display  level  relative  to the current procedure (0 =
          local, 1 = enclosing procedure, etc.).

          The first two operands of the load  and  store  instructions
          are  the data type (T) and size (S) in bits of the variable.
          The load address instruction specifies the size but not  the
          type  of  the  area  addressed.   The following are the data
          types specified in these and other instructions.

          Type   Data type
           a     address
           b     boolean
           c     character
           i     signed integer
           j     unsigned integer
           k     positive integer
           p     procedure value
           q     untyped
           r     real
           R     double word real
           s     character string
           S     set


          Since both the sizes and the offsets of variables are speci-
          fied  in  bits, it is possible for the front end to directly
          refer to packed fields of records, etc.  A particular P-code
          translator  implementation  will  place  restrictions on the
          size and alignment requirements of variables and  addresses.
          For  example,  although  address  constants  and offsets are
          specified in bits, a particular implementation  may  require
          them to be multiples of bytes.




                                  July 4, 1992






                                     - 6 -


          _4.  _P-_c_o_d_e _i_n_s_t_r_u_c_t_i_o_n_s

          In this section, we give a brief description of  the  P-code
          instructions.   The  following  is  an  example  instruction
          description:

          pcd O1,O2           T1,T2
               S0 := f(Si).

          In the example, pcd is the P-code opcode; O1, O2 are the
          operands on the P-code instruction; T1, T2 are the types of
          values the instruction works on.  Except as noted, the same
          conventions are used as in the preceding section.  In the
          description of the operation, S0 means the top of the stack,
          S1 means the next to top of the stack, etc.  The assignment

                  S0 := f(Si)

          means the stack elements Si referenced in f are popped off
          the stack and resulting value placed on the top of the
          stack.  If no assignment is made to S0, then no new value is
          pushed on the stack.  The expression [x] means the memory
          location addressed by x.  Note: An opcode that works for
          data type _i also works for data types _j and _k.  An opcode
          that works for data type _r also works for data type _R.

          _4._1.  _M_e_m_o_r_y _r_e_f_e_r_e_n_c_e _o_p_e_r_a_t_i_o_n_s

          The following instructions move values between the stack and
          memory:

          ind T,S             all
               S0 := [S0].

          lao S,M,O,N         all
               S0 := address of static variable specified by M,O,N.

          lda S,D,M,O,N       all
               S0 := address of procedure variable specified by
               D,M,O,N.

          ldo T,S,M,O,N       all
               S0 := value of static variable specified by M,O,N.

          lod T,S,D,M,O,N     all
               S0 := value of procedure variable specified by D,M,O,N.

          sro T,S,M,O,N       all
               Static variable specified by M,O,N := S0.

          stn T,S,D,M,O,N     all
               Local variable specified by D,M,O,N := S0, leave S0 on
               stack.



                                  July 4, 1992






                                     - 7 -


          sto T,S             all
               [S0] := S1, pop both S0 and S1.

          str T,S,D,M,O,N     all
               Local variable specified by D,M,O,N := S0.

          _4._2.  _S_t_a_c_k _o_p_e_r_a_t_i_o_n_s

          The following instructions manipulate values on the stack:

          adr
               This instruction is a cheap hack to allow functions to
               return arrays and records which can then be indexed or
               selected.  It indicates that the value on top of the
               stack should be considered to be the address of a data
               structure.

          abs T               i,r
               S0 := absolute value of S0.

          add T,S             a,c,i,r
               S0 := S0 + S1.

          ad2 T,S             a,c,i,r
               [S1] := [S1] + S0

          and T,S             b
               S0 := S0 boolean and S1.

          bit X               i
               X is a letter specifying the bitwise function to be
               performed.

               X   S0 :=
               a   S0 bitwise and S1
               o   S0 bitwise or S1
               n   bitwise complement S0
               x   S0 bitwise exclusive or S1
               l   S1 shifted left logically S0 bits
               r   S1 shifted right logically S0 bits
               e   extract S0 bits of S2 starting at S1
               i   insert S3 into S0 starting at S2 for S1 bits


          cap                 c
               S0 := capitalize S0; if S0 is a lower case letter, make
               it upper case.

          chr                 i
               S0 := character type S0; convert type from integer to
               character.





                                  July 4, 1992






                                     - 8 -


          dec T,V             i,a
               S0 := S0 - V; V is in bits for addresses.

          dif T,S             S
               S0 := S1 set subtract S0.

          div T,S             i,r
               S0 := S1 / S0.

          dv2 T,S             i,r
               [S1] := [S1] / S0.

          equ T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 = S0.

          flt T               r,R
               S0 := convert to float S0; if T is r, flt converts
               longreal or integer to real; if T is R, flt converts
               real or integer to longreal.

          geq T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 >= S0.

          grt T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 > S0.

          inc T,V             i,a
               S0 := S0 + V; V is in bits for addresses.

          inn T,S             S
               S0 := boolean result of S0 in set S1.

          int T,S             S
               S0 := S1 set intersection S0;

          ior T,S             b
               S0 := S1 boolean or S0.

          lca T,S,value       a,b,c,i,p,r,s,S
               S0 := address of constant specified by T,S,value.

               T   Kind        Value
               a   address     integer; in bits
               b   boolean     integer; 1=true, 0=false
               c   char        "x"
               i   integer     integer value
               j   cardinal    cardinal value
               n   address     omitted, nil pointer
               p   procedure   procedure name
               r   real        real value
               R   longreal    longreal value
               s   string      "xxx"; null padded to size
               S   set         n,bbbb; n=number of b's, b=0/1



                                  July 4, 1992






                                     - 9 -


          ldc T,S,value       a,b,c,i,p,r,s,S
               S0 := value of constant specified by T,S,value.  See
               lca for constant types and values.

          leq T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 <= S0.

          les T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 < S0.

          max T               i,r
               S0 := maximum of S1 and S0

          min T               i,r
               S0 := minimum of S1 and S0

          mod T,S             i
               S0 := S1 mod S0 (mod is modulus, not remainder).

          mp2 T,S             a,i,r
               [S1] := [S1] * S0.

          mup T,S             a,i,r
               S0 := S1 * S0.

          neg T,S             a,i,r
               S0 := - S0;

          neq T,S             a,b,c,i,q,r,s,S
               S0 := boolean result of S1 <> S0.

          not T,S             b
               S0 := boolean not S0.

          odd                 i
               S0 := boolean result of S0 mod 2 = 1.

          ord T,S             a,b,c,i
               S0 := integer type S0; change type to integer.

          rnd T
               SO := round(S0); round real or longreal to integer.

          sav N,X             all
               Save S0 in stack register N.  If X = c, the value is
               also left on the stack; otherwise, it is discarded.

               X                                                                                  Operation
               c                                                                                  N is not in use, copy S0 into it.  This does not require that any data
                                                                                                  actually move; if S0 is simple enough, you can copy a description
                       of S0 into N.  For example, the VAX doesn't copy S0 if it is a constant,
                                                                                                  or if S0 is stored in a register.
               d                                                                                  N is irrelevant.  Discard S0.  Use to pop the top element of the stack
               m                                                                                  N is not in use, move S0 into it


                                  July 4, 1992






                                     - 10 -


               r                                                                                  N is in use, store value of S0 into it
               t                                                                                  N is not in use, transfer S0 into it.  Even if S0 is simple, you should
                                                                                                  generate code to physically copy the data in S0.


          sb2 T,S             a,c,i,r
               [S1] := [S1] - S0.

          sdf T,S             S
               S0 := S1 symmetric set difference S0.

          set T,S,N           S
               Generate a set on the stack and unions it with the
               existing set.  If N = 1, S0 := the set contains only
               element S0.  If N = 2, S0 := the set contains elements
               S1 through S0 inclusive.

          sex T,S             S
               Remove element S0 from set [S1].

          sin T,S             S
               Add element S0 to set [S1].

          sml T,S             S
               S0 := index of smallest element in S0.

          sub T,S             a,c,i,r
               S0 := S1 - S0.

          trc T               r
               S0 := integer result of truncating S0.

          typ T,S             all
               S0 := change type and size of S0 as specified.

          uni T,S             S
               S0 := S1 set union S0.

          use N,X             all
               S0 := stack register N; if X = c, the stack register
               retains the value; otherwise, the stack register is
               discarded.

               X   Operation
               c   Copy value onto stack
               m   Move value onto stack
               d   Simply discard the stack register


          _4._3.  _C_o_n_t_r_o_l _i_n_s_t_r_u_c_t_i_o_n_s

          The following instructions affect the control flow:




                                  July 4, 1992






                                     - 11 -


          cep T,S,N,name
               Call external procedure name.  T and S describe the
               return value if name is a function; T = P if name is a
               procedure.  N is the number of parameters passed to the
               procedure.  The parameters are SN-1,SN-2,...,S0.

          chk T,Values
               Perform a runtime check, aborting the program if there
               is an error.  The check performed depends on the value
               of X as follows:

               a    Pointer validation.  Check that S0 is a valid
                    pointer.  Leave S0 on the stack.  The check per-
                    formed depends on the type of pointer:

                    Values   Kind of pointer
                      m      Modula-2
                      p      Pascal
                      n      Check <> nil


               c    Case not found in case statement.  This instruc-
                    tion is generated as the default else if one is
                    not specified for a case statement.

               d    Dynamic array validation.  S0 points to a dynamic
                    array; check its pointer.  Leave S0 on the stack.
                    The check depends on the type of pointer, as in
                    pointer validation.

               o    Check open array subscript.  S1 is the subscript
                    value, check that 0 <= S1 < S0.  Pop S0 off the
                    stack.

               p    No return from function.  This instruction is gen-
                    erated at the end of a function that does not end
                    with a return statement.

               r    Check subrange value.  Values = T,N1,N2, where T
                    is the type of value, N1 is the minimum legal
                    value and N2 is the maximum legal value.  Check
                    that N1 <= S0 <= N2.  Leave S0 on the stack.

               s    Check normal subscript.  Like r with a different
                    message.

               v    Check variant tag.  S0 is the address of a record.
                    Values = O,S,List.  O is the offset of the tag in
                    bits from S0.  S is the size of the tag.  List is
                    a list of values separated by semicolons.  If List
                    starts with a ~, then the tag must not have any of
                    the values.  Otherwise, the tag must have one of
                    the values.  A value is either a single number or
                    two numbers separated by a colon, indicating a


                                  July 4, 1992






                                     - 12 -


                    range of values.

               x    Check subarray former on open array.  S0 is the
                    size of the whole array.  S1 is the starting sub-
                    script.  S2 is the number of elements to put in
                    the subarray.  Check that 0 <= S2 <= S1+S2 <= S0.
                    Pop S0 and S1 off the stack.

               A    Assert statement failed.  S0 is a string.  Produce
                    an error message including S0.

          cip T,S,N
               Call indirect to a procedure.  S0 is the address of the
               procedure.  T and S describe the return value if the
               procedure is a function; T = P if it is not.  N is the
               number of parameters passed to the procedure.  The
               parameters are SN,SN-1,...,S1.

          cjp L
               Case jump.  Generate a jump table entry for label L.
               Used to generate a table for the XJP instruction.

          cup T,S,N,name
               Call external procedure name.  T and S describe the
               return value if name is a function; T = P if name is a
               procedure.  N is the number of parameters passed to the
               procedure.  The parameters are SN-1,SN-2,...,S0.

          ent T,S,L,N,P,Line,F,R
               Procedure entry.  The ent instruction has a label,
               which is the name of the procedure.  T and S are the
               type and size of the return value if the procedure is a
               function.  T = P if the procedure is not a function.  L
               is the nesting level of the procedure; the main program
               and global procedures are level 1.  N is the block
               number of the procedure.  P is the number of parameters
               to the procedure.  Line is the line number of the start
               of the procedure.  F is a set of flags indicating
               things about the procedure.  The first character is 1
               if the procedure contains no nested procedures.  The
               second character is 1 if the internal calling sequence
               is used for this procedure.  R is the number of words
               of t memory (starting at offset 0) that may be safely
               allocated to registers.

          fjp L
               Jump if false.  If S0 is false, jump to label L.  S0 is
               popped off the stack.

          for T,S,L
               For jump.  S0 = limit value, S1 = increment, S2 =
               address of index variable.  [S2] := [S2] + S1; if (S1 >
               0 and [S2] <= S0) or (S1 < 0 and [S2] >= S0), jump to
               L.  Pop S0, S1, and S2.


                                  July 4, 1992






                                     - 13 -


          lab
               The lab instruction has a label.  Define an instruction
               label.

          ljp L,D,N
               Long (out-of-block) jump (Pascal only).  Jumps to a
               label in another procedure.  L is the destination label
               name, D is the distance between the current nesting
               level and the target nesting level, and N is the block
               number of the destination procedure.  The destination
               procedure must have executed an sst (Save state) opcode
               for ljp to work

          mst N
               Mark the stack.  This instruction marks the beginning
               of a procedure call.  N is the number of arguments
               (words) passed to the procedure.  It is followed by the
               parameter expressions, par instructions, and finally
               the call instruction.

          par N
               Push argument N.  Move S0 into parameter argument N.
               This may load a register with S0, push S0 onto the
               argument stack, or do whatever your calling conventions
               dicate.

          ret T,S
               Return from a procedure.  If the procedure is a func-
               tion, T and S are the type and size of the return
               value, which is S0.  If the procedure is not a func-
               tion, T = P.

          rst
               Restore state (Pascal only).  If this procedure has a
               label which is the destination of an ljp (Long jump),
               this is the first instruction at the destination label.
               This instruction restores whatever state was saved with
               the sst (Save state) instruction.

          sst
               Save state (Pascal only).  If this procedure has a
               label which is the destination of an ljp (Long jump)
               instruction, it includes an sst opcode as part of the
               procedure initialization code.  This instruction saves
               the current display and any other information needed to
               restore state if an ljp instructions jumps into the
               procedure.

          tjp L
               Jump if true.  If S0 is true, jump to label L.  S0 is
               popped off the stack.





                                  July 4, 1992






                                     - 14 -


          ujp L
               Jump unconditionally.  Jump to label L.

          xjp T,E,L,U
               Indexed (case) jump.  Select a destination based on a
               value.  If S0 is not a value between L and U inclusive,
               jump to the label E.  Otherwise, T is a label of a set
               of cjp instructions.  Select the entry number S0 - L
               and jump to its destination.

          _4._4.  _P_s_e_u_d_o _i_n_s_t_r_u_c_t_i_o_n_s

          The following pseudo-instructions allocate memory and per-
          form other useful functions:

          bgn Language,N,F
               The bgn instruction has a label, which is the name of
               the module.  The label can be used to make unique glo-
               bal names in the P-code translator.  The Language
               operand indicates the compiler that generated the file.
               N is the procedure number of the main program, if it is
               in this compilation; otherwise, 0.  Initialization code
               will be inserted at the beginning of that program.  F
               is a set of flags indicating options on the compile.
               If the first character is 1, statement counting will be
               done for this module.  If the second character is 1,
               gprof profiling will be done for this module.

          com N,Name,S,T
               Define global/static storage.  N is the block number
               assigned to the variable used in load and store
               instructions.  Name is the global name to be used for
               the variable.  S is the size of the variable.  T is the
               type of storage to allocate as follows:

               d    External storage is defined in another module.
                    Equivalent to .comm on Unix systems.

               e    External storage is defined here.  Equivalent to
                    .globl on Unix systems.

               i    External storage and initialization is defined
                    here.  Equivalent to .globl on Unix systems, and
                    see the ini opcode for initialization details.

               I    Private storage and initialization is defined
                    here.

          cts X,Values
               Do statement counting.  The function performed depends
               on the value of X as follows:

               i    Initialize this module.



                                  July 4, 1992






                                     - 15 -


               d    Define the counter table for this module.  Values
                    = N,Name.  N is the number of counters in this
                    module.  Name is the file name for this module.

               c    Increment statement counter.  Values = N,M.  N is
                    the statement counter.  M is the line number
                    corresponding to the counter.

          dbg
               Dump p-code internal state.  This opcode is used only
               for debugging p-code translators, not for debugging
               programs.

          def SP,ST,SM,N,Name
               Define the size of procedure storage.  SP is the size
               of p memory (parameters).  ST is the size of t memory.
               SM is the size of m memory.  N is the block number of
               the procedure.  Name is the name of the procedure.

          ini O,S,T,value
               Initialize a portion of a global variable.  There may
               be several ini opcodes used to initialize a single
               variable if it has a structured type.  O is the bit
               offset into the variables storage.  S is the size in
               bits.  T is the type of data, and value is a constant
               the described storage should be initialized to.  Ini-
               tialization for a variable is finished when the bit
               offset O is -1.

          sac
               Allocate memory on the stack and copy.  S1 is the
               address of a pointer that points to the value to be
               copied, and that will be set to point to the new area.
               S0 is the size of the area as an address constant or
               expression.  The sac instruction is useful for copying
               value parameters, especially variable-length ones.

          sal
               Allocate memory on the stack.  S1 is the address of a
               pointer that is set to the beginning of the new area.
               S0 is the size of the area as an address constant or
               expression.  The sal instruction is useful for allocat-
               ing variable size local variables.

          sym X,Values
               Generate debugger symbol table information.  The sym
               instruction operands are designed around DBX.  The
               value of X determines the treatment of the operands.
               The Values are used to generate the appropriate .stabd
               or .stabs assembler directive.






                                  July 4, 1992






                                     - 16 -


          _5.  _S_o_m_e _t_r_a_d_i_t_i_o_n_s

          Although it may be tempting to think of P-code as a well-
          defined interface, in fact, there are few hard and fast
          rules.  For example, the operands on bgn and ent instruc-
          tions often change as necessary for a particular implementa-
          tion.  Memory classes can be added to model the particular
          kinds of registers and data types on a particular machine.

          A P-code translator should be able to operate in one pass,
          generating assembly language as it parses P-code.  By gen-
          erating assembly language, the P-code translator can avoid
          problems caused by forward references.  Jump labels and
          activation record sizes are generally used with forward
          references.

          The front end usually knows for what kind of machine it is
          generating code.  Although sizes and offsets are expressed
          in bits, a particular implementation may require some or all
          data types to have particular sizes or alignments.  It may
          also be necessary to align address values on particular
          boundaries.  Since the front end allocates storage, it is
          responsible for rounding up sizes and aligning data types as
          required.
































                                  July 4, 1992



