(*
    MathLib0 module for the DEC MIPS Modula-2 compiler.
    Philip A. Nelson   (phil@cs.wwu.edu)
    April 1991

    This is public domain software.
*)


IMPLEMENTATION MODULE MathLib0;

import longmath;

  PROCEDURE sqrt (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.sqrt(longfloat(x)));
    END sqrt;

  PROCEDURE exp (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.exp(longfloat(x)));
    END exp;

  PROCEDURE ln (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.log(longfloat(x)));
    END ln;

  PROCEDURE sin (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.sin(longfloat(x)));
    END sin;

  PROCEDURE cos (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.cos(longfloat(x)));
    END cos;

  PROCEDURE arctan (x: REAL) : REAL;
    BEGIN
      RETURN FLOAT(longmath.atan(longfloat(x)));
    END arctan;

  PROCEDURE real (x: INTEGER) : REAL;
    BEGIN
      RETURN FLOAT(x);
    END real;

  PROCEDURE entier (x: REAL) : INTEGER;
    BEGIN
      IF x < 0.0 THEN
        RETURN TRUNC(x-1.0);
      ELSE
        RETURN TRUNC(x);
      END;
    END entier;

END MathLib0.
