(*
    Terminal module for the DEC MIPS Modula-2 compiler.
    Philip A. Nelson   (phil@cs.wwu.edu)
    April 1991

    This is public domain software.

    This is not a complete character by character terminal
    module.  It does not contain all procedures defined by
    Wirth.  It also contains some extra procedures.

*)


IMPLEMENTATION MODULE Terminal;

IMPORT io;
IMPORT unix;

CONST EOL = 12C;

VAR LastCh : CHAR;

  PROCEDURE Read (VAR ch: CHAR);
    VAR retval : INTEGER;
    BEGIN
      retval := io.Readc (io.input, ch);
      IF retval = 1 THEN ch := EOL; END;
      LastCh := ch;
    END Read;

  PROCEDURE ReadString (VAR s: ARRAY OF CHAR);
    VAR retval : INTEGER;
        indx : INTEGER;
    BEGIN
      indx := 0;
      REPEAT
        retval := io.Readc (io.input, LastCh);
        s[indx] := LastCh;
        INC(indx);
      UNTIL (indx = HIGH(s)) OR (LastCh = EOL) OR (retval = 1);
      IF LastCh = EOL THEN
        s[indx-1] := 0C;
        retval := unix.ungetc (EOL,io.input);
      ELSIF (indx < HIGH(s)) THEN
        s[indx] := 0C;
      END;
    END ReadString;
  
  PROCEDURE ReadLn;
    VAR retval : INTEGER;
    BEGIN
      REPEAT
        retval := io.Readc (io.input, LastCh);
      UNTIL (LastCh = EOL) OR (retval = 1);
    END ReadLn;

  PROCEDURE ReadAgain;
    VAR retval : INTEGER;
    BEGIN
      retval := unix.ungetc (LastCh, io.input);
    END ReadAgain;


  PROCEDURE Write (ch: CHAR);
    BEGIN
      io.Writec (io.output, ch);
    END Write;

  PROCEDURE WriteString (s: ARRAY OF CHAR);
    BEGIN
      io.Writes (io.output, s);
    END WriteString;

  PROCEDURE WriteLn;
    BEGIN
      io.Writec (io.output, EOL);
    END WriteLn;

BEGIN
  LastCh := ' ';
END Terminal.

