implementation module GenUC;

(*****************************************************************************
 *									     *
 *             Copyright 1984-1992 Digital Equipment Corporation             *
 *                         All Rights Reserved				     *
 *								             *
 * Permission to use, copy, and modify this software and its documentation   *
 * is hereby granted only under the following terms and conditions.  Both    *
 * the above copyright notice and this permission notice must appear in all  *
 * copies of the software, derivative works or modified versions, and any    *
 * portions thereof, and both notices must appear in supporting              *
 * documentation.							     *
 *									     *
 * Users of this software agree to the terms and conditions set forth        *
 * herein, and hereby grant back to Digital a non-exclusive, unrestricted,   *
 * royalty-free right and license under any changes, enhancements or         *
 * extensions made to the core functions of the software, including but not  *
 * limited to those affording compatibility with other hardware or software  *
 * environments, but excluding applications which incorporate this software. *
 * Users further agree to use their best efforts to return to Digital any    *
 * such changes, enhancements or extensions that they make and inform        *
 * Digital of noteworthy uses of this software.  Correspondence should be    *
 * provided to Digital at:						     *
 * 									     *
 *                       Director of Licensing				     *
 *                       Western Research Laboratory			     *
 *                       Digital Equipment Corporation			     *
 *                       250 University Avenue				     *
 *                       Palo Alto, California  94301  			     *
 * 									     *
 * This software may be distributed (but not offered for sale or transferred *
 * for compensation) to third parties, provided such third parties agree to  *
 * abide by the terms and conditions of this notice.  			     *
 * 									     *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS    *
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED        *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL    *
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR     *
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF    *
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR     *
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    *
 * PERFORMANCE OF THIS SOFTWARE.				    	     *
 *									     *
 *****************************************************************************)

from Machine import MAXINT;

from io import
    SWriteF,WriteF,output;

from MemLib import
    ALLOCATE;

from Machine import
    HugeInteger, WORDSIZE, BOOLEANSIZE, HALFSIZE, BYTESIZE, FileName,
    BYTESPERWORD,BYTESPERADDR;
$if pascal then
from Globals import bufferFlag;
from Symbols import FileVarNode, programFileVarList, builtinScope;
$end

import strings;
from Strings import
    CopyString;

from Tokens import
    Token, TokenSet;

from Globals import
    target, TARGETMIPS, optimFlag,
    TraceGenuc, DEBUG, MODULEINITNAME,
    mainFileName, TraceOptim;

from Symbols import
    NULLLABEL, NUMOPTTEMPS, DisplayLevel, LabelNumber, 
    EvalMode, EvalModeSet, EnumList, EnumNode, MemoryOffset,
    PointerKind, CheckKind, GlobalSymKind, ConstNode, ParamKind,
    TypeNode, VarNode, FieldNode, VariantNode, ModuleNode,
    ExprNode, ExprList, StmtNode, StmtList, CaseNode, CaseTreeNode,
    ConstSetNode, ExprSetNode, ParamNode, ParamList,
    CodeNode, SYMTYPE, MemoryType, DataType, ProcNode,
    MODDEFINITION, BIPNOTBIP, ExprKind,
    StmtKind,
    booleanTypeNode, addressTypeNode, integerTypeNode,
    cardIntTypeNode, procTypeNode,
    globalModule, globalProc, currLine,
    currFile, FormerNode, FormerElementNode, FormerElementKind,
    InlineParamNode, InlineParamList, IPPARAM, OptNode, OptUsage,
    ConstSetType,SetValue,GlobalVarNode, ALIGNMENTUNSPECIFIED;

from Errors import
    Error, ExprError, StmtError, ErrorName, Warning;

from Consts import
    ConstSet, OrdOf;

from TypeInfo import
    NumberOf, LowerBoundOf, SizeOf, ReferenceByPoint, BaseType,
    AlignmentOf;

from Alloc import
    globalVarList,RoundUp;

from BuildExpr import
    WriteExpr;

$if pascal then
from CheckExpr import
    MakeExprConstString;
$end

from OCount import
    EvalState, InitTemps, UpdateTemps;

from PCodeOps import
    PCodeOp;

from UCode import
    MapT,operUcode,iOperUcode,NewLabel;

from GenCode import
    genCountFlag, GenCode;

from BuiltinUC import
    GenBuiltin;

from SymbolDump import
    InitStab, StabGlobalPort, StabProc,
    StabProcExit,
    StabCheckProcRef,MipGlobal,StabProcEntry;

from Runtime import
    NOPCODEBLOCK;

from stsupport import
    NULLDN;

from Mipudef import
     Uopcode, Memtype, LITTLEENDIAN, UCO_SOURCE;

import MipSym;

from MipUco import
     Uco1int, Ucooptn, Ucomment, Ucoloc, UcoProc,Ucomment,Uco2intint,
     Ucolab, Ucosym, Ucomem, Ucodef, Ucoinit, Uco0, Uco4int, Uco1type,
     Ucoldc, Uco2int, Ucoicuf,Uco2typint,Ucoxjp,Uco2typtyp,
     NOSIDEEFFECT_ATTR,EXTERNAL_ATTR, IN_MODE, NOSTRING, RETURN_ATTR,
     FRAMEPTR_ATTR;

const
    MIPS_SET_LIMIT = 512;
    STATICLINK = -4;
    RTINIT     = 'runtime__init';
    RTTERM     = 'runtime__term';
    RTBCOPY    = 'bcopy';
    RTERRORADDR   = 'runtime__erroraddr';
    RTERRORSUBSCRIPT = 'runtime__errorsubscript';
    RTERRORRANGE  = 'runtime__errorrange';
    RTERRORNORETURN = 'runtime__errornoreturn';
    RTERRORCASE   = 'runtime__errorcase';
    RTERRORSUBSCRIPTOPEN = 'runtime__errorsubscriptopen';
    RTERRORSUBARRAY = 'runtime__errorsubarray';
    RTERRORVARIANT = 'runtime__errorvariant';
    RTTRACE       = 'runtime__trace';
    RTSTRNCMP    = 'strncmp';
    CompareSet = TokenSet { TKEQUALS, TKSHARP, TKLESS, TKGREATER, TKNOTEQUAL,
     	       	    	    TKLSEQUAL, TKGREQUAL };
type
    ExitInfo = record
	exitLabel : LabelNumber;
	loopLevel : integer;
    end;
    DataTypeSet = set of Datatype;

var
    loopExit, forExit, whileExit, repeatExit : ExitInfo;
    currLevel : DisplayLevel;
    loopNestLevel, exitLevel : integer;
    currCounter, currCounterLine, numFast : integer;
    exited, returned : boolean;
    dummyVar: VarNode;
    sourceFileName : FileName;
    ucoLocalBytes,ucoFastLocalBytes,ucoOptTempBytes,ucoTempBytes : integer;
    curOptTempTypes,curFastTypes : dynarray of Datatype;

procedure GenOp(const op : PCodeOp);
begin
     SWriteF(theCharArray,'Unsupported pcode(%n)',op);
     Error(theCharArray);
end GenOp;

procedure GenReturnValue(const tn : TypeNode; size : integer);
var temp,bsize : integer;
    structret : boolean;
    dt,dt2 : Datatype;

begin
    bsize := RoundUp(size,BYTESIZE) div BYTESIZE;
    dt2 := MapT(tn);
    dt := dt2;
    structret := ReferenceByPoint(tn);
    if structret then
        dt := Adt;
     	bsize := BYTESPERADDR;
    end;
    temp := UcodeTemp(dt,bsize);
    case dt of				 (* load from return reg *)
    | Qdt:
        Ucomem(Ulod,dt,Rmt,0,128,8,0);
    | Rdt :
        Ucomem(Ulod,dt,Rmt,0,128,4,0);
    | Jdt,Ldt,Fdt,Adt,Hdt,Sdt:
	Ucomem(Ulod,dt,Rmt,0,8,bsize,0);
    end;
    Ucomem(Ustr,dt,Mmt,curUcodeBlock,temp,bsize,0);	(* clear stack *)
    Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,bsize,0);
    if structret and (dt2 = Sdt) then
        Uco2int(Uilod,Sdt,0,RoundUp(size,BYTESIZE) div BYTESIZE);
    end;
end GenReturnValue;

procedure GenLibCall(const name		 : array of char;
		     const retType       : TypeNode; 
		     const retSize       : MemoryOffset;
		     const numParams     : integer;
     	       	     const runtime       : RuntimeProc);

type RTSet = set of RuntimeProc;

const
    ExitRuntimes = RTSet{rt__term,rt__errornoreturn, rt__errorassert, 
     	 rt__erroraddr  ,rt__errorsubscript, rt__errorsubarray,rt__errorrange,
         rt__errorcase,rt__errorvariant};
    SideEffectFree = RTSet {rtbcopy,rtvoid,rtNAM,rtsprintf,rtsscanf, rtstrncmp};

var attr : integer;
    dt : Datatype;
begin
    attr := 0;
    if runtime in ExitRuntimes then
        inc(attr,RETURN_ATTR);
    end;
    if runtime in SideEffectFree then
        inc(attr,NOSIDEEFFECT_ATTR);
    end;
    if retType = nil then
        dt := Pdt;
    elsif ReferenceByPoint(retType) then
        dt := Adt;
    else
        dt := MapT(retType);
    end;
    UcoProc(Ucup,dt,RTlevel,MipSym.GlobalText(name,ord(runtime)),
     	    numParams,ord(retType # nil),attr);
    if dt # Pdt then
        GenReturnValue(retType,retSize);
    end;
end GenLibCall;

procedure GenCounter(line : integer; stl : StmtList);
begin
    if genCountFlag then
	if stl # nil then
	    if stl^.first # nil then
		line := stl^.first^.lineNumber;
	    end;
	end;
	currCounter := currCounter + 1;
	GenOp(PCCTS);(* C('c'); X; I(currCounter);
		X; I(line); EndLine;*)
	if line < currCounterLine then
	    Error('Line numbers out of order?');
	end;
    end;
end GenCounter;

procedure SetSize(const setVal : SetValue) : integer;
begin
     return trunc(NumberOf(BaseType(setVal^.setType)^.setRange));
end SetSize;

procedure NullSetString(var str : array of char; const size : integer);
var i : integer;
begin
    for i := Low(str) to Low(str)+size div 4 do
        str[i] := '0';
    end;
    str[Low(str)+size div 4+1] := 0C;
end NullSetString;

procedure SetString(var str : array of char;
     	       	    const setVal : SetValue) : integer;
var
    i,bits,index,nsize : integer;
    theSet : ConstSetType;
    hexChars : array[0..16] of char;
begin
    nsize := RoundUp(SetSize(setVal),WORDSIZE);
    assert(nsize <= MIPS_SET_LIMIT,'Too big a set in SetString');
    NullSetString(str,nsize);
    hexChars := '0123456789abcdef';
    theSet := setVal^.value;
    index := Low(str);
    for i := nsize-1 to 3 by -4 do	 (* set strings are big-endian! *)
     	bits :=  8*ord(i in theSet);
     	inc(bits,4*ord(i-1 in theSet));
     	inc(bits,2*ord(i-2 in theSet));
     	inc(bits,  ord(i-3 in theSet));
        if bits # 0 then
     	    str[index] := hexChars[bits];
     	    bits := 0;
        end;
     	inc(index);
    end;
    return nsize;
end SetString;

procedure GenInitialValue(const idn : integer;
    value : FormerNode; baseOffset : MemoryOffset);
var
    fen : FormerElementNode;
    csn : ConstSetNode;
    limit, index, lowerBound, size : MemoryOffset;

    procedure GenEnumNameTable(enumList : EnumList);
	var
	    enum		: EnumNode;
	    offset		: MemoryOffset;
	    numTableEntries     : integer;
	    shortWordIndex      : integer;
	    stringSize		: MemoryOffset;
    begin
	enum := enumList^.first;
	numTableEntries := enumList^.last^.enumOrd - enum^.enumOrd + 1;
	(* Number of entries in table *)
	offset := 0;
        Ucoinit(Jdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	        HALFSIZE div BYTESIZE,0,numTableEntries,NOSTRING);
	offset := offset + HALFSIZE;
    
	(* Generate the table of relative offsets of the start of each name *)
	shortWordIndex := 2 * (numTableEntries + 1);
	loop
            Ucoinit(Jdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	        HALFSIZE div BYTESIZE,0,shortWordIndex,NOSTRING);
	    offset := offset + HALFSIZE;
	    if enum = nil then 
		exit;
	    end;
	    shortWordIndex := shortWordIndex + enum^.name^.length + 1;
	    enum := enum^.next;
	end (* loop *);
    
	(* Now generate the actual characters of each name *)
	enum := enumList^.first;
	repeat
     	    CopyString(enum^.name,theCharArray);
            Ucoinit(Mdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	       	    enum^.name^.length+1,0,0,theCharArray);
	    stringSize := BYTESIZE * (enum^.name^.length + 1);
	    offset := offset + stringSize;
	    enum := enum^.next;
	until enum = nil;
    end GenEnumNameTable;

    procedure GenInitialValueConst(cn : ConstNode; size, offset : integer);
    begin
     	assert(size mod BYTESIZE = 0,'bad size in GenInitialValueConst');
     	assert(offset mod BYTESIZE = 0,'bad offset in GenInitialValueConst');
        case cn^.kind of
	| DTINTEGER, DTCARDINAL :
     	    if cn^.cardVal < 0.0 then
                Ucoinit(Jdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	                size div BYTESIZE,0,trunc(cn^.cardVal),NOSTRING);
	    elsif cn^.cardVal > MAXINT then
     	        Ucoinit(Ldt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	       	        size div BYTESIZE,0,
     	                trunc(cn^.cardVal-MAXINT-1.0)+trunc(MAXINT)+1,
     	       	        NOSTRING);
            else
                Ucoinit(Ldt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	                size div BYTESIZE,0,trunc(cn^.cardVal),NOSTRING);
            end;
	| DTCHAR :
            Ucoinit(Ldt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,ord(cn^.charVal),NOSTRING);
	| DTBOOLEAN :
            Ucoinit(Ldt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,ord(cn^.boolVal),NOSTRING);
	| DTENUMERATION :
            Ucoinit(Ldt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,cn^.enumVal^.enumOrd,NOSTRING);
	| DTREAL:
     	    SWriteF(theCharArray,'%1.17#G',cn^.realVal);
            Ucoinit(Rdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,0,theCharArray);
        | DTLONGREAL :
     	    SWriteF(theCharArray,'%1.17#G',cn^.realVal);
            Ucoinit(Qdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,0,theCharArray);
	| DTSTRING :
            CopyString(cn^.strVal,theCharArray);
     	    Ucoinit(Mdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	            size div BYTESIZE,0,0,theCharArray);
	| DTSET :
            assert(size = SetString(theCharArray,cn^.setVal), (* side-effect *)
     	       	    	 'non-equal size in GenInitialValueConst');;
     	    Ucoinit(Mdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	       	    size div BYTESIZE,0,0,theCharArray);
	| DTPROC :
     	    StabCheckProcRef(cn^.procVal);
     	    Ucoinit(Fdt,Smt,idn,offset div BYTESIZE,offset div BYTESIZE,
     	       	    size div BYTESIZE,0,cn^.procVal^.sym_idn,NOSTRING);
	| DTARRAY :
	    GenInitialValue(idn,cn^.arrayVal,offset);
	| DTRECORD :
	    GenInitialValue(idn,cn^.recordVal,offset);
	end (* case *);
    end GenInitialValueConst;

begin (* GenInitialValue *)
    case value^.kind of
    | FEENUMNAMETABLE :
	GenEnumNameTable(value^.formerType^.enumList);
	
    | FEARRAYCONST :
	lowerBound := trunc(LowerBoundOf(value^.formerType^.indexType));
	size := value^.formerType^.elementSize;
	fen := value^.value^.first;
	while fen # nil do 
	    csn := fen^.indexConst^.first;
	    while csn # nil do 
		index := trunc(OrdOf(csn^.lower));
		GenInitialValueConst(fen^.arrayConst,size,
			baseOffset+size*(index-lowerBound));
		if csn^.upper # nil then 
		    limit := trunc(OrdOf(csn^.upper));
		    index := index + 1;
		    while index <= limit do 
			GenInitialValueConst(fen^.arrayConst,size,
				baseOffset+size*(index-lowerBound));
			index := index + 1;
		    end;
		end;
		csn := csn^.next;
	    end;
	    fen := fen^.next;
	end;
    | FERECORDCONST :
	fen := value^.value^.first;
	while fen # nil do
	    GenInitialValueConst(fen^.recordConst,fen^.recordField^.size,
		    baseOffset+fen^.recordField^.offset);
	    fen := fen^.next;
	end;
    | FECONST :
	fen := value^.value^.first;
	if fen^.tagsConst # nil then
	    Error('Unexpected tags?');
	end;
	if fen^.next # nil then
	    Error('Unexpected values?');
	end;
	GenInitialValueConst(fen^.valueConst,value^.formerType^.size,
		    baseOffset);
    end (* case *);
end GenInitialValue;

procedure GenGlobal(gvn : GlobalVarNode);
var
    align : integer;
     uop : Uopcode;
begin
    if gvn^.sym_idn = NULLDN then
        gvn^.sym_idn := MipGlobal(gvn);
    end;
    if gvn^.used or gvn^.defineMemory then
        if gvn^.sym_idn = NULLDN then
            ErrorName(gvn^.globalName,'No indx for $');
        end;
	(* Need to declare com & init *)
     	if gvn^.value # nil then
     	    if gvn^.extern = GSPRIVATE then
     	       	uop := Ulsym;
            else
     	       	uop := Ucsym;
            end;
     	elsif gvn^.defineMemory then
     	    if gvn^.extern = GSEXTERNAL then
     	       	uop := Uesym;
     	    else
     	       	uop := Ucsym;
            end;
        else
     	    uop := Uesym;
     	end;
     	assert(gvn^.alignment > 0,
     	       'null alignment for global');
     	case gvn^.alignment of
        | 1..8: align := 0;
        | 9..16: align := 1;
        | 17..32: align := 2;
        else align := 3;
        end;
     	Ucosym(uop,gvn^.sym_idn,align,
     	       	     (gvn^.size+BYTESIZE-1) div BYTESIZE);
     	if gvn^.value # nil then
     	    GenInitialValue(gvn^.sym_idn,gvn^.value,0);
        end;
    end;
end GenGlobal;

procedure UcodeTemp(const dataType : Datatype; const size : integer) : integer;
var offset,fudge,ucodeoffset,lsize : integer;
begin
    fudge := 0;
    offset := ucoLocalBytes+ucoFastLocalBytes+ucoOptTempBytes+ucoTempBytes;
    assert(size > 0,'UcodeTemp got bogus size');
    lsize := size;
    if lsize = 3 then lsize := 4; end;
    case lsize of 
    | 1 :;
    | 2 : fudge := ord(odd(offset));
    | 4 : fudge := (4 - offset mod 4) mod 4;
    | else
        fudge := (8 - offset mod 8) mod 8;
     	lsize := RoundUp(size,8);	 (* double align size *)
    end;
    ucodeoffset := -(offset+fudge+lsize);
    if (dataType # Mdt) and ((lsize <= 4) or (dataType = Qdt)) then
        Ucomem(Uvreg,dataType,Mmt,curUcodeBlock,ucodeoffset,lsize,1);
    end;
    ucoTempBytes := ucoTempBytes + lsize + fudge;
    return ucodeoffset;
end UcodeTemp;

procedure GenStaticLink(const level : integer) : integer;
var proc : ProcNode;
    i : integer;
begin
    if level <= currLevel then
        assert(currLevel > RTlevel,'wrong currlevel for GenStaticLink');
     	assert(ucoLocalBytes >= 4,'no static link space');
        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,STATICLINK,BYTESPERADDR,0);
        proc := genProc^.enclosing;
        for i := currLevel to level+2 by -1 do (* we're already pointing up 1 
     	       	    	      	   	     	level *)
            Ucomem(Uisld,Adt,Mmt,proc^.sym_idn,STATICLINK,BYTESPERADDR,0);
     	    proc := proc^.enclosing;
        end;
        return proc^.sym_idn;
    elsif level = currLevel+1 then
        Uco4int(Ulda,Mmt,curUcodeBlock,0,BYTESPERWORD,0); (* for proc call *)
        return curUcodeBlock;
    end;
end GenStaticLink;

procedure GenIlod(const dt : Datatype;
     	          const offset,size : integer);
var foffset,boffset,bsize : integer;
begin
    if (offset mod BYTESIZE = 0) and (size mod BYTESIZE = 0) and (size # 24)
    then
        Uco2int(Uilod,dt,offset div BYTESIZE,size div BYTESIZE);
    else
	(* Assume word aligned address *)
     	boffset := (offset div BYTESIZE);
     	foffset := offset - boffset*BYTESIZE;
     	bsize := (foffset+size+BYTESIZE-1 mod BYTESIZE) div BYTESIZE;
        if (boffset mod BYTESPERWORD = 1) and (bsize # 1) then
            dec(boffset);
     	    inc(foffset,BYTESIZE);
            bsize := BYTESPERWORD;
        elsif (bsize = BYTESPERWORD-1) then
            bsize := BYTESPERWORD; 
        end;
     	assert(foffset+size <= WORDSIZE,
     	       'GenIlod: bit field straddles word boundary');
        Uco2int(Uilod,dt,boffset,bsize);
     	Ucoldc(Ldt,1,WORDSIZE-size-foffset, NOSTRING);
     	Uco1type(Ushl,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE-size, NOSTRING);
     	Uco1type(Ushr,dt);	(* take care of sign extend *)
    end;
end GenIlod;

procedure GenIstr(const dt : Datatype;
     	          const offset,size : integer);
var foffset,boffset,bsize : integer;
    temp : integer;
begin
    if (offset mod BYTESIZE = 0) and (size mod BYTESIZE = 0) and (size # 24)
    then
        Uco2int(Uistr,dt,offset div BYTESIZE,size div BYTESIZE);
    else
     	boffset := (offset div WORDSIZE)*BYTESPERWORD;
     	foffset := offset - boffset*BYTESIZE;
     	assert(foffset+size <= WORDSIZE,
     	       'GenIStr: bit field straddles word boundary');
     	(* upas and ccom always ref WORDs of memory, should we? *)
        (* WE shouldn't because don't know anything about the alignment 
           of the byte address *)
        (* Well, we gotta start somewhere... *)
	(* What about overlapping field stores and uopt rearranging? *)
     	bsize := (foffset+size+BYTESIZE-1) div BYTESIZE;
     	if (bsize = 3) then bsize := 4; end;
        temp := UcodeTemp(Adt,BYTESPERADDR);
        Uco2typtyp(Uswp,dt,Adt);
        Ucomem(Ustr,Adt,Mmt,curUcodeBlock,temp,BYTESPERADDR,0);
        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp,BYTESPERADDR,0);	(* for Uistr *)
        Uco2typtyp(Uswp,dt,Adt);
        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp,BYTESPERADDR,0);
        GenIlod(dt,boffset*BYTESIZE,bsize*BYTESIZE);
     	Ucoldc(Ldt,1,foffset,NOSTRING);
     	Uco1type(Ushr,Ldt);
        Uco1type(Uxor,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE-size,NOSTRING);
        Uco1type(Ushl,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE-size-foffset,NOSTRING);
        Uco1type(Ushr,Ldt);
        Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temp,BYTESPERADDR,0);
        GenIlod(dt,boffset*BYTESIZE,bsize*BYTESIZE);
        Uco1type(Uxor,Ldt);
        GenIstr(dt,boffset*BYTESIZE,bsize*BYTESIZE);
    end;
end GenIstr;

procedure GenLod(const dt : Datatype;
     	         const mt : Memtype; const offset,size,level : integer;
     	       	 block : integer);
var foffset,boffset,bsize : integer;
    uop : Uopcode;
begin
    if (level > 1) and (level # currLevel) then
     	block := GenStaticLink(level);
     	assert(block > 0,'bad block in GenLod');
        uop := Uisld;
    else
        uop := Ulod;
    end;
    if (offset mod BYTESIZE = 0) and (size mod BYTESIZE = 0) and (size # 24)
    then
        Ucomem(uop,dt,mt,block,offset div BYTESIZE,size div BYTESIZE,0);
    else
        if offset >= 0 then
     	    boffset := (offset div BYTESIZE);
        else
     	    boffset := ((offset-BYTESIZE+1) div BYTESIZE);
        end;
     	foffset := offset - boffset*BYTESIZE;
     	bsize := (size+BYTESIZE-1+foffset mod BYTESIZE) div BYTESIZE;
        if (boffset mod BYTESPERWORD = 1) and (bsize # 1) then
            dec(boffset);
     	    inc(foffset,BYTESIZE);
     	    bsize := BYTESPERWORD;
        elsif (bsize = BYTESPERWORD-1) then 
            bsize := BYTESPERWORD; 
        end;
     	assert(foffset+size <= WORDSIZE,
     	       'GenLod: bit field straddles word boundary');
        (* Let's worry about overlab especially with uopt rearranging things *)
     	(* upas and ccom always ref WORDs of memory, should we? *)
        Ucomem(uop,dt,mt,block,boffset,bsize,0);
     	Ucoldc(Ldt,1,WORDSIZE-size-foffset, NOSTRING);
     	Uco1type(Ushl,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE - size, NOSTRING);
     	Uco1type(Ushr,dt);		(* take care of sign extend *)
    end;
end GenLod;

procedure GenStr(const dt : Datatype;
     	         const mt : Memtype; const offset,size,level : integer;
     	       	 block : integer);
var boffset,bsize,foffset : integer;
    uop : Uopcode;
begin
    if (offset mod BYTESIZE = 0) and (size mod BYTESIZE = 0) and (size # 24) 
    then
        if (level > 1) and (level # currLevel) then
     	    block := GenStaticLink(level);
            assert(block >0,'bad block in GenStr');
            uop := Uisst;
     	    Uco2typtyp(Uswp,Adt,dt);	 (* or should we store into temp? *)
        else
            uop := Ustr;
        end;
        Ucomem(uop,dt,mt,block,offset div BYTESIZE,size div BYTESIZE,0);
    else
        if offset >= 0 then
     	    boffset := (offset div WORDSIZE)*BYTESPERWORD;
        else
     	    boffset := ((offset-WORDSIZE+1) div WORDSIZE)*BYTESPERWORD;
        end;
     	foffset := offset - boffset*BYTESIZE;
     	assert(foffset+size <= WORDSIZE,
     	       'GenStr: bit field straddles word boundary');
 	bsize := (size+BYTESIZE-1+offset mod BYTESIZE) div BYTESIZE;
     	if (bsize = 3) then bsize := 4; end;
        GenLod(dt,mt,boffset*BYTESIZE,bsize*BYTESIZE,level,block);
     	Ucoldc(Ldt,1,foffset,NOSTRING);
     	Uco1type(Ushr,Ldt);
        Uco1type(Uxor,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE-size,NOSTRING);
        Uco1type(Ushl,Ldt);
     	Ucoldc(Ldt,1,WORDSIZE-size-foffset,NOSTRING);
        Uco1type(Ushr,Ldt);
        GenLod(dt,mt,boffset*BYTESIZE,bsize*BYTESIZE,level,block);
        Uco1type(Uxor,Ldt);
        GenStr(dt,mt,boffset*BYTESIZE,bsize*BYTESIZE,level,block);
    end;
end GenStr;

procedure GenLda(const mt : Memtype; const offset,size,level : integer;
     	         block : integer);
var uop : Uopcode;
    boffset : integer;
begin
    if (level > 1) and (level # currLevel) then
     	block := GenStaticLink(level);
        assert(block >0,'bad block in GenLda');
        uop := Uilda;
    else
        uop := Ulda;
    end;
    if offset mod BYTESIZE = 0 then
     	if offset >= 0 then
     	    boffset := offset div BYTESIZE;
        else
     	    boffset := (offset-BYTESIZE+1) div BYTESIZE
        end;
        Uco4int(uop,mt,block,boffset,(size+BYTESIZE-1) div BYTESIZE,boffset);
    else
        Error('Cannot point at non-byte aligned data');
    end;
end GenLda;

procedure GenCompare(binOp : Token; tn : TypeNode);
var dt : Datatype;
    bt : TypeNode;
    size,alignment : integer;
begin
    bt := BaseType(tn);
    if bt = cardIntTypeNode then (* fudge unsigned *)
        dt := Jdt;
    else
        dt := MapT(tn);
        if dt = Adt then dt := Jdt; end; (* do signed address compares *)
    end;
    if dt # Mdt then
        Uco1type(operUcode[binOp],dt);
    else
	size := RoundUp(SizeOf(tn),BYTESIZE) div BYTESIZE;
	alignment := AlignmentOf(tn);
     	case alignment of
        | 8,16,32,64:
        else
     	    SWriteF(theCharArray,"Don't know what to do with align = %d",
     	            alignment);
     	    Error(theCharArray);
        end;
        Uco2intint(iOperUcode[binOp],alignment,size);
     end;
end GenCompare;

procedure GenVarT(vn : VarNode; tn : TypeNode; mode : EvalMode);
var 
    dt : Datatype;
    mt : Memtype;
    temp,block,offset,size,level : integer;
begin
    dt := MapT(tn);
    if (vn^.address.kind = MEMFAST) and (vn^.address.offset >= 0) then
        temp := vn^.address.offset div WORDSIZE;
	vn^.address.offset := -((ucoLocalBytes+temp*BYTESPERWORD)*BYTESIZE +
     	       	    	       WORDSIZE);
        (* We have a Check temporary, like for^.forLimitVar *)
        assert(curFastTypes^[temp] = Zdt,'huh?');
        curFastTypes^[temp] := dt;
     	if dt # Mdt then (* avoid small arrays *)
            if mode = EVALPOINT then
     	        Error('Taking address of VREG!');
            end;
            offset := vn^.address.offset div BYTESIZE;
       	    Ucomem(Uvreg,dt,Mmt,curUcodeBlock,
     	           offset,BYTESPERWORD,1);
        end;
	if (mode = EVALGET) and optimFlag then
     	    Warning('Try removing -O or -C from compile flags');
        end;
(*
	assert(mode # EVALGET,'Load from uninitialized compiler temporary!');
*)
    end;
    size := SizeOf(tn);
    if dt = Mdt then
        mode := EVALPOINT;		 (* work around GenExprVal *)
    end;
    if vn^.address.kind = MEMGLOBAL then
        mt := Smt;
        offset := 0;
        block := vn^.address.gvn^.sym_idn;
        level := 0;
    else
     	offset := vn^.address.offset;
     	case vn^.address.kind of
        | MEMPARAM:
     	    mt := Pmt;			 (* offset is ok *)
        | MEMNORMAL:
            mt := Mmt;
     	    offset := -(offset + vn^.address.size);
        | MEMFAST:
     	    mt := Mmt;
     	    size := vn^.address.size;
            assert(offset < 0,'non-negative offset in GenVarT');
        end;
        level := vn^.address.level;
     	block := curUcodeBlock;
    end;
    assert(block >=0,'bad block in GenVarT');
    case mode of
    | EVALGET   : GenLod(dt,mt,offset,size,level,block);
    | EVALPUT   : GenStr(dt,mt,offset,size,level,block);
    | EVALPOINT : GenLda(mt,offset,size,level,block);
    end;
end GenVarT;

procedure GenVar(vn : VarNode; mode : EvalMode);
begin
    GenVarT(vn,vn^.varType,mode);
end GenVar;

(* Used by OptGenExpr *)
procedure GenTemp(use : OptUsage; on : OptNode; en : ExprNode);
var
    tn : TypeNode;
    size,offset : integer;
    dt : Datatype;
begin
    tn := en^.exprType;
    size := RoundUp(SizeOf(tn),BYTESIZE);
    offset := -((ucoLocalBytes + ucoFastLocalBytes +
     	       	 (on^.tempNumber-1)*BYTESPERWORD) * BYTESIZE +
     	       	  	     WORDSIZE);
    if ReferenceByPoint(tn) then
        dt := Adt;
        size := WORDSIZE;
    else
        dt := MapT(tn);
    end;
    if offset mod WORDSIZE # 0 then
     	SWriteF(theCharArray,'Bad offset (%d) in GenTemp',
     	   	    offset);
     	Error(theCharArray);
    end;
    if curOptTempTypes^[on^.tempNumber-1] = Zdt then
        curOptTempTypes^[on^.tempNumber-1] := dt;
     	Ucomem(Uvreg,dt,Mmt,curUcodeBlock,offset div BYTESIZE,
     	       size div BYTESIZE,1);
    end;
    case use of
    | OUSEGENERATE  : GenStr(dt,Mmt,offset,size,0,curUcodeBlock);
    | OUSEAFTERFIRST: GenLod(dt,Mmt,offset,size,0,curUcodeBlock);
    | OUSEFIRST     : GenStr(dt,Mmt,offset,size,0,curUcodeBlock); 
     	              GenLod(dt,Mmt,offset,size,0,curUcodeBlock);
    end;
end GenTemp;

procedure GenMove(tn : TypeNode; alignment,size : integer);
begin
    if alignment = 0 then
        alignment := AlignmentOf(tn);
    end;
    if size = 0 then
        size := RoundUp(SizeOf(tn),BYTESIZE) div BYTESIZE;
    end;
    case alignment of
    | 8,16,32,64 :			 (* ok *)
    else
        SWriteF(theCharArray,
     	        "Don't know what to do with align = %d in GenMove",
     	        alignment);
     	Error(theCharArray);
    end;
    Uco2intint(Umov,alignment,size);
end GenMove;

procedure GenAssign(const lhs,rhs : ExprNode; lhstn : TypeNode);
var bitoffset : integer;
    lvalue : ExprNode;
begin
    if (MapT(lhstn) # Sdt) and ReferenceByPoint(lhstn) then
        if rhs^.kind = EXPRFUNC then
     	    GenExprFunc(rhs,EVALPOINT,lhs);
        else
            GenExpr(rhs,EVALPOINT);		 (* worry about OCount order *)
            GenExpr(lhs,EVALPOINT);
     	    Uco2typtyp(Uswp,Adt,Adt);
            GenMove(lhstn,0,0);
        end;
    elsif lhs^.kind = EXPRVAR then
        GenExpr(rhs,EVALGET);
	GenVarT(lhs^.exprVar,lhstn,EVALPUT);
    else
        bitoffset := 0;
        lvalue := lhs;
        if (lvalue^.kind = EXPRBINOP) and 
     	   (lvalue^.exprBinOp = TKPLUS) then
            if (lvalue^.opnd2^.kind = EXPRCONST) and
               (lvalue^.opnd2^.exprType = addressTypeNode) and
               (trunc(lvalue^.opnd2^.exprConst^.cardVal) mod BYTESIZE # 0) then
     	        bitoffset := trunc(lvalue^.opnd2^.exprConst^.cardVal);
     	        lvalue := lvalue^.opnd1;
            elsif (lvalue^.opnd1^.kind = EXPRCONST) and
               (lvalue^.opnd1^.exprType = addressTypeNode) and
               (trunc(lvalue^.opnd1^.exprConst^.cardVal) mod BYTESIZE # 0) then
     	        bitoffset := trunc(lvalue^.opnd1^.exprConst^.cardVal);
     	        lvalue := lvalue^.opnd2;
            end;
        end;
        GenExpr(rhs,EVALGET);		 (* this may set opt temps *)
	GenExpr(lvalue,EVALGET);	 (* that this uses *)
     	Uco2typtyp(Uswp,Adt,MapT(lhstn));
	GenIndirectVar(lhstn,EVALPUT,bitoffset);
    end;
end GenAssign;

procedure GenConstAddress(i : integer);
begin
    assert(i mod BYTESIZE = 0,'bad address in GenConstAddress');
    Ucoldc(Adt,BYTESPERADDR,i div BYTESIZE,NOSTRING);
end GenConstAddress;

procedure GenConstInteger(i : integer);
begin
    Ucoldc(Jdt,BYTESPERWORD,i,NOSTRING);
end GenConstInteger;

procedure GenConstBoolean(b : boolean);
begin
    Ucoldc(MapT(booleanTypeNode),BOOLEANSIZE div BYTESIZE,ord(b),NOSTRING);
end GenConstBoolean;

procedure GenExprCheck(en : ExprNode; mode : EvalMode);
var
    tagFn : FieldNode;
    vn : VariantNode;
    dt : Datatype;
    nextlabel, matchlabel, errlabel, oklabel : LabelNumber;
    csn : ConstSetNode;
    temp, size : integer;
begin
    GenExpr(en^.checkExpr,mode);
    if en^.doCheck then
	case en^.exprCheck of
	| CHECKSUBSCR, CHECKRANGE :
     	    assert(en^.checkType # nil,'bad type in GenExprCheck');
	    dt := MapT(en^.checkType);
            oklabel := NewLabel();
     	    errlabel := NewLabel();
            if (en^.checkLower = 0) and (en^.checkUpper = trunc(MAXINT)) then
     	        Uco1type(Udup,dt);	 (* leave value around *)
	        Ucoldc(Ldt,4,0,NOSTRING);
     	        Uco1type(Ugeq,Jdt);
                Uco1int(Utjp,oklabel);
            else
     	        if en^.checkLower = 0 then
     	        else
                    Uco1type(Udup,dt);		 (* leave value around *)
                    Ucoldc(Jdt,4,en^.checkLower,NOSTRING);
		    if en^.checkUpper < en^.checkLower then
                        Uco1type(Ules,Ldt);
		    else
                        Uco1type(Ules,Jdt);
		    end;
                    Uco1int(Utjp,errlabel);
     	       	end;
                Uco1type(Udup,dt);		 (* leave value around *)
                Ucoldc(Jdt,4,en^.checkUpper,NOSTRING);
	        if en^.checkLower >= 0 then
                    Uco1type(Uleq,Ldt);
	        else
                    Uco1type(Uleq,Jdt);
                end;
                Uco1int(Utjp,oklabel);
            end;
            Ucolab(errlabel,0,0);
            Uco1int(Umst,RTlevel);
            Uco1type(Udup,dt);		 (* just grap a copy *)
            Ucomem(Upar,dt,Pmt,0,0,BYTESPERWORD,0);
            Ucoldc(Jdt,4,en^.checkLower,NOSTRING);
            Ucomem(Upar,Jdt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
            Ucoldc(Jdt,4,en^.checkUpper,NOSTRING);
            Ucomem(Upar,Jdt,Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0);
     	    if en^.exprCheck = CHECKSUBSCR then
     	        GenLibCall(RTERRORSUBSCRIPT,nil,0,3,rt__errorsubscript);
            else
     	        GenLibCall(RTERRORRANGE,nil,0,3,rt__errorrange);
            end;
     	    Ucolab(oklabel,0,0);
	
	| CHECKSUBSCROPEN :
     	    assert(en^.checkType # nil,'bad type in GenExprCheck');
	    dt := MapT(en^.checkType);
            oklabel := NewLabel();
            (* Check that value is < limit (unsigned tests >= 0 also) *)
            Uco1type(Udup,dt);		 (* leave index around *)
	    if en^.checkUpper = 0 then
		GenVar(en^.arrVar,EVALPOINT);
	    else
		GenVar(en^.arrVar,EVALGET);
	    end;
     	    Uco2typint(Uinc,Adt,en^.checkLower div BYTESIZE);
	    GenIndirectVar(cardIntTypeNode,EVALGET,0);
            Uco1type(Ules,Ldt);
            Uco1int(Utjp,oklabel);
	    Uco1int(Umst,RTlevel);
     	    Uco1type(Udup,dt);		 (* just slip that param into place *)
     	    Ucomem(Upar,dt,Pmt,0,0,BYTESPERWORD,0);
	    if en^.checkUpper = 0 then
		GenVar(en^.arrVar,EVALPOINT);
	    else
		GenVar(en^.arrVar,EVALGET);
	    end;
     	    Uco2typint(Uinc,Adt,en^.checkLower div BYTESIZE);
	    GenIndirectVar(cardIntTypeNode,EVALGET,0);
     	    Ucomem(Upar,Ldt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
     	    GenLibCall(RTERRORSUBSCRIPTOPEN,nil,0,2,rt__errorsubscriptopen);
     	    Ucolab(oklabel,0,0);

	| CHECKSUBARRAY :
	    dt := Ldt; (* en^.checkType is nil *);
            oklabel := NewLabel();
            errlabel := NewLabel();
            Uco1type(Udup,dt);		 (* leave value around *)
     	    Ucoldc(Jdt,BYTESPERWORD,0,NOSTRING);
     	    Uco1type(Ules,Jdt);
            Uco1int(Utjp,errlabel);
            Uco1type(Udup,dt);		 (* leave value around *)
            Uco1type(Udup,dt);		 (* for add *)
	    (* already have first count, get subscript and limit *)
	    GenVar(en^.checkVar, EVALGET);
     	    Uco1type(Uadd,dt);
            Uco1type(Ugrt,Jdt);
     	    Uco1int(Utjp,errlabel);
            Uco1type(Udup,dt);		 (* for add *)
	    GenVar(en^.checkVar, EVALGET);
     	    Uco1type(Uadd,dt);
	    if en^.arrVar = nil then
		GenConstInteger(en^.checkLower+1); (* fixed array *)
	    else
		if en^.checkUpper = 0 then	(* open array *)
		    GenVar(en^.arrVar,EVALPOINT);
		else
		    GenVar(en^.arrVar,EVALGET);
		end;
     	       	Uco2typint(Uinc,Adt,en^.checkLower div BYTESIZE);
		GenIndirectVar(cardIntTypeNode,EVALGET,0);
	    end;
            Uco1type(Uleq,Jdt);
            Uco1int(Utjp,oklabel);
     	    Ucolab(errlabel,0,0);        
            Uco1int(Umst,RTlevel);
	    GenVar(en^.checkVar, EVALGET);
            Ucomem(Upar,MapT(en^.checkVar^.varType),Pmt,0,0,BYTESPERWORD,0);
            Uco1type(Udup,dt);
            Ucomem(Upar,dt,Pmt,0,BYTESPERWORD,BYTESPERWORD,0);
	    if en^.arrVar = nil then
		GenConstInteger(en^.checkLower+1); (* fixed array *)
	    else
		if en^.checkUpper = 0 then	(* open array *)
		    GenVar(en^.arrVar,EVALPOINT);
		else
		    GenVar(en^.arrVar,EVALGET);
		end;
     	       	Uco2typint(Uinc,Adt,en^.checkLower div BYTESIZE);
		GenIndirectVar(cardIntTypeNode,EVALGET,0);
	    end;
            Ucomem(Upar,Ldt,Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0);
     	    GenLibCall(RTERRORSUBARRAY,nil,0,3,rt__errorsubarray);
            Ucolab(oklabel,0,0);
	
	| CHECKPTRREF, CHECKDYNARRAY :
	    dt := Adt;			 (* en^.checkType may be nil *)
	    if en^.checkPtr = PTRNOCHECK then
		(* do nothing *)
	    else
     	        oklabel := NewLabel();
		Uco1type(Udup,dt);	 (* leave pointer around *)
		if en^.exprCheck = CHECKPTRREF then
		else
     	            Uco2int(Uilod,Adt,0,BYTESPERADDR);
		end;
		if en^.checkPtr = PTRMODULA then
                    Uco1type(Udup,Adt);
	            Uco2int(Uilod,Adt,-BYTESPERADDR,BYTESPERADDR);
                    Uco1type(Uequ,Adt);
     	            Uco1int(Utjp,oklabel);
		elsif en^.checkPtr = PTRPASCAL then
		    assert(false,"We don't do pascal pointer checks");
		else
		    Ucoldc(Adt,BYTESPERADDR,0,NOSTRING);
     	            Uco1type(Uneq,Adt);
     	       	    Uco1int(Utjp,oklabel);
		end;
     	       	Uco1int(Umst,RTlevel);
     	        Uco1type(Udup,dt);
     	       	Ucomem(Upar,dt,Pmt,0,0,BYTESPERADDR,0);
                GenLibCall(RTERRORADDR,nil,0,1,rt__erroraddr);
     	        Ucolab(oklabel,0,0);
	    end;
	
	| CHECKVARIANT :
	    vn := en^.checkVariant;
	    while vn # nil do
		tagFn := vn^.tagField;
		if tagFn^.offset >= 0 then
		    (* tag field exists, generate tag values *)
     	            Uco1type(Udup,Adt);	 (* leave pointer around *)
     	       	    assert(SizeOf(tagFn^.fieldType) mod BYTESIZE = 0,
     	       	    	   'bad size in CHECKVARIANT');
     	       	    assert(tagFn^.offset mod BYTESIZE = 0,
     	       	    	   'bad offset in CHECKVARIANT');
     	       	    size := SizeOf(tagFn^.fieldType) div BYTESIZE;
     	            GenIlod(Ldt,tagFn^.offset+en^.checkLower,
     	       	    	    SizeOf(tagFn^.fieldType));
	            assert(tagFn^.fieldType # nil,'bad type in GenExprCheck');
     	       	    dt := MapT(tagFn^.fieldType);
     	       	    temp := UcodeTemp(dt,size);
     	       	    Ucomem(Ustr,dt,Mmt,curUcodeBlock,temp,size,0);
     	            matchlabel := NewLabel();
	  	    csn := vn^.tag^.first;
	  	    while csn # nil do
			Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,size,0);
     	       	    	Ucoldc(Ldt,BYTESPERWORD,trunc(OrdOf(csn^.lower)),
     	       	    	       NOSTRING);
	                if (csn^.upper # nil) and 
     	       	    	   (csn^.upper # csn^.lower) then (* range check *)
     	       	    	    nextlabel := NewLabel();
     	       	    	    Uco1type(Ules,Jdt);
     	       	    	    Uco1int(Utjp,nextlabel);
			    Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,size,0);
     	       	    	    Ucoldc(Ldt,BYTESPERWORD,trunc(OrdOf(csn^.upper)),
     	       	    	           NOSTRING);
		            Uco1type(Uleq,Jdt);
     	            	    Uco1int(Utjp,matchlabel); 
     	       	    	    Ucolab(nextlabel,0,0);
     	       	    	else
     	       	    	    Uco1type(Uequ,Ldt);
     	       	    	    Uco1int(Utjp,matchlabel);
	                end;
	       	    	csn := csn^.next;
	       	    end;
		    if vn^.elsePart then (* else variant - want inverse test *)
     	       	        oklabel := NewLabel();
     	       	    	Uco1int(Uujp,oklabel);
     	       	        Ucolab(matchlabel,0,0);
		    end;
     	       	    Uco1int(Umst,RTlevel);
	            Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,size,0);
                    Ucomem(Upar,dt,Pmt,0,0,size,0);
     	       	    GenLibCall(RTERRORVARIANT,nil,0,1,rt__errorvariant);
     	       	    if vn^.elsePart then
     	       	        Ucolab(oklabel,0,0);
                    else
     	       	        Ucolab(matchlabel,0,0);
     	       	    end;
		end;
		vn := tagFn^.containingVariant;
	    end;
	end;
    end;
end GenExprCheck;

procedure GenStmtList(stmts : StmtList);
var
    stn : StmtNode;
    listExited, listReturned : boolean;
begin
    listExited := false;
    listReturned := false;
    if stmts # nil then
	stn := stmts^.first;
	while stn # nil do
	    GenStmt(stn);
	    stn := stn^.next;
	    if (stn # nil) and (exited or returned) then
		GenCounter(stn^.lineNumber,nil);
		listExited := listExited or exited;
		listReturned := listReturned or returned;
		exited := false;
		returned := false;
	    end;
	end;
    end;
    exited := exited or listExited;
    returned := returned or listReturned;
end GenStmtList;

procedure MoveStaticToStack(const vn : VarNode; const tn : TypeNode);
var
    size,temp : integer;
begin
    size := RoundUp(SizeOf(tn),BYTESIZE) div BYTESIZE;
    temp := UcodeTemp(Mdt,size);
    Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp); (* dst *)
    GenVarT(vn,addressTypeNode,EVALGET); (* src *)
    GenMove(tn,0,size);
    GenVarT(vn,addressTypeNode,EVALPOINT);
    Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp);
    GenIndirectVar(addressTypeNode,EVALPUT,0);
end MoveStaticToStack;

procedure MoveDynamicToStack(const vn : VarNode);
var
    temp : integer;
begin
    temp := UcodeTemp(Ldt,BYTESPERWORD);
    Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    (* double word align size *)
    Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    Ucoldc(Ldt,BYTESPERWORD,7,NOSTRING);
    Uco1type(Uadd,Ldt);
    Ucoldc(Ldt,BYTESPERWORD,-8,NOSTRING);
    Uco1type(Uand,Ldt);
    (* allocate space on stack, copy parameter value *)
    Uco0(Uaos);
    Uco1int(Umst,RTlevel);
    GenVarT(vn,addressTypeNode,EVALGET);
    Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0); (* src *)
    Uco0(Uldsp);			 (* dst *)
    Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
    Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    Ucomem(Upar,Ldt,Pmt,0,2*BYTESPERWORD,BYTESPERWORD,0); (* nbytes *)
    GenLibCall(RTBCOPY,nil,0,3,rtbcopy);
    GenVarT(vn,addressTypeNode,EVALPOINT);
    Uco0(Uldsp);
    GenIndirectVar(addressTypeNode,EVALPUT,0);
end MoveDynamicToStack;

procedure GenParamDefs(params : ParamList);
var
    param   : ParamNode;
    atn     : TypeNode;
    i,size  : integer;
    rowSize : MemoryOffset;
    dt      : Datatype;
begin
    param := params^.first;
    while param # nil do
     	case param^.kind of
        | PARAMCONST, PARAMVAR, PARAMVALUE:
     	    if param^.reference then
     	        dt := Adt;
	        size := BYTESPERADDR;
            else
     	        dt := MapT(param^.paramType);
     	        size := RoundUp(SizeOf(param^.paramType),BYTESIZE)
     	       	         div BYTESIZE;
            end;
            Ucomem(Updef,dt,Pmt,genProc^.sym_idn,
     	       	   param^.paramVar^.address.offset div BYTESIZE,size,IN_MODE);
        | PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST:
     	    (* descriptor *)
            if param^.paramType^.descripCount > 0 then
	        dt := Mdt;
            else
                dt := Adt;		 (* just pointer *)
            end;
            Ucomem(Updef,dt,Pmt,genProc^.sym_idn,
     	       	   param^.paramVar^.address.offset div BYTESIZE,
     	       	   param^.paramVar^.address.size div BYTESIZE,IN_MODE);
     	end;
	(* if it is a value open array, must copy it onto stack *)
	if param^.kind = PARAMARRAYVALUE then
	    (* get total number elements in array *)
	    atn := param^.paramType;
	    for i := 1 to param^.paramType^.descripCount do
	        (* point to parameter address *)
	        GenVarT(param^.paramVar,addressTypeNode,EVALPOINT);
     	        Uco2typint(Uinc,Adt,i*BYTESPERADDR);
		(* get count *)
		GenIndirectVar(cardIntTypeNode,EVALGET,0);
		if i > 1 then
		    (* multiply by previous values *)
     	       	    Uco1type(Umpy,Ldt);
		end;
		rowSize := atn^.elementSize;
		atn := atn^.elementType;
	    end;
	    GenConstAddress(rowSize);
	    (* multiply by element size *)
     	    Uco1type(Umpy,Ldt);
            MoveDynamicToStack(param^.paramVar);
	elsif (param^.kind = PARAMVALUE) and param^.reference then
     	    MoveStaticToStack(param^.paramVar,param^.paramType);
	end;
	param := param^.next;
    end;
end GenParamDefs;

procedure GenGlobalProc(proc: ProcNode);
var
    submod : ModuleNode;
    oklabel : LabelNumber;
begin
    if proc^.initFlagVar # nil then
	GenVar(proc^.initFlagVar,EVALGET);
	oklabel := NewLabel();
        Uco1int(Ufjp,oklabel);
        Uco0(Uret);
        Ucolab(oklabel,0,0);
	GenConstBoolean(true);
	GenVar(proc^.initFlagVar,EVALPUT);
    end;
    if genCountFlag then
	GenOp(PCCTS); (*C('i'); EndLine;*)
    end;

    (* generate initialization calls if this is global proc *)
    submod := globalModule^.modules^.first;
    while (submod # nil) do
	if (submod^.kind = MODDEFINITION) and 
		submod^.doinit and not submod^.noinit then
            Uco1int(Umst,RTlevel);
     	    CopyString(submod^.name,theCharArray);
     	    strings.Append(theCharArray,'_');
     	    strings.Append(theCharArray,MODULEINITNAME);
	    GenCall(procTypeNode,0,
     	       	    MipSym.GlobalText(theCharArray,NOPCODEBLOCK),
     	       	    RTlevel,nil);
	end;
	submod := submod^.next;
    end;
end GenGlobalProc;

procedure GenProcEntry(proc : ProcNode);
var
    numParams,level,attr,i : integer;
    param : ParamNode;
    parent : ProcNode;
    dt : Datatype;
$if pascal then
    vn  : VarNode;
    fvn : FileVarNode;
$end

begin
    genProc := proc;
    if (genProc = globalProc) or (not genProc^.containsProcs) then
        StabProc(genProc);		 (* let leaves do the work  *)
    end; (* and top Root *)
    StabProcEntry(genProc);
    curUcodeBlock := genProc^.sym_idn;
    if genProc^.procType^.funcType = nil then
        dt := Pdt;
    elsif ReferenceByPoint(genProc^.procType^.funcType) then
        dt := Adt;
    else
        dt := MapT(genProc^.procType^.funcType);
    end;
    if proc = globalProc then
        if proc^.globalName = nil then
            level := 1;
        else
            level := 2;
        end;
    else
        level := genProc^.displayLevel; 
    end;
    currLevel := level;
    numParams := 0;
    if genProc^.procType^.paramList # nil then
	param := genProc^.procType^.paramList^.first;
	while param # nil do
     	    case param^.kind of 
            | PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST:
     	        inc(numParams,param^.paramType^.descripCount + 1);
            | PARAMCONST, PARAMVAR, PARAMVALUE:
	        inc(numParams);
            end;
	    param := param^.next;
	end;
    end;
    if (genProc # globalProc) and ((genProc^.extern = GSPRIVATE)
	       	    	      	     or (genProc^.internalProc)) then
        attr := 0;
    else
        attr := EXTERNAL_ATTR;
    end;
    if genProc^.usesFP then
        inc(attr,FRAMEPTR_ATTR);
    end;
    Ucoloc(MipSym.symFileNumber,proc^.lineNumber);
    UcoProc(Uent,dt,level,curUcodeBlock,numParams,ord(dt # Pdt),attr);
    if (proc = globalProc) and (proc^.globalName = nil) then
        Ucomment(MAINPROGNAME);
	Ucomem(Updef,Jdt,Pmt,curUcodeBlock,0,BYTESPERWORD,IN_MODE);
    	Ucomem(Updef,Adt,Pmt,curUcodeBlock,4,BYTESPERADDR,IN_MODE);
     	Ucomem(Updef,Adt,Pmt,curUcodeBlock,8,BYTESPERADDR,IN_MODE);
        genProc^.mem[MEMPARAM].maximum := 12 * BYTESIZE;
     	Uco1int(Umst,RTlevel);
     	Ucomem(Ulod,Jdt,Pmt,curUcodeBlock,0,BYTESPERWORD,0);
     	Ucomem(Upar,Jdt,Pmt,0,0,BYTESPERWORD,0);
     	Ucomem(Ulod,Adt,Pmt,curUcodeBlock,BYTESPERWORD,BYTESPERADDR,0);
     	Ucomem(Upar,Adt,Pmt,0,BYTESPERWORD,BYTESPERADDR,0);
     	Ucomem(Ulod,Adt,Pmt,curUcodeBlock,2*BYTESPERWORD,4,0);
     	Ucomem(Upar,Adt,Pmt,0,2*BYTESPERWORD,BYTESPERADDR,0);
     	UcoProc(Ucup,Pdt,RTlevel,MipSym.GlobalText(RTINIT,ord(rt__init)),
     	        3,0,0);
    else
        if (proc # globalProc) and ((proc^.extern = GSPRIVATE) 
     	       	    	      	    or proc^.internalProc) then
     	    CopyString(genProc^.name,theCharArray);
        else
     	    CopyString(genProc^.globalName,theCharArray);
        end;
        Ucomment(theCharArray);
    end;
    (* Round to word boundary *)
    genProc^.mem[MEMNORMAL].maximum := (* normalize *)
     	  RoundUp(genProc^.mem[MEMNORMAL].maximum,WORDSIZE);
    ucoLocalBytes := genProc^.mem[MEMNORMAL].maximum div BYTESIZE;
    ucoFastLocalBytes := genProc^.mem[MEMFAST].maximum div BYTESIZE;
    numFast := ucoFastLocalBytes div BYTESPERWORD;
    ucoOptTempBytes := 0;
    if genProc^.tempMap # nil then
        ucoOptTempBytes := genProc^.tempMap^.numReg * BYTESPERWORD;
    end;
    if ucoFastLocalBytes > 0 then
        if (curFastTypes = nil) or (Number(curFastTypes) < numFast) then
            new(curFastTypes,max(numFast,NUMOPTTEMPS));
        end;
        for i := 0 to numFast-1 do
            curFastTypes^[i] := Zdt;
        end;
    end;
    if ucoOptTempBytes > 0 then
        if (curOptTempTypes = nil) or
           (Number(curOptTempTypes) < genProc^.tempMap^.numReg) then
            new(curOptTempTypes,max(proc^.tempMap^.numReg,NUMOPTTEMPS));
        end;
        for i := 0 to genProc^.tempMap^.numReg-1 do
            curOptTempTypes^[i] := Zdt;
        end;
    end;
    ucoTempBytes := 0;
    (* Handle Ulex *)
    if level > 2 then
        parent := genProc^.enclosing;
        for i := level-1 to 2 by -1 do
     	    Uco2intint(Ulex,i,parent^.sym_idn);
     	    parent := parent^.enclosing;
        end;
        Ucomem(Ulod,Adt,Rmt,0,8,BYTESPERADDR,0);
        Ucomem(Ustr,Adt,Mmt,curUcodeBlock,STATICLINK,BYTESPERADDR,0);
    end;
    if proc^.tailRecursion then
	proc^.tailRecursionEntry := NewLabel();
	Ucolab(proc^.tailRecursionEntry,0,0);
    end;
    if (proc^.procType^.funcType # nil) and 
	ReferenceByPoint(proc^.procType^.funcType) then
        Ucomem(Updef,Adt,Pmt,curUcodeBlock,0,BYTESPERADDR,0);
    end;
    (* may include param copies that require tailRecursion repeat *)
    if proc^.procType^.paramList # nil then
	GenParamDefs(proc^.procType^.paramList);
    end;
    Ucodef(Pmt,genProc^.mem[MEMPARAM].maximum div BYTESIZE);
    if proc = globalProc then
	GenGlobalProc(proc);
    end;
$if pascal then
    if proc = globalProc then       (* special Pascal entry code *)
	GenOp(PCMST); I(1);
        if mipsFlag then X; I(0); end; EndLine;
	GenConstInteger(ord(proc^.doCheck));
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('PCSTART', nil, 0, 1);
	if bufferFlag # 1 then	(* File output buffering option *)
	    GenOp(PCMST); I(1);
            if mipsFlag then X; I(0); end; EndLine;
	    GenConstInteger(bufferFlag);
	    GenOp(PCPAR); I(0); EndLine;
	    GenLibCall('BUFF', nil, 0, 1);
	end;
	if programFileVarList # nil then
	    fvn := programFileVarList^.first;
	    while fvn # nil do
		(* DEFNAME(file, name, namelength, datasize) *)
		vn := fvn^.fileVar;
		GenOp(PCMST); I(4);
                if mipsFlag then X; I(0); end; EndLine;
		GenVarT(vn, vn^.varType, EVALPOINT);
		GenOp(PCPAR); I(0); EndLine;
		GenExprString(MakeExprConstString(vn^.name), EVALPOINT);
		GenOp(PCPAR); I(1); EndLine;
		GenConstInteger(vn^.name^.length);
		GenOp(PCPAR); I(2); EndLine;
		if vn^.varType^.isTextFile then
		    GenConstInteger(0);
		else
		    GenConstInteger(
		       (SizeOf(vn^.varType^.fileType)+BYTESIZE-1) div BYTESIZE);
		end;
		GenOp(PCPAR); I(3); EndLine;
		GenLibCall('DEFNAME', nil, 0, 4);
		fvn := fvn^.next;
	    end (* while *);
	end (* if files declared in program header *);
    end (* if proc = globalProc *);
    if proc^.OOBLabelList # nil then (* Save state for OOB goto *)
	GenOp(PCSST); EndLine;
    end;
$end
end GenProcEntry;

procedure GenProcExit(proc : ProcNode);
begin
$if pascal then
    if proc = globalProc then   (* special Pascal exit code *)
	GenOp(PCMST); I(1);
        if mipsFlag then X; I(0); end; EndLine;
	GenConstInteger(0);
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('PCEXIT', nil, 0, 1);
    elsif proc^.containsFiles then
	GenOp(PCMST); I(1);
        if mipsFlag then X; I(0); end; EndLine;
	GenOp(PCLDA);	  (* Gross hack to load ap on stack *)
	I(WORDSIZE); X;    (* Size *)
	I(0); X;	    (* Relative display level *)
	C('p'); X;	    (* Parameter memory *)
	I(-WORDSIZE); X;   (* Offset from # params passed *)
	I(proc^.block); (* Block # *)
	EndLine;
	GenOp(PCPAR); I(0); EndLine;
	GenLibCall('PCLOSE', nil, 0, 1);
    end;
$end	   
    if (proc = globalProc) and (proc^.globalName = nil) then
        Uco1int(Umst,RTlevel);
        GenConstInteger(0);
     	Ucomem(Upar,Jdt,Pmt,0,0,BYTESPERWORD,0);
	GenLibCall(RTTERM, nil, 0, 1, rt__term);
    elsif proc^.procType^.funcType = nil then
        Uco0(Uret);
    else
$if modula2 then
     	Uco1int(Umst,RTlevel);
        GenLibCall(RTERRORNORETURN,nil,0,0,rt__errornoreturn);
$else (* pascal *)
	(* Load and return proc^.returnVar *)
	GenVar(proc^.returnVar, EVALGET);
	GenOpTL(PCRET, proc^.procType^.funcType);
$end
    end;
(*    if curOptTempTypes # nil then
(*        dispose(curOptTempTypes);*)
(*     	curOptTempTypes := nil; possible re-use *)
    end;*)
    Ucodef(Mmt,ucoLocalBytes+ucoFastLocalBytes+ucoOptTempBytes+ucoTempBytes);
    Uco1int(Uend,StabProcExit(proc));
end GenProcExit;

procedure GenProc(proc : ProcNode);
var
    code : CodeNode;
    counted : boolean;
$if pascal then
    vn  : VarNode;
    fvn : FileVarNode;
$end

begin
    currFile := proc^.fileName;
    currLine := proc^.lineNumber;
    counted := false;
    InitTemps;
    GenProcEntry(proc);
    returned := false;
    exited := false;
    exitLevel := 1000;
    code := proc^.code^.first;
    while code # nil do
	if not counted and (code^.stmts # nil) then
	    if code^.stmts^.first # nil then
		GenCounter(proc^.lineNumber,code^.stmts);
		counted := true;
	    end;
	end;
	GenStmtList(code^.stmts);
	code := code^.next;
    end;
    GenProcExit(proc);
end GenProc;
(*
procedure recurseGenProc(proc : ProcNode); (* put things backward for now *)
var
    submod : ModuleNode;
    code : CodeNode;
begin
    if proc = nil then return;
    else recurseGenProc(proc^.next); end;
            if (proc^.builtin # BIPNOTBIP) or proc^.inlineProc
$if pascal then
		    (* No main prog code for compiles with no PROGRAM decl *)
		    or ((proc = globalProc) and (proc^.name # nil))
$end
	    then
		(* no code generation *)
$if modula2 then
	    elsif (proc = globalProc) and (proc^.enclosingModule^.noinit) then
		(* No code for NOINIT module body *)
		code := proc^.code^.first;
		while code # nil do
		    assert((code^.stmts = nil) or (code^.stmts^.first = nil),
			'Init code for NOINIT module?');
		    code := code^.next;
		end;
		submod := globalModule^.modules^.first;
		while (submod # nil) do
		    if (submod^.kind = MODDEFINITION) then
			assert(submod^.noinit, 'Import init to NOINIT module?');
		    end;
		    submod := submod^.next;
		end;
$end
	    else
		GenProc(proc);
	    end;
end recurseGenProc;
*)

procedure GenComs(gvn : GlobalVarNode);
begin
    while gvn # nil do
        GenGlobal(gvn);
	gvn := gvn^.next;
    end;
end GenComs;

procedure GenModule (theModule : ModuleNode);
var
    proc : ProcNode;
    submod : ModuleNode;
    code : CodeNode;
begin
    if theModule^.kind # MODDEFINITION then
	if theModule # globalModule then
	    if theModule^.enclosing = globalModule then
		StabGlobalPort;
	    end;
	end;
	submod := theModule^.modules^.first;
	while submod # nil do
	    GenModule(submod);
	    submod := submod^.next;
	end;
	proc := theModule^.procs^.first;
	while proc # nil do
	    if (proc^.builtin # BIPNOTBIP) or proc^.inlineProc
$if pascal then
		    (* No main prog code for compiles with no PROGRAM decl *)
		    or ((proc = globalProc) and (proc^.name # nil))
$end
	    then
		(* no code generation *)
$if modula2 then
	    elsif (proc = globalProc) and (proc^.enclosingModule^.noinit) then
		(* No code for NOINIT module body *)
		code := proc^.code^.first;
		while code # nil do
		    assert((code^.stmts = nil) or (code^.stmts^.first = nil),
			'Init code for NOINIT module?');
		    code := code^.next;
		end;
		submod := globalModule^.modules^.first;
		while (submod # nil) do
		    if (submod^.kind = MODDEFINITION) then
			assert(submod^.noinit, 'Import init to NOINIT module?');
		    end;
		    submod := submod^.next;
		end;
$end
	    else
		GenProc(proc);
	    end;
	    proc := proc^.next;
	end;
    end;
end GenModule;

procedure GenStmtAssign(stn : StmtNode);
begin
(* |||
    if stn^.assignSizeCheck # nil then
	(* Check that string fits into dynamic array *)
	GenExpr(stn^.assignSizeCheck, EVALGET);
	(* Throw away top of stack *)
        Uco1type(Upop,MapT(stn^.assignSizeCheck^.exprType));
    end;
*)
    if stn^.assignOp = TKASSIGN then
	GenAssign(stn^.lhs,stn^.rhs,stn^.lhsType);
    else
	GenExpr(stn^.rhs^.opnd1^.exprVal,EVALPOINT);
     	Uco1type(Udup,Adt);
     	GenIndirectVar(stn^.lhsType,EVALGET,0);
	GenExpr(stn^.rhs^.opnd2,EVALGET);
	case stn^.assignOp of
	| TKPLUS	    : Uco1type(Uadd,MapT(stn^.lhsType));
	| TKASTERISK    : Uco1type(Umpy,MapT(stn^.lhsType));
	| TKMINUS       : Uco1type(Usub,MapT(stn^.lhsType));
	| TKDIV, 
	  TKSLASH       : Uco1type(Udiv,MapT(stn^.lhsType));
	end;
     	GenIndirectVar(stn^.lhsType,EVALPUT,0);
    end;
end GenStmtAssign;

procedure GenParamList(procType : TypeNode; procVariable : ExprNode;
	params : ExprList; const level : integer;
        returnExpr : ExprNode) : integer;
var
    pn		  : ParamNode;
    pen, den	  : ExprNode;
    numParams     : integer;
    alignment,size: integer;
    i,parOffset,temp : integer;
    dt            : Datatype;
    structReturn  : boolean;
begin
    parOffset := 0;
    numParams := 0;
    Uco1int(Umst,level);
    (* If this ever becomes a GenExpr then worry about the fact that
       OCount assumes parameters referenced before lvalue *)
    structReturn := (procType^.funcType # nil) and 
	  	    ReferenceByPoint(procType^.funcType);
    if structReturn then
     	inc(parOffset,BYTESPERADDR);
     	inc(numParams);
    end;
    if (procType^.paramList = nil) or (procType^.paramList^.first = nil) then
    else
	(* Now actually evaluate and push the arguments *)
	pen := params^.first;
	pn := procType^.paramList^.first;
	while (pn # nil) and (pen # nil) do
            if pn^.paramVar # nil then
     	        parOffset := pn^.paramVar^.address.offset div BYTESIZE;
            end;
	    case pn^.kind of
	    | PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST :
		GenExpr(pen^.descripBase, pen^.descripMode);
                Ucomem(Upar,Adt,Pmt,0,parOffset,BYTESPERADDR,0);
     	        inc(parOffset,BYTESPERWORD);
     	        inc(numParams);
		assert(pn^.paramType^.descripCount = pen^.descripCount,
		    'Bad descripCount match in GenParamList');
		den := pen^.descrips^.first;
		for i := 1 to pn^.paramType^.descripCount do
		    GenExpr(den, EVALGET);
                    Ucomem(Upar,Ldt,Pmt,0,parOffset,BYTESPERWORD,0);
		    den := den^.next;
     	            inc(numParams);
     	       	    inc(parOffset,BYTESPERWORD);
		end;
	    | PARAMVAR, PARAMVALUE, PARAMCONST :
		if pn^.reference then
		    GenExpr(pen,EVALPOINT);
     	       	    dt := Adt; 
     	            size := BYTESPERADDR;
                    alignment := BYTESPERADDR;
		else
		    GenExpr(pen,EVALGET);
		    dt := MapT(pn^.paramType);
     	            size := (SizeOf(pn^.paramType)+BYTESIZE-1) div BYTESIZE;
                    alignment := (AlignmentOf(pn^.paramType)+BYTESIZE-1)
     	       	    	          div BYTESIZE;
		end;
     	        if ((parOffset mod alignment) # 0) then
     	       	    parOffset := RoundUp(parOffset,alignment);
                end;
                Ucomem(Upar,dt,Pmt,0,parOffset,size,0);
     	        inc(numParams);
     	        inc(parOffset,RoundUp(size,BYTESPERWORD));
	    end;
	    pen := pen^.next;
	    pn := pn^.next;
	end;
    end;
    if procVariable <> nil then
	(* invocation of procedure variable, make it last parameter *)
	GenExpr(procVariable,EVALGET);
    end;
    if structReturn then
        if returnExpr = nil then
            size := RoundUp(SizeOf(procType^.funcType),BYTESIZE) div BYTESIZE;
            temp := UcodeTemp(Mdt,size);
            Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp);
        else
     	    GenExpr(returnExpr,EVALPOINT);
        end;
     	Ucomem(Upar,Adt,Pmt,0,0,BYTESPERADDR,0);
    end;
    return numParams;
end GenParamList;

procedure GenCall(procType : TypeNode; 
		  const numParams, procBlock, procLevel : integer;
     	       	  returnExpr : ExprNode);
var dt : Datatype;
    ignore : integer;
begin
    if procLevel # RTlevel then
     	if procLevel <= currLevel then
            ignore := GenStaticLink(procLevel-1);
        else
            ignore := GenStaticLink(procLevel);
        end;
        Ucomem(Ustr,Adt,Rmt,0,8,BYTESPERADDR,0);
    end;
    if (procType^.funcType = nil) or (returnExpr # nil) then
        dt := Pdt;
    elsif ReferenceByPoint(procType^.funcType) then
        dt := Adt;
    else
        dt := MapT(procType^.funcType);
    end;
    UcoProc(Ucup,dt,procLevel,procBlock,numParams,ord(dt # Pdt),0);
    if dt # Pdt then
        GenReturnValue(procType^.funcType,SizeOf(procType^.funcType));
    end;
end GenCall;

procedure GenTailRecursion(proc : ProcNode; params : ExprList);
const
    MAXTAILPARAMS = 50;	(* maximum number of parameters *)
var
    pn        : ParamNode;
    pen, en   : ExprNode;
    pnum      : integer;
    temps     : array [1..MAXTAILPARAMS] of integer;
begin
    if (params # nil) and (proc^.procType^.paramList # nil) then
	(* first evaluate all parameters (except those that are the same) *)
	pn := proc^.procType^.paramList^.first;
	pen := params^.first;
	pnum := 0;
	while pn # nil do
	    pnum := pnum + 1;
	    case pn^.kind of
	    | PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST :
		ExprError(pen, 'Tail recursion with open array?');
	    
	    | PARAMVAR :
		en := pen;
		if en^.kind = EXPRVAL then
		    (* By reference has EXPRVAL over it, so move down *)
		    en := en^.exprVal;
		end;
		if (en^.kind = EXPRVAR) and (en^.exprVar = pn^.paramVar) then
		    temps[pnum] := 0;
		else
		    GenExpr(pen, EVALPOINT);
		    temps[pnum] := UcodeTemp(Adt,BYTESPERADDR);
     	       	    Ucomem(Ustr,Adt,Mmt,curUcodeBlock,temps[pnum],BYTESPERADDR,
     	       	    	   0);
		end;
	    
	    | PARAMVALUE, PARAMCONST :
		en := pen;
		if en^.kind = EXPRCHECK then
		    en := en^.checkExpr;
		end;
		if (en^.kind = EXPRVAL) and (en^.exprVal^.kind = EXPRVAR) and
			(en^.exprVal^.exprVar = pn^.paramVar) then
		    temps[pnum] := 0;
		else
		    GenExpr(pen, EVALGET);
		    temps[pnum] := UcodeTemp(MapT(pen^.exprType),
     	       	    	      	   	   SizeOf(pen^.exprType) div BYTESIZE);
     	       	    Ucomem(Ustr,MapT(pen^.exprType),Mmt,curUcodeBlock,
     	       	    	   temps[pnum],SizeOf(pen^.exprType) div BYTESIZE,0)
		end;
	    end;
	    pen := pen^.next;
	    pn := pn^.next;
	end;
	(* now store them into the parameter list *)
	pn := proc^.procType^.paramList^.first;
	pen := params^.first;
	pnum := 0;
	while pn # nil do
	    pnum := pnum + 1;
	    case pn^.kind of
	    | PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST :
	    
	    | PARAMVAR :
		if temps[pnum] # 0 then
     	       	    Ucomem(Ulod,Adt,Mmt,curUcodeBlock,temps[pnum],BYTESPERADDR,
     	       	    	   0);
		    GenVarT(pn^.paramVar, addressTypeNode, EVALPUT);
		end;
	    
	    | PARAMVALUE, PARAMCONST :
		if temps[pnum] # 0 then
     	       	    Ucomem(Ulod,MapT(pen^.exprType),Mmt,curUcodeBlock,
     	       	    	   temps[pnum],SizeOf(pen^.exprType) div BYTESIZE,0);
		    GenVar(pn^.paramVar, EVALPUT);
		end;
	    end (* case *);
	    pen := pen^.next;
	    pn := pn^.next;
	end;
    end;
    Uco1int(Uujp,proc^.tailRecursionEntry);
end GenTailRecursion;

procedure GenChangeType(en : ExprNode; tn : TypeNode; mode : EvalMode);
var 
    dt,dt2 : Datatype;
    size, size2, temp : integer;
begin
    if (mode = EVALGET) and ReferenceByPoint(tn) and 
       (AlignmentOf(en^.exprType) # ALIGNMENTUNSPECIFIED) and
       (AlignmentOf(tn) <= AlignmentOf(en^.exprType)) then
        mode := EVALPOINT;
    end;
    GenExpr(en,mode);
    if mode = EVALGET then
        dt := MapT(en^.exprType);
        size := RoundUp(SizeOf(en^.exprType),BYTESIZE) div BYTESIZE;
        dt2 := MapT(tn);
        size2 := RoundUp(SizeOf(tn),BYTESIZE) div BYTESIZE;
     	if (dt = Mdt) and (dt2 # Mdt) then
            dt := Ldt;
            GenIlod(dt,0,size2*BYTESIZE);
        elsif (dt # Mdt) and (dt2 = Mdt) then
     	    (* don't virtualize *)
     	    temp := UcodeTemp(Mdt,max(size,size2)); 
     	    Ucomem(Ustr,dt,Mmt,curUcodeBlock,temp,size,0);
     	    Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp);
        elsif dt2 = Fdt then		 (* for uopt *)
            Uco2typtyp(Ucvt,Fdt,dt);
        elsif dt2 # Mdt then
     	    if (not (dt in DataTypeSet {Adt, Jdt, Ldt})) or 
     	       (not (dt2 in DataTypeSet {Adt, Jdt, Ldt})) then
     	        assert(size <= BYTESPERWORD,'Src too big in GenChangeType');
		assert(size2 <= BYTESPERWORD,'Tgt too big in GenChangeType');
     	        (* don't virtualize *)
     	        temp := UcodeTemp(Mdt,BYTESPERWORD);
		(* Clear work space *)
     	        Ucoldc(Ldt,BYTESPERWORD,0,NOSTRING);
     	        Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
     	        GenStr(dt,Mmt,temp*BYTESIZE,size*BYTESIZE,1,curUcodeBlock);
     	        GenLod(dt2,Mmt,temp*BYTESIZE,size2*BYTESIZE,1,curUcodeBlock);
            end;
        end;
(*    elsif not ReferenceByPoint(en^.exprType) then
        temp := UcodeTemp(Mdt,size);
     	Ucomem(Ustr,dt,Mmt,curUcodeBlock,temp,size,0);
     	Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp);*)
    end;
end GenChangeType;

procedure GenFuncProc(procExpr    : ExprNode; 
		      params	  : ExprList; 
		      selected    : boolean;
		      addrOfValue : VarNode;
		      mode        : EvalMode;
     	       	      returnExpr  : ExprNode);
var
    proc : ProcNode;
    numParams : integer;
    dt : Datatype;

begin
    if (procExpr^.kind = EXPRSYM) and (procExpr^.exprSym^.kind = SYMTYPE) then
        GenChangeType(params^.first,procExpr^.exprSym^.symType,mode);
     	if returnExpr # nil then
     	    GenExpr(returnExpr,EVALPOINT);
     	    Uco2typtyp(Uswp,Adt,Adt);
     	    GenMove(procExpr^.exprSym^.symType,
     	       	    max(AlignmentOf(procExpr^.exprSym^.symType),
     	       	        AlignmentOf(params^.first^.exprType)),0);
	end;
	return;
    elsif procExpr^.kind # EXPRCONST then
	numParams := GenParamList(procExpr^.exprType,procExpr,params,0,
     	       	    	          returnExpr);
	if (procExpr^.exprType^.funcType = nil) or (returnExpr # nil) then
	    dt := Pdt;
        elsif ReferenceByPoint(procExpr^.exprType^.funcType) then
            dt := Adt;
        else
	    dt := MapT(procExpr^.exprType^.funcType);
	end;
        Ucoicuf(dt,numParams,ord(dt # Pdt),0);
        if dt # Pdt then
            GenReturnValue(procExpr^.exprType^.funcType,
     	       	    	   SizeOf(procExpr^.exprType^.funcType));
        end;
    else
	proc := procExpr^.exprConst^.procVal;
	if proc^.builtin # BIPNOTBIP then
	    GenBuiltin(proc,params);
	else
	    if optimFlag and procExpr^.opt^.tailRecursion then
		GenTailRecursion(proc,params);
	    else
		numParams := GenParamList(proc^.procType,nil,params,
     	       	    	      	   	  proc^.displayLevel,returnExpr);
                StabCheckProcRef(proc);
		GenCall(proc^.procType,numParams,proc^.sym_idn,
     	       	        proc^.displayLevel,returnExpr);
	    end;
	end;
    end;
    if selected then
	if addrOfValue = nil then
	else
     	    assert(false, 'Should never get here');
	    (* Store value away, then load pointer to it *)
	    GenVarT(addrOfValue, procExpr^.exprType^.funcType, EVALPUT);
	    GenVarT(addrOfValue, procExpr^.exprType^.funcType, EVALPOINT);
	end;
    end;
end GenFuncProc;

procedure @inline GenStmtProc(const stn : StmtNode);
begin
    GenFuncProc(stn^.proc,stn^.params, false, nil, EVALGET,nil);
end GenStmtProc;


procedure GenStmtIf(stn : StmtNode);
var
    elseLabel, endLabel : LabelNumber;
    elsePresent : boolean;
begin
    elsePresent := stn^.elseList # nil;
    if elsePresent then
	elsePresent := stn^.elseList^.first # nil;
    end;
    endLabel := NewLabel();
    if elsePresent then
	elseLabel := NewLabel();
	GenCondition(stn^.ifCond,NULLLABEL,elseLabel);
	GenCounter(stn^.lineNumber,stn^.thenList);
	GenStmtList(stn^.thenList);
	Uco1int(Uujp,endLabel);
	Ucolab(elseLabel,0,0);
	GenCounter(stn^.lineNumber,stn^.elseList);
	GenStmtList(stn^.elseList);
    else
	GenCondition(stn^.ifCond,NULLLABEL,endLabel);
	GenCounter(stn^.lineNumber,stn^.thenList);
	GenStmtList(stn^.thenList);
    end;
    Ucolab(endLabel,0,0);
end GenStmtIf;

procedure GenCaseTable(tree : CaseTreeNode; minval, maxval : HugeInteger;
	elseLabel : LabelNumber);
var
    i : HugeInteger;
begin
    if tree = nil then
	i := minval;
	while i <= maxval do
	    Uco1int(Uujp,elseLabel);
	    i := i + 1.0;
	end;
    else
	GenCaseTable(tree^.lower,minval,tree^.first-1.0,elseLabel);
	i := tree^.first;
	while i <= tree^.last do
	    Uco1int(Uujp,tree^.caseNode^.pcodeLabel);
	    i := i + 1.0;
	end;
	GenCaseTable(tree^.higher,tree^.last+1.0,maxval,elseLabel);
    end;
end GenCaseTable;

procedure GenStmtCase(stn : StmtNode);
var
    caseNode : CaseNode;
    elseLabel, table, bottom : LabelNumber;
    node : CaseTreeNode;
    minval, maxval : HugeInteger;
    min,max : integer;
begin
    if stn^.cases = nil then
	(* Just generate selector, throw it away, then execute check or
	   the else statement. *)
	GenExpr(stn^.caseSel, EVALGET);
	(* Throw away top of stack *)
        Uco1type(Upop,MapT(stn^.caseSel^.exprType));
	if stn^.caseElse = nil then
	    if stn^.caseSel^.doCheck then
     	        Uco1int(Umst,RTlevel);
     	        GenLibCall(RTERRORCASE,nil,0,0,rt__errorcase);
	    end;
	else
	    GenCounter(stn^.lineNumber,stn^.caseElse);
	    GenStmtList(stn^.caseElse);
	end;
    else (* Normal situation, non-empty case *)
	bottom := NewLabel();
        if (stn^.caseElse # nil) or stn^.caseSel^.doCheck then
	    elseLabel := NewLabel();
        else
     	    elseLabel := bottom;
        end;
	table := NewLabel();
	node := stn^.caseTree;
	repeat
	    minval := node^.first;
	    node := node^.lower;
	until node = nil;
	node := stn^.caseTree;
	repeat
	    maxval := node^.last;
	    node := node^.higher;
	until node = nil;
	GenExpr(stn^.caseSel,EVALGET);
        min := trunc(minval);
        max := trunc(maxval);
        if min # 0 then (* Borrowed from GenT.mod *)
            Ucoldc(MapT(stn^.caseSel^.exprType),BYTESPERWORD,min,
     	       	   NOSTRING);
     	    Uco1type(Usub,MapT(stn^.caseSel^.exprType));
     	    max := max - min;
     	    min := 0;
        end;
        Ucoxjp(MapT(stn^.caseSel^.exprType),table,elseLabel,min,max);
	caseNode := stn^.cases^.first;
	while caseNode # nil do
	    caseNode^.pcodeLabel := NewLabel();
	    caseNode := caseNode^.next;
        end;
	Uco2intint(Uclab,table,max+1);	 (* Noone will ever jump here! *)
	GenCaseTable(stn^.caseTree,minval,maxval,elseLabel);
	if (stn^.caseElse = nil) and stn^.caseSel^.doCheck then
     	    (* let this be part of CASE *)
	    Ucolab(elseLabel,0,0);
     	    Uco1int(Umst,RTlevel);
     	    GenLibCall(RTERRORCASE,nil,0,0,rt__errorcase);
        end;
	caseNode := stn^.cases^.first;
	while caseNode # nil do
	    Ucolab(caseNode^.pcodeLabel,0,0);
	    GenCounter(stn^.lineNumber,caseNode^.stmts);
	    GenStmtList(caseNode^.stmts);
	    Uco1int(Uujp,bottom);
	    caseNode := caseNode^.next;
	end;
	if stn^.caseElse # nil then
	    Ucolab(elseLabel,0,0);
	    GenCounter(stn^.lineNumber,stn^.caseElse);
	    GenStmtList(stn^.caseElse);
	    Uco1int(Uujp,bottom);
	end;
	Ucolab(bottom,0,0);		 (* This has to be after jump table *)
                                         (* or else *)
     	       	    	      	         (* Ugen will look at jump table as *)
     	       	    	      	   	 (* part of normal control flow *)
    end;
end GenStmtCase;

procedure GenPrePostEval(el : ExprList;state : EvalState);
var
    en : ExprNode;
begin
    if el = nil then
	(* do nothing *)
    else
	en := el^.first;
	while en # nil do
	    OptGenExpr(en,EVALGET,state);
	    en := en^.next;
	end;
    end;
end GenPrePostEval;

procedure GenStmtWhile(stn : StmtNode);
var
    top, bottom : LabelNumber;
    save : ExitInfo;
begin
    top := NewLabel();
    bottom := NewLabel();
    save := whileExit;
    whileExit.exitLabel := bottom;
    whileExit.loopLevel := loopNestLevel;

    GenCondition(stn^.whileCond,NULLLABEL,bottom);
    GenPrePostEval(stn^.whilePreEval,EVALPRE);
    Ucolab(top,0,0);

    GenCounter(stn^.lineNumber,stn^.whileBody);

    loopNestLevel := loopNestLevel + 1;
    GenStmtList(stn^.whileBody);
    loopNestLevel := loopNestLevel - 1;

    GenCondition(stn^.whileCond,top,NULLLABEL);

    Ucolab(bottom,0,0);

    GenPrePostEval(stn^.whilePreEval,EVALPOST);
    whileExit := save;
    if exitLevel > loopNestLevel then
	exited := false;
	exitLevel := 1000;
    end;
end GenStmtWhile;


procedure GenStmtRepeat(stn : StmtNode);
var
    top, bottom : LabelNumber;
    save : ExitInfo;
begin
    top := NewLabel();
    bottom := NewLabel();
    save := repeatExit;
    repeatExit.exitLabel := bottom;
    repeatExit.loopLevel := loopNestLevel;

    GenPrePostEval(stn^.repeatPreEval,EVALPRE);

    Ucolab(top,0,0);

    GenCounter(stn^.lineNumber,stn^.repeatBody);

    loopNestLevel := loopNestLevel + 1;
    GenStmtList(stn^.repeatBody);
    loopNestLevel := loopNestLevel - 1;

    GenCondition(stn^.repeatCond,NULLLABEL,top);

    Ucolab(bottom,0,0);

    GenPrePostEval(stn^.repeatPreEval,EVALPOST);

    repeatExit := save;
    if exitLevel > loopNestLevel then
	exited := false;
	exitLevel := 1000;
    end;
end GenStmtRepeat;


procedure GenStmtLoop(stn : StmtNode);
var
    top, bottom : LabelNumber;
    save : ExitInfo;
begin
    top := NewLabel();
    bottom := NewLabel();
    save := loopExit;
    loopExit.exitLabel := bottom;
    loopExit.loopLevel := loopNestLevel;

    GenPrePostEval(stn^.loopPreEval,EVALPRE);
    Ucolab(top,0,0);

    GenCounter(stn^.lineNumber,stn^.loopBody);

    loopNestLevel := loopNestLevel + 1;
    GenStmtList(stn^.loopBody);
    loopNestLevel := loopNestLevel - 1;

    Uco1int(Uujp,top);
    Ucolab(bottom,0,0);

    GenPrePostEval(stn^.loopPreEval,EVALPOST);
    
    loopExit := save;
    if exitLevel > loopNestLevel then
	exited := false;
	exitLevel := 1000;
    end;
end GenStmtLoop;


procedure GenStmtStmts(stn : StmtNode);
begin
    GenStmtList(stn^.stmts);
end GenStmtStmts;


procedure GenStmtFor(stn : StmtNode);
var
    top, bottom : LabelNumber;
    increment,temp: integer;
    limit       : HugeInteger;
    compareop   : Token;
    tn		: TypeNode;
    variableInc, variableLimit : boolean;
    save : ExitInfo;
    dt : Datatype;
begin
    top := NewLabel();
    bottom := NewLabel();
    save := forExit;
    forExit.exitLabel := bottom;
    forExit.loopLevel := loopNestLevel;

    if stn^.forBy^.kind = EXPRCONST then
	increment := trunc(OrdOf(stn^.forBy^.exprConst));
	variableInc := false;
    else
	variableInc := true;
    end;

    if (stn^.forTo^.kind = EXPRCONST) then
	limit := OrdOf(stn^.forTo^.exprConst);
	variableLimit := false;
    else
	variableLimit := true;
    end;

    tn := stn^.forIndexType;
    dt := MapT(tn);
    if variableLimit then
	GenExpr(stn^.forTo,EVALGET);
	GenVarT(stn^.forLimitVar,tn,EVALPUT);
    end;
    
    GenExpr(stn^.forFrom,EVALGET);
    GenVarT(stn^.forIndexVar,tn,EVALPUT);

    if variableInc then
	GenExpr(stn^.forBy,EVALGET);
	GenVarT(stn^.forIncVar,tn,EVALPUT);
    elsif increment > 0 then
	compareop := TKLSEQUAL;
    else
	compareop := TKGREQUAL;
    end;

    if not stn^.forWillExecute then
	(* see if loop ever executed *)
	GenVarT(stn^.forIndexVar, tn, EVALGET);
	if variableLimit then
	    GenVarT(stn^.forLimitVar,tn,EVALGET);
	elsif tn^.kind = DTPOINTER then
     	    Ucoldc(Adt,BYTESPERADDR,trunc(limit) div BYTESIZE,NOSTRING);
	else
     	    Ucoldc(Ldt,BYTESPERWORD,trunc(limit),NOSTRING);
	end;
	if variableInc then
            Uco1type(Usub,Jdt);
	    GenVarT(stn^.forIncVar,tn,EVALGET);
     	    Uco1type(Uxor,Ldt);
	    GenConstInteger(0);
     	    Uco1type(Ules,Jdt);
	elsif tn^.kind = DTCARDINAL then
            Uco1type(operUcode[compareop],Jdt);
	else
            GenCompare(compareop,tn)
	end;
        Uco1int(Ufjp,bottom);
    
	(* If here, for will execute at least once.  Range-check upper bound *)
	if stn^.forLimitCheck # nil then
	    GenExpr(stn^.forLimitCheck, EVALGET);
	    (* Throw away top of stack *)
            Uco1type(Upop,MapT(stn^.forLimitCheck^.exprType));
	end;
    end;

    (* evaluate invariants *)
    GenPrePostEval(stn^.forPreEval,EVALPRE);

    Ucolab(top,0,0);

    GenCounter(stn^.lineNumber,stn^.forBody);

    loopNestLevel := loopNestLevel + 1;
    GenStmtList(stn^.forBody);
    loopNestLevel := loopNestLevel - 1;

    GenVarT(stn^.forIndexVar,tn,EVALGET);
    if variableInc then
	GenVarT(stn^.forIncVar,tn,EVALGET);
    elsif tn^.kind = DTPOINTER then
     	Ucoldc(Adt,BYTESPERADDR,increment div BYTESIZE,NOSTRING);
    else
     	Ucoldc(Ldt,BYTESPERWORD,increment,NOSTRING);
    end;
    Uco1type(Uadd,dt);
    temp := UcodeTemp(dt,BYTESPERWORD);
	 (* store index someplace WIDE *)
    Ucomem(Ustr,dt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    GenVarT(stn^.forIndexVar,tn,EVALPUT);
    Ucomem(Ulod,dt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);
    if variableLimit then
	GenVarT(stn^.forLimitVar,tn,EVALGET);
    elsif tn^.kind = DTPOINTER then
        Ucoldc(Adt,BYTESPERADDR,trunc(limit) div BYTESIZE,NOSTRING);
    else
     	Ucoldc(Ldt,BYTESPERWORD,trunc(limit),NOSTRING);
    end;
    if tn^.kind = DTCARDINAL then
        Uco1type(operUcode[compareop],Jdt);
    else
     	GenCompare(compareop,tn);
    end;
    Uco1int(Utjp,top);
    Ucolab(bottom,0,0);

    GenPrePostEval(stn^.forPreEval,EVALPOST);

    forExit := save;
    if exitLevel > loopNestLevel then
	exited := false;
	exitLevel := 1000;
    end;
end GenStmtFor;


procedure GenStmtWith(stn : StmtNode);
begin
    GenExpr(stn^.withQual,EVALGET);
    GenVar(stn^.withPtrVar,EVALPUT);
    GenStmtList(stn^.withBody);
end GenStmtWith;


procedure GenStmtReturn(stn : StmtNode);
var
    on       : OptNode;
    doreturn,rbp : boolean;
    tn       : TypeNode;
    dt,dt2   : Datatype;
    size     : integer;

begin
    doreturn := true;
    returned := true;
    tn := genProc^.procType^.funcType;
    if tn # nil then
        size := SizeOf(tn);
     	rbp := ReferenceByPoint(tn);
        dt2 := MapT(tn);
    end;
    if stn^.inlineExpr # nil then
	GenAssign(stn^.inlineVarExpr,stn^.returnVal, stn^.returnVal^.exprType);
        Uco1int(Uujp,stn^.inlineExpr^.inlineReturn);
        doreturn := false;
    elsif stn^.inlineStmt # nil then
        Uco1int(Uujp,stn^.inlineStmt^.inlineReturn);
        doreturn := false;
    elsif stn^.returnVal # nil then
        if rbp and (dt2 # Sdt) then
            GenExpr(stn^.returnVal,EVALPOINT);
        else
            GenExpr(stn^.returnVal,EVALGET);
        end;
	(* watch for tail recursion *)
	if optimFlag then
	    if stn^.returnVal^.kind = EXPRFUNC then
		on := stn^.returnVal^.func^.opt;
		if on^.tailRecursion then
		    doreturn := false;
		end;
	    end;
	end;
    end;
    if doreturn then
        if tn # nil then
	    dt := dt2;
            if rbp then dt := Mdt; end;
     	    case dt of
            | Qdt: Ucomem(Ustr,dt,Rmt,0,128,2*BYTESPERWORD,0);
     	    | Rdt: Ucomem(Ustr,dt,Rmt,0,128,BYTESPERWORD,0);
     	    | Jdt,Ldt,Sdt,Fdt,Adt,Hdt:
                Ucomem(Ustr,dt,Rmt,0,8,BYTESPERWORD,0);
            | Mdt:
     	        Ucomem(Ulod,Adt,Pmt,curUcodeBlock,0,BYTESPERADDR,0);
     	        if dt2 = Sdt then
     	            Uco2typtyp(Uswp,Sdt,Adt);
     	       	    GenIndirectVar(tn,EVALPUT,0);
                else
     	            Uco2typtyp(Uswp,Adt,Adt);
     	       	    GenMove(tn,0,0);
                end;
     	        Ucomem(Ulod,Adt,Pmt,curUcodeBlock,0,BYTESPERADDR,0);
     	        Ucomem(Ustr,Adt,Rmt,0,8,BYTESPERADDR,0);
     	    else
     	        Error('return: unsupported return type');
     	    end;
        end;
        if (genProc = globalProc) and (genProc^.globalName = nil) then
            Uco1int(Umst,RTlevel);
            GenConstInteger(0);
            Ucomem(Upar,Jdt,Pmt,0,0,BYTESPERWORD,0);
	    GenLibCall(RTTERM, nil, 0, 1, rt__term);
        end;
        Uco0(Uret);
    end;
end GenStmtReturn;

procedure GenStmtExit(stn : StmtNode);
begin
    exited := true;
    case stn^.exitKind of
    | STMTLOOP:
	Uco1int(Uujp,loopExit.exitLabel);
	if loopExit.loopLevel < exitLevel then
	    exitLevel := loopExit.loopLevel;
	end;
    
    | STMTFOR:
	Uco1int(Uujp,forExit.exitLabel);
	if forExit.loopLevel < exitLevel then
	    exitLevel := forExit.loopLevel;
	end;
    
    | STMTREPEAT:
	Uco1int(Uujp,repeatExit.exitLabel);
	if repeatExit.loopLevel < exitLevel then
	    exitLevel := repeatExit.loopLevel;
	end;
    
    | STMTWHILE:
	Uco1int(Uujp,whileExit.exitLabel);
	if whileExit.loopLevel < exitLevel then
	    exitLevel := whileExit.loopLevel;
	end;
	
    end;
end GenStmtExit;


$if pascal then
procedure GenStmtGoto(stn : StmtNode);
begin
    if stn^.OOB then
	GenOp(PCLJP);
	C('l'); GenString(stn^.targetLabel^.labelName); 
	X;
	I(currLevel - stn^.targetLabel^.proc^.displayLevel);
	X;
	I(stn^.targetLabel^.proc^.block);
	EndLine;
    else
	GenOp(PCUJP);	
	C('l');	
	GenString(stn^.targetLabel^.labelName);
	EndLine();
    end;
end GenStmtGoto;

procedure GenStmtLabel(stn : StmtNode);
begin
    C('l');
    GenString(stn^.label^.labelName);
    GenOpL(PCLAB);
    if stn^.label^.OOBIndex > 0 then
	GenOpL(PCRST);
    end;
end GenStmtLabel;
$end


procedure DoInline(inlineParams  : ExprList; 
		   inlineFormals : InlineParamList; 
		   paramList     : ParamList);
var
    pen, den: ExprNode;
    pn      : ParamNode;
    ipn     : InlineParamNode;
    atn     : TypeNode;
    i       : integer;
    rowSize : MemoryOffset;
begin
    if (inlineParams # nil) and (inlineFormals # nil) and (paramList # nil) then
        pen := inlineParams^.first;
        pn := paramList^.first;
        ipn := inlineFormals^.first;
        while (pn # nil) and (pen # nil) do
	    if ipn^.kind = IPPARAM then
		case pn^.kind of
		| PARAMARRAYVALUE, PARAMARRAYVAR, PARAMARRAYCONST :
		    GenExpr(pen^.descripBase, pen^.descripMode);
		    GenVarT(ipn^.formal,addressTypeNode,EVALPUT);
		    (* Generate descriptor count/strides *)
		    den := pen^.descrips^.first;
		    for i := 1 to pn^.paramType^.descripCount do
			GenVarT(ipn^.formal,addressTypeNode,EVALPOINT);
			GenExpr(den,EVALGET);
     	       	    	Uco2int(Uistr,Jdt,i*BYTESPERWORD,BYTESPERWORD);
			den := den^.next;
		    end (* for *);
		    if pn^.kind = PARAMARRAYVALUE then
			(* get number of elements *)
			atn := pn^.paramType;
			for i := 1 to pn^.paramType^.descripCount do
			    (* get address of pointer variable *)
			    GenVarT(ipn^.formal,addressTypeNode,EVALPOINT);
     	       	    	    Uco2int(Uilod,Ldt,i*BYTESPERWORD,BYTESPERWORD);
			    if i > 1 then
				(* multiply by previous values *)
     	       	    	        Uco1type(Umpy,Ldt);
			    end;
			    rowSize := atn^.elementSize;
			    atn := atn^.elementType;
			end;
			GenConstAddress(rowSize);
			(* multiply by element size *)
     	       	    	Uco1type(Umpy,Ldt);
	       		(* double word align size *)
     	       	        MoveDynamicToStack(ipn^.formal);
		    end;

		| PARAMVAR, PARAMVALUE, PARAMCONST :
		    if pn^.reference then
			GenExpr(pen,EVALPOINT);
			GenVarT(ipn^.formal,addressTypeNode,EVALPUT);
		    else
			GenExpr(pen,EVALGET);
			GenVar(ipn^.formal,EVALPUT);
		    end;
		    if (pn^.kind = PARAMVALUE) and pn^.reference then
     	       	        MoveStaticToStack(ipn^.formal,pn^.paramType);
		    end;
		end (* case *);
	    end (* if ipn^.kind = IPPARAM *);
	    pen := pen^.next;
            pn := pn^.next;
            ipn := ipn^.next;
        end (* while *);
    end (* if *);
end DoInline;

procedure GenStmtInline(stn : StmtNode);
begin
    DoInline(stn^.inlineParams, stn^.inlineFormals,
	    stn^.inlineProc^.procType^.paramList);
    stn^.inlineReturn := NewLabel();
    GenStmtList(stn^.inlineBody);
    Ucolab(stn^.inlineReturn,0,0);
end GenStmtInline;


procedure GenStmt(stn : StmtNode);
begin
    if DEBUG and TraceGenuc then
	WriteF(output,'# statement %n\n', stn^.kind);
    end;
    if stn^.bad then
	StmtError(stn,'GenStmt: bad statement?');
    else
	currFile := stn^.fileName;
	currLine := stn^.lineNumber;
(*	StabLine(currFile,currLine);*)
					 (* Find map of currFile to fileN? *)
        Ucoloc(MipSym.symFileNumber,currLine);
	case stn^.kind of
$if pascal then
	| STMTLABEL     :   GenStmtLabel(stn);
	| STMTGOTO      :   GenStmtGoto(stn);
$end
	| STMTNONE      :   (* nothing *);
	| STMTASSIGN    :   GenStmtAssign(stn);
	| STMTPROC      :   GenStmtProc(stn);
	| STMTIF	:   GenStmtIf(stn);
	| STMTCASE      :   GenStmtCase(stn);
	| STMTWHILE	:   GenStmtWhile(stn);
	| STMTREPEAT    :   GenStmtRepeat(stn);
	| STMTLOOP      :   GenStmtLoop(stn);
	| STMTFOR       :   GenStmtFor(stn);
	| STMTWITH      :   GenStmtWith(stn);
	| STMTRETURN    :   GenStmtReturn(stn);
	| STMTEXIT      :   GenStmtExit(stn);
	| STMTINLINE    :   GenStmtInline(stn);
	| STMTSTMTS     :   GenStmtStmts(stn);
	end;
	UpdateTemps;
    end;
end GenStmt;

procedure GenIndirectVar(varType : TypeNode; mode : EvalMode;
     	       	    	 bitOffset : integer);
var
    size : integer;
    dt : Datatype;
begin
    dt := MapT(varType);
    size := SizeOf(varType);
    if dt = Mdt then 
        if mode = EVALPUT then
     	    GenMove(varType,0,RoundUp(size,BYTESIZE) div BYTESIZE);
        end;
     	return;
    end;
    if mode in EvalModeSet{EVALGET, EVALPUT} then
	if mode = EVALGET then
     	    GenIlod(dt,bitOffset,size);
	else
     	    GenIstr(dt,bitOffset,size);
	end;
    end;
end GenIndirectVar;

procedure GenConst(const cn : ConstNode);
var
    alignment, size : integer;
begin
    if cn^.sym_idn = NULLDN then
        cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,NOPCODEBLOCK);
    end;
    case cn^.kind of
    | DTINTEGER,DTCARDINAL:
        Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERWORD);
        if cn^.cardVal < 0.0 then
            Ucoinit(Jdt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,trunc(cn^.cardVal),
     	            NOSTRING);
     	elsif cn^.cardVal > MAXINT then
     	    Ucoinit(Ldt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,
     	            trunc(cn^.cardVal-MAXINT-1.0)+trunc(MAXINT)+1,
     	       	    NOSTRING);
        else
            Ucoinit(Ldt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,trunc(cn^.cardVal),
     	            NOSTRING);
        end;
    | DTBOOLEAN:
        Ucosym(Ulsym,cn^.sym_idn,0,1);
        Ucoinit(Ldt,Smt,cn^.sym_idn,0,0,1,0,ord(cn^.boolVal),NOSTRING);
    | DTCHAR:
        Ucosym(Ulsym,cn^.sym_idn,0,1);
     	theCharArray[Low(theCharArray)] := cn^.charVal;
     	theCharArray[Low(theCharArray)+1] := 0C;
     	Ucoinit(Mdt,Smt,cn^.sym_idn,0,0,1,0,0,theCharArray);
    | DTSET:
     	size := SetString(theCharArray,cn^.setVal);
     	Ucosym(Ulsym,cn^.sym_idn,2,size div BYTESIZE);
     	Ucoinit(Sdt,Smt,cn^.sym_idn,0,0,size div BYTESIZE,0,0,theCharArray);
    | DTSTRING:
        size := cn^.strVal^.length;
        Ucosym(Ulsym,cn^.sym_idn,2,size);
        CopyString(cn^.strVal,theCharArray);
     	Ucoinit(Mdt,Smt,cn^.sym_idn,0,0,size,0,0,theCharArray);
    | DTPOINTER:
        Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERADDR);
	Ucoinit(Adt,Smt,cn^.sym_idn,0,0,BYTESPERADDR,0,0,NOSTRING);
    | DTREAL:
        Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERWORD);
     	SWriteF(theCharArray,'%1.17#G',cn^.realVal);
        Ucoinit(Rdt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,0,theCharArray);
    | DTLONGREAL:
        Ucosym(Ulsym,cn^.sym_idn,3,2*BYTESPERWORD);
     	SWriteF(theCharArray,'%1.17#G',cn^.realVal);
        Ucoinit(Qdt,Smt,cn^.sym_idn,0,0,2*BYTESPERWORD,0,0,theCharArray);
    | DTENUMERATION:
        size := SizeOf(cn^.enumVal^.enumType);
        case size of
        | 1..8: alignment := 0;
        | 9..16: alignment := 1;
        | 17..32: alignment := 2;
        end;
        Ucosym(Ulsym,cn^.sym_idn,alignment,size div BYTESIZE);
        Ucoinit(Ldt,Smt,cn^.sym_idn,0,0,size div BYTESIZE,0,
     	        cn^.enumVal^.enumOrd,NOSTRING);
    else
        SWriteF(theCharArray,'no support for %n in GenConst',cn^.kind);
     	Error(theCharArray);
    end;
end GenConst;

procedure GenExprString(en : ExprNode; mode : EvalMode);
var blockNumber,size : integer;
begin
    if mode = EVALPUT then
	ExprError(en,'GenExprString: Cannot store into a constant?');
    elsif en^.exprConst^.kind # DTSTRING then
	ExprError(en,'GenExprString: not a string?');
    else
     	blockNumber := MipSym.StaticData(MipSym.UNIQUESYM,NOPCODEBLOCK);
     	size := RoundUp(SizeOf(en^.constType),BYTESIZE) div BYTESIZE;
     	Ucosym(Ulsym,blockNumber,2,size);
        CopyString(en^.exprConst^.strVal,theCharArray);
     	Ucoinit(Mdt,Smt,blockNumber,0,0,size,0,0,theCharArray);
     	Uco4int(Ulda,Smt,blockNumber,0,size,0);
    end;
end GenExprString;

procedure GenExprConst(en : ExprNode; mode : EvalMode);
var
    cn : ConstNode;
    alignment,size,value : integer;
    dt,dt2 : Datatype;
begin
    dt2 := MapT(en^.exprType);
    cn := en^.exprConst;
    if mode = EVALPUT then
	ExprError(en,'Store into a constant?');
    end;
    case cn^.kind of
    | DTINTEGER, DTCARDINAL :
        if cn^.cardVal > MAXINT then
     	    value := trunc(cn^.cardVal-MAXINT-1.0)+trunc(MAXINT)+1;
        else
     	    value := trunc(cn^.cardVal);
        end;
	if en^.exprType^.kind = DTPOINTER then
            dt := Adt;
     	    assert(value mod BYTESIZE = 0,'bad address in GenExprConst');
     	    value := value div BYTESIZE;
	elsif cn^.cardVal < 0.0 then
            dt := Jdt;
	else
	    dt := Ldt;
	end;
        if mode = EVALGET then
     	    Ucoldc(dt,BYTESPERWORD,value,NOSTRING);
        else
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERWORD);
	  	Ucoinit(dt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,value,NOSTRING);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,BYTESPERWORD,0);
        end;

    | DTCHAR :
	if (en^.exprType^.kind = DTSTRING) and (mode = EVALGET) then
            dt := Ldt;
     	    Ucoldc(dt,2,ord(cn^.charVal)*256,NOSTRING);
     	elsif mode = EVALPOINT then
     	    dt := Adt;
     	    if cn^.sym_idn = NULLDN then
     	        GenConst(cn);
     	    end;
     	    Uco4int(Ulda,Smt,cn^.sym_idn,0,1,0);
	else
            dt := Ldt;
     	    Ucoldc(dt,1,ord(cn^.charVal),NOSTRING);
	end;
        dt2 := dt;

    | DTBOOLEAN :
     	dt := Ldt;
        if mode = EVALGET then
            Ucoldc(MapT(booleanTypeNode),1,ord(cn^.boolVal),
     	       	   NOSTRING);
        else
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,0,1);
	  	Ucoinit(Ldt,Smt,cn^.sym_idn,0,0,1,0,ord(cn^.boolVal),NOSTRING);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,1,0);
        end;
    
    | DTREAL,
      DTLONGREAL :
        dt := dt2;			 (* don't bother with Ucvt *)
        if dt = Qdt then
            size := 8;
     	    alignment := 3;
        else
     	    size := 4;
            alignment := 2;
        end;
     	SWriteF(theCharArray,'%1.17#G',cn^.realVal);
        if mode = EVALGET then
            Ucoldc(dt,size,0,theCharArray);
        else				 (* same as boolean *)
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,alignment,size);
	  	Ucoinit(dt,Smt,cn^.sym_idn,0,0,size,0,0,theCharArray);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,size,0);
        end;
    
    | DTSTRING :
     	dt := Adt; 
	GenExprString(en,mode);
        dt2 := dt;

    | DTENUMERATION :
        dt := Ldt;
        if mode = EVALGET then
            Ucoldc(dt,BYTESPERWORD,cn^.enumVal^.enumOrd,NOSTRING);
        else
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERWORD);
	  	Ucoinit(dt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,
     	       	    	cn^.enumVal^.enumOrd,NOSTRING);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,BYTESPERWORD,0);
        end;    

    | DTPROC :
        if cn^.procVal^.sym_idn = NULLDN then
     	    StabCheckProcRef(cn^.procVal);
        end;
        dt := Fdt;
        if mode = EVALGET then
     	    Ucoldc(dt,BYTESPERADDR,cn^.procVal^.sym_idn,NOSTRING);
        else
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,2,BYTESPERWORD);
     	        Ucoinit(Fdt,Smt,cn^.sym_idn,0,0,BYTESPERWORD,0,
     	       	        cn^.procVal^.sym_idn,NOSTRING);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,BYTESPERWORD,0);
     	end;
    
    | DTPOINTER :
        dt := Adt; dt2 := dt;
        size := SizeOf(en^.exprType);
        if mode = EVALGET then
            if size > WORDSIZE then 
     	        Error('>WORDSIZE pointer in GenExprConst'); 
     	    end;
            Ucoldc(dt,BYTESPERADDR,0,NOSTRING);
        else
     	    if cn^.sym_idn = NULLDN then
                cn^.sym_idn := MipSym.StaticData(MipSym.UNIQUESYM,
     	       	    	      	   	     	  NOPCODEBLOCK);
                Ucosym(Ulsym,cn^.sym_idn,3,size div BYTESIZE);
	  	Ucoinit(Adt,Smt,cn^.sym_idn,0,
     	       	  	size div BYTESIZE - BYTESPERADDR,
     	            	BYTESPERADDR,0,0,NOSTRING);
            end;
            Uco4int(Ulda,Smt,cn^.sym_idn,0,size div BYTESIZE,0);
     	end;
    
    | DTSET :
        dt := Sdt;			 (* no conversion necessary *)
        dt2 := dt;
        size := GenConstSet(cn,mode);
    end;
    if (dt # dt2) then
        Uco2typtyp(Ucvt,dt2,dt);
    end;
end GenExprConst;

procedure GenExprUnOp(en : ExprNode; mode : EvalMode);
begin
    assert(mode = EVALGET, 'Mode not EVALGET in GenExprUnOp?');
    GenExpr(en^.opnd,EVALGET);
    if en^.exprUnOp = TKMINUS then
        Uco1type(Uneg,MapT(en^.unOperType)); (* unary subtract *)
    elsif en^.exprUnOp = TKPLUS then
	(* unary plus *)
    else
     	Uco1type(operUcode[en^.exprUnOp],MapT(en^.unOperType));
    end;
end GenExprUnOp;

procedure GenExprBinSetOp(en : ExprNode; mode : EvalMode);
var
    binOp : Token;
    size,temp,temp2 : integer;
begin
    size := RoundUp(trunc(NumberOf(en^.operType^.setRange)),WORDSIZE) div
     	     BYTESIZE;
    binOp := en^.exprBinOp;
    GenExpr(en^.opnd1,EVALGET);
    if binOp = TKSLASH then
        temp := UcodeTemp(Sdt,size);
     	Ucomem(Ustr,Sdt,Mmt,curUcodeBlock,temp,size,0);
     	Ucomem(Ulod,Sdt,Mmt,curUcodeBlock,temp,size,0);
    end;
    GenExpr(en^.opnd2,EVALGET);
    if binOp = TKSLASH then
        temp2 := UcodeTemp(Sdt,size);
     	Ucomem(Ustr,Sdt,Mmt,curUcodeBlock,temp2,size,0);
     	Ucomem(Ulod,Sdt,Mmt,curUcodeBlock,temp2,size,0);
    end;
    case binOp of
	| TKPLUS :
     	    Uco2typint(Uuni,Sdt,size);
	
	| TKMINUS :
     	    Uco2typint(Udif,Sdt,size);
	
	| TKASTERISK :
     	    Uco2typint(Uint,Sdt,size);
	
	| TKSLASH :
     	    Uco2typint(Uuni,Sdt,size);
     	    Ucomem(Ulod,Sdt,Mmt,curUcodeBlock,temp,size,0);
     	    Ucomem(Ulod,Sdt,Mmt,curUcodeBlock,temp2,size,0);
     	    Uco2typint(Uint,Sdt,size);
     	    Uco2typint(Udif,Sdt,size);
	
	| TKLSEQUAL :
     	    Uco2typint(Udif,Sdt,size);
     	    NullSetString(theCharArray,size);
     	    Ucoldc(Sdt,size,0,theCharArray);
     	    Uco1type(Uequ,Sdt);
	
$if pascal then
	| TKLESS :
	    Error('Set <, > not implemented yet');
$end

	| TKEQUALS, TKSHARP, TKNOTEQUAL:
     	    Uco1type(operUcode[binOp],Sdt);

	| TKIN :
            Uco2int(Uinn,MapT(en^.opnd1^.exprType),0,size);
    end;
    if (mode = EVALPOINT) and 
       (binOp in TokenSet {TKPLUS,TKMINUS,TKASTERISK,TKSLASH}) then
        temp := UcodeTemp(Mdt,size);
        Ucomem(Ustr,Sdt,Mmt,curUcodeBlock,temp,size,0);
        Uco4int(Ulda,Mmt,curUcodeBlock,temp,size,temp);
    end;
end GenExprBinSetOp;

procedure GenExprBinOp(en : ExprNode; mode : EvalMode);
var
    trueLabel, bothLabel : LabelNumber;
    temp : integer;
begin
    if en^.operType^.kind = DTSET then
	GenExprBinSetOp(en,mode);
    elsif en^.exprBinOp in TokenSet{TKAND, TKAMPERSAND, TKOR} then
	trueLabel := NewLabel();
	bothLabel := NewLabel();
        temp := UcodeTemp(Ldt,BYTESPERWORD);
	GenCondition(en,trueLabel,NULLLABEL);
	GenConstBoolean(false);
	Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);        
	Uco1int(Uujp,bothLabel);
	Ucolab(trueLabel,0,0);
	GenConstBoolean(true);
	Ucomem(Ustr,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);        
	Ucolab(bothLabel,0,0);
	Ucomem(Ulod,Ldt,Mmt,curUcodeBlock,temp,BYTESPERWORD,0);        
    elsif en^.operType^.kind = DTARRAY then
	(* ARRAY OF CHAR comparison.  Use C lib strncmp, then use
	   comparison of result to 0. *)
	Uco1int(Umst, RTlevel);
	GenExpr(en^.opnd1, EVALGET);
	Ucomem(Upar, Adt, Pmt, 0, 0, BYTESPERADDR, 0);
	GenExpr(en^.opnd2,EVALGET);
	Ucomem(Upar, Adt, Pmt, 0, BYTESPERADDR, BYTESPERADDR, 0);
	GenConstInteger(trunc(NumberOf(en^.operType^.indexType)));
	Ucomem(Upar, Ldt, Pmt, 0, 2*BYTESPERADDR, BYTESPERWORD, 0);
	GenLibCall(RTSTRNCMP, integerTypeNode, WORDSIZE, 3, rtstrncmp);
	GenConstInteger(0);
	Uco1type(operUcode[en^.exprBinOp], Jdt);
    else
	GenExpr(en^.opnd1,EVALGET);
	GenExpr(en^.opnd2,EVALGET);
     	if en^.exprBinOp in CompareSet then
     	    GenCompare(en^.exprBinOp,en^.operType);
        else
            Uco1type(operUcode[en^.exprBinOp],MapT(en^.operType));
        end;
    end;
end GenExprBinOp;

(* Why is this so? If you hardwire EVALGET then you'll get things like
 return struct. If you hardware EVALPOINT then foo^.next := ar[i]
 becomes a corrupt indirect store. *)
procedure GenExprVal(en : ExprNode; mode : EvalMode);
var
     dt : Datatype;
     size, bitoffset : integer;
     rvalue : ExprNode;
begin
    if en^.exprVal^.kind = EXPRVAR then
	GenVarT(en^.exprVal^.exprVar,en^.exprType,EVALGET);
    else
        bitoffset := 0;
        rvalue := en^.exprVal;
        if (rvalue^.kind = EXPRBINOP) and 
     	   (rvalue^.exprBinOp = TKPLUS) then
           if (rvalue^.opnd2^.kind = EXPRCONST) and
              (rvalue^.opnd2^.exprType = addressTypeNode) and
              (trunc(rvalue^.opnd2^.exprConst^.cardVal) mod BYTESIZE # 0) then
     	       bitoffset := trunc(rvalue^.opnd2^.exprConst^.cardVal);
     	       rvalue := rvalue^.opnd1;
           elsif (rvalue^.opnd1^.kind = EXPRCONST) and
              (rvalue^.opnd1^.exprType = addressTypeNode) and
              (trunc(rvalue^.opnd1^.exprConst^.cardVal) mod BYTESIZE # 0) then
     	       bitoffset := trunc(rvalue^.opnd1^.exprConst^.cardVal);
     	       rvalue := rvalue^.opnd2;
           end;
        end;
	GenExpr(rvalue,EVALGET);
        dt := MapT(en^.exprType);
     	size := SizeOf(en^.exprType);
        if dt # Mdt then
     	    if mode = EVALPUT then
     	        Error('Wrong order for GenIndirectVar!');
            end;
            GenIndirectVar(en^.exprType,EVALGET,bitoffset);
        end;
    end;
end GenExprVal;

procedure GenExprSave(en : ExprNode; mode : EvalMode);
begin
    if mode = EVALGET then
	GenExpr(en^.exprSave,EVALGET);
    else
	GenExpr(en^.exprSave,EVALPOINT);
    end;
    GenVar(en^.exprSaveVar,EVALPUT);
    GenVar(en^.exprSaveVar,EVALGET);
end GenExprSave;

procedure @inline GenExprFunc(const en : ExprNode; const mode : EvalMode;
     	       	    	      returnExpr : ExprNode);
begin
    GenFuncProc(en^.func,en^.params, en^.selected, en^.addrOfValue, mode,
     	        returnExpr);
end GenExprFunc;

procedure GenExprInline(en : ExprNode; mode : EvalMode);
begin
    assert(mode # EVALPUT, 'Mode EVALPUT in GenExprInline?');
    DoInline(en^.inlineParams, en^.inlineFormals,
	en^.inlineProc^.procType^.paramList);
    en^.inlineReturn := NewLabel();
    GenStmtList(en^.inlineBody);
    Ucolab(en^.inlineReturn,0,0);
    GenExpr(en^.inlineResult, mode);
end GenExprInline;

procedure GenConstSet(cn : ConstNode; mode : EvalMode) : integer;
var size : integer;
begin
    if mode = EVALGET then	
        size := SetString(theCharArray,cn^.setVal);
     	Ucoldc(Sdt,size div BYTESIZE,0,theCharArray);
(*        Ucomem(Ulod,Sdt,Smt,cn^.sym_idn,0,size div BYTESIZE,0);*)
    else
        if cn^.sym_idn = NULLDN then
            GenConst(cn);
        end;
        size := SetSize(cn^.setVal);
        Uco4int(Ulda,Smt,cn^.sym_idn,0,size div BYTESIZE,0);
    end;
    return size;
end GenConstSet;

procedure GenExprSet(en : ExprNode; mode : EvalMode);
var
    esn : ExprSetNode;
    cn : ConstNode;
    size : integer;
begin
    cn := ConstSet(en^.setConst,en^.setType);
    if en^.setExpr # nil then mode := EVALGET; end;
    size := GenConstSet(cn,mode);
    if en^.setExpr # nil then
	esn := en^.setExpr^.first;
	while esn # nil do
	    GenExpr(esn^.lower,EVALGET);
	    if esn^.upper = nil then
		Uco2typint(Usgs,MapT(esn^.lower^.exprType),size div BYTESIZE);
	    else
		GenExpr(esn^.upper,EVALGET);
		Uco2typint(Umus,MapT(esn^.upper^.exprType),size div BYTESIZE);
	    end;
     	    Uco2typint(Uuni,Sdt,size div BYTESIZE);
	    esn := esn^.next;
	end;
    end;
end GenExprSet;

procedure SideEffectFree(en : ExprNode) : boolean;
begin
    case en^.kind of
    | EXPRVAR, EXPRCONST: return true;
    | EXPRBINOP: return false;
(* record.field will kill us TKPLUS *)
(*SideEffectFree(en^.opnd1) and SideEffectFree(en^.opnd2); *)
    | EXPRVAL: return (en^.exprVal^.kind = EXPRVAR) or
     	       	      SideEffectFree(en^.exprVal);
    | EXPRFUNC: return false;
    | EXPRUNOP: return SideEffectFree(en^.opnd);
    | EXPRCHECK: return false;		 (* don't bother *)
    | EXPRSAVE: return false;
    | EXPRSET: return en^.setExpr = nil; (* otherwise assume the worst *)
    | EXPRINLINE: return false;		 (* assume the worst *)
    end;
end SideEffectFree;

procedure DoGenExpr(en : ExprNode; mode : EvalMode);
begin
    case en^.kind of
    | EXPRVAR       :   if mode = EVALGET then mode := EVALPOINT; end;
     	       	        GenVar(en^.exprVar, mode);
    | EXPRCONST     :   GenExprConst(en, mode);
    | EXPRBINOP     :   GenExprBinOp(en, mode);
    | EXPRVAL       :   GenExprVal(en, mode);
    | EXPRFUNC      :   GenExprFunc(en, mode, nil);
    | EXPRUNOP      :   GenExprUnOp(en, mode);
    | EXPRCHECK     :   GenExprCheck(en, mode);
    | EXPRSAVE      :   GenExprSave(en, mode);
    | EXPRSET       :   GenExprSet(en, mode);
    | EXPRINLINE    :   GenExprInline(en, mode);
    end;
end DoGenExpr;

procedure OptGenExpr(en : ExprNode; mode : EvalMode; state : EvalState);
var
    on, ron : OptNode;
begin
    on := en^.opt;
    ron := on^.rootEqual;
    if (on^.usage # OUSEINDIVIDUAL) or
	    ((on^.usage = OUSEINDIVIDUAL) and (state # EVALNORMAL)) then
	if DEBUG and TraceOptim then
	    WriteF(output,'OptGenExpr: usage=%n, mode=%n, state=%n, en=',
		    on^.usage, mode, state);
	    WriteExpr(en);
	    WriteF(output, '\n');
	end;
    end;
    case on^.usage of
    | OUSEINDIVIDUAL :
	(* not subexpression, do normal evaluate *)
	if state = EVALNORMAL then
	    DoGenExpr(en,mode);
	end;
    
    | OUSEGENERATE :
	(* either generation or discard of a value, depending on state *)
	if state = EVALPRE then
	    (* calculate a value for later use *)
	    DoGenExpr(en,mode);
	    GenTemp(on^.usage,ron,en);
	end;
    
    | OUSEFIRST :
	(* first use of a value, evaluate and copy it *)
	DoGenExpr(en,mode);
	GenTemp(on^.usage,ron,en);
    
    | OUSEAFTERFIRST :
	(* reuse saved value *)
	GenTemp(on^.usage,ron,en);
    
    | OUSEINDUCTION :
	if state = EVALNORMAL then
	    (* use of for index *)
	    GenVarT(ron^.inductionVar,en^.exprType,EVALGET);
	end;
    
    end;
end OptGenExpr;

procedure GenExpr(en : ExprNode; mode : EvalMode);
begin
    if en = nil then
	Error('Generated nil expression?');
    else
	if DEBUG and TraceGenuc then
	    WriteF(output,'# expression %n %n\n', en^.kind, mode);
	end;
	if en^.exprType = nil then
	    ExprError(en,'GenExpr: no type on expression');
	end;
	if optimFlag then
	    OptGenExpr(en,mode,EVALNORMAL);
	else
	    DoGenExpr(en,mode);
	end;
    end;
end GenExpr;

procedure GenCondition(en : ExprNode; trueLabel,falseLabel : LabelNumber);
var
    done : boolean;
    fallThrough : LabelNumber;
begin
    done := false;
    if en^.kind = EXPRUNOP then
	if en^.exprUnOp = TKNOT then
	    GenCondition(en^.opnd,falseLabel,trueLabel);
	    done := true;
	end;
    elsif en^.kind = EXPRBINOP then
	fallThrough := NULLLABEL;
	if en^.exprBinOp in TokenSet{TKAND, TKAMPERSAND} then
	    if falseLabel = NULLLABEL then
		fallThrough := NewLabel();
		falseLabel := fallThrough;
	    end;
	    GenCondition(en^.opnd1,NULLLABEL,falseLabel);
	    GenCondition(en^.opnd2,trueLabel,falseLabel);
	    if fallThrough # NULLLABEL then
		Ucolab(fallThrough,0,0);
	    end;
	    done := true;
	elsif en^.exprBinOp = TKOR then
	    if trueLabel = NULLLABEL then
		fallThrough := NewLabel();
		trueLabel := fallThrough;
	    end;
	    GenCondition(en^.opnd1,trueLabel,NULLLABEL);
	    GenCondition(en^.opnd2,trueLabel,falseLabel);
	    if fallThrough # NULLLABEL then
     	        Ucolab(fallThrough,0,0);
	    end;
	    done := true;
	end;
    end;
    if not done then
	GenExpr(en,EVALGET);
	if trueLabel # NULLLABEL then
     	    Uco1int(Utjp,trueLabel);
	    if falseLabel # NULLLABEL then
		Uco1int(Uujp,falseLabel);
	    end;
	else
     	    Uco1int(Ufjp,falseLabel);
	end;
    end;
end GenCondition;

procedure GenCode;
begin
    if DEBUG and TraceGenuc then
	WriteF(output,'Beginning code generation\n');
    end;
    loopExit.exitLabel := NULLLABEL;
    loopExit.loopLevel := 0;
    forExit := loopExit;
    whileExit := loopExit;
    repeatExit := loopExit;
    currCounter := 0;
    loopNestLevel := 0;
    new(dummyVar);	(* For use by GenAddress *)
    
    InitStab(mainFileName);
$if pascal then
    StabScope(builtinScope);
$end
    Uco1int(Ubgn, LITTLEENDIAN);
    Ucooptn(UCO_SOURCE, 1);
    CopyString(mainFileName,sourceFileName);
    Ucomment(sourceFileName);		 (* for uopt *)
    Ucoloc(MipSym.symFileNumber, 1);

    GenComs(globalVarList^.first);
    GenModule(globalModule);

    Uco1int(Ustp, 0);

    if genCountFlag then
	GenOp(PCCTS);(* C('d'); X; I(currCounter); X;
	    GenString(mainFileName); EndLine;*)
    end;
    if DEBUG and TraceGenuc then
	WriteF(output,'Ending code generation\n');
    end;
end GenCode;

begin
    assert(true,'@(#)$Header: GenUC.mod,v 1.10 90/05/23 00:30:08 lattanzi Locked $');
    target := TARGETMIPS;
    curOptTempTypes := nil;
    curFastTypes := nil;
    ucoTempBytes := 0;
end GenUC.
