implementation module Alloc;

(*****************************************************************************
 *									     *
 *             Copyright 1984-1992 Digital Equipment Corporation             *
 *                         All Rights Reserved				     *
 *								             *
 * Permission to use, copy, and modify this software and its documentation   *
 * is hereby granted only under the following terms and conditions.  Both    *
 * the above copyright notice and this permission notice must appear in all  *
 * copies of the software, derivative works or modified versions, and any    *
 * portions thereof, and both notices must appear in supporting              *
 * documentation.							     *
 *									     *
 * Users of this software agree to the terms and conditions set forth        *
 * herein, and hereby grant back to Digital a non-exclusive, unrestricted,   *
 * royalty-free right and license under any changes, enhancements or         *
 * extensions made to the core functions of the software, including but not  *
 * limited to those affording compatibility with other hardware or software  *
 * environments, but excluding applications which incorporate this software. *
 * Users further agree to use their best efforts to return to Digital any    *
 * such changes, enhancements or extensions that they make and inform        *
 * Digital of noteworthy uses of this software.  Correspondence should be    *
 * provided to Digital at:						     *
 * 									     *
 *                       Director of Licensing				     *
 *                       Western Research Laboratory			     *
 *                       Digital Equipment Corporation			     *
 *                       250 University Avenue				     *
 *                       Palo Alto, California  94301  			     *
 * 									     *
 * This software may be distributed (but not offered for sale or transferred *
 * for compensation) to third parties, provided such third parties agree to  *
 * abide by the terms and conditions of this notice.  			     *
 * 									     *
 * THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS    *
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED        *
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL    *
 * EQUIPMENT CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR     *
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF    *
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR     *
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR    *
 * PERFORMANCE OF THIS SOFTWARE.				    	     *
 *									     *
 *****************************************************************************)

from io import
    Writef, output;

from MemLib import
    ALLOCATE;

from Machine import
    WORDSIZE;

from Strings import
    String;

from Globals import
    TraceDecls, DEBUG, target, TargetMachine;

from Symbols import
    MemoryType, MemoryOffset, GlobalSymKind, FormerNode, GlobalVarNode, 
    AllocationPair, ProcNode, Address;

$if mips then
from stsupport import
    NULLDN;
$end

var
    globalVarNumber : integer;


procedure InitAllocationArray(var aa : AllocationArray);
begin
    aa[MEMNORMAL].current := 0;
    aa[MEMNORMAL].maximum := 0;
    aa[MEMFAST].current := 0;
    aa[MEMFAST].maximum := 0;
    aa[MEMPARAM].current := 0;
    aa[MEMPARAM].maximum := 0;
end InitAllocationArray;


procedure RoundUp(const value, multiple : MemoryOffset) : MemoryOffset;
begin
    return multiple * ((value + multiple - 1) div multiple);
end RoundUp;


procedure AllocateGlobal(const name	    : String; 
			       size	    : MemoryOffset;
			 const alignment    : MemoryOffset;
			 const extern       : GlobalSymKind;
			 const defineMemory : boolean;
			 const value        : FormerNode;
			 var   address      : Address); 
var
    gvn : GlobalVarNode;
begin
    case target of
    | TARGETVAX, TARGETTITAN, TARGETTITANM :
	(* MEMGLOBAL is always word-aligned. *)
	size := RoundUp(size, WORDSIZE);
    | TARGETMIPS :
	(* Don't change size. *)
    end;
    new(gvn);
    gvn^.globalName := name;
    gvn^.number := globalVarNumber;
    globalVarNumber := globalVarNumber + 1;
$if mips then
    gvn^.sym_idn := NULLDN;
$end
    gvn^.size := size;
    gvn^.alignment := alignment;
    gvn^.extern := extern;
    gvn^.defineMemory := defineMemory;
    gvn^.used := false;
    gvn^.shared := false;
    gvn^.value := value;
    address.kind := MEMGLOBAL;
    address.gvn := gvn;
    if globalVarList^.first = nil then
	globalVarList^.first := gvn;
    else
        globalVarList^.last^.next := gvn;
    end;
    globalVarList^.last := gvn;
    gvn^.next := nil;
end AllocateGlobal;


(* MEMFAST and MEMPARAM are always word-aligned.

   MEMNORMAL is bit-aligned as specified, but note that on the MIPS
   all local variables are addressed with negative offsets, so that
   the value offset + size must be aligned properly.

   MEMRECORD is bit-aligned as specified. *)

procedure AllocateMemory(var   ap        : AllocationPair;
			 const mt        : MemoryType;
			       size      : MemoryOffset;
			 const alignment : MemoryOffset; 
			 const proc      : ProcNode;
			 var   address   : Address); 
var
    offset : MemoryOffset;
begin
    assert(mt # MEMGLOBAL);
    offset := ap.current;
    case target of
    | TARGETVAX, TARGETTITAN, TARGETTITANM :
	case mt of
	| MEMNORMAL, MEMRECORD :
	    offset := RoundUp(offset, alignment);
	| MEMFAST, MEMPARAM :
	    size := RoundUp(size, WORDSIZE);
	    offset := RoundUp(offset, WORDSIZE);
	end;
    | TARGETMIPS :
	case mt of
	| MEMNORMAL :
            offset := RoundUp(offset+size, alignment) - size;
	| MEMRECORD :
	    offset := RoundUp(offset, alignment);
	| MEMPARAM :
	    offset := RoundUp(offset, max(WORDSIZE, alignment));
        | MEMFAST :
	    size := RoundUp(size, WORDSIZE);
        end;
    end (* case target *);

    address.kind := mt;
    address.proc := proc;
    if proc # nil then
	address.level := proc^.displayLevel;
    else
	address.level := 0;
    end;
    address.offset := offset;
    address.size := size;
    address.upLevelAddr := false;
    if DEBUG and TraceDecls then
	Writef(output, 'AllocateMemory: size=%d, align=%d, offset=%d, %n\n',
		size, alignment, offset, mt);
    end;
    ap.current := offset + size;
    if ap.current > ap.maximum then
	ap.maximum := ap.current;
    end;
end AllocateMemory;


begin (* Alloc *)
(* Initialize globalVarList and globalVarNumber. *)
    new(globalVarList);
    globalVarList^.first := nil;
    globalVarList^.last  := nil;
    globalVarNumber := 1;
end Alloc.
