implementation module Mipuini;
$if vax then
from Mipudef import
	Utabrec, Uopcode, Uoperand;

var 
  Utab	   : array Uopcode of Utabrec;

procedure @external uini;
const					(* BfieldOp is the length of a Bcode *)
					(* record (in 'integer' length) *    *)
					(* whose "rightmost" field in Brec   *)
					(* is 'field'			     *)
    BNullOp  = 1;
    BI1Op    = 2;			(* Uop with I1 field		     *)
    BLenOp   = 3;			(* Uop with Length field	     *)
    BTypTypOp = 3;			(* two type fields		     *)

  var 
    Opctr    : integer;
    Curop    : Uopcode;

  procedure Opc(
	      Lop      : Uopcode (*;
	      Opname   : Opcstring*));
begin
      (*Utab[Lop].Opcname := Opname;*)
      Opctr := 0;
      Curop := Lop;
     (*procedure Opc*)end Opc;

  procedure Push(
	      Op       : Uoperand);
begin
      Opctr := Opctr+1;
      Utab[Curop].Format[Opctr] := Op;
     (*procedure Push*)end Push;

  begin
    Opc(Uabs(*, 'ABS '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uadd(*, 'ADD '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uadj(*, 'ADJ '*));
    Push(Sdtype);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uand(*, 'AND '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uaos(*, 'AOS '*));
    Push(Send);
    Opc(Ubgn(*, 'BGN '*));
    Push(Sblockno);							(*!01*)
    Push(Slength);
    Push(Soffset);
    Push(Send);
    Opc(Ubgnb(*, 'BGNB'*));
    Push(Sblockno);							(*!01*)
    Push(Send);
    Opc(Uchkt(*, 'CHKT'*));
    Push(Send);
    Opc(Uchkh(*, 'CHKH'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Uchkl(*, 'CHKL'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Uchkn(*, 'CHKN'*));
    Push(Send);
    Opc(Uclab(*, 'CLAB'*));
    Push(Slabel0);
    Push(Slength);
    Push(Send);
    Opc(Ucomm(*, 'COMM'*));
    Push(Scomment);
    Push(Send);
    Opc(Ucup(*, 'CUP '*));
    Push(Sdtype);
    Push(Slexlev);
    Push(Sblockno);
    Push(Spop);
    Push(Spush);
    Push(Sexternal);							(*!03*)
    Push(Send);
    Opc(Ucvt(*, 'CVT '*));
    Push(Sdtype);
    Push(Sdtype2);
    Push(Send);
    Opc(Ucvtl(*, 'CVTL'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Ucvt2(*, 'CVT2'*));
    Push(Sdtype);
    Push(Sdtype2);
    Push(Send);
    Opc(Udec(*, 'DEC '*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Udef(*, 'DEF '*));
    Push(Smtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Udif(*, 'DIF '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Udiv(*, 'DIV '*));
    Push(Sdtype);
    Push(Send);
    Opc(Udup(*, 'DUP '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uend(*, 'END '*));
    Push(Sblockno);							(*!01*)
    Push(Send);
    Opc(Uendb(*, 'ENDB'*));
    Push(Sblockno);							(*!01*)
    Push(Send);
    Opc(Uent(*, 'ENT '*));							(*!01*)
    Push(Sdtype);
    Push(Slexlev);
    Push(Sblockno);
    Push(Spop);
    Push(Spush);
    Push(Sexternal);
    Push(Send);
    Opc(Uaent(*, 'AENT'*));							(*!01*)
    Push(Sdtype);
    Push(Slexlev);
    Push(Sblockno);
    Push(Spop);
    Push(Spush);
    Push(Sexternal);
    Push(Send);
    Opc(Uequ(*, 'EQU '*));
    Push(Sdtype);
    Push(Send);
    Opc(Ufjp(*, 'FJP '*));
    Push(Slabel1);
    Push(Send);
    Opc(Ugeq(*, 'GEQ '*));
    Push(Sdtype);
    Push(Send);
    Opc(Ugrt(*, 'GRT '*));
    Push(Sdtype);
    Push(Send);
    Opc(Ugoob(*, 'GOOB'*));
    Push(Slexlev);
    Push(Sblockno);
    Push(Send);
    Opc(Uicup(*, 'ICUP'*));
    Push(Sdtype);
    Push(Spop);
    Push(Spush);
    Push(Sexternal);							(*!03*)
    Push(Send);
    Opc(Uiequ(*, 'IEQU'*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uigeq(*, 'IGEQ'*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uigrt(*, 'IGRT'*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uileq(*, 'ILEQ'*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uiles(*, 'ILES'*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uildv(*, 'ILDV'*));
    Push(Sdtype);
    Push(Ssomenumber); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uilod(*, 'ILOD'*));
    Push(Sdtype);
    Push(Ssomenumber); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uineq(*, 'INEQ'*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uinc(*, 'INC '*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Uinit(*, 'INIT'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Slength); (*!06*)
    Push(SarrayOffset); (*!06*)
    Push(Sinitval);
    Push(Send);
    Opc(Uinn(*, 'INN '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Ssomenumber);
    Push(Send);
    Opc(Uint(*, 'INT '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uior(*, 'IOR '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uistv(*, 'ISTV'*));
    Push(Sdtype);
    Push(Ssomenumber); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uistr(*, 'ISTR'*));
    Push(Sdtype);
    Push(Ssomenumber); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uixa(*, 'IXA '*));
    Push(Sdtype);
    Push(Ssomenumber); (*!06*)
    Push(Send);
    Opc(Ulab(*, 'LAB '*));
    Push(Slabel0);
    Push(Slexlev);
    Push(Slength);							(*!01*)
    Push(Send);
    Opc(Uldef(*, 'LDEF'*));
    Push(Slabel0);
    Push(Slexlev);
    Push(Slength);							(*!01*)
    Push(Send);
    Opc(Ulca(*, 'LCA '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Ssomenumber);
    Push(Sconstval);
    Push(Send);
    Opc(Uilda(*, 'ILDA'*));
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Send);
    Opc(Ulda(*, 'LDA '*));
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Send);
    Opc(Uldc(*, 'LDC '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Sconstval);
    Push(Send);
    Opc(Uldp(*, 'LDP '*));							(*!01*)
    Push(Slexlev);
    Push(Ssomenumber);
    Push(Send);
    Opc(Uldsp(*, 'LDSP'*));							(*!01*)
    Push(Send);
    Opc(Uldap(*, 'LDAP'*));							(*!01*)
    Push(Send);
    Opc(Uleq(*, 'LEQ '*));
    Push(Sdtype);
    Push(Send);
    Opc(Ules(*, 'LES '*));
    Push(Sdtype);
    Push(Send);
    Opc(Ulex(*, 'LEX '*));
    Push(Slexlev);
    Push(Sblockno);
    Push(Send);
    Opc(Uloc(*, 'LOC '*));
    Push(Sblockno);
    Push(Slength);
    Push(Send);
    Opc(Ulod(*, 'LOD '*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Umin(*, 'MIN '*));
    Push(Sdtype);
    Push(Send);
    Opc(Umax(*, 'MAX '*));
    Push(Sdtype);
    Push(Send);
    Opc(Umod(*, 'MOD '*));
    Push(Sdtype);
    Push(Send);
    Opc(Urem(*, 'REM '*));							(*!03*)
    Push(Sdtype);
    Push(Send);
    Opc(Umov(*, 'MOV '*));
    Push(Sdtype);
    Push(Ssomenumber);							(*!03*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Umpy(*, 'MPY '*));
    Push(Sdtype);
    Push(Send);
    Opc(Umst(*, 'MST '*));
    Push(Slexlev);
    Push(Send);
    Opc(Umus(*, 'MUS '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uneg(*, 'NEG '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uneq(*, 'NEQ '*));
    Push(Sdtype);
    Push(Send);
    Opc(Unop(*, 'NOP '*));
    Push(Send);
    Opc(Unot(*, 'NOT '*));
    Push(Sdtype);
    Push(Send);
    Opc(Unstr(*, 'NSTR'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uodd(*, 'ODD '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uoptn(*, 'OPTN'*));							(*!01*)
    Push(Ssomenumber);
    Push(Slength);
    Push(Send);
    Opc(Upar(*, 'PAR '*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Updef(*, 'PDEF'*));							(*!03*)
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Slexlev);
    Push(Send);
    Opc(Upop(*, 'POP '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uregs(*, 'REGS'*));
    Push(Slexlev);
    Push(Ssomenumber);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uret(*, 'RET '*));
    Push(Send);
    Opc(Urlda(*, 'RLDA'*));
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Urldc(*, 'RLDC'*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Ssomenumber); (*!06*)
    Push(Sconstval);
    Push(Send);
    Opc(Urlod(*, 'RLOD'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Send);
    Opc(Urnd(*, 'RND '*));
    Push(Sdtype);
    Push(Sdtype2);
    Push(Send);
    Opc(Urpar(*, 'RPAR'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Send);
    Opc(Urstr(*, 'RSTR'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2); (*!06*)
    Push(Send);
    Opc(Usdef(*, 'SDEF'*));
    Push(Sblockno);							(*!02*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uasym(*, 'ASYM'*));
    Push(Sblockno);
    Push(Slength); 
    Push(Send);
    Opc(Usgs(*, 'SGS '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Usqr(*, 'SQR '*));
    Push(Sdtype);
    Push(Send);
    Opc(Usqrt(*, 'SQRT'*));							(*!03*)
    Push(Sdtype);
    Push(Send);
    Opc(Ustp(*, 'STP '*));							(*!01*)
    Push(Sblockno);
    Push(Send);
    Opc(Ustr(*, 'STR '*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Ustsp(*, 'STSP'*));							(*!01*)
    Push(Send);
    Opc(Usub(*, 'SUB '*));
    Push(Sdtype);
    Push(Send);
    Opc(Uswp(*, 'SWP '*));
    Push(Sdtype);
    Push(Sdtype2);
    Push(Send);
    Opc(Utjp(*, 'TJP '*));
    Push(Slabel1);
    Push(Send);
    Opc(Uujp(*, 'UJP '*));
    Push(Slabel1);
    Push(Send);
    Opc(Uuni(*, 'UNI '*));
    Push(Sdtype);
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uvequ(*, 'VEQU'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvgeq(*, 'VGEQ'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvgrt(*, 'VGRT'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvles(*, 'VLES'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvleq(*, 'VLEQ'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvmov(*, 'VMOV'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uvneq(*, 'VNEQ'*));
    Push(Sdtype);
    Push(Send);
    Opc(Uxjp(*, 'XJP '*));
    Push(Sdtype);
    Push(Slabel1);
    Push(Slabel2);
    Push(Soffset);
    Push(Slength);
    Push(Send);
    Opc(Uxor(*, 'XOR '*));
    Push(Sdtype);
    Push(Send);

    Opc(Ucsym(*, 'CSYM'*));				(* redbob !01 *)
    Push(Sblockno);				(* redbob *)
    Push(Slexlev);				(* redbob *)
    Push(Slength);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Uesym(*, 'ESYM'*));				(* redbob !01 *)
    Push(Sblockno);				(* redbob *)
    Push(Slexlev);				(* redbob *)
    Push(Slength);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Ufsym(*, 'FSYM'*));
    Push(Sblockno);
    Push(Slexlev);
    Push(Slength);
    Push(Send);	
    Opc(Ugsym(*, 'GSYM'*));				(* redbob *)
    Push(Sblockno);				(* redbob !01 *)
    Push(Slexlev);				(* redbob *)
    Push(Slength);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Ulsym(*, 'LSYM'*));				(* redbob !01 *)
    Push(Sblockno);				(* redbob *)
    Push(Slexlev);				(* redbob *)
    Push(Slength);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Ushl(*, 'SHL '*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Ushr(*, 'SHR '*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Ulnot(*, 'LNOT'*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Uicuf(*, 'ICUF'*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Spop);					(* redbob *)
    Push(Spush);				(* redbob *)
    Push(Sexternal);							(*!03*)
    Push(Send);					(* redbob *)
    Opc(Uisld(*, 'ISLD'*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Smtype);				(* redbob *)
    Push(Sblockno);				(* redbob *)
    Push(Soffset); (*!06*)				(* redbob *)
    Push(Slength); (*!06*)				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Uisst(*, 'ISST'*));				(* redbob *)
    Push(Sdtype);				(* redbob *)
    Push(Smtype);				(* redbob *)
    Push(Sblockno);				(* redbob *)
    Push(Soffset); (*!06*)				(* redbob *)
    Push(Slength); (*!06*)				(* redbob *)
    Push(Send);					(* redbob *)
    Opc(Upmov(*, 'PMOV'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2);							(*!03*)
    Push(Send);
    Opc(Umpmv(*, 'MPMV'*));
    Push(Sdtype);
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Soffset2);							(*!03*)
    Push(Send);
    Opc(Uunal(*, 'UNAL'*));
    Push(Sdtypenum);
    Push(Smtypenum);
    Push(Slexlev);
    Push(Send);
    Opc(Uveqv(*, 'VEQV'*));
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Send);
    Opc(Uvreg(*, 'VREG'*));
    Push(Sdtype);							(*!03*)
    Push(Smtype);
    Push(Sblockno);
    Push(Soffset); (*!06*)
    Push(Slength); (*!06*)
    Push(Slexlev);							(*!04*)
    Push(Send);
    Opc(Uijp(*, 'IJP '*));							(*!05*)
    Push(Send);
    Opc(Ucg1(*, 'CG1 '*));							(*!05*)
    Push(Send);
    Opc(Ucg2(*, 'CG2 '*));							(*!05*)
    Push(Send);
    Opc(Utpeq(*, 'TPEQ'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Utpne(*, 'TPNE'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Utplt(*, 'TPLT'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Utpgt(*, 'TPGT'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Utpge(*, 'TPGE'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    Opc(Utple(*, 'TPLE'*));
    Push(Sdtype);
    Push(Ssomenumber);
    Push(Send);
    
    (* Initializes tables for writing B-code				     *)

    for Curop := Uabs to Unop do
      
	Utab[Curop].Hasattr := false;
	Utab[Curop].Hasconst := false;
	Utab[Curop].Instlength := BNullOp;
      end;(*for*)

    Utab[Ulod].Hasattr := true;
    Utab[Ustr].Hasattr := true;
    Utab[Uilod].Hasattr := true;
    Utab[Uistr].Hasattr := true;
    Utab[Umov].Hasattr := true;
    Utab[Uabs].Hasattr := true;
    Utab[Uneg].Hasattr := true;
    Utab[Usqr].Hasattr := true;
    Utab[Uchkn].Hasattr := true;
    Utab[Uchkt].Hasattr := true;
    Utab[Ulnot].Hasattr := true;
    Utab[Unot].Hasattr := true;
    Utab[Uodd].Hasattr := true;
    Utab[Usqrt].Hasattr := true;
    Utab[Ucvtl].Hasattr := true;
    Utab[Udec].Hasattr := true;
    Utab[Uinc].Hasattr := true;
    Utab[Uchkh].Hasattr := true;
    Utab[Uchkl].Hasattr := true;
    Utab[Usgs].Hasattr := true;
    Utab[Ucvt].Hasattr := true;
    Utab[Urnd].Hasattr := true;
    Utab[Uadj].Hasattr := true;
    Utab[Uadd].Hasattr := true;
    Utab[Udiv].Hasattr := true;
    Utab[Umod].Hasattr := true;
    Utab[Umpy].Hasattr := true;
    Utab[Usub].Hasattr := true;
    Utab[Urem].Hasattr := true;
    Utab[Uand].Hasattr := true;
    Utab[Uequ].Hasattr := true;
    Utab[Ugeq].Hasattr := true;
    Utab[Ugrt].Hasattr := true;
    Utab[Uior].Hasattr := true;
    Utab[Uleq].Hasattr := true;
    Utab[Ules].Hasattr := true;
    Utab[Umax].Hasattr := true;
    Utab[Umin].Hasattr := true;
    Utab[Uneq].Hasattr := true;
    Utab[Ushl].Hasattr := true;
    Utab[Ushr].Hasattr := true;
    Utab[Uxor].Hasattr := true;
    Utab[Uixa].Hasattr := true;
    Utab[Uint].Hasattr := true;
    Utab[Udif].Hasattr := true;
    Utab[Umus].Hasattr := true;
    Utab[Uuni].Hasattr := true;
    Utab[Uinn].Hasattr := true;
    Utab[Uiequ].Hasattr := true;
    Utab[Uigrt].Hasattr := true;
    Utab[Uigeq].Hasattr := true;
    Utab[Uileq].Hasattr := true;
    Utab[Uiles].Hasattr := true;
    Utab[Uineq].Hasattr := true;

    Utab[Ucomm].Hasconst := true;
    Utab[Uinit].Hasconst := true;
    Utab[Ulca].Hasconst := true;
    Utab[Uldc].Hasconst := true;
    Utab[Urldc].Hasconst := true;

    Utab[Uadj].Instlength := 4;
    Utab[Ubgn].Instlength := 4;						(*!01*)
    Utab[Ubgnb].Instlength := BI1Op;					(*!01*)
    Utab[Uchkh].Instlength := BI1Op;
    Utab[Uchkl].Instlength := BI1Op;
    Utab[Uclab].Instlength := 3;					
    Utab[Ucomm].Instlength := 3;
    Utab[Ucup].Instlength :=  BLenOp;					(*!01*)
    Utab[Ucvt].Instlength := BTypTypOp;
    Utab[Ucvt2].Instlength := BTypTypOp;
    Utab[Ucvtl].Instlength := BI1Op;					(*!01*)
    Utab[Udec].Instlength := BI1Op;
    Utab[Uinc].Instlength := BI1Op;
    Utab[Udef].Instlength := BLenOp;
    Utab[Udif].Instlength := BLenOp;
    Utab[Uint].Instlength := BLenOp;
    Utab[Uuni].Instlength := BLenOp;
    Utab[Uend].Instlength := 2;						(*!01*)
    Utab[Uendb].Instlength := BI1Op;					(*!01*)
    Utab[Uent].Instlength :=  BLenOp;					(*!01*)
    Utab[Uaent].Instlength :=  BLenOp;					(*!01*)
    Utab[Uiequ].Instlength := BLenOp;
    Utab[Uigeq].Instlength := BLenOp;
    Utab[Uigrt].Instlength := BLenOp;
    Utab[Uileq].Instlength := BLenOp;
    Utab[Uiles].Instlength := BLenOp;
    Utab[Uineq].Instlength := BLenOp;
    Utab[Ufjp].Instlength := BI1Op;
    Utab[Utjp].Instlength := BI1Op;
    Utab[Uujp].Instlength := BI1Op;
    Utab[Ugoob].Instlength := BI1Op;
  
    Utab[Uicup].Instlength := BLenOp;
    Utab[Uildv].Instlength := BLenOp;
    Utab[Uilod].Instlength := BLenOp;
    Utab[Uinit].Instlength := 6;				(* redbob    *)
    Utab[Uinn].Instlength := BLenOp;
    Utab[Uistv].Instlength := BLenOp;
    Utab[Uistr].Instlength := BLenOp;
    Utab[Uixa].Instlength := BI1Op;
    Utab[Ulab].Instlength := BLenOp;					(*!01*)
    Utab[Uldef].Instlength := BLenOp;					(*!01*)
    Utab[Ulca].Instlength := 3;
    Utab[Uilda].Instlength := 5;
    Utab[Ulda].Instlength := 5;
    Utab[Uldc].Instlength := 3;
    Utab[Uldp].Instlength := 3;						(*!01*)
    Utab[Ulex].Instlength := 2;
    Utab[Uloc].Instlength := BLenOp;
    Utab[Ulod].Instlength := 4;
    Utab[Umov].Instlength := BLenOp;
    Utab[Umus].Instlength := BLenOp;
    Utab[Unstr].Instlength := 4;
    Utab[Uoptn].Instlength := 3;					(*!01*)
    Utab[Upar].Instlength := 4;
    Utab[Updef].Instlength := 4;					(*!03*)
    Utab[Uregs].Instlength := 4;
    Utab[Urlda].Instlength := 4;
    Utab[Urldc].Instlength := 3;
    Utab[Urlod].Instlength := 5;
    Utab[Urnd].Instlength := BTypTypOp;
    Utab[Urpar].Instlength := 5;
    Utab[Urstr].Instlength := 5;
    Utab[Usdef].Instlength := 3;
    Utab[Uasym].Instlength := 3;
    Utab[Usgs].Instlength := BLenOp;
    Utab[Ustp].Instlength := 2;						(*!01*)
    Utab[Ustr].Instlength := 4;
    Utab[Uswp].Instlength := 3;
    Utab[Uxjp].Instlength := 5;
    Utab[Ucsym].Instlength := 3;				(* redbob !01*)
    Utab[Uesym].Instlength := 3;				(* redbob !01*)
    Utab[Ufsym].Instlength := 3;				(* redbob !01*)
    Utab[Ugsym].Instlength := 3;				(* redbob !01*)
    Utab[Ulsym].Instlength := 3;				(* redbob !01*)
    Utab[Uicuf].Instlength := BLenOp;				(* redbob !01*)
    Utab[Uisld].Instlength := 4;				(* redbob *)
    Utab[Uisst].Instlength := 4;				(* redbob *)
    Utab[Upmov].Instlength := 5;				(* redbob !03*)
    Utab[Umpmv].Instlength := 5;				(* redbob !03*)
    Utab[Uveqv].Instlength := 4;				(* redbob *)
    Utab[Uvreg].Instlength := 4;				(* redbob !04*)
    Utab[Utpeq].Instlength := BI1Op;
    Utab[Utpne].Instlength := BI1Op;
    Utab[Utplt].Instlength := BI1Op;
    Utab[Utpgt].Instlength := BI1Op;
    Utab[Utpge].Instlength := BI1Op;
    Utab[Utple].Instlength := BI1Op;
   (*procedure Uini*)end uini;

procedure @external getutabrec(
	    Uopc : Uopcode;
	var Utabr: Utabrec) ;
begin
    Utabr := Utab[Uopc];
   (*procedure Getutabrec*)end getutabrec;
$end
end Mipuini.
