implementation module UCode;

(****************************************************************************
 *									    *
 *  Copyright (c) 1984 by						    *
 *  DIGITAL EQUIPMENT CORPORATION, Maynard, Massachusetts.		    *
 *  All rights reserved.						    *
 * 									    *
 *  This software is furnished under a license and may be used and copied   *
 *  only in  accordance with  the  terms  of  such  license  and with the   *
 *  inclusion of the above copyright notice. This software or  any  other   *
 *  copies thereof may not be provided or otherwise made available to any   *
 *  other person.  No title to and ownership of  the  software is  hereby   *
 *  transferred.							    *
 * 									    *
 *  The information in this software is  subject to change without notice   *
 *  and  should  not  be  construed as  a commitment by DIGITAL EQUIPMENT   *
 *  CORPORATION.							    *
 * 									    *
 *  DIGITAL assumes no responsibility for the use  or  reliability of its   *
 *  software on equipment which is not supplied by DIGITAL.		    *
 * 									    *
 *  $Header: UCode.mod,v 1.4 90/02/21 20:18:26 lattanzi Locked $
 ****************************************************************************)
from Machine import
    WORDSIZE;

from io import
    SWritef;

from Tokens import
    Token;

from Strings import
    String, CopyString;

from Symbols import
    MemoryType, LabelNumber, TypeNode, SetValue, DataType,ArrayKind,
    cardIntTypeNode,PointerKind (* ||| ,PointerKindSet *);

from TypeInfo import
    BaseType, NumberOf, SizeOf;

from PCodeOps import
    PCodeOp;

from MipSym import
     StabExportData,StabLocalData;

from strings import
     Assign,Append,Compare;
var
    typeDT : array DataType of Datatype;
    labelNumber : LabelNumber;
    memTypeChar : array MemoryType of char;
    stabData : array[0..1023] of char;
    capture : boolean;
    t : Token;
    scope : (unknown,local,exportscope);

procedure @inline NewLabel (): LabelNumber;
begin
    labelNumber := labelNumber + 1;
    return labelNumber;
end NewLabel;

procedure @inline Lab(const l : LabelNumber);
begin
end Lab;

procedure MapT(const tn : TypeNode) : Datatype;
var
    bt : TypeNode;
begin
    bt := BaseType(tn);
    if bt = nil then
        return Pdt;
    elsif bt = cardIntTypeNode then
        return Ldt;
$if false then			    (* ||| Uopt generates garbage with this *)
    elsif bt^.kind = DTPOINTER then
        if bt^.ptrKind in PointerKindSet {PTRNOCHECK,PTRC} then
     	    return Adt;
        else
     	    return Hdt;
        end;
$end
    elsif bt^.kind = DTDYNARRAY then
     	if bt^.dynArrayType^.arrayKind = ARRAYNOCOUNT then
            return Adt;			 (* just a pointer *)
        else
     	    return Mdt;			 (* else counts *)
        end;
    elsif (bt^.kind = DTOPAQUE) and (SizeOf(tn) > WORDSIZE) then
	return Mdt;
    else
        return typeDT[bt^.kind];
    end;
end MapT;

procedure @inline I(const v:integer);
     var s : array[0..10] of char;
begin
    if capture then
        swritef(s,'%d',v);
     	Append(stabData,s);
    end;
end I;

procedure @inline C(const c : char);
    var s : array[0..1] of char;
begin
    if c = '"' then
        capture := not capture;
    elsif capture then
        s[0] := c;
        s[1] := 0C;
        Append(stabData,s);
    elsif scope = unknown then
        if c = 'X' then
     	    scope := exportscope;
        else
     	    scope := local;
        end;
    end;
end C;

procedure @inline GenReal(const r : longreal);
    var s : array[0..20] of char;
begin
    if capture then
        SWritef(s, '%1.17#G', r);
        Append(stabData,s);
    end;
end GenReal;

procedure @inline GenString(const s : String);
    var str : array[0..511] of char;
begin
    if capture then
        CopyString(s,str);
        Append(stabData,str);
    end;
end GenString;

procedure @inline W(const s : array of char);
begin
    if capture then
        Append(stabData,s);
    end;
end W;

procedure GenSet(const s : SetValue);
var
    i, last : integer;
    setSize : integer;
    tn : TypeNode;
begin
    tn := BaseType(s^.setType);
    setSize := trunc(NumberOf(tn^.setRange));
    I(setSize);
    X;
    last := setSize - 1;
    while (last >= 0) and not (last in s^.value) do
	last := last - 1;
    end;
    I(last+1);
    if last >= 0 then
	X;
	for i := 0 to last do
	    if i in s^.value then
		C('1');
	    else
		C('0');
	    end;
	end;
    end;
end GenSet;

procedure @inline X;
begin
    if capture then
        Append(stabData,',');
    end;
end X;

procedure @inline EndLine;
begin
     if Compare(stabData,'<>','') then
         if scope = exportscope then
     	     StabExportData(stabData);
         elsif scope = local then
     	     StabLocalData(stabData);
         else
     	     assert(false,'Illegal scope type for StabData');
         end;
         Assign(stabData,'');
     end;
     scope := unknown;
end EndLine;

begin
    assert(true,'@(#)$Header: UCode.mod,v 1.4 90/02/21 20:18:26 lattanzi Locked $');
    Assign(stabData,'');
    capture := false;
    scope := unknown;
    labelNumber := First(LabelNumber)+1;
    typeDT[DTPOINTER]     := Adt;
    typeDT[DTRECORD]      := Mdt;
    typeDT[DTARRAY]       := Mdt;
    typeDT[DTDYNARRAY]    := Adt;	 (* for reference by point *)
    typeDT[DTINTEGER]     := Jdt;
    typeDT[DTBOOLEAN]     := Ldt;
    typeDT[DTCHAR]	  := Ldt;
    typeDT[DTRENAME]      := Zdt;	 (* should not get out *)
    typeDT[DTOPAQUE]      := Adt;
    typeDT[DTSTRING]      := Mdt;
    typeDT[DTREAL]	  := Rdt;
    typeDT[DTLONGREAL]    := Qdt;
    typeDT[DTSET]	  := Sdt;
    typeDT[DTCARDINAL]    := Ldt;
    typeDT[DTSUBRANGE]    := Zdt;
    typeDT[DTENUMERATION] := Ldt;
    typeDT[DTPROC]	  := Fdt;
    typeDT[DTWORD]	  := Jdt;
    typeDT[DTBYTE]	  := Ldt;
    typeDT[DTANY]	  := Zdt;	 (* trap for now *)
    for t := first(Token) to last(Token) do
	operUcode[t] := Unop;
	iOperUcode[t] := Unop;
    end;
    operUcode[TKPLUS]       :=	Uadd;
    operUcode[TKMINUS]      :=	Usub;
    operUcode[TKASTERISK]   :=	Umpy;
    operUcode[TKSLASH]      :=	Udiv;
    operUcode[TKAMPERSAND]  :=	Uand;
    operUcode[TKEQUALS]     :=	Uequ;
    iOperUcode[TKEQUALS]    :=	Uiequ;
    operUcode[TKSHARP]      :=	Uneq;
    iOperUcode[TKSHARP]     :=	Uineq;
    operUcode[TKLESS]       :=	Ules;
    iOperUcode[TKLESS]      :=	Uiles;
    operUcode[TKGREATER]    :=	Ugrt;
    iOperUcode[TKGREATER]   :=	Uigrt;
    operUcode[TKNOTEQUAL]   :=	Uneq;
    iOperUcode[TKNOTEQUAL]  :=	Uineq;
    operUcode[TKLSEQUAL]    :=	Uleq;
    iOperUcode[TKLSEQUAL]   :=	Uileq;
    operUcode[TKGREQUAL]    :=	Ugeq;
    iOperUcode[TKGREQUAL]   :=	Uigeq;
    operUcode[TKAND]	    :=	Uand;
    operUcode[TKDIV]	    :=	Udiv;
    operUcode[TKIN]	    :=	Uinn;
    operUcode[TKMOD]	    :=	Umod;
    operUcode[TKNOT]	    :=	Ulnot;
    operUcode[TKOR]	    :=	Uior;
end UCode.
