case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
	echo "Using config.sh from above..."
    fi
    . ./config.sh
    ;;
esac
echo "Extracting makedist (with variable substitutions)"
: This section of the file will have variable substitutions done on it.
: Move anything that needs config subs from !NO!SUBS! section to !GROK!THIS!.
: Protect any dollar signs and backticks that you do not want interpreted
: by putting a backslash in front.
cat >makedist <<!GROK!THIS!
#!$perlpath
	eval "exec $perlpath -S \$0 \$*"
		if \$running_under_some_shell;

# $Header: makedist.SH,v 2.0.1.1 88/08/04 23:55:14 lwall Exp $
#
# $Log:	makedist.SH,v $
# Revision 2.0.1.1  88/08/04  23:55:14  lwall
# 
# patch1: depends on perlpath now
# 
# Revision 2.0  88/06/28  23:12:17  lwall
# Baseline.
# 

\$DIST='`pwd`';
\$ENV{'DIST'} = \$DIST;
!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
$spitshell >>makedist <<'!NO!SUBS!'

do 'getopt.pl';
do Getopt("s");

$MAXKITSIZE = 50000 unless $MAXKITSIZE = $opt_s;
$KITOVERHEAD = 1700;
$FILEOVERHEAD = 90;
$NEWMANI = 'MANIFEST.new';
$MANI = 'MANIFEST';

do readpackage();

$ENV{'package'} = $package;
$ENV{'baserev'} = $baserev;

unlink <$package.kit? $package.kit??>;

do manifake();

sub manifake {
    # make MANIFEST and MANIFEST.new say the same thing
    if (! -f $NEWMANI) {
	if (-f $MANI) {
	    open(IN,$MANI) || die "Can't open $MANI";
	    open(OUT,">$NEWMANI") || die "Can't create $NEWMANI";
	    while (<IN>) {
		next if 1 .. /---/;
		s/(\s+)[0-9]*\s*/$1/;
	    }
	    close IN; close OUT;
	}
	else {
die "You need to make a MANIFEST.new file, with names and descriptions.\n";
	}
    }
}

do kitlists();

sub kitlists {
    open(IN,$NEWMANI) || die "Can't open $NEWMANI";
    @files = <IN>;
    close IN;
    for (@files) {
	s/\s.*\n//;
	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,
	   $blksize,$blocks) = stat($_);
	$size += 1000000 if /README/;
	$size{$_} = $size;
    }

    sub revnum { $size{$a} < $size{$b} ? 1 : $size{$a} > $size{$b} ? -1 : 0; }
    @files = sort revnum @files;

    for (@files) {
	$size = $size{$_};
	$size -= 1000000 if /README/;
	$i=1;
	while (($newtot = int($tot[$i] + $size + $size/40 + $FILEOVERHEAD)) >
	    $MAXKITSIZE-$KITOVERHEAD && $tot[$i]) {
	      $i++;
	}
	$tot[$i] = $newtot;
	print "Adding $_ to kit $i giving $newtot bytes\n" if $opt_v;
	$kit{$_} = $i;
	$list[$i] .= " $_";
    }
}

do manimake();

# make MANIFEST and MANIFEST.new say the same thing
sub manimake {
    die "You don't have a $NEWMANI file.  Run manifake.\n"
	unless -f "$NEWMANI";
    open(NEWMANI,$NEWMANI) || die "Can't read $NEWMANI";
    while (<NEWMANI>) {
	($key,$val) = ($_,'') unless ($key,$val) = /^(\S+)\s+(.*)/;
	$comment{$key} = $val;
    }
    close NEWMANI;

    open(MANI,">$MANI") || die "Can't create $MANI.\n";
    print MANI
"After all the $package kits are run you should have the following files:

Filename		Kit Description
--------		--- -----------
";
    for (sort keys(comment)) {
	printf MANI "%-24s%2s %s\n",$_,$kit{$_},$comment{$_};
    }
    close MANI;
}

$numkits = $#list;
if ($numkits > 9) {
    $sp = '%02d';
}
else {
    $sp = '%d';
}

for ($kitnum = 1; $kitnum <= $numkits; $kitnum++) {
    $list = $list[$kitnum];
    $kit = sprintf("$package.kit" . $sp,$kitnum);
    print "*** Making $kit ***\n" if $opt_v;
    open(KIT,">$kit") || die "Can't create $kit.\n";

    do kitleader();

    @files = split(' ',$list);
    reset 'X';
    for $file (@files) {
	$_ = $file;
	while (s|^(.*)/.*$|$1|) {
	    push(@Xdirs,$_) unless $Xseen{$_}++;
	}
    }
    print KIT "mkdir ",join(' ', sort @Xdirs)," 2>/dev/null\n";

    foreach $file (@files) {
	print "\t",$file,"\n" if $opt_v;
	print KIT "echo Extracting $file\n";
	print KIT "sed >$file <<'!STUFFY!FUNK!' -e 's/X//'\n";
	open file;
	while (<file>) {
	    print KIT 'X',$_;
	}
	close file;
	print KIT "!STUFFY!FUNK!\n";
    }
    do kittrailer();
    chmod 0755, $kit;
}

sub kitleader {
    print KIT
"#! /bin/sh

# Make a new directory for the $package sources, cd to it, and run kits 1
# thru $numkits through sh.  When all $numkits kits have been run, read README.

echo \"This is $package $baserev kit $kitnum (of $numkits).  If kit $kitnum is complete, the line\"
echo '\"'\"End of kit $kitnum (of $numkits)\"'\" will echo at the end.'
echo \"\"
export PATH || (echo \"You didn't use sh, you clunch.\" ; kill \$\$)
";
}

sub kittrailer {
    $rangelist = '';
    for ($i = 1; $i <= $numkits; $i++) {
	$rangelist .= ' ' . $i;
    }
    print KIT
"echo \"\"
echo \"End of kit $kitnum (of $numkits)\"
cat /dev/null >kit${kitnum}isdone
run=''
config=''
for iskit in$rangelist; do
    if test -f kit\${iskit}isdone; then
	run=\"\$run \$iskit\"
    else
	todo=\"\$todo \$iskit\"
    fi
done
case \$todo in
    '')
	echo \"You have run all your kits.  Please read README and then type Configure.\"
	chmod 755 Configure
	;;
    *)  echo \"You have run\$run.\"
	echo \"You still need to run\$todo.\"
	;;
esac
: Someone might mail this, so...
exit
";
}
!NO!SUBS!
cat ../pl/package.pl >>makedist
chmod +x makedist
$eunicefix makedist
