case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
	echo "Using config.sh from above..."
    fi
    . ./config.sh
    ;;
esac
: This forces SH files to create target in same directory as SH file.
: This is so that make depend always knows where to find SH derivatives.
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac
echo "Extracting patmake (with variable substitutions)"
cat >patmake <<!GROK!THIS!
#!$perlpath
        eval "exec $perlpath -S \$0 \$*"
                if \$running_under_some_shell;

# $Header: patmake.SH,v 2.0.1.1 88/08/05 00:30:00 lwall Exp $
#
# $Log:	patmake.SH,v $
# Revision 2.0.1.1  88/08/05  00:30:00  lwall
# patch1: now depends on perlpath
# 
# Revision 2.0  88/06/28  23:19:46  lwall
# Baseline.
# 
# 

\$defeditor='$defeditor';
!GROK!THIS!

: In the following dollars and backticks do not need the extra backslash.
cat >>patmake <<'!NO!SUBS!'

do readpackage();

if (-f 'patchlevel.h') {
    open(PL,"patchlevel.h") || die "Can't open patchlevel.h\n";
    while (<PL>) {
        $last = $1 if /^#define\s+PATCHLEVEL\s+(\d+)/;
    }
    die "Malformed patchlevel.h file.\n" if $last eq '';
    $bnum = $last + 1;
}
else {
    $bnum = 1;
    $last = '';
}

@ARGV = <[Mm]akefile*>;
$mf = '';
while (<>) {
    $mf .= $_ if /^[a-z]+:/;
}
$* = 1;
$after = '';
$after .= "\t\tConfigure -d\n" if -f 'Configure';
$after .= "\t\tmake depend\n" if $mf =~ /^depend:/;
$after .= "\t\tmake\n" if $mf;
$after .= "\t\tmake test\n" if $mf =~ /^test:/;
$after .= "\t\tmake install\n" if $mf =~ /^install:/;
$* = 0;

chdir 'bugs' if -d 'bugs';

die "Patch #$bnum already exists.\n" if -f "patch$bnum";

@patlist=<*.$bnum>;
die "No diff files for patch #$bnum.\n" if $patlist[0] =~ /^\*/;

if (-s ".logs$bnum") {
    $logs = '';
    open(LOGS,".logs$bnum");
    while (<LOGS>) {
	$logs .= $_ unless $logseen{$_};
	$logseen{$_} = 1;
    }
    close LOGS;
    $subs = $logs;
    $* = 1;
    $logs =~ s/^patch\d+:\s*/\t/g;
    $logs =~ s/\n/\n\n/g;
    $subs =~ s/^patch\d+:\s*/Subject: /g;
    $* = 0;
}
else {
    $subs = "Subject: \n";
}

$hah = " (hah!)" if $bnum == 1;

open(PATCH,">patch$bnum") || die "Can't create patch";
print PATCH
"System: $package version $baserev
Patch #: $bnum
Priority: 
${subs}From:

Description:
$logs
Repeat-By:

Fix:	From rn, say \"| patch -p -N -d DIR\", where DIR is your $package source
	directory.  Outside of rn, say \"cd DIR; patch -p -N <thisarticle\".
	If you don't have the patch program, apply the following by hand,
	or get patch (version 2.0, latest patchlevel).

	After patching:
$after
	If patch indicates that patchlevel is the wrong version, you may need
	to apply one or more previous patches, or the patch may already
	have been applied.  See the patchlevel.h file to find out what has or
	has not been applied.  In any event, don't continue with the patch.

	If you are missing previous patches$hah they can be obtained from me:

	$maintname
	$maintloc

	If you send a mail message of the following form it will greatly speed
	processing:

	Subject: Command
	@SH mailpatch PATH $package $baserev LIST
		   ^ note the c

	where PATH is a return path FROM ME TO YOU either in Internet notation,
	or in bang notation from some well-known host, and LIST is the number
	of one or more patches you need, separated by spaces, commas, and/or
	hyphens.  Saying 35- says everything from 35 to the end.

";
if ($ftpsite) {
    print PATCH "
	You can also get the patches via anonymous FTP from
	$ftpsite.
";
}
print PATCH "
Index: patchlevel.h
";

if ($last eq '') {
    `echo "#define PATCHLEVEL 1" >patchlevel.h`;
    `cp /dev/null patchlevel.h.null`;
    print PATCH `diff -c patchlevel.h.null patchlevel.h`;
    unlink 'patchlevel.h', 'patchlevel.h.null';
}
else {
    print PATCH
"Prereq: $last
1c1
< #define PATCHLEVEL $last
---
> #define PATCHLEVEL $bnum
";
}

@ARGV = @patlist;
while (<>) { print PATCH; }
close PATCH;

$editor = $ENV{'VISUAL'};
$editor = $ENV{'EDITOR'} unless $editor;
$editor = $defeditor unless $editor;
$editor = 'vi' unless $editor;
system $editor, "patch$bnum";
if (-s "patch$bnum") {
    chdir '..';
    `echo "#define PATCHLEVEL $bnum" >patchlevel.h`;
    open(PL,"patchlevel.h") || die "Can't open patchlevel.h\n";
    while (<PL>) {
	$bnum = $1 if /^#define\s+PATCHLEVEL\s+(\d+)/;
    }
    die "Malformed patchlevel.h file.\n" if $bnum eq '';
    
    if ($newsgroups) {
	print "\nDo you wish to post patch #$bnum to $newsgroups? [y] ";
	$ans = <stdin>;
	system 'patpost', $bnum unless $ans =~ /^n/i;
    }
    if ($recipients) {
	print "\nDo you wish to send patch #$bnum to $recipients? [y] ";
	$ans = <stdin>;
	system 'patsend', $bnum, $recipients unless $ans =~ /^n/i;
    }
    if ($ftpdir) {
	print "\nDo you wish to copy patch #$bnum to $ftpdir? [y] ";
	$ans = <stdin>;
	system 'patftp', $bnum unless $ans =~ /^n/i;
    }
    utime time, time, 'patchlevel.h';
}
else {
    unlink "patch$bnum";
    die "Aborted.\n";
}

!NO!SUBS!
cat ../pl/package.pl >>patmake
chmod +x patmake
$eunicefix patmake
