.TH RGREP l "7 September 1985"
.UC 4
.SH NAME
rgrep \- search a file for a pattern backwards, provide tails
.SH SYNOPSIS
.B /usr/unsupported/watchmkr/rgrep
[ option ] ...
expression [ file ] ...
.SH DESCRIPTION
.I Rgrep
is a variant of the 
.I grep
family.
The named
.I files
(standard input default)
are searched from the end towards the beginning
for occurences of the specified pattern.
The patterns recognized are limited regular expressions
of the type described the manual entry for
.IR ed (1).
The library routine
.IR regex (3)
is used to do pattern matching.
.PP
.I Rgrep 
can also be used to print a trailing portion of a file, either based on 
the occurence of a pattern, or on a number of lines.  In this function it
is subsumed by 
.IR sed (1)
and
.IR tail (1), 
and is much faster than 
.I sed(1)
for long files.
.PP
The following options are recognized.
.TP
.B \-v
All lines but those matching are printed.
.TP
.B \-c
Only a count of matching lines is printed.
.TP
.B \-l
The names of files with matching lines are listed (once) separated by newlines.
.TP
.B \-i
Upper case is folded to lower case for comparisons.
.TP
.B \-n
Each line is preceded by its relative line number from the end of the file.
.TP
.B \-b
Each line is preceded by the block number on which it was found.
This is sometimes useful in locating disk block numbers by context.
.TP
.B \-s
Silent mode.  Nothing is printed (except error messages).
This is useful for checking the error status.
.TP
.BI \-e " expression"
Same as a simple
.I expression 
argument, but useful when the
.I expression
begins with a \-.
.TP
.B \-y
Same as 
.B \-i.
.TP
.B \-t
Give a file tail whose first line matches the given pattern.
There is no limit on the length of the tail.
.TP
.I \-cnt
Give a file tail \fIcnt\fP lines long.
This performs the same function as
.IR tail (1)
but is much less efficient for operations on pipes.  There is no
limit on the length of the file tail (unlike 
.I tail,
which limits the total length of the file tail to 4096 characters).
.LP
In all cases the file name is shown if there is more than one input file.
Care should be taken when using the characters $ * [ ^ | ( ) and \\ in the
.I expression
as they are also meaningful to the Shell.  It is safest to enclose the entire
.I expression
argument in single quotes \' \'.
.LP
In the following description of regular expression
syntax, `character' excludes newline:
.IP
A \e followed by a single character other than newline matches that character.
.IP
The character ^ matches the beginning of a line.
.IP
The character $ matches the end of a line.
.IP
A 
.B .
(period) matches any character.
.IP
A single character not otherwise endowed with special
meaning matches that character.
.IP
A string enclosed in brackets [\|] matches any single character from the string.
Ranges of ASCII character codes may be abbreviated as in `a\-z0\-9'.
A ]
may occur only as the first character of the string.
A literal \- must be placed where it can't be mistaken as a range indicator.
.IP
A regular expression followed by an * (asterisk) matches a sequence of 0
or more matches of the regular expression.
A regular expression followed by a + (plus) matches a sequence of 1 or more
matches of the regular expression.
A regular expression followed by a ? (question mark) matches a sequence of
0 or 1 matches of the regular expression.
.IP
Two regular expressions concatenated match a match of the first followed
by a match of the second.
.IP
A regular expression enclosed in quoted parentheses
matches a match for the regular expression (e.g. \e( \fIx\fP \e)).
.IP
A number \fIn\fP preceded by a backslash \e matches the same string
as the \fIn\fPth
regular expression enclosed in parentheses.
.LP
The order of precedence of operators at the same parenthesis level
is [\|] then *+? then concatentation.
.SH "SEE ALSO"
ed(1),
sed(1),
sh(1),
grep(1),
bm(1),
tail(1),
body(1)
.SH DIAGNOSTICS
Exit status is 0 if any matches are found,
1 if none, 2 for syntax errors or inaccessible files.
.SH BUGS
Lines are limited to 2047 characters; longer lines are split into
chunks at most 2047 characters long.
.PP
Data from non-seekable descriptors (pipes, sockets, and ttys)
is copied to a temporary file, ``/tmp/rvg.*''.
This file will not be removed if the
program is killed with a SIGKILL or a SIGTERM.
