
/*
 *  termcap.h -- definitions of the variables in which
 *		 the termcap info is kept
 */


# define auto_right_margin (_bools[0])	/* Terminal has automatic margins */
# define BS (_bools[1])		/* Terminal can backspace with '^H' */
# define hard_copy (_bools[2])		/* Hardcopy terminal */
# define has_meta_key (_bools[3])	/* Has meta key */
# define move_insert_mode (_bools[4])	/* Safe to move while in insert mode */
# define NC (_bools[5])		/* No correctly working carriage return */
# define PT (_bools[6])		/* Has hardware tabs */
# define transparent_underline (_bools[7])	/* '_' overstrikes */
#define	NUM_BOOLS	8

# define insert_line (_strs[0])		/* Add new blank line */
# define cursor_left (_strs[1])		/* Backspace if not '^H' */
# define back_tab (_strs[2])		/* Back tab */
# define clr_eos (_strs[3])		/* Clear to end of display */
# define clr_eol (_strs[4])		/* Clear to end of line */
# define CH (_strs[5])		/* Like CM but horizontal motion only */
# define clear_screen (_strs[6])	/* Clear screen */
# define cursor_address (_strs[7])		/* Cursor motion */
# define carriage_return (_strs[8])	/* Carriage return (default '^M') */
# define CS (_strs[9])		/* Change scrolling region (vt100), like CM */
# define CV (_strs[10])		/* Like CM but vertical only */
# define delete_character (_strs[11])	/* Delete character */
# define delete_line (_strs[12])		/* Delete line */
# define DM (_strs[13])		/* Delete mode */
# define cursor_down (_strs[14])		/* Down one line */
# define ED (_strs[15])		/* End delete mode */
# define EI (_strs[16])		/* End insert mode */
# define cursor_home (_strs[17])		/* Home cursor */
# define insert_character (_strs[18])		/* Insert character */
# define IM (_strs[19])		/* Insert mode (enter) */
# define IS (_strs[20])		/* Terminal initialization string */
# define LL (_strs[21])		/* Last line, first column */
# define cursor_right (_strs[22]) /* Non-destructive space (cursor right) */
# define newline (_strs[23])		/* Newline character (default '\n') */
# define PC (_strs[24])		/* Pad character */
# define SF (_strs[25])		/* Scroll forward */
# define SR (_strs[26])		/* Scroll reverse */
# define TA (_strs[27])		/* Tab (other than '^I' or with padding) */
# define TE (_strs[28])		/* String to end programs that use CM */
# define TI (_strs[29])		/* String to begin programs that use CM */
# define cursor_up (_strs[30])		/* Upline (cursor up) */
# define flash_screen (_strs[31])		/* Visible bell */
# define VE (_strs[32])		/* Sequence to end open/visual mode */
# define VS (_strs[33])		/* Sequence to start open/visual mode */
# define exit_standout_mode (_strs[34])		/* End standout mode */
# define enter_standout_mode (_strs[35])	/* Begin standout mode */
# define parm_dch (_strs[36])	/* Delete n characters */
# define parm_ich (_strs[37])	/* Insert n characters */
# define parm_delete_line (_strs[38]) /* Delete n lines */
# define parm_insert_line (_strs[39]) /* Insert n lines */
#define	NUM_STRS	40

# define columns (_nums[0])	/* Number of columns in a line */
# define BSdelay (_nums[1])	/* Backspace delay */
# define CRdelay (_nums[2])	/* Carriage return delay */
# define NLdelay (_nums[3])	/* Newline delay */
# define TAdelay (_nums[4])	/* Tab delay  */
# define lines   (_nums[5])	/* Number of lines on screen */
#define	NUM_NUMS	6

/* Things defined to look more like TERMINFO */
#define	over_strike	0
#define	bell		0
