.TH WEBIFY 1
.SH NAME
webify \- convert Postscript documents to Web HTML
.SH SYNOPSIS
.B webify
.RI [ -d ]
.RI [ -p ]
.RI [ -h ]
.RI [ -v ]
.RI [ "-S size" ]
.RI [ "-T size" ]
.RI [ "-t title" ]
.I template
.I psfile
.RI [ subdir ]
.SH DESCRIPTION
.B Webify
is a UNIX program which converts an arbitrary, multipage Postscript
file to a tree of HTML files with GIF images and thumbnails for
each page, using Ghostscript (the
.I gs
command) to do the conversion.
It was motivated by the need to convert Powerpoint (and other presentations)
to Web-browsable form, but will handle arbitrary Postscript files.
.PP
.B Webify
will create a directory containing newly-generated GIFs and HTML
pages for browsing your document.
.PP
Use the
.B webify
command with no options to get a usage message and information on
the template file format.
.SH OPTIONS
.IP -d
debug mode
.IP "-g gsname"
specifies name of Ghostscript command to use; defaul to "gs"
.IP -h
horizontal (landscape) mode \- the default
.IP -v
vertical (portrait) mode
.IP -f
flipped pages (seascape) mode
.IP "-S size"
slide (page) resolution # dpi; dictates page size
.IP "-T size"
thumbnail resolution # dpi; dictates final size
.IP "-t title"
gives title of presentation/document
.IP "subdir"
destination directory, defaults to basename of postscript file
.SH "MORE DOCUMENTATION"
The web documentation for
.B webify
is
.nf
    http://cag-www.lcs.mit.edu/~ward/webify/webifydoc
.fi
.PP
See also the
.BR notes.html ,
.B webifydoc.ps.gz
and
.B webify.template
files provided with the software.
.SH AUTHOR
Steve Ward, ward@mit.edu

