/* _clib.h - internal library header file
 * $Version: 1.6 $
 * Copyright (c) 1991, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __CLIB
#define __CLIB

#include <yvals.h>
#include <stdio.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#define STREAM_IO  	    0 /* Used by _doscan */
#define CONSOLE_IO      1

/*
 * Mutual exclusion enter/exit macros.  Used for object deletion protection.
 */

#ifdef _mutex
#define mutex_enter() unsigned char mutexsav = __enter_clib_mutex();
#define mutex_return(x) {__exit_clib_mutex(mutexsav); return(x); }
#define mutex_void_return() {__exit_clib_mutex(mutexsav); return;}
#ifdef _16bit
#define mutex_exit(x) {__exit_clib_mutex(mutexsav); \
	extern	_int_exit(int); \
	_int_exit(x); }
#else
#define mutex_exit(x) {__exit_clib_mutex(mutexsav); return(x); }
#endif

#else

#define mutex_enter() 
#define mutex_return(val) return(val);
#define mutex_void_return() return;
#ifdef _16bit
#define mutex_exit(val) {extern	_int_exit(int); _int_exit(val); }
#else
#define mutex_exit(val) return(val);
#endif
#endif

/*
 * function prototypes
 */

int             _Pascal _doprnt(const char *, char* *, FILE *, int(*)());
int             _Pascal _doscan(const char *, char* *, FILE *, int(*)(), 
						   int(*)(), int);
int             _Pascal _dtobcd(double, char *);
int             _Pascal _dtos(double, char *);
unsigned char   _Pascal __enter_clib_mutex();
void            _Pascal __exit_clib_mutex(unsigned char);
size_t          _Pascal _filbuf(char *, size_t, FILE *);
int             _Pascal _fflush(FILE *);
size_t          _Pascal _flsbuf(char *, size_t, FILE *);
int             _Pascal _fltprnt(int, va_list, char, int, unsigned int, int, 
						   unsigned int, unsigned int, FILE *, int(*fp)());
int             _Pascal _fltscan(FILE *, unsigned int, unsigned int, char *,
						   unsigned int, int(*getfp)(), int(*putfp)(), int);
FILE          * _Pascal _fopen(int, unsigned int);
int             _Pascal _getch(FILE *);
unsigned int    _Pascal _modeparse(const char *);
double          _Pascal _pow_10(int);
int             _Pascal _putch(int, FILE *);
int             _Pascal _validate_stream_ptr (FILE *);
int             _Pascal _write(int, const char *, unsigned int);
int             _Pascal _putc(int, FILE *);
int             _Pascal _getc(FILE *);



#ifdef __cplusplus
}
#endif
#endif /* __CLIB */
