/* dos.h
 * $Version: 1.6 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _DOS
#define _DOS

#include <yvals.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _FAR
#define _FAR    far
#endif

/*
 * processor status flag macro definitions
 */

#define _FLAG_CARRY     0x0001      /* Carry flag */
#define _FLAG_PARITY    0x0004      /* Parity flag */
#define _FLAG_AUXCARRY  0x0010      /* Auxillary carry flag */
#define _FLAG_ZERO      0x0040      /* Zero flag */
#define _FLAG_SIGN      0x0080      /* Sign flag */
#define _FLAG_TRAP      0x0100      /* Trap flag */
#define _FLAG_INTERRUPT 0x0200      /* Interrupt enable flag */
#define _FLAG_DIRECTION 0x0400      /* Direction flag */
#define _FLAG_OVERFLOW  0x0800      /* Overflow flag */
#define _FLAG_IOPL      0x3000      /* IO privilege level mask */
#define _FLAG_NESTED    0x4000      /* Nested task flag */
#define _FLAG_RESUME    0x10000     /* Resume flag */
#define _FLAG_VM        0x20000     /* Virtual 86 mode */

/*
 * file attribute mask macro definitions
 */

#define _A_NORMAL       0x00        /* Normal file access, read/write OK */
#define _A_RDONLY       0x01        /* File is read-only */
#define _A_HIDDEN       0x02        /* File is hidden */
#define _A_SYSTEM       0x04        /* File is a system file */
#define _A_VOLID        0x08        /* File holds volume ID */
#define _A_SUBDIR       0x10        /* File is a subdirectory */
#define _A_ARCH         0x20        /* File needs to be archived */

/*
 * macro definitions used by functions needing the DS register or seg.
 * and off. of a pointer
 */

extern unsigned int _dataseg;

#define DATASEG() _dataseg

#define _NP_OFF(p) ((unsigned int)p)
#define _NP_SEG(p) _dataseg
#define P_SEG(p) FP_SEG(p)
#define P_OFF(p) FP_OFF(p)

#define _doserrno ((_thread_ptr()->__doserrno)) /* DOS system error variable */

struct DOSERROR {
    int     exterror;
    char    Class;
    char    action;
    char    locus;
};

/*
 * structure definition used by loadexec
 */

struct pblock {
    _aligndef(unsigned int, env)  /* segment address of environment */
    _ptrdef(char _FAR, com_line)  /* program command line */
    _ptrdef(char _FAR, fcb1)
    _ptrdef(char _FAR, fcb2)
};

/*
 * structure definition used by sysint and sysint21
 */

struct regval {
    unsigned int    ax, bx, cx, dx, si, di, ds, es, bp;
};

union REGS {
    struct DWORDREGS {unsigned int  eax, ebx, ecx, edx, esi,
                                    edi, cflag, eflags, ebp;} w;

    struct WORDREGS  {unsigned int  ax, bx, cx, dx, si,
                                    di, cflag, flags, bp;} x;

#ifdef __INT32__ 

    struct BYTEREGS  {unsigned int  al:8, ah:8, :16, bl:8, bh:8, :16,
                                    cl:8, ch:8, :16, dl:8, dh:8, :16;} h;
#else /* __INT16__ */
    struct BYTEREGS  {unsigned int  al:8, ah:8, bl:8, bh:8,
                                    cl:8, ch:8, dl:8, dh:8;} h;
#endif /* __INT32__ */
};

struct SREGS {
    unsigned short    es, cs, ss, ds, fs, gs;
};

/*
 * structure definition used by _dos_findfirst
 */

#ifndef _FINDT
#define _FINDT
#include <_noalign.h>
struct find_t {
    char            reserved[21];   /* Reserved for DOS */
    char            attrib;         /* Returned attribute */
    unsigned short  wr_time;        /* Time file last written */
    unsigned short  wr_date;        /* Date file last written */
    long32          size;           /* Size of file */
    char            name[13];       /* String containing the filename */
    };
#include <_align.h>
#endif /* _FINDT */

/*
 * structure definition used by _dos_getdate and _dos_setdate
 */

struct dosdate_t {
    unsigned char    day;           /* Range: 1-31 */
    unsigned char    month;         /* Range: 1-12 */
    unsigned short   year;          /* Range: 1980-2099 */
    unsigned char    dayofweek;     /* Range: 0-6 (0=Sun, 1=Mon, etc.) */
};

/*
 * structure definition used by _dos_gettime and _dos_settime
 */

struct dostime_t {
    unsigned char    hour;          /* Range: 0-23 */
    unsigned char    minute;        /* Range: 0-59 */
    unsigned char    second;        /* Range: 0-59 */
    unsigned char    hsecond;       /* Range: 0-99 */
};

/*
 * structure definition used by _dos_getdiskfree
 */

struct diskfree_t {
    unsigned short    total_clusters;
    unsigned short    avail_clusters;
    unsigned short    sectors_per_cluster;
    unsigned short    bytes_per_sector;
};

/*
 * function prototypes
 */

int             _Pascal bdos(int, unsigned int, unsigned int);
void _FAR       _Pascal _ctlcint(void);
unsigned int    _Pascal _dos_allocmem(unsigned int, unsigned int *);
unsigned int    _Pascal _dos_close(int);
unsigned int    _Pascal _dos_creat(const char *, unsigned int, int *);
unsigned int    _Pascal _dos_creatnew(const char *, unsigned int,
						   int *);
unsigned int    _Pascal _dos_findfirst(const char *, unsigned int,
						   struct find_t *);
unsigned int    _Pascal _dos_findnext(struct find_t *);
unsigned int    _Pascal _dos_freemem(unsigned int);
void            _Pascal _dos_getdate(struct dosdate_t *);
unsigned int    _Pascal _dos_getdiskfree(unsigned int, struct diskfree_t *);
void            _Pascal _dos_getdrive(unsigned int *);
unsigned int    _Pascal _dos_getfileattr(const char *, unsigned int *);
unsigned int    _Pascal _dos_getftime(int, unsigned int *,
						   unsigned int *);
void            _Pascal _dos_gettime(struct dostime_t *);
unsigned int    _Pascal _dos_open(const char *, unsigned int, int *);
unsigned int    _Pascal _dos_read(int, void *, unsigned int,
						   unsigned int *);
unsigned int    _Pascal _dos_setblock(unsigned int, unsigned int,
						   unsigned int *);
unsigned int    _Pascal _dos_setdate(struct dosdate_t *);
void            _Pascal _dos_setdrive(unsigned int, unsigned int *);
unsigned int    _Pascal _dos_setfileattr(const char *, unsigned int);
unsigned int    _Pascal _dos_setftime(int, unsigned int,
						   unsigned int);
unsigned int    _Pascal _dos_settime(struct dostime_t *);
unsigned int    _Pascal _dos_write(int, const void *, unsigned int,
						   unsigned int *);
int             _Pascal dosexterr(struct DOSERROR *);
int             _Pascal int86(int, const union REGS *, union REGS *);
int             _Pascal int86x(int, const union REGS *, union REGS *,
						   struct SREGS *);
int             _Pascal intdos(const union REGS *, union REGS *);
int             _Pascal intdosx(const union REGS *, union REGS *,
						   struct SREGS *);
int             _Pascal loadexec(char _FAR *, struct pblock _FAR *, int);
long32          _Pascal ptrdiff(void _FAR *, void _FAR *);
void            _Pascal _quit(int);
int             _Pascal sysint(unsigned int, const struct regval *,
						   struct regval *);
int             _Pascal sysint21(const struct regval *, struct regval *);


void            _Pascal segread(struct SREGS *);

#ifdef __cplusplus
} 
#endif

#include <_restore.h>

#endif /* _DOS */
