/* io.h - file access function prototypes
 * $Version: 1.4 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _IO
#define _IO 

#include <yvals.h>
#include <time.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * function prototypes
 */

int         _Pascal access(const char *, int);
int         _Pascal chmod(const char *, mode_t);
int         _Pascal chown(const char *, uid_t, gid_t);
int         _Pascal chsize(int, long32);
int         _Pascal close(int);
int         _Pascal creat(const char *, mode_t);
int         _Pascal dup(int);
int         _Pascal dup2(int, int);
int         _Pascal eof(int);
long32      _Pascal filelength(int);
int         _Pascal isatty(int);
int         _Pascal link(const char *, const char *);
int         _Pascal locking(int, int, long32);
off_t       _Pascal lseek(int, off_t, int);
long32      _Pascal ltell(int);
int         _Pascal _map_length(int, const void *, size_t);
char      * _Pascal mktemp(char *);
int         _Cdecl open(const char *, int, ...);
int         _Pascal _open(const char *, unsigned int, unsigned int,
                       unsigned int);
int         _Pascal read(int, char *, unsigned int);
int         _Pascal setmode(int, int);
int         _Pascal _stdio_stdopen(int);
long32      _Pascal tell(int);
mode_t      _Pascal umask(mode_t);
int         _Pascal unlink(const char *);
int         _Pascal write(int, const char *, unsigned int);

/*
 * macro definitions
 */

#define sopen(fname, oflag, shflag, pmode) open(fname, oflag|shflag, pmode)

#ifdef __cplusplus
}
#endif
#endif /* _IO */

