/* math.h - math and trig definitions
 * $Version: 1.7 $
 * Copyright (c) 1984,85,86,87 Computer Innovations Inc, ALL RIGHTS RESERVED.
 * Copyright (c) 1988-90, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _MATH
#define _MATH

#include <yvals.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * standard macro definitions
 */

#ifndef HUGE_VAL
#define HUGE_VAL _Hugeval
#endif

/*
 * non-ANSI macro definitions for matherr()
 */

#define DOMAIN      1           /* Argument domain error     */
#define SING        2           /* Singularity error         */
#define OVERFLOW    3           /* Function overflow error   */
#define UNDERFLOW   4           /* Function underflow error  */
#define TLOSS       5           /* Total loss of precision   */
#define PLOSS       6           /* Partial loss of precision */

/* 
 * non-ANSI structure declarations
 */

struct exception {
    _aligndef(int, type)
    _ptrdef(char, name)
    double  arg1;
    double  arg2;
    double  retval;
};

struct complex {
    double x;
    double y;
};


/*
 * standard function prototypes
 */
			
double      _Pascal acos(double);
double      _Pascal asin(double);
double      _Pascal atan(double);
double      _Pascal atan2(double, double);
double      _Pascal cos(double);
double      _Pascal sin(double);
double      _Pascal tan(double);
double      _Pascal cosh(double);
double      _Pascal sinh(double);
double      _Pascal tanh(double);
double      _Pascal exp(double);
double      _Pascal frexp(double, int *);
double      _Pascal ldexp(double, int);
double      _Pascal log(double);
double      _Pascal log10(double);
double      _Pascal modf(double, double *);
double      _Pascal pow(double, double);
double      _Pascal sqrt(double);
double      _Pascal ceil(double);
double      _Pascal fabs(double);
double      _Pascal floor(double);
double      _Pascal fmod(double, double);


/*
 * non-ANSI function prototypes
 */

double      _Pascal j0(double);
double      _Pascal j1(double);
double      _Pascal jn(int, double);
int         _Pascal matherr(struct exception *); /* this is just a stub */
double      _Pascal square(double);
double      _Pascal y0(double);
double      _Pascal y1(double);
double      _Pascal yn(int, double);

#ifdef __WATCOMC__
#pragma aux (pascal) acos;
#pragma aux (pascal) asin;
#pragma aux (pascal) atan;
#pragma aux (pascal) atan2;
#pragma aux (pascal) ceil;
#pragma aux (pascal) cos;
#pragma aux (pascal) cosh;
#pragma aux (pascal) ecvt;
#pragma aux (pascal) exp;
#pragma aux (pascal) fabs;
#pragma aux (pascal) fcvt;
#pragma aux (pascal) floor;
#pragma aux (pascal) fmod;
#pragma aux (pascal) frexp;
#pragma aux (pascal) ftoa;
#pragma aux (pascal) gcvt;
#pragma aux (pascal) j0;
#pragma aux (pascal) j1;
#pragma aux (pascal) jn;
#pragma aux (pascal) ldexp;
#pragma aux (pascal) log;
#pragma aux (pascal) log10;
#pragma aux (pascal) modf;
#pragma aux (pascal) pow;
#pragma aux (pascal) sin;
#pragma aux (pascal) sinh;
#pragma aux (pascal) sqrt;
#pragma aux (pascal) square;
#pragma aux (pascal) tan;
#pragma aux (pascal) tanh;
#pragma aux (pascal) y0;
#pragma aux (pascal) y1;
#pragma aux (pascal) yn;
#endif

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* _MATH */
