/* 
 * region.h C++ class for iRMX regions
 * $Version: 1.3 $
 * Copyright (c) 1993 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __REGION_H_
#define __REGION_H_

#include <yvals.h>
#include <rmxobj.h>

	/*
	 * Class Region: iRMX regions.
	 */
class Region : public RMXObject
{
	public:
		~Region()
			{	rqdeleteregion(token, &cur_excep);	};
		void accept_control(void)
			{	rqacceptcontrol(token, &cur_excep);	};
		void receive_control(void)
			{	rqreceivecontrol(token, &cur_excep);	};
		void send_control(void)
			{	rqsendcontrol(&cur_excep);	};

	protected:
		Region(selector new_token)
			{	token = new_token; cur_excep = 0 /*E_OK*/; };

	private:

};

class FIFORegion : public Region
{
	public:
		FIFORegion() : Region((selector) 0)
			{ token = rqcreateregion(0, &cur_excep);	};
		~FIFORegion() {};

	protected:

	private:
};

class PriorityRegion : public Region
{
	public:
		PriorityRegion() : Region((selector) 0)
			{ token = rqcreateregion(1, &cur_excep);	};
		~PriorityRegion() {};

	protected:

	private:
};

#endif	/*	__REGION_H_	*/
