/* stdlib.h - standard utility functions
 * $Version: 1.11 $
 * Copyright (C) 1988-93 Intel Corporation, ALL RIGHTS RESERVED
 */

#ifndef _STDLIB
#define _STDLIB

#include <yvals.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

/*
 * macro definitions
 */

#define EXIT_FAILURE _EXFAIL 
#define EXIT_SUCCESS 0
#define MB_CUR_MAX _Mbcurmax 
#define RAND_MAX 0x7FFF

/*
 * non-standard macro definitions
 */

#define _MAX_PATH       256                /* Max length of full pathname */
#define _MAX_DRIVE        3                /* Max length of drive component */
#define _MAX_DIR        256                /* Max length of path component */
#define _MAX_FNAME      256                /* Max length of file name component */
#define _MAX_EXT        256                /* Max length of extension component */

/*
 * type definitions
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif
#ifndef _WCHART
#define _WCHART
typedef _Wchart wchar_t;
#endif

typedef struct {
    int     quot;
    int     rem;
} div_t;

typedef struct {
    long32  quot;
    long32  rem;
} ldiv_t;

/*
 * non-standard type definitions
 */

typedef int   (_Pascal * onexit_t)(void);

/*
 * non-standrard extern definitions
 */

extern int   _fmode; /* Default file translation mode */

/*
 * function prototypes
 */

void              _Pascal abort(void);
int               _Pascal abs(int);
int               _Pascal atexit(void (_Pascal *)(void));
double            _Pascal atof(const char *);
int               _Pascal atoi(const char *);
long32            _Pascal atol(const char *);
void            * _Pascal bsearch(const void *, const void *, size_t, size_t, 
                             int (_Pascal *)(const void *, const void *));
void            * _Pascal calloc(size_t, size_t);
div_t             _Pascal div(int, int);
char            * _Pascal ecvt(double, int, int   *, int   *);
char            * _Pascal fcvt(double, int, int   *, int   *);
void              _Pascal free(void *);
char            * _Pascal ftoa(double, char *, unsigned int, unsigned int);
char            * _Pascal _fullpath(char *, const char *, size_t);
char            * _Pascal gcvt(double, int, char *);
char            * _Pascal getenv(const char *);
char            * _Pascal itoa(int, char *, int);
char            * _Pascal itoh(int, char *);
long32            _Pascal labs(long32);
ldiv_t            _Pascal ldiv(long32, long32);
char            * _Pascal ltoa(long32, char *, int);
char            * _Pascal ltoh(unsigned long32, char *);
char            * _Pascal ltos(long32, char *, int);
void              _Pascal _makepath(char *, const char *, const char *,
                             const char *, const char *);
void            * _Pascal malloc(size_t);
int               _Pascal mblen(const char *, size_t);
size_t            _Pascal mbstowcs(wchar_t *, const char *, size_t);
int               _Pascal mbtowc(wchar_t *, const char *, size_t);
onexit_t          _Pascal onexit(onexit_t);
int               _Pascal putenv(const char *);
void              _Pascal qsort(void *, size_t, size_t,
							 int   (_Pascal *)(const void *, const void *));
int               _Pascal rand(void);
void            * _Pascal realloc(void *, size_t);
void            * _Pascal sbrk(unsigned);
void              _Pascal _searchenv(const char *, const char *, char *);
void              _Pascal _splitpath(const char *, char *, char *, char *, char *);
void              _Pascal srand(unsigned int);
double            _Pascal strtod(const char *, char **);
long32            _Pascal strtol(const char *, char **, int);
unsigned long32   _Pascal strtoul(const char *, char **, int);
void              _Pascal swab(const char *, char *, int);
int               _Pascal system(const char *);
char            * _Pascal ultoa(unsigned long32, char *, int);
char            * _Pascal utoa(unsigned int, char *, int);
size_t            _Pascal wcstombs(char *, const wchar_t *, size_t);
int               _Pascal wctomb(char *, wchar_t);

#ifdef __WATCOMC__
#pragma aux (pascal) abs;
#pragma aux (pascal) labs;
#pragma aux (pascal) atof;
#pragma aux (pascal) strtod;
#endif

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)
#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)

void          _Pascal exit(int);

#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

#define exit(stat) __Exit(stat)

void          _Pascal exit(int);

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)

/*
 * macro definitions
 */

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))
#define _strtold(_a, _b) (long double)strtod(_a, _b)

#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* _STDLIB */
