#ifndef ETHER_H
#define ETHER_H

#include "types.h"
#include "memblock.h"

typedef u8 ether_addr[6];

typedef struct tag_ether_packet {
  ether_addr src_addr;
  ether_addr dest_addr;
  u16 type;
  u16 length;
  u16 payload_offset;
  u8 *payload_start;
  memblock *data;
} ether_packet;


ether_packet *unpack_ether_header(memblock *mb);
memblock *pack_ether_header(ether_packet *);


#endif /* ETHER_H */
