#include <stdlib.h>

#include <nucleus.h>
#include <rmx_err.h>

#include "router.h"

#define FIFO_QUEUING 0x20  /* bit 5 */

SELECTOR eth0_fifo, eth1_fifo;

/****************************** create_fifos ******************************/
void create_fifos(void) {
    WORD status;
    
    eth0_fifo = rq_create_mailbox(FIFO_QUEUING, &status);
    ERR(status);

    eth1_fifo = rq_create_mailbox(FIFO_QUEUING, &status);
    ERR(status);
}

/****************************** destroy_fifos ******************************/
void destroy_fifos(void) {
    WORD status;
    
    rq_delete_mailbox(eth0_fifo, &status);
    ERR(status);
    
    rq_delete_mailbox(eth1_fifo, &status);
    ERR(status);
}

/****************************** handle_fifos ******************************/
void handle_fifos(void) {
    WORD status;
    memblock *chain;
    
	/* Check if a new packet has arrived in eth0_fifo */
    rq_receive_data(eth0_fifo, chain, 0, &status);
    if ((status != E_OK) || (status != E_TIME))
	ERR(status);
    if (status == E_OK) /* if we read a packet, send it */
	route_packet(ETH1, chain);

	/* Check if a new packet has arrived in eth1_fifo */
    rq_receive_data(eth1_fifo, chain, 0, &status);
    if ((status != E_OK) || (status != E_TIME))
	ERR(status);
    if (status == E_OK) /* if we read a packet, send it */
	route_packet(ETH0, chain);
}

/****************************** route_packet ********************************/
void route_packet(u8 interface, memblock *chain) {
    ether_packet *epacket;
    arp_packet *apacket;
    ipv4_packet *ippacket;

    epacket = unpack_ether_header(chain);
    
    apacket = decode_arp_packet(epacket);
    if (apacket) { /* if this actually was an arp packet */
	handle_arp_packet(interface, apacket);
	free(apacket);
	free(epacket);
	free_memblock_chain(chain);
	return;
    }
    
    ippacket = unpack_ipv4_packet(epacket);
    if (ippacket) { /* if this actually was an ipv4 packet */
	handle_ipv4_packet(interface, ippacket);
	free(ippacket);
	free(epacket);
	free_memblock_chain(chain);
	return;
    }
}

	
