#include "router.h"

/****************************** config_hardware ******************************/
void config_hardware(u8 dir) {
    int x;
    u16 base;
    u8 *ether, data;
    u16 port;

    if (dir == UP) {
	    /* config both MACE's */
	for(x=0; x<2; x++) {
	    base = (x==0)?0x1000:0x1080;
	    ether = (u8 *)&router_ether_addr[x];
	
		/* Write 0x2 to PLSCC(0x1C) to select 10baseT */
	    outbyte(base+PLSCC, 0x2);
    
		/*  Write 0x84 to IAC(0x24) to change physical address. */
	    outbyte(base+IAC, 0x84);
	    
		/*  Repeatedly read IAC(0x24) until bit 7 is a 1 to be sure 
		    the MACE is ready. */
	    data = 0;
	    while (! (data & BIT(7)))
		data = inbyte(base+IAC);
	    
		/*  Write PADR(0x28) 6 times with the 48-bit physical 
		    address. */
port = base+PADR;
data = *ether++;
	    outbyte(port, data);
	    outbyte(port, data);
	    outbyte(base+PADR, data);
	    outbyte(base+PADR, data);
	    outbyte(base+PADR, data);
	    outbyte(base+PADR, data);
	    
		/*  Write 0x3 to MACCC(0x1A) to enable transmit and receive. */
	    outbyte(base+MACCC, 0x3);
	}
    } else if (dir == DOWN) {
	for(x=0; x<2; x++) {
	    base = (x==0)?0x1000:0x1080;
	    
		/* Clear ENXMT and ENRCV */
 	    outbyte(base+MACCC, 0x0);
	}
    }
}

/****************************** send_packet ******************************/
void send_packet(u8 interface, ether_packet *packet) {
    u16 data, temp;
    u16 base;
    u8 data8;
    memblock *curblock = packet->data;
    u16 *ptr = (u16 *)packet->data;
    u16 length = packet->length;

    base = (interface == ETH0)?0x1000:0x1080;

    while (length >= 0) {
	temp = inbyte(base+PR);
	    /* if XMTSV set, read XMTFS to clear it */
	if (temp & XMTSV)
	    data8 = inbyte(base+XMTFS);
	
	if (temp & TDTREQ) {
	    if (length > 8) {
		data = *ptr;
		outword(base+XMTFIFO, data);
		data = *(ptr+1);
		outword(base+XMTFIFO, data);
		data = *(ptr+2);
		outword(base+XMTFIFO, data);
		data = *(ptr+3);
		outword(base+XMTFIFO, data);
		length -= 8;
		ptr = (u16 *)curblock->next;
		curblock = curblock->next;
	    } else { 
		while (length > 2) {
		    data = *ptr;
		    outword(base+XMTFIFO, data);
		    ptr += 2;
		    length -= 2;
		}
		base |= 0x4; /* DDG -- set EOF bit in addr */
		if (length == 2) {
		    data = *ptr;
		    outword(base+XMTFIFO, data);
		} else {
		    data8 = *(u8 *)ptr;
		    outbyte(base+XMTFIFO, data8);
		}
		length = 0;
	    }
	}
    }
}

/****************************** read_eth ******************************/
void read_eth(u8 interface, u8 *data, u16 length) {
    u8 x, base;
    u16 *ptr;
    u8 rcvfs[4];

    ptr = (u16 *)data;
    base = (interface == ETH0)?0x1000:0x1080;

    if (length == 64) {
	    /* do 32 u16 reads from RCVFIFO into current buffer */
	for(x=0; x<32; x++) {
	    *ptr++ = inword(base+RCVFIFO);
	}
    } else { /* packet with less than 64 bytes left */
	for(x=0; x<length/2; x++) {
	    *ptr++ = inword(base+RCVFIFO);
	}
	if ((length % 2) == 1) {/* if read of odd length */
	    *(u8 *)ptr = inbyte(base+RCVFIFO);
	}
    }
    for (x=0; x<4; x++) {
	rcvfs[x] = inbyte(base+RCVFS);
    }
}
	
