#include <stdio.h>
#include <string.h>
#include <ctype.h>

#ifndef TESTBED
#include <rmx_def.h>
#else
#define NO_EXCEPTIONS 1
#endif

#include "router.h"

void main() {
    u16 status;
    
    set_exception(NO_EXCEPTIONS);  /* handle exceptions inline */
    
    set_term(&status);  /* initialize, then wipe screen */
    clear_screen();
    
    printf("Welcome to 6.115 Router\n");

    printf("Please enter any setup commands, then type start to begin\n");
    monitor_loop();

    printf("Creating queues\n");
    create_fifos();
    printf("Starting interrupt handling\n");
    enable_interrupts();
    printf("Enabling ethernet interfaces\n");
    config_hardware(UP);

	/* enter main monitor loop, to deal with console 
	   commands and queuing packets */
    printf("Entering monitor loop\n");
    monitor_loop();

    printf("Monitor loop exited.\nDisabling ethernet interfaces\n");
    config_hardware(DOWN);
    printf("Stopping interrupt handling\n");
    disable_interrupts();
    printf("Destroying queues\n");
    destroy_fifos();
    
    printf("Exiting 6.115 Router\n");
}
