#include "rt_table.h"
#include "types.h"
#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>

static rt_table_entry *rt_table[256] = {
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
  NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL};

typedef struct tag_mask mask;

struct tag_mask {
  u32 msk;
  mask *next;
};

static mask *net_masks_in_use = NULL;


void rt_table_add_mask(u32 msk)
{
  mask *last = NULL;
  mask *p = net_masks_in_use;

  printf("adding mask %x\n", (unsigned int)msk);

  while (p!=NULL && p->msk >= msk) {
    last=p;
    p=p->next;
  }

  if (p==NULL || p->msk > msk) {
    if (last==NULL) {
      net_masks_in_use=(mask *) malloc(sizeof(mask));
      net_masks_in_use->next=p;
      net_masks_in_use->msk=msk;
    } else {
      last->next=(mask *) malloc(sizeof(mask));
      last->next->next=p;
      last->next->msk=msk;
    }
  }
}

int rt_table_hash_ip (u32 ip_addr)
{
  return ((ip_addr & 0x000000ff) ^ ((ip_addr >> 8) & 0x000000ff)
	  ^ ((ip_addr >> 8) & 0x000000ff) ^ ((ip_addr >> 8) & 0x000000ff));
}


rt_table_entry *rt_table_hash_get(u32 ip)
{
  rt_table_entry *current;
  int hash_code=rt_table_hash_ip (ip);
  
  for (current=rt_table[hash_code] ; 
       current != NULL && current->dest!=ip ;
       current = current->next) {
  }

  return current;
}

rt_table_entry *rt_table_hash_get_or_new(u32 ip)
{
  rt_table_entry *current;
  rt_table_entry *last;
  
  int hash_code=rt_table_hash_ip (ip);

  for (current=rt_table[hash_code], last=NULL ; 
       current != NULL && current->dest!=ip ;
       current = current->next) {
  }
  if (current==NULL) {
    current=(rt_table_entry *)malloc(sizeof (rt_table_entry));

    current->dest=ip;
    if (last==NULL) {
      rt_table[hash_code]=current;
    } else {
      last->next=current;
    }
  }
 
  return current;
}


void rt_add_host_route(u32 dest_ip, u32 next_hop_ip, int ifx) 
{
  rt_table_entry *new_entry = rt_table_hash_get_or_new(dest_ip);

  struct in_addr temp;
  temp.s_addr = dest_ip;
  printf("Adding host route to %s ", inet_ntoa(temp));
  temp.s_addr = next_hop_ip;
  printf("via %s on %d ", inet_ntoa(temp), ifx);
  printf("using hash %x\n", rt_table_hash_ip (dest_ip));

  new_entry->net_mask=0xffffffff;
  new_entry->next_hop_ip=next_hop_ip;
  new_entry->next_hop_if=ifx;
  new_entry->net_p=0;
}

void rt_add_net_route(u32 net_ip, u32 net_mask, u32 next_hop_ip, int ifx)
{
  rt_table_entry *new_entry = rt_table_hash_get_or_new(net_ip);


  struct in_addr temp;
  temp.s_addr = net_ip;
  printf("Adding net route to %s with mask %x ", 
	 inet_ntoa(temp), (unsigned int)net_mask);
  temp.s_addr = next_hop_ip;
  printf("via %s on %d ", inet_ntoa(temp), ifx);
  printf("using hash %x\n", rt_table_hash_ip (net_ip));

  temp.s_addr = net_ip;
  printf("Adding host route to %s, mask %x ", 
	 inet_ntoa(temp), (unsigned int)net_mask);
  temp.s_addr = next_hop_ip;
  printf("via %s on %d\n", inet_ntoa(temp), ifx);

  new_entry->net_mask=net_mask;
  new_entry->next_hop_ip=next_hop_ip;
  new_entry->next_hop_if=ifx;
  new_entry->net_p=1;

  rt_table_add_mask(net_mask);
}

void rt_add_default_route(u32 next_hop_ip, int ifx)
{
  rt_table_entry *new_entry = rt_table_hash_get_or_new(0);

  struct in_addr temp;
  temp.s_addr = next_hop_ip;
  printf("Adding default route to %s on %d ", inet_ntoa(temp), ifx);
  printf("using hash %x\n", rt_table_hash_ip (next_hop_ip));

  new_entry->net_mask=0;
  new_entry->next_hop_ip=next_hop_ip;
  new_entry->next_hop_if=ifx;
  new_entry->net_p=1;
  
  rt_table_add_mask(0);
}

rt_table_entry *rt_route(u32 dest_ip)
{
  rt_table_entry *result;
  mask *p = net_masks_in_use;

  struct in_addr temp;
  temp.s_addr = dest_ip;
  printf("Searching for route to %s\n", inet_ntoa(temp));

  result=rt_table_hash_get(dest_ip); 
  
  while ((result==NULL) & (p!=NULL)) {
    result=rt_table_hash_get(dest_ip & p->msk);
    p=p->next;
  }
  
  return result;
}



