// This is -*- c++ -*- code

// $Id: move.h,v 1.9 1995/12/02 05:58:53 hartmans Exp $

#ifndef __MOVE_H__
#define __MOVE_H__

#include <6170.h>
#include <typeinfo.h>
#include <ps5/web_node.h>
class move {
public:
  // Overview: an abstract move passed between  board and player and game.
  // A move is an immutable stack/heap abstraction.
    
  // Destructors:
  virtual ~move();
  // Frees any state associated with move.
  
  // Methods:
  virtual void display(extensions *ext, ostream &body) = 0;
  // Effects: returns an html representation of this move for inclusion
  // in a move list.  The headers in extensions (if extensions is non-null)
  // can be used to determine the capabilities of the web client.
  // Effects:  Return a textual representation of the move for inclusion
  // in a move list.
  
  virtual bool operator == (move &m) = 0;
  // Effects: returns true if two moves are equal, else returns
  // false.  Move equality means that the effect of applying one
  // move to any board will be indistinguishable from the effect of
  // applying the other move to the same board.

  virtual move * copy() = 0;
  //Effects: returns a copy of this such that
  // this->copy() == this.
  
  virtual void * force ( typeinfo_t &type) = 0;

protected:
  // Constructors:
  move ();
  // Effects: creates an empty move.
  
  move (const move &m);
  // Effects: copies an empty move.
  
  move & operator = (const move & m );
  // Modifies: this
  // Effects: this becomes m
};

inline move::move () {}

inline move::move(const move &) {/*argsused*/}

inline move &move::operator = (const  move &) {return *this;}


#endif

