#ifndef _SERVER_H
#define _SERVER_H

#include "sockstream.h"

class server {
    // abstract: A server encapsulates a network endpoint that accepts
    //    multiple connections from clients (concurrently or otherwise).
    //    Every time it accepts a connection, a new socket is created
    //    to handle the connection.

public:
    server(int port);
    // checks   A socket can be created on the given port.
    // effects  Creates a server that listens on the given port.

    int accept();
    // effects  Blocks until a connection is established with a client.
    //          Returns an sockstream for the new connection.

    void close();
    // modifies "this"
    // effects  No more connection can be accepted.

    int file_descriptor();
    // Return the UNIX file descriptor on which server listens for connections

private:
    server();
    server(server &);
    operator=(server &);
	// disallow operations

    int s;    // the original socket on which server listens for connections
};

#endif /* _SERVER_H */
