#include "ps5/url_ops.h"

// black box tests for "url_ops.h"

static int test = 0;

void result(string x, string y) {
    test++;
    if (x != y) {
	cout << "Test " << test++ << ": expected <"
	     << y << ">, got <"<<x << ">\n";
    }
}

main(int argc, char *argv[]) {
    result(extract_pathname("/?foo"), "");
    result(extract_pathname("?foo"), "");
    result(extract_pathname("///?foo"), "");
    result(extract_pathname("/aa/b/?foo"), "aa/b/");
    result(extract_pathname("/aa/b/?/foo"), "aa/b/");
    result(extract_pathname("/aa/b/c?/foo"), "aa/b/c");
    result(extract_pathname("/aa?/foo"), "aa");
    result(extract_pathname("aa?/foo"), "aa");
    result(extract_pathname("?"), "");
    result(extract_pathname("///"), "");
    result(extract_pathname(""), "");
    result(extract_pathname("///?"), "");
    result(extract_query("/a/b/c?foo"), "foo");
    result(extract_query("/a/b/c?"), "");
    result(extract_query("/a/b/c"), "");
    result(extract_query("?foo/bar"), "foo/bar");
    result(extract_query("?"), "");
    result(extract_query(""), "");
    result(first_component("/a/b/c"), "a");
    result(first_component("/aa/b/c"), "aa");
    result(first_component("a/b/c"), "a");
    result(first_component("aa/b/c"), "aa");
    result(first_component("///a/b/c"), "a");
    result(first_component("a"), "a");
    result(first_component("/a"), "a");
    result(first_component("/abc"), "abc");
    result(first_component("/a/"), "a");
    result(first_component("/abc/"), "abc");
    result(first_component("/"), "");
    result(first_component("////"), "");
    result(first_component(""), "");
    result(last_component("/aa/b/c"), "c");
    result(last_component("/a/b/c"), "c");
    result(last_component("a/b/c/"), "c");
    result(last_component("aa/b/c//"), "c");
    result(last_component("///"), "");
    result(last_component("/"), "");
    result(last_component(""), "");
    result(last_component("a"), "a");
    result(last_component("a/"), "a");
    result(last_component("/a"), "a");
    result(rest_components("/a/b/c"), "b/c");
    result(rest_components("//a/b/c//"), "b/c//");
    result(rest_components("a/b"), "b");
    result(rest_components("a///b/"), "b/");
    result(extension("foo.txt"), "txt");
    result(extension("foo"), "");
    result(extension("a.foo/foo"), "");
    result(extension("a.foo/foo.bar"), "bar");
    result(extension("foo."), "");
    result(extension(".txt"), "txt");
    result(extension("foo.txt///"), "txt");
    result(extension("foo.txt/"), "txt");
    result(extension("txt/"), "");
    result(extension(""), "");
    result(extension("/"), "");
    result(extension("///"), "");
}
