#include "digraph.h"

/*****************************************************************************/
// Eq? routines

bool eqint(int i, int j) {
    return i==j;
}

bool eqflt(float i, float j) {
    return i==j;
}

/*****************************************************************************/
// Generic boolean checker

void test(bool cond, string msg) {
    cout << msg <<": ";
    if (cond) 
	cout << "OK\n";
    else
	cout << "*******ERROR******\n";
}

/*****************************************************************************/

static void test_table_int_char() {
    table<int, char> *tic = new table<int, char>(eqint);
    char temp;
    
    cout << "Testing table<int,char>\n";
    tic->insert(10,'a');
    tic->lookup(10, temp);
    test(temp== 'a',"lookup after first insert");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_int_float() {
    table<int, float> *tif = new table<int, float>(eqint);
    float temp;
    
    cout << "Testing table<int,float>\n";
    tif->insert(10,5.5);
    tif->lookup(10, temp);
    test(temp== 5.5,"lookup after first insert");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_float_float() {
    table<float, float> *tff = new table<float, float>(eqflt);
    float temp;
    
    cout << "Testing table<float,float>\n";
    tff->insert(1.3,5.5);
    tff->lookup(1.3, temp);
    test(temp== 5.5,"lookup after first insert");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_int_none(){
    table<int, int> *tii = new table<int, int>(eqint);
    int temp =0;
    
    cout << "Testing table<int, int> with no insertions\n";
    test(!tii->lookup(3, temp),"Didn't find non-existant value");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_multiple_appends(){
    table<int, int> *tii = new table<int, int>(eqint);
    int temp =0;

    tii->insert(3,5);
    tii->insert(4,15);
    cout << "Testing table<int, int> with multiple insertions\n";
    tii->lookup(3, temp);
    test(temp== 5,"lookup after first insert");
    tii->lookup(4, temp);
    test(temp== 15,"lookup after second insert");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_single_remove(){
    table<int, int> *tii = new table<int, int>(eqint);
    int temp;

    tii->insert(3,5);
    tii->insert(4,15);
    tii->remove(3);
    cout << "Testing table<int, int> with single remove\n";
    tii->lookup(4, temp);
    test(temp== 15,"lookup after second insert");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_multiple_removes() {
    table<int, int> *tii = new table<int, int>(eqint);
    int temp;

    tii->insert(3,5);
    tii->insert(4,15);
    tii->remove(3);
    tii->remove(3);
    tii->remove(4);
    cout << "Testing table<int, int> with multiple removes\n";
    test(!tii->lookup(4, temp),"File remains after being removed");
    cout << "done\n";
}

/*****************************************************************************/

static void test_table_rep_ok() {
    table<int, float> *tif = new table<int, float>(eqint);

    cout << "Testing table<int, float> Rep Invarient\n";
    tif->insert(3, 5.8);
    tif->insert(4, 15.7);
    tif->insert(2, 7.7);
    // tif->insert(3, 7.7);  Removed to allow checks to continue.
    // Inset check will catch anything that fails
    cout << "Rep Invarient test passed\n";
}

/*****************************************************************************/

static void test_table_keys() {
    table<int, float> *tif = new table<int, float>(eqint);
    int temp;
        
    tif->insert(3, 5.8);
    tif->insert(4, 15.7);
    tif->insert(2, 7.7);
    cout << "Testing table<int, float> keys generator\n";
    generator<int> * g = tif->keys();
    while (g->get(temp))
	cout << temp << " ";
    cout << "\n";
    cout << "Testing table<int, float> keys generator successfull\n";
}

/*****************************************************************************/

static void digraph_add_node(){
    digraph *d = new digraph();
    
    cout << "Testing digraph add_node\n";
    d->add_node(0);
    d->add_node(2);
    test(!d->add_node(0),"Should be unable to duplicate node");
}

/*****************************************************************************/

static void digraph_add_edge(){
    digraph *d = new digraph();

    cout << "Testing digraph add_edge\n";
    d->add_node(0);
    d->add_node(2);
    test(d->add_edge(0, 2, 3.4), "Checking initial add_edge()");
    test(!d->add_edge(0, 2, 3.4), "Checking second add_edge()");
}

/*****************************************************************************/

static void digraph_lookup_edge(){
    digraph *d = new digraph();
    float temp;
    
    d->add_node(0);
    d->add_node(2);
    test(d->add_edge(0, 2, 3.0), "Checking initial add_edge()");
    test(d->lookup_edge(0,2, temp),"Found initial edge");
    test(temp == 3.0, "Edge was of correct weight");
}

/*****************************************************************************/

static void digraph_remove_edge(){
    digraph *d = new digraph();
    
    d->add_node(0);
    d->add_node(2);
    d->add_edge(0, 2, 3.4);
    test(d->remove_edge(0, 2), "Checking remove_edge()");
    test(!d->remove_edge(4, 2), "Checking second remove_edge()");
}

/*****************************************************************************/

static void digraph_nodes(){
    digraph *d = new digraph();
    int temp;
    
    d->add_node(0);
    d->add_node(2);
    d->add_node(5);
    d->add_node(12);
    cout << "Testing nodes()\n";
    generator<int> *g = d->nodes();
    while (g->get(temp))
	cout << temp << " ";
    cout << "\nDone testing nodes()\n";
}

/*****************************************************************************/

static void digraph_successors(){
    digraph *d = new digraph();
    generator<int> *g;
    int temp;
    
    d->add_node(0);
    d->add_node(2);
    d->add_node(3);
    d->add_node(12);
    d->add_edge(0, 2, 4.5);
    d->add_edge(0, 3, 3.4);
    d->add_edge(0, 12, 17.6);
    cout << "Testing successors\n";
    if (d->successors(0, g)){
	while (g->get(temp))
	    cout << temp << " ";
	cout << "\nDone testing successors()\n";
    }
    else
	test(false,"Finished successors test\n");
}

/*****************************************************************************/

static void digraph_rep_ok(){
    digraph *d = new digraph();

    cout << "Checking Rep Invarient\n";
    d->add_node(0);
    d->add_node(2);
    d->add_node(5);
    d->add_node(7);
    d->add_node(12);
    d->add_edge(0, 2, 4.5);
    d->add_edge(0, 7, 3.4);
    d->add_edge(0, 12, 17.6);
    d->add_edge(2, 0, 4.5);
    d->add_edge(2, 5, 3.4);
    d->add_edge(2, 12, 17.6);
    d->add_edge(5, 2, 4.5);
    d->add_edge(5, 7, 3.4);
    d->add_edge(5, 12, 17.6);
    d->add_edge(7, 2, 4.5);
    d->add_edge(7, 0, 3.4);
    d->add_edge(9, 12, 17.6);
    test(d->rep_ok(),"Rep Invarient Check");
}

/*****************************************************************************/

static void digraph_out(){
    digraph *d = new digraph();
    
    cout << "Testing digraph <<\n";
    d->add_node(0);
    d->add_node(2);
    d->add_node(5);
    d->add_node(7);
    d->add_node(12);
    d->add_edge(0, 2, 4.5);
    d->add_edge(0, 7, 3.4);
    d->add_edge(0, 12, 17.6);
    d->add_edge(2, 0, 4.5);
    d->add_edge(2, 5, 3.4);
    d->add_edge(2, 12, 17.6);
    d->add_edge(5, 2, 4.5);
    d->add_edge(5, 7, 3.4);
    d->add_edge(5, 12, 17.6);
    d->add_edge(7, 2, 4.5);
    d->add_edge(7, 0, 3.4);
    cout << d;
}

/*****************************************************************************/

int main() {
    test_table_int_char();
    test_table_int_float();
    test_table_float_float();
    test_table_int_none();
    test_table_multiple_appends();
    test_table_single_remove();
    test_table_multiple_removes();
    test_table_rep_ok();
    test_table_keys();
    
    digraph_add_node();
    digraph_add_edge();
    digraph_lookup_edge();
    digraph_remove_edge();
    digraph_nodes();
    digraph_successors();
    digraph_rep_ok();
    digraph_out();
    cout << "Done with Tests\n";
}

	
