/* rmxemb.h iRMX header
 * $Version: 1.6 $
 * Copyright (C) 1989-91, 93 Intel Corporation, ALL RIGHTS RESERVED
 */

#ifndef __RMXEMBH__
#define __RMXEMBH__

#include <yvals.h>
#include <rmxtypes.h>
#include <nucleus.h>
#include <rmk.h>
#include <rmx_def.h>
#include <_noalign.h>

#ifdef __cplusplus
extern "C" {
#endif

/**********  Simple data types  **********/

#ifndef  BOOLEAN
#   define  BOOLEAN             unsigned char
#endif

/**********  Common datatypes  **********/

/* CONTROL_REQUEST */

#define  CONTROL_REQUEST        UINT_32
#define  PARITY_MODE            UINT_32
#define  LINE_STATE             UINT_32
#define  CLOCK_SRC              UINT_32
#define  FLOW_CONTROL           UINT_32
#define  TRANSFER_MODE          UINT_32
#define  BUFFER_XFER_MODE       UINT_32
#define  BUS_XFER_MODE          UINT_32
#define  BUS_PRIORITY_MODE      UINT_32
#define  BUS_CYCLE_MODE         UINT_32
#define  INPUT_SAMPLING_MODE    UINT_32
#define  ADDRESS_TYPE           UINT_32
#define  ADDRESS_INC_MODE       UINT_32
#define  PIN_MODE               UINT_32
#define  COUNT_TYPE             UINT_32
#define  COUNT_MODE             UINT_32
#define  WATCHDOG_MODE          UINT_32

#define  no_change_control      0x00L
#define  poweron_control        0x01L
#define  start_control          0x02L
#define  suspend_control        0x03L
#define  resume_control         0x04L
#define  cancel_control         0x05L
#define  reset_control          0x06L
#define  shutdown_control       0x07L
#define  restart_control        0x08L
#define  sw_dreq_off_control    0x09L
#define  sw_dreq_on_control     0x0AL
#define  shutdown_all_control   0x0BL

#define  NO_CHANGE_CONTROL      no_change_control
#define  POWERON_CONTROL        poweron_control
#define  START_CONTROL          start_control
#define  SUSPEND_CONTROL        suspend_control
#define  RESUME_CONTROL         resume_control
#define  CANCEL_CONTROL         cancel_control
#define  RESET_CONTROL          reset_control
#define  SHUTDOWN_CONTROL       shutdown_control
#define  RESTART_CONTROL        restart_control
#define  SW_DREQ_OFF_CONTROL    sw_dreq_off_control
#define  SW_DREQ_ON_CONTROL     sw_dreq_on_control
#define  SHUTDOWN_ALL_CONTROL   shutdown_all_control


/**********  Common devices  **********/

#define  PQ_DEVICE(unit)        ((UINT_16) unit)


/**********  Common wait options  **********/

#define  PQ_NO_WAIT             (UINT_16) 0
#define  PQ_WAIT_FOREVER        (UINT_16) 0xFFFF
#define  PQ_WAIT_LATER          (UINT_16) 0xFFFE
#define  PQ_WAIT_SEC(sec)       ((UINT_16) (100*sec))
#define  PQ_WAIT_MSEC(msec)     ((UINT_16) (msec/100))


/**********  PQ specific exception codes  **********/

#define  FIRST_PQ_ENVIRON_ERROR  0x00F0
#define  LAST_PQ_ENVIRON_ERROR   0x00F4

#define  E_DATA_OVERRUN          0x00F0
#define  E_DATA_UNDERRUN         0x00F1
#define  E_DATA_PARITY           0x00F2
#define  E_DATA_FRAMING          0x00F3
#define  E_DATA_BREAK            0x00F4
#define  E_DATA_UNKNOWN          0x00F5

#define  FIRST_PQ_PROG_ERROR     0x80F0
#define  LAST_PQ_PROG_ERROR      0x80F0


/**********  Driver Ids  **********/

#define  NULL_DRIVER_ID         ((UINT_16) 0)
#define  SERIAL_DRIVER_ID       ((UINT_16) 1)
#define  DMA_DRIVER_ID          ((UINT_16) 2)
#define  PARALLEL_DRIVER_ID     ((UINT_16) 3)
#define  TIMER_DRIVER_ID        ((UINT_16) 4)
#define  WATCHDOG_DRIVER_ID     ((UINT_16) 5)
#define  ALL_DRIVER_ID          ((UINT_16) 0xFFFF)


/**********  Function Ids  **********/

#define  NULL_FUNC_ID           ((UINT_16) 0)
#define  INIT_FUNC_ID           ((UINT_16) 1)
#define  CONFIG_FUNC_ID         ((UINT_16) 2)
#define  CONTROL_FUNC_ID        ((UINT_16) 3)
#define  STATUS_FUNC_ID         ((UINT_16) 4)
#define  READ_FUNC_ID           ((UINT_16) 5)
#define  WRITE_FUNC_ID          ((UINT_16) 6)
#define  READ_CHAR_FUNC_ID      ((UINT_16) 7)
#define  WRITE_CHAR_FUNC_ID     ((UINT_16) 8)
#define  TRANSFER_FUNC_ID       ((UINT_16) 9)
#define  ALL_FUNC_ID            ((UINT_16) 0xFFFF)


/**********  SERIAL data types  **********/


#define  SYNCH0_DEVICE          (PQ_DEVICE(0))
#define  ASYNCH0_DEVICE         (PQ_DEVICE(1))
#define  ASYNCH1_DEVICE         (PQ_DEVICE(2))

#define  COM1_DEVICE            ASYNCH0_DEVICE
#define  COM2_DEVICE            ASYNCH1_DEVICE


#define  OVERRUN_ERROR_FLAG     0x01
#define  PARITY_ERROR_FLAG      0x02
#define  FRAMING_ERROR_FLAG     0x04
#define  BREAK_INTERRUPT_FLAG   0x08
#define  UNDERRUN_ERROR_FLAG    0x08
#define  CTS_ON_FLAG            0x10
#define  DSR_ON_FLAG            0x20
#define  RI_ON_FLAG             0x40
#define  DCD_ON_FLAG            0x80


/* PARITY_MODE */

#define  no_parity              0x01L
#define  odd_parity             0x02L
#define  even_parity            0x03L
#define  mark_parity            0x04L
#define  space_parity           0x05L
#define  sticky_parity          0x06L

#define  NO_PARITY              no_parity
#define  ODD_PARITY             odd_parity
#define  EVEN_PARITY            even_parity
#define  MARK_PARITY            mark_parity
#define  SPACE_PARITY           space_parity
#define  STICKY_PARITY          sticky_parity


/* LINE_STATE */

#define  line_not_used          0x01L
#define  line_off               0x02L
#define  line_on                0x03L

#define  LINE_NOT_USED          line_not_used
#define  LINE_OFF               line_off
#define  LINE_ON                line_on


/* CLOCK_SRC */

#define  clock_not_used         0x01L
#define  internal_clock         0x02L
#define  external_clock         0x03L

#define  CLOCK_NOT_USED         clock_not_used
#define  INTERNAL_CLOCK         internal_clock
#define  EXTERNAL_CLOCK         external_clock


/* FLOW_CONTROL */

#define  no_flow_control        0x01L
#define  hw_flow_control        0x02L

#define  NO_FLOW_CONTROL        no_flow_control
#define  HW_FLOW_CONTROL        hw_flow_control


/* TRANSFER_MODE */

#define  no_change_transfer     0x00L
#define  no_transfer            0x01L
#define  polled_transfer        0x02L
#define  interrupt_transfer     0x03L
#define  dma_transfer           0x04L

#define  NO_CHANGE_TRANSFER     no_change_transfer
#define  NO_TRANSFER            no_transfer
#define  POLLED_TRANSFER        polled_transfer
#define  INTERRUPT_TRANSFER     interrupt_transfer
#define  DMA_TRANSFER           dma_transfer


typedef struct
{
    UINT_32                 rts;
    UINT_32                 dtr;

} MODEM_CONTROL_STRUCT;


typedef struct
{
    BOOLEAN                 rx_ready;
    BOOLEAN                 tx_ready;
    BOOLEAN                 rx_error;
    BOOLEAN                 modem_status;

} INTERRUPT_SELECT_STRUCT;


typedef struct
{
    UINT_32                 rx_buffer_size;
    UINT_32                 baud_rate;
    UINT_32                 parity_mode;
    UINT_8                  stop_bits;
    UINT_8                  send_break;
    UINT_16                 data_bits;
    MODEM_CONTROL_STRUCT    initial_modem_lines;
    UINT_32                 tx_clock_src;
    UINT_32                 rx_clock_src;
    UINT_32                 flow_control;
    UINT_32                 transfer_mode;
    INTERRUPT_SELECT_STRUCT interrupt_select;

} SERIAL_CONFIG_STRUCT;


typedef struct
{
    UINT_16                 tx_pending_count;
    UINT_16                 rx_pending_count;
    UINT_16                 tx_queued_requests;
    UINT_16                 rx_queued_requests;

} QUEUE_STATUS_STRUCT;


typedef struct
{
    UINT_32                 cts;
    UINT_32                 dsr;
    UINT_32                 ring;
    UINT_32                 dcd;

} MODEM_STATUS_STRUCT;


/**********  SERIAL prototypes  **********/

void _Fparam        pq_serial_config
(
    UINT_16                     unit,
    SERIAL_CONFIG_STRUCT far *  config_struct_ptr,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_serial_control
(
    UINT_16                     unit,
    UINT_32                     control_request,
    MODEM_CONTROL_STRUCT far *  modem_control_struct_ptr,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_serial_status
(
    UINT_16                     unit,
    QUEUE_STATUS_STRUCT far *   queue_status_struct_ptr,
    MODEM_STATUS_STRUCT far *   modem_status_struct_ptr,
    UINT_16 far *               except_ptr
);


UINT_32 _Fparam     pq_serial_read
(
    UINT_16                     unit,
    UINT_8 far *                buffer_ptr,
    UINT_8 far *                buffer_status_ptr,
    UINT_32                     count,
    void far *                  reserved_ptr,
    UINT_16                     wait_time,
    UINT_16 far *               except_ptr
);


UINT_32 _Fparam     pq_serial_write
(
    UINT_16                     unit,
    UINT_8 far *                buffer_ptr,
    UINT_32                     count,
    void far *                  reserved_ptr,
    UINT_16                     wait_time,
    UINT_16 far *               except_ptr
);


UINT_8 _Fparam      pq_serial_read_char
(
    UINT_16                     unit,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_serial_write_char
(
    UINT_16                     unit,
    UINT_8                      out_char,
    UINT_16 far *               except_ptr
);


/**********  DMA data types  **********/


#define  DMA0_DEVICE            (PQ_DEVICE(0))
#define  DMA1_DEVICE            (PQ_DEVICE(1))


/* BUFFER_XFER_MODE */

#define  single_buffer          0x01L
#define  auto_repeat_buffer     0x02L
#define  chain_buffer           0x03L

#define  SINGLE_BUFFER          single_buffer
#define  AUTO_REPEAT_BUFFER     auto_repeat_buffer
#define  CHAIN_BUFFER           chain_buffer


/* BUS_XFER_MODE */

#define  single_xfer            0x01L
#define  block_xfer             0x02L
#define  demand_xfer            0x03L
#define  cascade_xfer           0x04L

#define  SINGLE_XFER            single_xfer
#define  BLOCK_XFER             block_xfer
#define  DEMAND_XFER            demand_xfer
#define  CASCADE_XFER           cascade_xfer


/* BUS_PRIORITY_MODE */

#define  chan0_lowest_priority      0x01L
#define  chan1_lowest_priority      0x02L
#define  ext_bus_lowest_priority    0x03L
#define  rotating_priority          0x04L

#define  CHAN0_LOWEST_PRIORITY      chan0_lowest_priority
#define  CHAN1_LOWEST_PRIORITY      chan1_lowest_priority
#define  EXT_BUS_LOWEST_PRIORITY    ext_bus_lowest_priority
#define  ROTATING_PRIORITY          rotating_priority


/* BUS_CYCLE_MODE */

#define  single_cycle           0x01L
#define  two_cycle              0x02L

#define  SINGLE_CYCLE           single_cycle
#define  TWO_CYCLE              two_cycle


/* INPUT_SAMPLING_MODE */

#define  no_change_sampling     0x00L
#define  no_sampling            0x01L
#define  asynch_sampling        0x02L
#define  synch_sampling         0x03L

#define  NO_CHANGE_SAMPLING     no_change_sampling
#define  NO_SAMPLING            no_sampling
#define  ASYNCH_SAMPLING        asynch_sampling
#define  SYNCH_SAMPLING         synch_sampling


/* ADDRESS_TYPE */

#define  byte_bucket_addr_type  0x01L
#define  absolute_addr_type     0x02L
#define  segment_addr_type      0x03L
#define  io_port_addr_type      0x04L

#define  BYTE_BUCKET_ADDR_TYPE  byte_bucket_addr_type
#define  ABSOLUTE_ADDR_TYPE     absolute_addr_type
#define  SEGMENT_ADDR_TYPE      segment_addr_type
#define  IO_PORT_ADDR_TYPE      io_port_addr_type


/* ADDRESS_INC_MODE */

#define  inc_address            0x01L
#define  dec_address            0x02L
#define  hold_address           0x03L

#define  INC_ADDRESS            inc_address
#define  DEC_ADDRESS            dec_address
#define  HOLD_ADDRESS           hold_address



typedef struct
{
    UINT_32                 buffer_xfer_mode;
    UINT_32                 bus_xfer_mode;
    UINT_32                 bus_priority_mode;
    UINT_32                 bus_cycle_mode;
    UINT_32                 eop_sampling_mode;
    UINT_32                 dreq_sampling_mode;

} DMA_CONFIG_STRUCT;


typedef struct
{
    BOOLEAN                 xfer_active;
    UINT_32                 pending_count;
    BOOLEAN                 hw_dreq_pending;
    BOOLEAN                 sw_dreq_pending;
    BOOLEAN                 base_addr_empty;

} DMA_STATUS_STRUCT;


typedef struct
{
    UINT_32                 address_type;
    UINT_32                 address_inc_mode;
    BOOLEAN                 is_requestor;
    UINT_16                 data_width;
    UINT_16                 io_port;
    UINT_32                 absolute_addr;
    void far *              segment_addr;

} ADDRESS_INFO_STRUCT;


/**********  DMA prototypes  **********/


void _Fparam        pq_dma_config
(
    UINT_16                     unit,
    DMA_CONFIG_STRUCT far *     config_struct_ptr,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_dma_control
(
    UINT_16                     unit,
    UINT_32                     control_request,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_dma_status
(
    UINT_16                     unit,
    DMA_STATUS_STRUCT far *     status_struct_ptr,
    UINT_16 far *               except_ptr
);


UINT_32 _Fparam     pq_dma_transfer
(
    UINT_16                     unit,
    ADDRESS_INFO_STRUCT far *   src_addr_info_ptr,
    ADDRESS_INFO_STRUCT far *   dest_addr_info_ptr,
    UINT_32                     count,
    void far *                  reserved_ptr,
    UINT_16                     wait_time,
    UINT_16 far *               except_ptr
);


/**********  PARALLEL data types  **********/


#define  PARALLEL0_DEVICE       (PQ_DEVICE(0))
#define  PARALLEL1_DEVICE       (PQ_DEVICE(1))
#define  PARALLEL2_DEVICE       (PQ_DEVICE(2))


/* PIN_MODE */

#define  pin_not_used           0x01L
#define  high_impedance         0x02L
#define  complementary          0x03L
#define  open_drain             0x04L

#define  PIN_NOT_USED           pin_not_used
#define  HIGH_IMPEDANCE         high_impedance
#define  COMPLEMENTARY          complementary
#define  OPEN_DRAIN             open_drain



typedef struct
{
    UINT_32                 pin_mode[8];

} PARALLEL_CONFIG_STRUCT;


typedef struct
{
    UINT_32                 pin_mode[8];
    UINT_8                  read_used_mask;
    UINT_8                  write_used_mask;

} PARALLEL_STATUS_STRUCT;


/**********  PARALLEL prototypes  **********/


void _Fparam        pq_parallel_config
(
    UINT_16                         unit,
    PARALLEL_CONFIG_STRUCT far *    config_struct_ptr,
    UINT_16 far *                   except_ptr
);


void _Fparam        pq_parallel_control
(
    UINT_16                         unit,
    UINT_32                         control_request,
    UINT_16 far *                   except_ptr
);


void _Fparam        pq_parallel_status
(
    UINT_16                         unit,
    PARALLEL_STATUS_STRUCT far *    status_struct_ptr,
    UINT_16 far *                   except_ptr
);


UINT_8 _Fparam      pq_parallel_read
(
    UINT_16                         unit,
    UINT_8                          mask,
    UINT_16 far *                   except_ptr
);


void _Fparam        pq_parallel_write
(
    UINT_16                         unit,
    UINT_8                          value,
    UINT_8                          mask,
    UINT_16 far *                   except_ptr
);



/**********  TIMER data types  **********/


#define  TIMER0_DEVICE          (PQ_DEVICE(0))  /* owned by iRMX */
#define  TIMER1_DEVICE          (PQ_DEVICE(1))
#define  TIMER2_DEVICE          (PQ_DEVICE(2))

#define  DEFAULT_TIMER_COUNT    ((UINT_16) 0)


/* COUNT_TYPE */

#define  binary                 0x01L
#define  bcd                    0x02L

#define  BINARY                 binary
#define  BCD                    bcd


/* COUNT_MODE */

#define  hw_interrupt           0x01L
#define  hw_oneshot             0x02L
#define  rate_generator         0x03L
#define  square_wave            0x04L
#define  sw_strobe              0x05L
#define  hw_strobe              0x06L

#define  HW_INTERRUPT           hw_interrupt
#define  HW_ONESHOT             hw_oneshot
#define  RATE_GENERATOR         rate_generator
#define  SQUARE_WAVE            square_wave
#define  SW_STROBE              sw_strobe
#define  HW_STROBE              hw_strobe



typedef struct
{
    UINT_32                 count_type;
    UINT_32                 count_mode;
    UINT_16                 count;

} TIMER_CONFIG_STRUCT;


typedef struct
{
    UINT_32                 count_type;
    UINT_32                 count_mode;
    UINT_16                 count;
    BOOLEAN                 count_valid;
    UINT_8                  out_line_state;

} TIMER_STATUS_STRUCT;


/**********  TIMER prototypes  **********/


void _Fparam        pq_timer_config
(
    UINT_16                     unit,
    TIMER_CONFIG_STRUCT far *   config_struct_ptr,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_timer_control
(
    UINT_16                     unit,
    UINT_32                     control_request,
    UINT_16                     count,
    UINT_16 far *               except_ptr
);


void _Fparam        pq_timer_status
(
    UINT_16                     unit,
    TIMER_STATUS_STRUCT far *   status_struct_ptr,
    UINT_16 far *               except_ptr
);


/**********  WATCHDOG data types  **********/


#define  WATCHDOG0_DEVICE       (PQ_DEVICE(0))


/* WATCHDOG_MODE */

#define  not_used               0x01L
#define  system_mode            0x02L
#define  bus_monitor            0x03L
#define  timer_mode             0x04L

#define  NOT_USED               not_used
#define  SYSTEM_MODE            system_mode
#define  BUS_MONITOR            bus_monitor
#define  TIMER_MODE             timer_mode



typedef struct
{
    UINT_32                 mode;
    UINT_32                 reload_count;

} WATCHDOG_CONFIG_STRUCT;


typedef struct
{
    UINT_32                 mode;
    UINT_32                 reload_count;
    UINT_32                 current_count;
    BOOLEAN                 clocks_running;

} WATCHDOG_STATUS_STRUCT;


/**********  WATCHDOG prototypes  **********/


void _Fparam        pq_watchdog_config
(
    UINT_16                         unit,
    WATCHDOG_CONFIG_STRUCT far *    config_struct_ptr,
    UINT_16 far *                   except_ptr
);


void _Fparam        pq_watchdog_control
(
    UINT_16                         unit,
    UINT_32                         control,
    UINT_16 far *                   except_ptr
);


void _Fparam        pq_watchdog_status
(
    UINT_16                         unit,
    WATCHDOG_STATUS_STRUCT far *    status_struct_ptr,
    UINT_16 far *                   except_ptr
);


/*
 * -------------------- iRMX CINFO definitions -------------------- 
 */

/*
 * CINFO macro definitions 
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif
#define _CONFIGURED        1
#define _STDIO_FUNCTION    2
#define _NO_FSTATUS        1

/*
 * CINFO type definitions
 */

typedef struct
{
    int                     num_eios_bufs;
    unsigned long32 *       accounting;
    unsigned short          num_accounting;
    unsigned short          num_clib_functs;
    char *                  flags;
    unsigned long32         task_flags;

} CINFO_STRUCT;


/*
 * CINFO function prototypes
 */

void                _Pascal _cstop (selector task_t);
int                 _Pascal _get_arguments (int far *, char far **, size_t,
                                char far *, size_t);
int                 _Pascal _get_info (int, CINFO_STRUCT *);
selector            _Pascal _get_rmx_conn (int fd);
int                 _Pascal _put_rmx_conn (selector connection);
int                 _Pascal _set_info (int, CINFO_STRUCT *);

#include <_restore.h>

#ifdef __cplusplus
}
#endif

#endif      /* __RMXEMBH__ */
