#include "types.h"
#include "memblock.h"
#include "ether.h"
#include "arp.h"
#include <string.h>
#include <stdlib.h>

/* unpackage an ARP packet, or return null if the hardware and
   protocol address types are not ethernet and IP respectively. */

arp_packet *decode_arp_packet(ether_packet *pkt)
{
  arp_packet *result;
  u16 hard_type;
  u16 prot_type;
  u16 op;

  hard_type = SWAP16(*((u16 *)(pkt->payload_start + 0)));
  prot_type = SWAP16(*((u16 *)(pkt->payload_start + 2)));
  op = SWAP16(*((u16 *)(pkt->payload_start + 6)));


  /* Return NULL if this isn't an ARP for IP over ethernet; also bail
     if this is a RARP and not an ARP. */
  if (hard_type != 0x0001 || prot_type != 0x0800 ||
      (op != 0x0001 && op != 0x0002)) {
    return NULL;
  }

  result=(arp_packet *) malloc(sizeof(arp_packet));
  
  result->op = op;
  memcpy(result->src_en_addr, pkt->payload_start+8 , 6);
  result->src_ip_addr = SWAP32(*((u32 *)(pkt->payload_start + 14)));
  memcpy(result->dest_en_addr, pkt->payload_start + 18, 6);
  result->dest_ip_addr = SWAP32(*((u32 *)(pkt->payload_start + 24)));

  return result;
}

ether_packet *encode_arp_packet(arp_packet *pkt)
{
  ether_packet *result;
  memblock *mb;

  mb = new_memblock();
  result = (ether_packet *) malloc(sizeof(ether_packet));
  if (!result)
      return NULL;
  
  result->data = mb;
  result->payload_offset=14;
  result->payload_start= result->data->data+result->payload_offset;

  result->type=0x0806;
  memcpy(result->src_addr, pkt->src_en_addr, 6);
  memcpy(result->dest_addr, pkt->dest_en_addr, 6);

  result->length=28+14;

  *((u16 *)(result->payload_start + 0)) = SWAP16(0x0001);
  *((u16 *)(result->payload_start + 2)) = SWAP16(0x0806);
  *(result->payload_start + 4) = 6;
  *(result->payload_start + 5) = 4;

  *((u16 *)(result->payload_start + 6)) = SWAP16(pkt->op);

  memcpy(result->payload_start + 8, pkt->src_en_addr, 6);
  *((u32 *)(result->payload_start + 14)) = SWAP32(pkt->src_ip_addr);
  memcpy(result->payload_start + 18, pkt->dest_en_addr, 6);
  *((u32 *)(result->payload_start + 24)) = SWAP32(pkt->dest_ip_addr);

  pack_ether_header(result);

  return result;
}
