/* _alloc.h - alloc and free header definitions
 * $Version: 1.5 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __ALLOC
#define __ALLOC

/*
 * NOTE - This file is hard-wired for 32 bit compilation.
 */

#include <yvals.h>
#include <limits.h>
#include <reent.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#ifndef _free_list_item_t
#define _free_list_item_t
struct free_list_item {
    _ptrdef(struct free_list_item, next)
    _aligndef(unsigned int, length)
};
#endif
#define _FREE_LIST_SIZE   20
#define FH_SIZE           sizeof(struct free_list_item)
#define INTSIZE           sizeof(int)
#define MIN_ALLOC         sizeof(int)
#define MAX_ALLOC         (UINT_MAX - FH_SIZE)

/*
 * function prototypes
 */

void                    _Pascal _merge_free_lists(struct _heap *);
int                     _Pascal _merge_free_blocks(struct free_list_item *);
void                    _Pascal _malloc_take(struct free_list_item *, unsigned);
struct free_list_item * _Pascal _malloc_find(unsigned);
void                    _Pascal _free(struct free_list_item *);
void                    _Pascal _hfree(struct free_list_item *, struct _heap *);
void                    _Pascal hfree(void *, struct _heap *);

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* __ALLOC */
