#ifndef _DIGRAPH_H
#define _DIGRAPH_H

#include "6170.h"
#include "table.h"

class digraph {

public:
    
// Overview
// A digraph is a weighted directed graph.
// Its abstract state is a pair <N, E>.
// N is the set of nodes in the graph. A node is an integer.
// E is the set of weighted edges between nodes in N.
// An edge is <from_node, to_node, wt>, where from_node and to_node are in N,
// and wt is a real (float) weight. There is at most one edge from any node to
// another node; i.e., for any two edges in E, <f1, t1, w1> and <f2, t2, w2>, 
// (f1 == f2) => (t1 != t2).  In addition, (f1 != t1) for any edge.


// Constructor
    
    digraph();
    // effects  Initializes this to be an empty digraph.
    
// Methods
    
    bool add_node(int node);
    // modifies this
    // effects  Returns false if node is already in this.
    //          Else adds node to this and returns true.
    
    bool add_edge(int from_node, int to_node, float wt);
    // modifies this
    // effects  Returns false if either from_ or to_node is not in this,
    //          or if an edge already exists from from_node to to_node.
    //          Else adds an edge of weight wt from from_node to to_node
    //          and returns true.

    bool lookup_edge(int from_node, int to_node, float &wt) const;
    // modifies wt
    // effects  Returns false if either from_ or to_node is not in this,
    //          or if no edge exists from from_node to to_node.
    //          Else sets wt to the weight of the edge and returns true. 
    
    bool remove_edge(int from_node, int to_node);
    // modifies this
    // effects  Returns false if either from_ or to_node is not in this,
    //          or if no edge exists from from_node to to_node.
    //          Else removes the edge from from_node to to_node
    //          and returns true.

    generator<int>* nodes() const;
    // effects  Returns a generator that will produce each node in this
    //          exactly once, in arbitrary order.
    // requires this not be modified while generator is in use.

    bool successors(int node, generator<int> *&gi) const;
    // modifies gi
    // effects  Returns false if node is not in this.
    //          Else, sets gi to a generator that will produce the nodes that
    //          the given node points to, each exactly once in arbitrary order,
    //          and returns true.
    // requires this not be modified while generator is in use.
    
    bool rep_ok();
    // effects  Returns true iff the rep invariant is satisfied.
    
private:
	
//  Abstraction Function
//  this->graph->length() == number of nodes in system
//  this->nodes() == generator that will return all nodes in system
//  this->successors(node) will give list of the second point of each
//  edge from node.

//  Rep Invarient
//  No edge points from a node to itself
//  No two edges from one node point to the same node

    typedef table<int, float>* NODE;
    table<int, NODE> *graph;
};

ostream& operator <<(ostream& out, digraph const *&d);
// modifies     out
// effects      Prints the abstract state of d to out.

#endif /* _DIGRAPH_H */
