#!zwish -f

wm minsize . 0 0

frame .f0 -relief sunken -borderwidth 3
button .f0.b -bitmap {@/usr/include/X11/bitmaps/skull}  -width 40
listbox .f0.list  -geometry {10x4} -yscrollcommand {.f0.scrbar set}
scrollbar .f0.scrbar -command {.f0.list yview}

frame .f1 -relief sunken -borderwidth 3
text .f1.text  -width 40 -height 10 -yscrollcommand {.f1.scrbar set} -wrap word
scrollbar .f1.scrbar -command {.f1.text yview}

pack .f0.b -in .f0 -fill y -side left
pack .f0.list -after .f0.b -fill x -expand 1 -side left
pack .f0.scrbar -after .f0.list -fill y -side right
pack .f0 -side top -fill x

pack .f1.text -in .f1 -fill x -expand 1 -side left
pack .f1.scrbar -after .f1.text -fill y -expand 1 -anchor e 
pack .f1 -after .f0 -expand 1 -fill both


proc notice_handler {notice t lb} {
    display_notice $notice $t
    set sel [$lb curselection]
    $lb insert end $notice
    if {[llength $sel] == 0 || [lindex $sel 0] == [$lb size] - 2} {
	$lb select from end
    }
}

proc display_notice {notice t} {
    # delete current text
    $t delete 1.0 end
    
    # Insert various fields.
    $t insert end "From: [$notice get sender]\n"
    $t insert end "To: [$notice get class] [$notice get class_inst] [$notice get recipient]\n"
    $t insert end "Time: [$notice get time]\n"
    
    # body
    $t insert end [$notice get field1]
    # signature
    $t insert end "\n\t--[$notice get field0]"
}

.f0.b configure -command {
    set sel [.f0.list curselection]
    
    if {[llength $sel] == 0} {
	return
    }
    set beg [lindex $sel 0]
    set end [expr $beg + [llength $sel] - 1]
    .f0.list delete $beg $end
    .f0.list select clear
    if {[.f0.list size] == 0} {
	.f1.text delete 1.0 end
	.f1.text insert 1.0 "No messages"
	return
    }
    .f0.list select from $beg
    display_notice [.f0.list get $beg] .f1.text
}

bind .f0.list <ButtonRelease-1> {
  if {[.f0.list size] != 0} {
    display_notice [.f0.list get [.f0.list nearest %y]] .f1.text
  }
}

zinit
zopen
source zsubs
.f1.text insert 1.0 "No messages"
zset_handler {notice_handler [zreceive] .f1.text .f0.list}