/* _dos.h - This file defines data structures for DOS access.
 * $Version: 1.7 $
 * Copyright (c) 1990-91,93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef __DOS
#define __DOS

#include <yvals.h>
#include <_noalign.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro defintions
 */

#ifndef _FAR
#define _FAR far
#endif
#ifndef _HUGE
#define _HUGE huge
#endif
#ifndef _NEAR
#define _NEAR near
#endif
#ifndef OK
#define OK 0
#endif
#ifndef ERROR
#define ERROR -1
#endif

/*
 * type definitions
 */

#ifndef _MODET
#define _MODET
typedef _Modet mode_t;
#endif

/*
 * structure definition used by _dos_findfirst.  This version is a special
 * internal one that includes specification of the reserved fields.
 */

#ifndef _FINDT
#define _FINDT
struct find_t {
    unsigned short	search_attrib;		/* Attrib passed to findfirst() */
    selector		dir_t;				/* Token for target directory */
    selector		mbox_t;				/* Token for I/O mailbox */
    char			wildcard_spec[15];	/* Wildcard search string */
    char            attrib;				/* Returned attribute */
    unsigned short  wr_time;			/* Time file last written */
    unsigned short  wr_date;			/* Date file last written */
    long32          size;				/* Size of file */
    char            name[13];			/* String containing the filename */
};
#endif /* _FINDT */

extern int    _chbuf;
extern mode_t _umask;

/*
 * function prototypes
 */

int             _Pascal _dosf25(int, void _FAR *);
void _FAR     * _Pascal _dosf35(int);
int             _Pascal _dosf3f(int, char *, unsigned int);
int             _Pascal _dosf40(int, char *, unsigned int);
void          * _Pascal _dosf48(unsigned int);
int             _Pascal _dosf49(void _FAR *);
int             _Pascal _dosf4a(unsigned int, unsigned int);
int             _Pascal _dosf4e(const char *, struct find_t *, unsigned int);
void _FAR     * _Pascal abstoptr(unsigned long32);
unsigned long32 _Pascal ptrtoabs(void _FAR *);

#define abstoptr(a) \
        (void _FAR *)((((unsigned long32)a>>4)<<16)|(unsigned long32)(a&0xF))

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* __DOS */
