/* string.h standard header 
 * $Version: 1.3 $
 * Copyright (c) 1993 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _STRING
#define _STRING 

#include <yvals.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * type definitions
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif

/*
 * function prototypes
 */

void      * _Pascal memchr(const void *, int, size_t);
int         _Pascal memcmp(const void *, const void *, size_t);
void      * _Pascal memcpy(void *, const void *, size_t);
void      * _Pascal memmove(void *, const void *, size_t);
void      * _Pascal memset(void *, int, size_t);
char      * _Pascal strcat(char *, const char *);
char      * _Pascal strchr(const char *, int);
int         _Pascal strcmp(const char *, const char *);
int         _Pascal strcoll(const char *, const char *);
char      * _Pascal strcpy(char *, const char *);
size_t      _Pascal strcspn(const char *, const char *);
char      * _Pascal strerror(int);
size_t      _Pascal strlen(const char *);
char      * _Pascal strncat(char *, const char *, size_t);
int         _Pascal strncmp(const char *, const char *, size_t);
char      * _Pascal strncpy(char *, const char *, size_t);
char      * _Pascal strpbrk(const char *, const char *);
char      * _Pascal strrchr(const char *, int);
size_t      _Pascal strspn(const char *, const char *);
char      * _Pascal strstr(const char *, const char *);
char      * _Pascal strtok(char *, const char *);
size_t      _Pascal strxfrm(char *, const char *, size_t);

/*
 * non-standard function prototypes
 */

char      * _Pascal cstr(char *, const char *);
void      * _Pascal memccpy(void *, const void *, int, int);
int         _Pascal memicmp(const void *, const void *, unsigned int);
void        _Pascal movedata(unsigned int, unsigned int, unsigned int,
					   unsigned int, unsigned int);
int         _Pascal strcmpi(const char *, const char *);
char      * _Pascal strdup(const char *);
int         _Pascal stricmp(const char *, const char *);
char      * _Pascal strlwr(char *);
int         _Pascal strnicmp(const char *, const char *, size_t);
char      * _Pascal strnset(char *, int, size_t);
char      * _Pascal strrev(char *);
char      * _Pascal strset(char *, int);
char      * _Pascal strupr(char *);
char      * _Pascal udistr(char *, const char *);

#ifdef __cplusplus
}
#endif
#endif /* _STRING */
