#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>

#include "router.h"

ether_addr router_ether_addr[2];
u32 router_ip_addr[2];

static char command[50];
static int position = 0;

char handle_command(char *command);

#define CONTINUE 0
#define EXIT_LOOP 1

#ifdef TESTBED
#define getche getchar
#endif

/********************************* monitor_loop ************************/
void monitor_loop(void) {
    int count=0;
    
    printf("\nCommand: ");
    fflush(stdout);
    
    for(;;) {
	    /* first handle packet transmission fifos */
	handle_fifos();
	    /* Once every 10000 iterations clear arp cache */
	if (count++ == 10000) {
	    count = 0;
	    arp_cache_check_timeouts();
	}

	if (kbhit()) {
	    char ch;
	    ch = getche();
	    if (ch != '\n')
		command[position++] = ch;
	    else {
		    /* a new command was just entered */
		command[position] = 0;
		ch = handle_command(command);
		position = 0;
		memset(command, 0, sizeof(command));
		if (ch == EXIT_LOOP)
		    break;
		printf("\nCommand: ");
		fflush(stdout);
	    }
	}
	else {
		/* do we want this here?  i don't like the
		   thought of pure busy loops, but maybe the
		   interrupt handlers will do their job well */
	    sleep(1);
	}
    }
}

static char started = 0;
static char ipset = 0;
static char etherset = 0;

/********************************* handle_command ************************
  handle whatever commands our console should support */
char handle_command(char *command) {
    int ifx;
    u32 dest_ip, next_hop_ip, net_mask, net_ip;
    ether_addr hw_addr;

    if (!strncmp(command, "ints", 4)) {
	printf("ETH0 int count = %d, ETH1 int count = %d\n",
	       eth0_intcount, eth1_intcount);
	return CONTINUE;
    }
    if (!strncmp(command, "exit", 4)) {
	if (started)
	    return EXIT_LOOP;
	else {
	    fprintf(stderr, "Attempt to exit without starting first\n");
	    return CONTINUE;
	}
    }
    if (!strncmp(command, "start", 5)) {
	if ((ipset == 2) && (etherset == 2)) {
	    started = 1;
	    return EXIT_LOOP;
	} else {
	    printf("You must set ip and ethernet addresses for both "
		   "interfaces before starting\n");
	    return CONTINUE;
	}
    }
    if (!strncmp(command, "quit", 4)) {
	exit(0);
    }
    if (!strncmp(command, "set_ip", 6)) {
	ifx = atoi(strtok(command + 7, " "));
	router_ip_addr[ifx] = my_aton(strtok(command + 7, " "));
	printf("router_ip_addr[%d] = %x\n",
	       ifx, router_ip_addr[ifx]);
	ipset++;
	return CONTINUE;
    }
    if (!strncmp(command, "set_ether", 9)) {
	ifx = atoi(strtok(command + 10, " "));
	my_atoh(strtok(NULL, " "), &router_ether_addr[ifx]);
	etherset++;
	return CONTINUE;
    }
    if (!strncmp(command, "load_defaults", 13)) {
	router_ip_addr[0] = my_aton(ETH0_IP_ADDR);
	router_ip_addr[1] = my_aton(ETH1_IP_ADDR);
	my_atoh(ETH0_ETHER_ADDR, &router_ether_addr[0]);
	my_atoh(ETH1_ETHER_ADDR, &router_ether_addr[1]);
	etherset=2;
	ipset=2;
	return CONTINUE;
    }
    if (!strncmp(command, "rt_add_host", 11)) {
	dest_ip = my_aton(strtok(command+12," "));
	next_hop_ip = my_aton(strtok(NULL," "));
	ifx = atoi(strtok(NULL, " "));
	rt_add_host_route(dest_ip, next_hop_ip, ifx); 
	return CONTINUE;
    }
    if (!strncmp(command, "rt_add_net", 10)) {
	net_ip = my_aton(strtok(command+11, " "));
	net_mask = my_aton(strtok(NULL, " "));
	next_hop_ip = my_aton(strtok(NULL, " "));
	ifx = atoi(strtok(NULL, " "));
	rt_add_net_route(net_ip, net_mask, next_hop_ip, ifx);
	return CONTINUE;
    }
    if (!strncmp(command, "rt_add_default", 14)) {
	next_hop_ip = my_aton(strtok(command+15, " "));
	ifx = atoi(strtok(NULL, " "));
	rt_add_default_route(next_hop_ip, ifx);
	return CONTINUE;
    }
    if (!strncmp(command, "arp_add", 7)) {
	dest_ip = my_aton(strtok(command+8, " "));
	my_atoh(strtok(NULL, " "), &hw_addr);
	arp_cache_add_entry(dest_ip, hw_addr);
	return CONTINUE;
    }
    if (!strncmp(command, "help", 4)) {
	printf("Valid commands are:\n"
	       "ints\t\t\t\t\tInterrupt Count\n"
	       "exit\t\t\t\t\tExit monitor loop\n"
	       "start\t\t\t\t\tFinish setup loop\n"
	       "quit\t\t\t\t\tHard exit\n"
	       "set_ip interface ip\t\t\tSet local ip address\n"
	       "set_ether interface ether\t\tSet local ether address\n"
	       "load_defaults\t\t\t\tLoad default ip and ether adresses\n"
	       "arp_add dest_ip dest_ether\t\tAdd arp entry\n"
	       "rt_add_default next_hop_ip interface\tAdd default\n"
	       "rt_add_host dest_ip next_hop_ip interface\t\tAdd host\n"
	       "rt_add_net net_ip net_mask next_hop_ip interface\tAdd network\n");
	
	return CONTINUE;
    }

	/* if we made it this far, matched nothing above */
    fprintf(stderr, "Unknown command: %s\n", command);
    return CONTINUE;
}

