#ifndef _TABLE_H
#define _TABLE_H

template <class KEY, class VALUE>
class table {
public:
    
// Overview
// A table is a map from a key k to a value v.
// Its abstract state is a set of pairs of keys and values, 
// [ <k1 v1> <k2 v2> ...], such that no two pairs have the same key.
// This is is a mutable heap abstraction.
    
// Constructors
    
    table(bool (*eq)(KEY, KEY));
    // requires eq is a valid equality operator on keys.
    // effects  Initializes this to be a table with no mappings.
    
// Methods
    
    void insert(KEY k, VALUE v);
    // modifies this
    // checks   k not already a key in this.
    // effects  Adds a mapping from k to v.

    bool lookup(KEY k, VALUE &v) const;
    // effects  Sets v to the value that k is mapped to, if a map exists.
    //          otherwise returns false.
	
    bool remove(KEY k);
    // modifies this
    // effects  Removes mapping for k, if one exists.  Returns true
    //          if k existed, else returns false.
    
    generator<KEY>* keys() const;
    // effects  Returns a generator that will produce each key stored in this
    //          exactly once, in arbitrary order.
    // requires this not be modified while generator is in use.
    
    int length();
    // effects  Returns number of keys in this

    KEY get_key(int i);
    // checks   i < number of keys in this
    // effects  returns the KEY related with table item number i.

    bool rep_ok();
    // effects  Returns true iff the rep invariant is satisfied.
    
   private:

// Abstraction Function
// this->els->length() == Number of keys
// this->els->map.k maps to this->els->map.v as k maps to k

// Rep Invarient
// No key is repeated in this.
	
	typedef struct {
	    KEY k;
	    VALUE v;
	} map;

        array<map> *els;

        bool (*eqp)(KEY, KEY);

        friend class tablegen<KEY, VALUE>;
};


#include "table.t"

#endif /* _TABLE_H */
