// Copyright 1995 Barbara Liskov

#include <stdlib.h>

#include "6170.h"
#include "file.h"

static string extract_field(string s, int start, int finish);
static string remove_spaces(string s);

file::file(string line) {
    int last = line.length()-1;
    check(last >= 45, "Not enough characters in file line");
    file_line = line;
    file_owner = extract_field(line, 14, 21);
    file_size = atoi(extract_field(line, 22, 30).get_chars());
    // XXX need to check for right integer format
    file_time = extract_field(line, 32, 43);
    file_name = extract_field(line, 45, last); 
}

string file::owner() {
    return file_owner;
}

int file::size() {
    return file_size;
}

string file::time() {
    return file_time;
}    

string file::name() {
    return file_name;
}

string file::line() {
    return file_line;
}


string extract_field(string s, int start, int finish) {
    //	requires 0 <= start <= finish < s.length()
    //	effects	 Return the substring of "s" that starts at
    //		 character position "start" and ends at "finish",
    //		 with all leading and trailing spaces removed.
    return remove_spaces(s.substring(start, finish - start + 1));
}

string remove_spaces(string s) {
    //	effects	Return a string which is identical to "s" except
    //		that all leading or trailing space characters
    //		have been removed. If all characters in "s" are
    //		spaces, return the empty string.

    int length = s.length();

    int start; // the first non-space character 
    for (start = 0; start < length; start++) {
	if (s[start] != ' ') break;
    }
    if (start == length) return "";

    int finish; // the last non-space char 
    for (finish = length - 1; finish >= start; finish--) {
	if (s[finish] != ' ') break;
    }
    return s.substring(start, finish - start + 1);
}
