#include "types.h"
#include "memblock.h"
#include <stdlib.h>
#include <malloc.h>

memblock *new_memblock()
{
  memblock *result;
  
  result=malloc(sizeof(memblock));
  result->next=NULL;

  return result;
}

memblock *copy_to_new_memblock(void *data)
{
  memblock *result;

  result=new_memblock();
  memcpy(&(result->data),data,64*sizeof(u8));

  return result;
}

void free_memblock_chain(memblock *mb)
{
  memblock *next;

  while (mb!=NULL) {
    next = mb->next;
    free(mb);
    mb=next;
  }
}
