#include <6170.h>
#include <chess_capture_move.h>
#include <chess_display_board.h>

typeinfo_t chess_capture_move::typeinfo = new_typeinfo();

chess_capture_move:: chess_capture_move (int from_x, int from_y, 
					 int to_x, int to_y,
					 chess_display_board::chess_piece piece,
					 chess_display_board::color piece_color,
					 bool promotion) {
    p.x1 = from_x;
    p.y1 = from_y;
    p.x2 = to_x;
    p.y2 = to_y;
    c  = piece_color;
    piecetaken = piece;
    promoted = promotion;
}

chess_capture_move::chess_capture_move (int x1i, int y1i, int x2i, int y2i,
					chess_display_board *b)
{
    p.x1 = x1i;
    p.x2 = x2i;
    p.y1 = y1i;
    p.y2 = y2i;
    piecetaken = b->fetch(y2i,x2i).piece_type;
    c = b->fetch(y2i,x2i).piece_color;
    if (((y2i==7) || (y2i==0)) && 
	(b->fetch(y1i, x1i).piece_type==chess_display_board::pawn))
	promoted = true;
    else
	promoted = false;
}


chess_capture_move::chess_capture_move (const chess_capture_move &m){
    p = m.get_path();
    piecetaken = m.get_piece_taken();
    c = m.get_color_taken();
    promoted = m.promoted;
}

void chess_capture_move::display(extensions *ext, ostream &body){
    body << (char)('a'+p.x1) << p.y1+1 << "->"<< (char)('a'+p.x2)<<p.y2+1 << 
      endl;
}

bool chess_capture_move::operator == (move &m) {
    chess_capture_move *mv = (chess_capture_move *) m.force(typeinfo);
    if (!mv)
	return false;
    
    chess_display_board::path temp = mv->get_path();
    return ((temp.x1==p.x1) && (temp.y1==p.y1) && (temp.x2==p.x2) && (temp.y2==p.y2)
	    && (mv->get_piece_taken() == piecetaken) &&
	    (mv->get_color_taken() == c) && (promoted == mv->promoted));
}

move* chess_capture_move::copy(){
    return new chess_capture_move(*this);
}

void *chess_capture_move::force(typeinfo_t &t)
{
    if (t == typeinfo) return this;
    else return 0;
 }


char piecetoc(chess_display_board::chess_piece p,
	      chess_display_board::color pc) {
    switch(p){
    case chess_display_board::none:
	return '-';
    case chess_display_board::invalid:
	return '-';
    case chess_display_board::pawn:
	if (pc == chess_display_board::black)
	    return 'p';
	else
	    return 'P';
    case chess_display_board::rook:
	if (pc == chess_display_board::black)
	    return 'r';
	else
	    return 'R';
    case chess_display_board::knight:
	if (pc == chess_display_board::black)
	    return 'n';
	else
	    return 'N';
    case chess_display_board::bishop:
	if (pc == chess_display_board::black)
	    return 'b';
	else
	    return 'B';
    case chess_display_board::queen:
	if (pc == chess_display_board::black)
	    return 'q';
	else
	    return 'Q';
    case chess_display_board::king:
	if (pc == chess_display_board::black)
	    return 'k';
	else
	    return 'K';
    }
    return '-'; // default to turn off warning
}
