#ifndef _DIR_NODE_H
#define _DIR_NODE_H

#include "ps5/web_node.h"

template <class KEY, class VALUE> class map;

class dir_node : public web_node {
// abstract: A "dir_node" represents a URL in the web and all URLs that
//      have it as a prefix. It contains a number of other web_nodes and
//      routes requests to them based on the first component of the
//      request pathname.
public:

    dir_node(string name);
	// create a "dir_node" whose name in the parent web node is
	// "self_name". The name is used when constructing HTML hot-links
	// to contained children.

// methods:

    bool add(string name, web_node *child);
    // Add the node "child" under the name "name" and return true, unless 
    // that name is already used, in which case return false.

    bool remove(string name);
    // Remove the binding under the "name" and return true, unless 
    // no such binding exists, in which case return false.


    virtual http_response *get_self(string query_args, extensions *);
    // effects: Produce whatever response is appropriate when the request to
    //          "get" has no trailing pathname components, i.e. the pathname
    //          is "/".
    // inherited: Generates a simple list of names which are HTML links
    //          to the kid pages.

    virtual string base_uri() const;
    // Effects: returns the base uri (as specified to constructor) to
    // this.

    // overridden from "web_node"
    virtual http_response *get(string request, extensions *);
    generator<web_node *> *descendents();
    
    friend class dirgen;
private:
    void operator= (dir_node &);

    map <string, web_node *> *mappings;
    string self_name;
};



#endif /* _DIR_NODE_H */
