#ifndef _HTTP_RESPONSE_H
#define _HTTP_RESPONSE_H

#include "6170.h"

class http_response {
    // An "http_response" represents an HTTP/1.0 response. It has an
    // initial status line, a series of headers, and a body.
    // See "http://www.w3.org/hypertext/WWW/Protocols/HTTP/Response.html"
    // for more details.
public:
    virtual int code();
	// The status code of the HTTP response, e.g. 200 for OK.
    virtual void send(ostream &o);
	// Effects: Send the entire contents of the HTTP/1.0 response to "o".
	//   This is equivalent to sending an initial line for the status
	//   code, then sending all the headers followed by a carriage
	//   return, then sending the body of the response.
    virtual void headers(ostream &o);
        // Effects: sends all the headers of the response.
        //
        // Inherited: sends only the "Server", "MIME-version", 
	//    "Content-type", and "Content-length" headers. Subclasses may
	//    override this to add more headers.
    virtual void body(ostream &o);
	// Send just the body of the HTTP response to "o".
    virtual bool body_length(int &length);
        // Provide the length of the body in bytes and return "true",
        // or just return "false", in which case the length of the body
        // is unknown.
    virtual string content_type();
	// Return the content-type of this response. By default, "text/html".

    static const int OK = 200, ACCEPTED = 202, NO_RESPONSE = 204,
	MOVED = 301, BAD_REQUEST = 400, UNAUTHORIZED = 401, FORBIDDEN = 403,
	NOT_FOUND = 404, INTERNAL_ERROR = 500, NOT_IMPLEMENTED = 501,
	OVERLOADED = 502;
	// An abridged list of HTTP/1.0 result codes that might be returned
	// as "code".
	//
	// See "http://www.w3.org/hypertext/WWW/Protocols/HTTP/HTRESP.html"
	// for details on the meanings of these status codes.
};

string result_description(int code);
    // Return a human readable description of the result code "code".

#endif
